
// w20_1_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -1.500000
 // --table_div  1.604485
 // --table_op  0.012500

struct tablew20_1_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablew20_1_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablew20_1_neg&() const { return *(tablew20_1_neg*)this; }
};

 static tablew20_1_neg_imp<2048> w20_1_neg_table __rt_data = {
	0,0.58808,17.0583,2048, {
	0.000000000000,0.023698998688,0.043512932492,0.060728273727,0.076191503079,
	0.090459737345,0.103899788828,0.116753311426,0.129179643916,0.141283985921,
	0.153135927968,0.164781637903,0.176251875421,0.187567262926,0.198741752006,
	0.209784903248,0.220703385624,0.231501962620,0.242184140829,0.252752596538,
	0.263209456323,0.273556481623,0.283795190167,0.293926935863,0.303952961386,
	0.313874432785,0.323692462286,0.333408123320,0.343022460441,0.352536495883,
	0.361951233900,0.371267663661,0.380486761178,0.389609490613,0.398636805165,
	0.407569647681,0.416408951101,0.425155638766,0.433810624660,0.442374813601,
	0.450849101387,0.459234374929,0.467531512368,0.475741383173,0.483864848244,
	0.491902760000,0.499855962470,0.507725291375,0.515511574219,0.523215630362,
	0.530838271109,0.538380299787,0.545842511821,0.553225694817,0.560530628636,
	0.567758085471,0.574908829921,0.581983619070,0.588983202556,0.595908322648,
	0.602759714314,0.609538105300,0.616244216192,0.622878760496,0.629442444699,
	0.635935968343,0.642360024094,0.648715297805,0.655002468586,0.661222208873,
	0.667375184486,0.673462054704,0.679483472320,0.685440083712,0.691332528899,
	0.697161441611,0.702927449346,0.708631173434,0.714273229093,0.719854225496,
	0.725374765825,0.730835447331,0.736236861396,0.741579593584,0.746864223705,
	0.752091325868,0.757261468535,0.762375214583,0.767433121353,0.772435740706,
	0.777383619079,0.782277297536,0.787117311820,0.791904192410,0.796638464568,
	0.801320648391,0.805951258865,0.810530805910,0.815059794435,0.819538724385,
	0.823968090789,0.828348383810,0.832680088791,0.836963686304,0.841199652196,
	0.845388457638,0.849530569165,0.853626448728,0.857676553737,0.861681337102,
	0.865641247282,0.869556728329,0.873428219926,0.877256157436,0.881040971941,
	0.884783090284,0.888482935112,0.892140924917,0.895757474079,0.899332992900,
	0.902867887650,0.906362560607,0.909817410090,0.913232830505,0.916609212380,
	0.919946942404,0.923246403461,0.926507974676,0.929732031443,0.932918945467,
	0.936069084797,0.939182813866,0.942260493521,0.945302481066,0.948309130287,
	0.951280791496,0.954217811558,0.957120533930,0.959989298691,0.962824442577,
	0.965626299013,0.968395198147,0.971131466880,0.973835428899,0.976507404711,
	0.979147711668,0.981756664006,0.984334572868,0.986881746341,0.989398489482,
	0.991885104347,0.994341890024,0.996769142662,0.999167155494,1.001536218875,
	1.003876620302,1.006188644446,1.008472573179,1.010728685604,1.012957258077,
	1.015158564239,1.017332875038,1.019480458760,1.021601581054,1.023696504955,
	1.025765490913,1.027808796818,1.029826678022,1.031819387369,1.033787175216,
	1.035730289457,1.037648975551,1.039543476542,1.041414033086,1.043260883469,
	1.045084263639,1.046884407221,1.048661545543,1.050415907659,1.052147720372,
	1.053857208253,1.055544593665,1.057210096786,1.058853935628,1.060476326060,
	1.062077481827,1.063657614573,1.065216933862,1.066755647196,1.068273960037,
	1.069772075827,1.071250196006,1.072708520035,1.074147245413,1.075566567697,
	1.076966680520,1.078347775613,1.079710042819,1.081053670116,1.082378843634,
	1.083685747669,1.084974564710,1.086245475446,1.087498658793,1.088734291907,
	1.089952550199,1.091153607358,1.092337635364,1.093504804506,1.094655283396,
	1.095789238990,1.096906836603,1.098008239922,1.099093611024,1.100163110394,
	1.101216896936,1.102255127994,1.103277959363,1.104285545305,1.105278038566,
	1.106255590390,1.107218350531,1.108166467272,1.109100087439,1.110019356410,
	1.110924418136,1.111815415150,1.112692488586,1.113555778187,1.114405422322,
	1.115241558000,1.116064320881,1.116873845291,1.117670264234,1.118453709408,
	1.119224311213,1.119982198766,1.120727499916,1.121460341253,1.122180848122,
	1.122889144634,1.123585353679,1.124269596939,1.124941994900,1.125602666859,
	1.126251730943,1.126889304113,1.127515502184,1.128130439827,1.128734230588,
	1.129326986893,1.129908820064,1.130479840327,1.131040156824,1.131589877620,
	1.132129109722,1.132657959078,1.133176530599,1.133684928160,1.134183254614,
	1.134671611804,1.135150100570,1.135618820757,1.136077871231,1.136527349884,
	1.136967353642,1.137397978481,1.137819319430,1.138231470582,1.138634525107,
	1.139028575256,1.139413712370,1.139790026895,1.140157608385,1.140516545510,
	1.140866926071,1.141208837002,1.141542364384,1.141867593447,1.142184608585,
	1.142493493360,1.142794330510,1.143087201961,1.143372188831,1.143649371440,
	1.143918829315,1.144180641204,1.144434885075,1.144681638132,1.144920976817,
	1.145152976820,1.145377713085,1.145595259818,1.145805690495,1.146009077868,
	1.146205493972,1.146395010133,1.146577696976,1.146753624427,1.146922861726,
	1.147085477430,1.147241539422,1.147391114915,1.147534270459,1.147671071951,
	1.147801584637,1.147925873121,1.148044001370,1.148156032722,1.148262029889,
	1.148362054966,1.148456169438,1.148544434182,1.148626909475,1.148703655001,
	1.148774729856,1.148840192554,1.148900101031,1.148954512652,1.149003484219,
	1.149047071971,1.149085331595,1.149118318228,1.149146086464,1.149168690360,
	1.149186183437,1.149198618691,1.149206048596,1.149208525105,1.149206099664,
	1.149198823207,1.149186746170,1.149169918487,1.149148389605,1.149122208478,
	1.149091423582,1.149056082911,1.149016233989,1.148971923869,1.148923199141,
	1.148870105936,1.148812689927,1.148750996340,1.148685069954,1.148614955104,
	1.148540695691,1.148462335181,1.148379916610,1.148293482592,1.148203075319,
	1.148108736567,1.148010507699,1.147908429671,1.147802543034,1.147692887939,
	1.147579504140,1.147462431001,1.147341707493,1.147217372208,1.147089463352,
	1.146958018756,1.146823075878,1.146684671805,1.146542843258,1.146397626596,
	1.146249057818,1.146097172569,1.145942006139,1.145783593474,1.145621969169,
	1.145457167483,1.145289222333,1.145118167302,1.144944035641,1.144766860272,
	1.144586673794,1.144403508480,1.144217396287,1.144028368855,1.143836457512,
	1.143641693276,1.143444106858,1.143243728666,1.143040588807,1.142834717089,
	1.142626143029,1.142414895848,1.142201004480,1.141984497573,1.141765403492,
	1.141543750319,1.141319565862,1.141092877650,1.140863712942,1.140632098727,
	1.140398061727,1.140161628398,1.139922824937,1.139681677280,1.139438211105,
	1.139192451838,1.138944424654,1.138694154475,1.138441665980,1.138186983602,
	1.137930131531,1.137671133721,1.137410013884,1.137146795501,1.136881501818,
	1.136614155852,1.136344780391,1.136073397999,1.135800031014,1.135524701554,
	1.135247431518,1.134968242587,1.134687156227,1.134404193692,1.134119376025,
	1.133832724061,1.133544258426,1.133253999545,1.132961967636,1.132668182721,
	1.132372664621,1.132075432959,1.131776507166,1.131475906478,1.131173649943,
	1.130869756416,1.130564244568,1.130257132882,1.129948439660,1.129638183021,
	1.129326380904,1.129013051069,1.128698211102,1.128381878412,1.128064070236,
	1.127744803639,1.127424095517,1.127101962598,1.126778421444,1.126453488451,
	1.126127179854,1.125799511725,1.125470499977,1.125140160363,1.124808508482,
	1.124475559775,1.124141329531,1.123805832887,1.123469084829,1.123131100192,
	1.122791893667,1.122451479795,1.122109872975,1.121767087460,1.121423137364,
	1.121078036657,1.120731799172,1.120384438604,1.120035968511,1.119686402315,
	1.119335753306,1.118984034641,1.118631259344,1.118277440310,1.117922590308,
	1.117566721975,1.117209847825,1.116851980246,1.116493131503,1.116133313738,
	1.115772538971,1.115410819103,1.115048165915,1.114684591073,1.114320106123,
	1.113954722498,1.113588451514,1.113221304378,1.112853292180,1.112484425904,
	1.112114716420,1.111744174491,1.111372810772,1.111000635813,1.110627660055,
	1.110253893837,1.109879347394,1.109504030858,1.109127954259,1.108751127528,
	1.108373560495,1.107995262892,1.107616244354,1.107236514418,1.106856082526,
	1.106474958026,1.106093150171,1.105710668121,1.105327520946,1.104943717622,
	1.104559267038,1.104174177990,1.103788459189,1.103402119256,1.103015166727,
	1.102627610051,1.102239457592,1.101850717632,1.101461398367,1.101071507910,
	1.100681054296,1.100290045475,1.099898489320,1.099506393622,1.099113766096,
	1.098720614377,1.098326946024,1.097932768521,1.097538089274,1.097142915616,
	1.096747254805,1.096351114026,1.095954500392,1.095557420943,1.095159882649,
	1.094761892410,1.094363457053,1.093964583340,1.093565277962,1.093165547542,
	1.092765398639,1.092364837742,1.091963871277,1.091562505602,1.091160747013,
	1.090758601742,1.090356075956,1.089953175760,1.089549907199,1.089146276255,
	1.088742288849,1.088337950842,1.087933268035,1.087528246172,1.087122890937,
	1.086717207956,1.086311202798,1.085904880975,1.085498247944,1.085091309106,
	1.084684069806,1.084276535335,1.083868710931,1.083460601776,1.083052213002,
	1.082643549688,1.082234616859,1.081825419490,1.081415962506,1.081006250782,
	1.080596289139,1.080186082355,1.079775635153,1.079364952211,1.078954038159,
	1.078542897579,1.078131535005,1.077719954925,1.077308161782,1.076896159973,
	1.076483953849,1.076071547716,1.075658945837,1.075246152431,1.074833171672,
	1.074420007692,1.074006664582,1.073593146388,1.073179457116,1.072765600731,
	1.072351581154,1.071937402270,1.071523067921,1.071108581910,1.070693948000,
	1.070279169916,1.069864251344,1.069449195932,1.069034007290,1.068618688990,
	1.068203244568,1.067787677523,1.067371991317,1.066956189376,1.066540275092,
	1.066124251819,1.065708122878,1.065291891556,1.064875561104,1.064459134739,
	1.064042615645,1.063626006975,1.063209311845,1.062792533341,1.062375674516,
	1.061958738392,1.061541727956,1.061124646169,1.060707495956,1.060290280214,
	1.059873001810,1.059455663578,1.059038268325,1.058620818827,1.058203317831,
	1.057785768056,1.057368172191,1.056950532897,1.056532852807,1.056115134527,
	1.055697380634,1.055279593678,1.054861776182,1.054443930645,1.054026059534,
	1.053608165295,1.053190250344,1.052772317075,1.052354367854,1.051936405022,
	1.051518430897,1.051100447769,1.050682457905,1.050264463550,1.049846466923,
	1.049428470217,1.049010475606,1.048592485238,1.048174501239,1.047756525710,
	1.047338560732,1.046920608363,1.046502670637,1.046084749569,1.045666847151,
	1.045248965352,1.044831106121,1.044413271387,1.043995463055,1.043577683014,
	1.043159933128,1.042742215242,1.042324531183,1.041906882756,1.041489271746,
	1.041071699920,1.040654169026,1.040236680791,1.039819236924,1.039401839115,
	1.038984489037,1.038567188343,1.038149938667,1.037732741628,1.037315598825,
	1.036898511839,1.036481482235,1.036064511559,1.035647601342,1.035230753097,
	1.034813968319,1.034397248488,1.033980595067,1.033564009503,1.033147493226,
	1.032731047651,1.032314674176,1.031898374185,1.031482149045,1.031066000109,
	1.030649928713,1.030233936179,1.029818023815,1.029402192913,1.028986444749,
	1.028570780588,1.028155201678,1.027739709254,1.027324304537,1.026908988733,
	1.026493763035,1.026078628622,1.025663586660,1.025248638303,1.024833784687,
	1.024419026941,1.024004366177,1.023589803495,1.023175339983,1.022760976715,
	1.022346714755,1.021932555152,1.021518498944,1.021104547157,1.020690700805,
	1.020276960890,1.019863328402,1.019449804320,1.019036389610,1.018623085229,
	1.018209892120,1.017796811217,1.017383843443,1.016970989707,1.016558250912,
	1.016145627945,1.015733121686,1.015320733005,1.014908462757,1.014496311792,
	1.014084280947,1.013672371048,1.013260582914,1.012848917352,1.012437375160,
	1.012025957124,1.011614664024,1.011203496628,1.010792455696,1.010381541978,
	1.009970756213,1.009560099134,1.009149571464,1.008739173914,1.008328907192,
	1.007918771991,1.007508768999,1.007098898895,1.006689162349,1.006279560022,
	1.005870092566,1.005460760628,1.005051564843,1.004642505840,1.004233584240,
	1.003824800655,1.003416155689,1.003007649940,1.002599283996,1.002191058439,
	1.001782973842,1.001375030773,1.000967229789,1.000559571443,1.000152056278,
	0.999744684833,0.999337457636,0.998930375211,0.998523438074,0.998116646733,
	0.997710001691,0.997303503442,0.996897152477,0.996490949276,0.996084894315,
	0.995678988062,0.995273230981,0.994867623527,0.994462166151,0.994056859294,
	0.993651703395,0.993246698885,0.992841846188,0.992437145725,0.992032597907,
	0.991628203141,0.991223961831,0.990819874369,0.990415941148,0.990012162550,
	0.989608538954,0.989205070734,0.988801758256,0.988398601884,0.987995601972,
	0.987592758874,0.987190072934,0.986787544494,0.986385173889,0.985982961450,
	0.985580907502,0.985179012367,0.984777276358,0.984375699787,0.983974282960,
	0.983573026177,0.983171929734,0.982770993924,0.982370219031,0.981969605339,
	0.981569153126,0.981168862663,0.980768734219,0.980368768059,0.979968964442,
	0.979569323623,0.979169845853,0.978770531378,0.978371380442,0.977972393283,
	0.977573570133,0.977174911224,0.976776416782,0.976378087027,0.975979922179,
	0.975581922451,0.975184088054,0.974786419193,0.974388916070,0.973991578886,
	0.973594407833,0.973197403105,0.972800564887,0.972403893364,0.972007388717,
	0.971611051121,0.971214880750,0.970818877775,0.970423042360,0.970027374670,
	0.969631874862,0.969236543095,0.968841379519,0.968446384286,0.968051557540,
	0.967656899426,0.967262410082,0.966868089646,0.966473938252,0.966079956029,
	0.965686143106,0.965292499606,0.964899025652,0.964505721361,0.964112586850,
	0.963719622230,0.963326827612,0.962934203103,0.962541748806,0.962149464823,
	0.961757351253,0.961365408192,0.960973635732,0.960582033964,0.960190602976,
	0.959799342853,0.959408253678,0.959017335530,0.958626588488,0.958236012627,
	0.957845608018,0.957455374731,0.957065312836,0.956675422395,0.956285703474,
	0.955896156131,0.955506780425,0.955117576412,0.954728544145,0.954339683676,
	0.953950995054,0.953562478324,0.953174133532,0.952785960721,0.952397959930,
	0.952010131198,0.951622474560,0.951234990051,0.950847677702,0.950460537543,
	0.950073569603,0.949686773905,0.949300150476,0.948913699336,0.948527420505,
	0.948141314001,0.947755379840,0.947369618037,0.946984028604,0.946598611551,
	0.946213366888,0.945828294620,0.945443394753,0.945058667290,0.944674112233,
	0.944289729581,0.943905519334,0.943521481487,0.943137616034,0.942753922970,
	0.942370402285,0.941987053969,0.941603878012,0.941220874398,0.940838043113,
	0.940455384142,0.940072897465,0.939690583063,0.939308440915,0.938926470999,
	0.938544673290,0.938163047764,0.937781594392,0.937400313147,0.937019203999,
	0.936638266917,0.936257501868,0.935876908818,0.935496487731,0.935116238572,
	0.934736161302,0.934356255883,0.933976522272,0.933596960429,0.933217570310,
	0.932838351872,0.932459305067,0.932080429850,0.931701726172,0.931323193985,
	0.930944833236,0.930566643876,0.930188625850,0.929810779106,0.929433103587,
	0.929055599238,0.928678266001,0.928301103817,0.927924112628,0.927547292372,
	0.927170642988,0.926794164412,0.926417856582,0.926041719431,0.925665752895,
	0.925289956906,0.924914331396,0.924538876297,0.924163591538,0.923788477049,
	0.923413532757,0.923038758591,0.922664154476,0.922289720337,0.921915456100,
	0.921541361687,0.921167437022,0.920793682025,0.920420096618,0.920046680721,
	0.919673434253,0.919300357133,0.918927449277,0.918554710602,0.918182141024,
	0.917809740458,0.917437508819,0.917065446018,0.916693551971,0.916321826587,
	0.915950269778,0.915578881455,0.915207661526,0.914836609901,0.914465726488,
	0.914095011193,0.913724463925,0.913354084587,0.912983873087,0.912613829328,
	0.912243953214,0.911874244648,0.911504703533,0.911135329770,0.910766123261,
	0.910397083906,0.910028211605,0.909659506257,0.909290967761,0.908922596015,
	0.908554390916,0.908186352361,0.907818480246,0.907450774467,0.907083234919,
	0.906715861495,0.906348654091,0.905981612599,0.905614736912,0.905248026923,
	0.904881482522,0.904515103601,0.904148890050,0.903782841760,0.903416958620,
	0.903051240519,0.902685687346,0.902320298989,0.901955075334,0.901590016270,
	0.901225121682,0.900860391457,0.900495825480,0.900131423637,0.899767185812,
	0.899403111889,0.899039201752,0.898675455285,0.898311872370,0.897948452889,
	0.897585196726,0.897222103761,0.896859173875,0.896496406950,0.896133802865,
	0.895771361501,0.895409082737,0.895046966452,0.894685012526,0.894323220836,
	0.893961591261,0.893600123678,0.893238817965,0.892877673998,0.892516691654,
	0.892155870809,0.891795211339,0.891434713121,0.891074376027,0.890714199935,
	0.890354184718,0.889994330249,0.889634636405,0.889275103057,0.888915730078,
	0.888556517343,0.888197464724,0.887838572092,0.887479839319,0.887121266279,
	0.886762852841,0.886404598878,0.886046504259,0.885688568856,0.885330792538,
	0.884973175177,0.884615716641,0.884258416800,0.883901275524,0.883544292680,
	0.883187468139,0.882830801769,0.882474293437,0.882117943012,0.881761750361,
	0.881405715352,0.881049837853,0.880694117730,0.880338554850,0.879983149079,
	0.879627900285,0.879272808333,0.878917873090,0.878563094420,0.878208472190,
	0.877854006265,0.877499696509,0.877145542789,0.876791544968,0.876437702911,
	0.876084016483,0.875730485548,0.875377109969,0.875023889611,0.874670824337,
	0.874317914010,0.873965158494,0.873612557653,0.873260111348,0.872907819443,
	0.872555681800,0.872203698282,0.871851868751,0.871500193069,0.871148671099,
	0.870797302701,0.870446087738,0.870095026072,0.869744117563,0.869393362074,
	0.869042759464,0.868692309596,0.868342012330,0.867991867527,0.867641875047,
	0.867292034751,0.866942346499,0.866592810152,0.866243425569,0.865894192611,
	0.865545111138,0.865196181009,0.864847402085,0.864498774224,0.864150297286,
	0.863801971130,0.863453795617,0.863105770604,0.862757895951,0.862410171518,
	0.862062597162,0.861715172743,0.861367898119,0.861020773149,0.860673797691,
	0.860326971605,0.859980294748,0.859633766978,0.859287388154,0.858941158134,
	0.858595076776,0.858249143937,0.857903359477,0.857557723252,0.857212235121,
	0.856866894941,0.856521702569,0.856176657864,0.855831760683,0.855487010883,
	0.855142408322,0.854797952856,0.854453644344,0.854109482643,0.853765467609,
	0.853421599100,0.853077876973,0.852734301085,0.852390871293,0.852047587453,
	0.851704449424,0.851361457061,0.851018610221,0.850675908762,0.850333352540,
	0.849990941411,0.849648675232,0.849306553861,0.848964577153,0.848622744965,
	0.848281057154,0.847939513576,0.847598114087,0.847256858545,0.846915746805,
	0.846574778724,0.846233954159,0.845893272965,0.845552734999,0.845212340118,
	0.844872088177,0.844531979034,0.844192012543,0.843852188563,0.843512506948,
	0.843172967555,0.842833570240,0.842494314860,0.842155201271,0.841816229329,
	0.841477398890,0.841138709810,0.840800161946,0.840461755154,0.840123489290,
	0.839785364209,0.839447379770,0.839109535826,0.838771832236,0.838434268854,
	0.838096845538,0.837759562143,0.837422418525,0.837085414542,0.836748550048,
	0.836411824901,0.836075238956,0.835738792070,0.835402484099,0.835066314899,
	0.834730284327,0.834394392239,0.834058638491,0.833723022939,0.833387545441,
	0.833052205852,0.832717004029,0.832381939828,0.832047013105,0.831712223717,
	0.831377571521,0.831043056373,0.830708678129,0.830374436647,0.830040331782,
	0.829706363391,0.829372531331,0.829038835459,0.828705275631,0.828371851703,
	0.828038563533,0.827705410978,0.827372393893,0.827039512137,0.826706765565,
	0.826374154035,0.826041677404,0.825709335528,0.825377128264,0.825045055471,
	0.824713117003,0.824381312720,0.824049642477,0.823718106133,0.823386703543,
	0.823055434566,0.822724299059,0.822393296878,0.822062427882,0.821731691928,
	0.821401088873,0.821070618575,0.820740280891,0.820410075679,0.820080002797,
	0.819750062101,0.819420253450,0.819090576702,0.818761031714,0.818431618345,
	0.818102336451,0.817773185891,0.817444166524,0.817115278206,0.816786520797,
	0.816457894154,0.816129398135,0.815801032599,0.815472797404,0.815144692408,
	0.814816717469,0.814488872447,0.814161157200,0.813833571585,0.813506115462,
	0.813178788690,0.812851591127,0.812524522631,0.812197583062,0.811870772279,
	0.811544090140,0.811217536505,0.810891111232,0.810564814181,0.810238645210,
	0.809912604179,0.809586690948,0.809260905375,0.808935247320,0.808609716642,
	0.808284313202,0.807959036858,0.807633887470,0.807308864897,0.806983969001,
	0.806659199639,0.806334556673,0.806010039962,0.805685649366,0.805361384746,
	0.805037245961,0.804713232872,0.804389345338,0.804065583221,0.803741946380,
	0.803418434676,0.803095047970,0.802771786122,0.802448648992,0.802125636443,
	0.801802748333,0.801479984525,0.801157344879,0.800834829256,0.800512437516,
	0.800190169523,0.799868025135,0.799546004216,0.799224106625,0.798902332225,
	0.798580680877,0.798259152442,0.797937746782,0.797616463759,0.797295303234,
	0.796974265070,0.796653349128,0.796332555270,0.796011883359,0.795691333256,
	0.795370904823,0.795050597923,0.794730412418,0.794410348171,0.794090405043,
	0.793770582898,0.793450881599,0.793131301007,0.792811840985,0.792492501398,
	0.792173282106,0.791854182974,0.791535203864,0.791216344640,0.790897605165,
	0.790578985302,0.790260484914,0.789942103865,0.789623842018,0.789305699238,
	0.788987675387,0.788669770330,0.788351983930,0.788034316051,0.787716766557,
	0.787399335313,0.787082022182,0.786764827028,0.786447749717,0.786130790111,
	0.785813948077,0.785497223477,0.785180616178,0.784864126043,0.784547752937,
	0.784231496725,0.783915357273,0.783599334444,0.783283428105,0.782967638120,
	0.782651964354,0.782336406674,0.782020964944,0.781705639029,0.781390428796,
	0.781075334110,0.780760354837,0.780445490842,0.780130741992,0.779816108152,
	0.779501589188,0.779187184968,0.778872895356,0.778558720219,0.778244659423,
	0.777930712836,0.777616880323,0.777303161751,0.776989556987,0.776676065898,
	0.776362688350,0.776049424210,0.775736273347,0.775423235626,0.775110310914,
	0.774797499080,0.774484799990,0.774172213513,0.773859739515,0.773547377864,
	0.773235128428,0.772922991074,0.772610965672,0.772299052087,0.771987250190,
	0.771675559847,0.771363980926,0.771052513298,0.770741156828,0.770429911387,
	0.770118776843,0.769807753063,0.769496839918,0.769186037275,0.768875345005,
	0.768564762975,0.768254291055,0.767943929113,0.767633677020,0.767323534645,
	0.767013501856,0.766703578523,0.766393764517,0.766084059707,0.765774463961,
	0.765464977151,0.765155599147,0.764846329817,0.764537169033,0.764228116664,
	0.763919172582,0.763610336655,0.763301608755,0.762992988752,0.762684476517,
	0.762376071920,0.762067774833,0.761759585125,0.761451502669,0.761143527335,
	0.760835658995,0.760527897519,0.760220242779,0.759912694646,0.759605252992,
	0.759297917689,0.758990688608,0.758683565620,0.758376548598,0.758069637414,
	0.757762831940,0.757456132047,0.757149537608,0.756843048496,0.756536664582,
	0.756230385739,0.755924211840,0.755618142758,0.755312178364,0.755006318533,
	0.754700563136,0.754394912047,0.754089365138,0.753783922284,0.753478583357,
	0.753173348231,0.752868216779,0.752563188875,0.752258264392,0.751953443204,
	0.751648725185,0.751344110208,0.751039598148,0.750735188879,0.750430882275,
	0.750126678209,0.749822576558,0.749518577194,0.749214679993,0.748910884828,
	0.748607191576,0.748303600109,0.748000110305,0.747696722036,0.747393435179,
	0.747090249609,0.746787165200,0.746484181828,0.746181299369,0.745878517698,
	0.745575836690,0.745273256222,0.744970776168,0.744668396406,0.744366116811,
	0.744063937258,0.743761857624,0.743459877786,0.743157997619,0.742856217000,
	0.742554535806,0.742252953913,0.741951471197,0.741650087536,0.741348802806,
	0.741047616885,0.740746529649,0.740445540975,0.740144650741,0.739843858824,
	0.739543165101,0.739242569450,0.738942071749,0.738641671875,0.738341369705,
	0.738041165119,0.737741057993,0.737441048205,0.737141135635,0.736841320159,
	0.736541601657,0.736241980006,0.735942455086,0.735643026775,0.735343694951,
	0.735044459493,0.734745320280,0.734446277192,0.734147330106,0.733848478902,
	0.733549723460,0.733251063659,0.732952499378,0.732654030496,0.732355656893,
	0.732057378449,0.731759195044,0.731461106557,0.731163112869,0.730865213859,
	0.730567409407,0.730269699395,0.729972083701,0.729674562207,0.729377134792,
	0.729079801338,0.728782561726,0.728485415835,0.728188363548,0.727891404743,
	0.727594539304,0.727297767111,0.727001088045,0.726704501987,0.726408008819,
	0.726111608423,0.725815300680,0.725519085471,0.725222962678,0.724926932184,
	0.724630993870,0.724335147619,0.724039393311,0.723743730831,0.723448160059,
	0.723152680879,0.722857293172,0.722561996822,0.722266791712,0.721971677723,
	0.721676654739,0.721381722642,0.721086881317,0.720792130645,0.720497470511,
	0.720202900797,0.719908421387,0.719614032164,0.719319733013,0.719025523816,
	0.718731404458,0.718437374822,0.718143434793,0.717849584254,0.717555823090,
	0.717262151184,0.716968568422,0.716675074687,0.716381669864,0.716088353839,
	0.715795126494,0.715501987716,0.715208937389,0.714915975398,0.714623101628,
	0.714330315965,0.714037618293,0.713745008499,0.713452486466,0.713160052082,
	0.712867705231,0.712575445799,0.712283273673,0.711991188737,0.711699190879,
	0.711407279983,0.711115455937,0.710823718626,0.710532067937,0.710240503757,
	0.709949025971,0.709657634467,0.709366329131,0.709075109850,0.708783976511,
	0.708492929001,0.708201967207,0.707911091016,0.707620300316,0.707329594993,
	0.707038974937,0.706748440033,0.706457990169,0.706167625234,0.705877345115,
	0.705587149700,0.705297038878,0.705007012535,0.704717070561,0.704427212844,
	0.704137439272,0.703847749733,0.703558144116,0.703268622311,0.702979184204,
	0.702689829687,0.702400558646,0.702111370972,0.701822266554,0.701533245280,
	0.701244307041,0.700955451724,0.700666679221,0.700377989420,0.700089382212,
	0.699800857485,0.699512415131,0.699224055038,0.698935777097,0.698647581198,
	0.698359467231,0.698071435087,0.697783484655,0.697495615827,0.697207828494,
	0.696920122545,0.696632497871,0.696344954364,0.696057491915,0.695770110414,
	0.695482809752,0.695195589822,0.694908450514,0.694621391719,0.694334413329,
	0.694047515237,0.693760697333,0.693473959509,0.693187301657,0.692900723670,
	0.692614225439,0.692327806857,0.692041467815,0.691755208206,0.691469027923,
	0.691182926858,0.690896904903,0.690610961952,0.690325097898,0.690039312632,
	0.689753606049,0.689467978041,0.689182428502,0.688896957324,0.688611564402,
	0.688326249628,0.688041012896,0.687755854100,0.687470773134,0.687185769891,
	0.686900844266,0.686615996152,0.686331225443,0.686046532034,0.685761915820,
	0.685477376693,0.685192914550,0.684908529284,0.684624220790,0.684339988963,
	0.684055833698,0.683771754890,0.683487752434,0.683203826224,0.682919976157,
	0.682636202127,0.682352504030,0.682068881761,0.681785335217,0.681501864292,
	0.681218468883,0.680935148885,0.680651904194,0.680368734707,0.680085640320,
	0.679802620928,0.679519676429,0.679236806718,0.678954011692,0.678671291248,
	0.678388645283,0.678106073692,0.677823576375,0.677541153226,0.677258804143,
	0.676976529024,0.676694327766,0.676412200266,0.676130146422,0.675848166130,
	0.675566259290,0.675284425798,0.675002665552,0.674720978450,0.674439364391,
	0.674157823272,0.673876354992,0.673594959449,0.673313636541,0.673032386167,
	0.672751208225,0.672470102615,0.672189069234,0.671908107981,0.671627218757,
	0.671346401459,0.671065655986,0.670784982239,0.670504380116,0.670223849517,
	0.669943390341,0.669663002488,0.669382685858,0.669102440350,0.668822265864,
	0.668542162300,0.668262129559,0.667982167540,0.667702276144,0.667422455270,
	0.667142704821,0.666863024695,0.666583414794,0.666303875018,0.666024405269,
	0.665745005447,0.665465675452,0.665186415187,0.664907224553,0.664628103450,
	0.664349051780,0.664070069444,0.663791156345,0.663512312383,0.663233537461,
	0.662954831481,0.662676194343,0.662397625951,0.662119126206,0.661840695011,
	0.661562332268,0.661284037880,0.661005811748,0.660727653776,0.660449563865,
	0.660171541920,0.659893587843,0.659615701536,0.659337882903,0.659060131847,
	0.658782448272,0.658504832080,0.658227283175,0.657949801461,0.657672386841,
	0.657395039218,0.657117758498,0.656840544583,0.656563397378,0.656286316786,
	0.656009302712,0.655732355061,0.655455473736,0.655178658642,0.654901909684,
	0.654625226766,0.654348609793,0.654072058670,0.653795573302,0.653519153594,
	0.653242799450,0.652966510777,0.652690287480,0.652414129463,0.652138036633,
	0.651862008894,0.651586046154,0.651310148317,0.651034315289,0.650758546977,
	0.650482843287,0.650207204124,0.649931629394,0.649656119005,0.649380672863,
	0.649105290874,0.648829972945,0.648554718982,0.648279528893,0.648004402584,
	0.647729339963,0.647454340936,0.647179405411,0.646904533295,0.646629724495,
	0.646354978919,0.646080296474,0.645805677069,0.645531120610,0.645256627007,
	0.644982196166,0.644707827996,0.644433522404,0.644159279300,0.643885098592,
	0.643610980187,0.643336923995,0.643062929925,0.642788997884,0.642515127781,
	0.642241319526,0.641967573028,0.641693888196,0.641420264938,0.641146703165,
	0.640873202785,0.640599763708,0.640326385844,0.640053069102,0.639779813392,
	0.639506618624,0.639233484708,0.638960411554,0.638687399072,0.638414447172,
	0.638141555765,0.637868724761,0.637595954071,0.637323243605,0.637050593274,
	0.636778002988,0.636505472660,0.636233002199,0.635960591517,0.635688240524,
	0.635415949134,0.635143717255,0.634871544801,0.634599431683,0.634327377812,
	0.634055383100,0.633783447460,0.633511570802,0.633239753039,0.632967994084,
	0.632696293848,0.632424652244,0.632153069184,0.631881544581,0.631610078348,
	0.631338670396,0.631067320640,0.630796028991,0.630524795364,0.630253619670,
	0.629982501824,0.629711441738,0.629440439326,0.629169494502,0.628898607179,
	0.628627777270,0.628357004690,0.628086289352,0.627815631171,0.627545030060,
	0.627274485934,0.627003998706,0.626733568292,0.626463194606,0.626192877561,
	0.625922617074,0.625652413059,0.625382265430,0.625112174102,0.624842138991,
	0.624572160012,0.624302237079,0.624032370109,0.623762559016,0.623492803716,
	0.623223104126,0.622953460159,0.622683871733,0.622414338763,0.622144861166,
	0.621875438856,0.621606071752,0.621336759768,0.621067502821,0.620798300828,
	0.620529153705,0.620260061370,0.619991023738,0.619722040727,0.619453112253,
	0.619184238234,0.618915418587,0.618646653229,0.618377942078,0.618109285050,
	0.617840682065,0.617572133038,0.617303637888,0.617035196534,0.616766808891,
	0.616498474880,0.616230194418,0.615961967423,0.615693793814,0.615425673508,
	0.615157606425,0.614889592484,0.614621631602,0.614353723699,0.614085868693,
	0.613818066505,0.613550317052,0.613282620254,0.613014976031,0.612747384301,
	0.612479844985,0.612212358002,0.611944923271,0.611677540713,0.611410210247,
	0.611142931794,0.610875705273,0.610608530605,0.610341407710,0.610074336508,
	0.609807316920,0.609540348867,0.609273432269,0.609006567047,0.608739753122,
	0.608472990414,0.608206278846,0.607939618338,0.607673008812,0.607406450188,
	0.607139942389,0.606873485336,0.606607078950,0.606340723154,0.606074417869,
	0.605808163017,0.605541958521,0.605275804303,0.605009700284,0.604743646387,
	0.604477642536,0.604211688651,0.603945784657,0.603679930475,0.603414126029,
	0.603148371241,0.602882666035,0.602617010334,0.602351404062,0.602085847140,
	0.601820339494,0.601554881046,0.601289471721,0.601024111441,0.600758800131,
	0.600493537716,0.600228324118,0.599963159262,0.599698043073,0.599432975474,
	0.599167956391,0.598902985748,0.598638063469,0.598373189479,0.598108363703,
	0.597843586067,0.597578856494,0.597314174911,0.597049541243,0.596784955415,
	0.596520417352,0.596255926980,0.595991484225,0.595727089013,0.595462741269,
	0.595198440919,0.594934187890,0.594669982108,0.594405823498,0.594141711988,
	0.593877647504,0.593613629972,0.593349659319,0.593085735472,0.592821858358,
	0.592558027903,0.592294244035,0.592030506682,0.591766815770,0.591503171226,
	0.591239572979,0.590976020955,0.590712515083,0.590449055291,0.590185641505,
	0.589922273655,0.589658951668,0.589395675473,0.589132444997,0.588869260170,
	0.588606120920,0.588343027175,0.588079978864
	}
};

double always_inline w20_1_negclip(double x) {
    double f = fabs(x);
    f = f * w20_1_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = w20_1_neg_table.data[0];
    } else if (i >= w20_1_neg_table.size-1) {
        f = w20_1_neg_table.data[w20_1_neg_table.size-1];
    } else {
    f -= i;
    f = w20_1_neg_table.data[i]*(1-f) + w20_1_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

