/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.elementvalues;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;

public class EnumElementValue
extends ElementValue {
    public static final String ENTRY_NAME = "EnumElement";
    private static final int LENGTH = 4;
    private int typeNameIndex;
    private int constNameIndex;

    protected EnumElementValue() {
        super(101);
    }

    public int getTypeNameIndex() {
        return this.typeNameIndex;
    }

    public void setTypeNameIndex(int n) {
        this.typeNameIndex = n;
    }

    public int getConstNameIndex() {
        return this.constNameIndex;
    }

    public void setConstNameIndex(int n) {
        this.constNameIndex = n;
    }

    protected int getSpecificLength() {
        return 4;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.typeNameIndex = dataInput.readUnsignedShort();
        this.constNameIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.typeNameIndex);
        dataOutput.writeShort(this.constNameIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "EnumElementValue with type_name_index " + this.typeNameIndex + ", const_name_index " + this.constNameIndex);
    }

    public String getEntryName() {
        return ENTRY_NAME;
    }
}

