/**
 * This package contains various classes pertaining to "resources": anything that needs to be injected into
 * tests and which may need to be started up or torn down. A common example is a temporary directory.
 *
 * <p>Check out the following types for details on the "temporary directory" extension:
 * <ul>
 *     <li>{@link org.junitpioneer.jupiter.resource.TemporaryDirectory}</li>
 *     <li>{@link org.junitpioneer.jupiter.resource.Dir}</li>
 * </ul>
 *
 * <p>Check out the following types for details on resources in general:
 * <ul>
 *     <li>{@link org.junitpioneer.jupiter.resource.Resource}</li>
 *     <li>{@link org.junitpioneer.jupiter.resource.ResourceFactory}</li>
 *     <li>{@link org.junitpioneer.jupiter.resource.New}</li>
 *     <li>{@link org.junitpioneer.jupiter.resource.Shared}</li>
 * </ul>
 */

package org.junitpioneer.jupiter.resource;
