/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.graphics.ImageUtil;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    NSOpenGLContext glcontext;
    NSBezierPath visiblePath;
    static NSMutableArray supportedPboardTypes = NSMutableArray.arrayWithCapacity(1L);

    Canvas() {
    }

    @Override
    long attributedSubstringFromRange(long id2, long sel, long range) {
        if (this.ime != null) {
            return this.ime.attributedSubstringFromRange(id2, sel, range);
        }
        return super.attributedSubstringFromRange(id2, sel, range);
    }

    @Override
    void sendFocusEvent(int type) {
        if (this.caret != null) {
            if (type == 15) {
                this.caret.setFocus();
            } else {
                this.caret.killFocus();
            }
        }
        super.sendFocusEvent(type);
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    long characterIndexForPoint(long id2, long sel, long point) {
        if (this.ime != null) {
            return this.ime.characterIndexForPoint(id2, sel, point);
        }
        return super.characterIndexForPoint(id2, sel, point);
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        this.drawBackground(gc, x, y, width, height, 0, 0);
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        super.drawBackground(id2, context, rect);
        if (this.glcontext != null) {
            if (this.isObscured()) {
                this.glcontext.setValues(new int[]{-1}, 235L);
                context.saveGraphicsState();
                context.setCompositingOperation(0L);
                if (this.visiblePath == null) {
                    long visibleRegion = this.getVisibleRegion();
                    this.visiblePath = this.getPath(visibleRegion);
                    OS.DisposeRgn(visibleRegion);
                }
                this.visiblePath.addClip();
                NSBezierPath.fillRect(rect);
                context.restoreGraphicsState();
            } else {
                this.glcontext.setValues(new int[]{1}, 235L);
            }
        }
    }

    @Override
    void drawRect(long id2, long sel, NSRect rect) {
        if (this.glcontext != null && this.glcontext.view() == null) {
            this.glcontext.setView(this.view);
        }
        super.drawRect(id2, sel, rect);
    }

    @Override
    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        super.drawWidget(id2, context, rect);
        if (this.caret == null) {
            return;
        }
        if (this.caret.isShowing) {
            long ctx = context.graphicsPort();
            OS.CGContextSaveGState(ctx);
            OS.CGContextSetBlendMode(ctx, 10);
            Image image = this.caret.image;
            if (image != null) {
                NSImage imageHandle = image.handle;
                NSSize size = imageHandle.size();
                NSBitmapImageRep imageRep = ImageUtil.createImageRep(image, size);
                if (!imageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                    return;
                }
                NSBitmapImageRep rep = new NSBitmapImageRep(imageRep);
                CGRect destRect = new CGRect();
                destRect.origin.x = this.caret.x;
                destRect.origin.y = this.caret.y;
                destRect.size.width = size.width;
                destRect.size.height = size.height;
                long data = rep.bitmapData();
                long format = rep.bitmapFormat();
                long bpr = rep.bytesPerRow();
                int alphaInfo = rep.hasAlpha() ? ((format & 1L) != 0L ? 4 : 3) : ((format & 1L) != 0L ? 6 : 5);
                long provider = OS.CGDataProviderCreateWithData(0L, data, bpr * (long)((int)size.height), 0L);
                long colorspace = OS.CGColorSpaceCreateDeviceRGB();
                long cgImage = OS.CGImageCreate((int)size.width, (int)size.height, rep.bitsPerSample(), rep.bitsPerPixel(), bpr, colorspace, alphaInfo, provider, 0L, true, 0);
                OS.CGColorSpaceRelease(colorspace);
                OS.CGDataProviderRelease(provider);
                OS.CGContextScaleCTM(ctx, 1.0, -1.0);
                OS.CGContextTranslateCTM(ctx, 0.0, -(size.height + 2.0 * destRect.origin.y));
                OS.CGContextSetBlendMode(ctx, 10);
                OS.CGContextDrawImage(ctx, destRect, cgImage);
                OS.CGImageRelease(cgImage);
            } else {
                CGRect drawRect = new CGRect();
                drawRect.origin.x = this.caret.x;
                drawRect.origin.y = this.caret.y;
                drawRect.size.width = this.caret.width != 0 ? (double)this.caret.width : 1.0;
                drawRect.size.height = this.caret.height;
                long colorspace = OS.CGColorSpaceCreateDeviceRGB();
                OS.CGContextSetFillColorSpace(ctx, colorspace);
                OS.CGColorSpaceRelease(colorspace);
                OS.CGContextSetFillColor(ctx, new double[]{1.0, 1.0, 1.0, 1.0});
                OS.CGContextFillRect(ctx, drawRect);
            }
            OS.CGContextRestoreGState(ctx);
        }
    }

    @Override
    NSRect firstRectForCharacterRange(long id2, long sel, long range) {
        if (this.ime != null) {
            return this.ime.firstRectForCharacterRange(id2, sel, range);
        }
        return super.firstRectForCharacterRange(id2, sel, range);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    boolean hasMarkedText(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.hasMarkedText(id2, sel);
        }
        return super.hasMarkedText(id2, sel);
    }

    @Override
    boolean imeInComposition() {
        return this.ime != null && this.ime.isInlineEnabled() && this.ime.startOffset != -1;
    }

    @Override
    boolean insertText(long id2, long sel, long string) {
        if (this.ime != null && !this.ime.insertText(id2, sel, string)) {
            return false;
        }
        return super.insertText(id2, sel, string);
    }

    @Override
    boolean isOpaque(long id2, long sel) {
        if (this.glcontext != null) {
            return true;
        }
        return super.isOpaque(id2, sel);
    }

    @Override
    NSRange markedRange(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.markedRange(id2, sel);
        }
        return super.markedRange(id2, sel);
    }

    @Override
    boolean readSelectionFromPasteboard(long id2, long sel, long pasteboard) {
        boolean result = false;
        NSPasteboard pboard = new NSPasteboard(pasteboard);
        NSArray availableTypes = pboard.types();
        for (long i = 0L; i < supportedPboardTypes.count() && !result; ++i) {
            NSString type = new NSString(supportedPboardTypes.objectAtIndex(i));
            if (!availableTypes.containsObject(type)) continue;
            result = this.readSelectionFromPasteboard(pboard, type);
        }
        return result;
    }

    boolean readSelectionFromPasteboard(NSPasteboard pboard, NSString type) {
        NSString string;
        boolean result = false;
        NSString newSelection = null;
        if (type.isEqualToString(OS.NSPasteboardTypeString) && (string = pboard.stringForType(OS.NSPasteboardTypeString)) != null && string.length() > 0L) {
            newSelection = string;
        }
        if (newSelection != null) {
            Accessible acc = this.getAccessible();
            acc.internal_accessibilitySetValue_forAttribute(newSelection, OS.NSAccessibilitySelectedTextAttribute, -1);
            result = true;
        }
        return result;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.caret != null) {
            this.caret.reskin(flags);
        }
        if (this.ime != null) {
            this.ime.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    @Override
    void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.visiblePath != null) {
            this.visiblePath.release();
        }
        this.visiblePath = null;
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        Control control;
        boolean redraw;
        Rectangle clientRect;
        Rectangle sourceRect;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isDrawing()) {
            return;
        }
        NSRect visibleRect = this.view.visibleRect();
        if (visibleRect.width <= 0.0 || visibleRect.height <= 0.0) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if ((sourceRect = new Rectangle(x, y, width, height)).intersects(clientRect = this.getClientArea())) {
            this.getShell().setScrolling();
            this.update(all);
        }
        boolean bl2 = redraw = (control = this.findBackgroundControl()) != null && control.backgroundImage != null;
        if (!redraw) {
            redraw = this.hasRegion();
        }
        if (!redraw) {
            redraw = this.isObscured();
        }
        if (redraw) {
            this.redrawWidget(this.view, x, y, width, height, false);
            this.redrawWidget(this.view, destX, destY, width, height, false);
        } else {
            boolean disjoint;
            NSRect damage = new NSRect();
            damage.x = x;
            damage.y = y;
            damage.width = width;
            damage.height = height;
            NSPoint dest = new NSPoint();
            dest.x = destX;
            dest.y = destY;
            this.view.lockFocus();
            NSSize delta = new NSSize();
            delta.width = deltaX;
            delta.height = deltaY;
            this.view.scrollRect(damage, delta);
            this.view.unlockFocus();
            boolean bl3 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
            if (disjoint) {
                this.view.setNeedsDisplayInRect(damage);
            } else {
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    damage.x = newX;
                    damage.width = Math.abs(deltaX);
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    damage.x = x;
                    damage.y = newY;
                    damage.width = width;
                    damage.height = Math.abs(deltaY);
                    this.view.setNeedsDisplayInRect(damage);
                }
            }
            NSRect srcRect = new NSRect();
            srcRect.x = sourceRect.x;
            srcRect.y = sourceRect.y;
            srcRect.width = sourceRect.width;
            srcRect.height = sourceRect.height;
            OS.NSIntersectionRect(visibleRect, visibleRect, srcRect);
            if (!OS.NSEqualRects(visibleRect, srcRect)) {
                if (srcRect.x != visibleRect.x) {
                    damage.x = srcRect.x + (double)deltaX;
                    damage.y = srcRect.y + (double)deltaY;
                    damage.width = visibleRect.x - srcRect.x;
                    damage.height = srcRect.height;
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (visibleRect.x + visibleRect.width != srcRect.x + srcRect.width) {
                    damage.x = srcRect.x + visibleRect.width + (double)deltaX;
                    damage.y = srcRect.y + (double)deltaY;
                    damage.width = srcRect.width - visibleRect.width;
                    damage.height = srcRect.height;
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (visibleRect.y != srcRect.y) {
                    damage.x = visibleRect.x + (double)deltaX;
                    damage.y = srcRect.y + (double)deltaY;
                    damage.width = visibleRect.width;
                    damage.height = visibleRect.y - srcRect.y;
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (visibleRect.y + visibleRect.height != srcRect.y + srcRect.height) {
                    damage.x = visibleRect.x + (double)deltaX;
                    damage.y = visibleRect.y + visibleRect.height + (double)deltaY;
                    damage.width = visibleRect.width;
                    damage.height = srcRect.y + srcRect.height - (visibleRect.y + visibleRect.height);
                    this.view.setNeedsDisplayInRect(damage);
                }
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) < Math.max(x, rect.x) || Math.min(y + height, rect.y + rect.height) < Math.max(y, rect.y)) continue;
                child.setLocation(rect.x + deltaX, rect.y + deltaY);
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    @Override
    NSRange selectedRange(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.selectedRange(id2, sel);
        }
        return super.selectedRange(id2, sel);
    }

    @Override
    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        if (this.caret != null) {
            NSCursor.setHiddenUntilMouseMoves(true);
        }
        return super.sendKeyEvent(nsEvent, type);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    @Override
    void setOpenGLContext(Object value) {
        this.glcontext = (NSOpenGLContext)value;
        Shell shell = this.getShell();
        shell.glContextCount = this.glcontext != null ? ++shell.glContextCount : --shell.glContextCount;
        shell.updateOpaque();
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            this.error(5);
        }
        this.ime = ime;
    }

    @Override
    boolean setMarkedText_selectedRange(long id2, long sel, long string, long range) {
        if (this.ime != null && !this.ime.setMarkedText_selectedRange(id2, sel, string, range)) {
            return false;
        }
        return super.setMarkedText_selectedRange(id2, sel, string, range);
    }

    @Override
    long validAttributesForMarkedText(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.validAttributesForMarkedText(id2, sel);
        }
        return super.validAttributesForMarkedText(id2, sel);
    }

    @Override
    long validRequestorForSendType(long id2, long sel, long sendType, long returnType) {
        NSArray attributes;
        Accessible acc;
        if (id2 == this.view.id && (acc = this.getAccessible()) != null && (attributes = acc.internal_accessibilityAttributeNames(-1)) != null) {
            NSString selectionString;
            id selection;
            boolean canHandlePBoardType;
            boolean canReturn = attributes.containsObject(OS.NSAccessibilitySelectedTextAttribute);
            boolean canSend = acc.internal_accessibilityIsAttributeSettable(OS.NSAccessibilitySelectedTextAttribute, -1);
            boolean bl = canHandlePBoardType = supportedPboardTypes.containsObject(new id(sendType)) && supportedPboardTypes.containsObject(new id(returnType));
            if (canReturn && canSend && canHandlePBoardType && (selection = acc.internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (selectionString = new NSString(selection)).length() > 0L) {
                return this.view.id;
            }
        }
        return super.validRequestorForSendType(id2, sel, sendType, returnType);
    }

    @Override
    void updateOpenGLContext(long id2, long sel, long notification) {
        if (this.glcontext != null) {
            this.glcontext.update();
        }
    }

    @Override
    void viewWillMoveToWindow(long id2, long sel, long arg0) {
        super.viewWillMoveToWindow(id2, sel, arg0);
        if (this.glcontext != null && id2 == this.view.id && arg0 != 0L) {
            Widget newShell = this.display.getWidget(new NSWindow(arg0).contentView());
            if (newShell instanceof Shell) {
                ++((Shell)newShell).glContextCount;
                ((Shell)newShell).updateOpaque();
            }
            Shell shell = this.getShell();
            --shell.glContextCount;
            shell.updateOpaque();
        }
    }

    @Override
    boolean writeSelectionToPasteboard(long id2, long sel, long pasteboardObj, long typesObj) {
        NSString type;
        long i;
        boolean result = false;
        NSPasteboard pboard = new NSPasteboard(pasteboardObj);
        NSArray types = new NSArray(typesObj);
        NSMutableArray typesToDeclare = NSMutableArray.arrayWithCapacity(2L);
        for (i = 0L; i < supportedPboardTypes.count(); ++i) {
            type = new NSString(supportedPboardTypes.objectAtIndex(i));
            if (!types.containsObject(type)) continue;
            typesToDeclare.addObject(type);
        }
        if (typesToDeclare.count() > 0L) {
            pboard.declareTypes(typesToDeclare, this.view);
            for (i = 0L; i < typesToDeclare.count(); ++i) {
                type = new NSString(typesToDeclare.objectAtIndex(i));
                if (!this.writeSelectionToPasteboard(pboard, type)) continue;
                result = true;
            }
        }
        return result;
    }

    boolean writeSelectionToPasteboard(NSPasteboard pboard, NSString type) {
        NSString selectionString;
        Accessible acc;
        id selection;
        boolean result = false;
        if (type.isEqualToString(OS.NSPasteboardTypeString) && (selection = (acc = this.getAccessible()).internal_accessibilityAttributeValue(OS.NSAccessibilitySelectedTextAttribute, -1)) != null && (selectionString = new NSString(selection)).length() > 0L) {
            result = pboard.setString(selectionString, OS.NSPasteboardTypeString);
        }
        return result;
    }

    static {
        supportedPboardTypes.retain();
        supportedPboardTypes.addObject(OS.NSPasteboardTypeString);
    }
}

