/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    ImageList imageList;
    long clientHandle;
    long boxHandle;
    long labelHandle;
    long imageHandle;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;

    public ExpandItem(ExpandBar parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(index);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.handle = GTK.gtk_expander_new(null);
        if (this.handle == 0L) {
            this.error(2);
        }
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.clientHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_container_add(this.handle, this.clientHandle);
        this.boxHandle = this.gtk_box_new(0, false, 4);
        if (this.boxHandle == 0L) {
            this.error(2);
        }
        this.labelHandle = GTK.gtk_label_new(null);
        if (this.labelHandle == 0L) {
            this.error(2);
        }
        this.imageHandle = GTK.gtk_image_new();
        if (this.imageHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_container_add(this.boxHandle, this.imageHandle);
        GTK.gtk_container_add(this.boxHandle, this.labelHandle);
        GTK.gtk_expander_set_label_widget(this.handle, this.boxHandle);
        GTK.gtk_widget_set_can_focus(this.handle, true);
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.showWidget(index);
        this.parent.createItem(this, this.style, index);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.boxHandle);
        this.display.removeWidget(this.labelHandle);
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void release(boolean destroy) {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.release(destroy);
        }
        super.release(destroy);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    void drawChevron(GC gc, int x, int y) {
        int[] polyline2;
        int[] polyline1;
        if (this.expanded) {
            int px = x + 4 + 5;
            int py = y + 4 + 7;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 6, py};
        } else {
            int px = x + 4 + 5;
            int py = y + 4 + 4;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 6, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 6, py};
        }
        gc.setForeground(this.display.getSystemColor(30));
        gc.drawPolyline(DPIUtil.autoScaleDown(polyline1));
        gc.drawPolyline(DPIUtil.autoScaleDown(polyline2));
    }

    void drawItem(GC gc, boolean drawFocus) {
        int headerHeight = this.parent.getBandHeight();
        Display display = this.getDisplay();
        gc.setForeground(display.getSystemColor(31));
        gc.setBackground(display.getSystemColor(32));
        gc.fillGradientRectangle(this.x, this.y, this.width, headerHeight, true);
        if (this.expanded) {
            gc.setForeground(display.getSystemColor(32));
            gc.drawLine(this.x, this.y + headerHeight, this.x, this.y + headerHeight + this.height - 1);
            gc.drawLine(this.x, this.y + headerHeight + this.height - 1, this.x + this.width - 1, this.y + headerHeight + this.height - 1);
            gc.drawLine(this.x + this.width - 1, this.y + headerHeight + this.height - 1, this.x + this.width - 1, this.y + headerHeight);
        }
        int drawX = this.x;
        if (this.image != null) {
            drawX += 6;
            if (this.imageHeight > headerHeight) {
                gc.drawImage(this.image, drawX, this.y + headerHeight - this.imageHeight);
            } else {
                gc.drawImage(this.image, drawX, this.y + (headerHeight - this.imageHeight) / 2);
            }
            drawX += this.imageWidth;
        }
        if (this.text.length() > 0) {
            Point size = gc.stringExtent(this.text);
            gc.setForeground(this.parent.getForeground());
            gc.drawString(this.text, drawX += 6, this.y + (headerHeight - size.y) / 2, true);
        }
        int chevronSize = 24;
        this.drawChevron(gc, this.x + this.width - chevronSize, this.y + (headerHeight - chevronSize) / 2);
        if (drawFocus) {
            gc.drawFocus(this.x + 1, this.y + 1, this.width - 2, headerHeight - 2);
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        int headerHeight = allocation.height - (this.expanded ? this.height : 0);
        if (this.expanded && headerHeight < 0) {
            return allocation.height;
        }
        return headerHeight;
    }

    public int getHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeightInPixels());
    }

    int getHeightInPixels() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(GC gc) {
        int width = 36;
        if (this.image != null) {
            width += 6 + this.imageWidth;
        }
        if (this.text.length() > 0) {
            width += gc.stringExtent((String)this.text).x;
        }
        return width;
    }

    @Override
    long gtk_activate(long widget) {
        Event event = new Event();
        event.item = this;
        int type = GTK.gtk_expander_get_expanded(this.handle) ? 18 : 17;
        this.parent.sendEvent(type, event);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        this.setFocus();
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        GTK.gtk_widget_set_can_focus(this.handle, false);
        this.parent.lastFocus = this;
        return 0L;
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        this.parent.layoutItems(0, false);
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long widget, long event) {
        this.parent.gtk_enter_notify_event(widget, event);
        return 0L;
    }

    boolean hasFocus() {
        return GTK.gtk_widget_has_focus(this.handle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(60), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        OS.g_signal_connect_closure(this.clientHandle, OS.size_allocate, this.display.getClosure(47), true);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
    }

    void redraw() {
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.boxHandle, this);
        this.display.addWidget(this.labelHandle, this);
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.boxHandle = 0L;
        this.clientHandle = 0L;
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.imageList = null;
        this.control = null;
    }

    void resizeControl(int yScroll) {
        if (this.control != null && !this.control.isDisposed()) {
            boolean visible = GTK.gtk_expander_get_expanded(this.handle);
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.clientHandle, allocation);
            int x = 0;
            int y = 0;
            if (x != -1 && y != -1) {
                int width = allocation.width;
                int height = allocation.height;
                int[] property = new int[1];
                GTK.gtk_widget_style_get(this.handle, OS.focus_line_width, property, 0L);
                y += property[0] * 2;
                height -= property[0] * 2;
                ScrollBar vBar = this.parent.verticalBar;
                if (vBar != null && GTK.gtk_widget_get_visible(vBar.handle)) {
                    GTK.gtk_widget_get_allocation(this.parent.scrolledHandle, allocation);
                    width = allocation.width - this.parent.vScrollBarWidth() - 2 * this.parent.spacing;
                }
                if (visible) {
                    GTK.gtk_widget_show(this.control.topHandle());
                }
                this.control.setBounds(x, y, width, Math.max(0, height), true, true);
            }
            this.control.setVisible(visible);
        }
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean size) {
        this.redraw();
        int headerHeight = this.parent.getBandHeight();
        if (move) {
            if (this.imageHeight > headerHeight) {
                y += this.imageHeight - headerHeight;
            }
            this.x = x;
            this.y = y;
            this.redraw();
        }
        if (size) {
            this.width = width;
            this.height = height;
            this.redraw();
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (move) {
                this.control.setLocationInPixels(x + 1, y + headerHeight);
            }
            if (size) {
                this.control.setSizeInPixels(Math.max(0, width - 2), Math.max(0, height - 1));
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        if (control != null) {
            control.setVisible(this.expanded);
            Control.gtk_widget_reparent(control, this.clientHandle());
        }
        this.parent.layoutItems(0, true);
    }

    long clientHandle() {
        return this.clientHandle;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        GTK.gtk_expander_set_expanded(this.handle, expanded);
        this.parent.layoutItems(0, true);
    }

    boolean setFocus() {
        if (!GTK.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        GTK.gtk_widget_set_can_focus(this.handle, true);
        GTK.gtk_widget_grab_focus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        boolean result = GTK.gtk_widget_is_focus(this.handle);
        if (!result) {
            GTK.gtk_widget_set_can_focus(this.handle, false);
        }
        return result;
    }

    void setFontDescription(long font) {
        this.setFontDescription(this.handle, font);
        if (this.labelHandle != 0L) {
            this.setFontDescription(this.labelHandle, font);
        }
        if (this.imageHandle != 0L) {
            this.setFontDescription(this.imageHandle, font);
        }
    }

    void setForegroundRGBA(GdkRGBA rgba) {
        this.parent.setForegroundGdkRGBA(this.handle, rgba);
        if (this.labelHandle != 0L) {
            this.parent.setForegroundGdkRGBA(this.labelHandle, rgba);
        }
        if (this.imageHandle != 0L) {
            this.parent.setForegroundGdkRGBA(this.imageHandle, rgba);
        }
    }

    public void setHeight(int height) {
        this.checkWidget();
        this.setHeightInPixels(DPIUtil.autoScaleUp(height));
    }

    void setHeightInPixels(int height) {
        this.checkWidget();
        if (height < 0) {
            return;
        }
        this.height = height;
        GTK.gtk_widget_set_size_request(this.clientHandle, -1, height);
        this.parent.layoutItems(0, false);
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int imageIndex = this.imageList.add(image);
            long pixbuf = this.imageList.getPixbuf(imageIndex);
            this.gtk_image_set_from_gicon(this.imageHandle, pixbuf);
            if (this.text.length() == 0) {
                GTK.gtk_widget_hide(this.labelHandle);
            }
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_gicon(this.imageHandle, 0L);
            GTK.gtk_widget_show(this.labelHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.parent.style & 0x4000000) != 0 || !create) {
            int dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.handle, dir);
            GTK.gtk_container_forall(this.handle, this.display.setDirectionProc, dir);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        byte[] buffer = Converter.wcsToMbcs(string, true);
        GTK.gtk_label_set_text(this.labelHandle, buffer);
    }

    void showWidget(int index) {
        GTK.gtk_widget_show(this.handle);
        GTK.gtk_widget_show(this.clientHandle);
        if (this.labelHandle != 0L) {
            GTK.gtk_widget_show(this.labelHandle);
        }
        if (this.boxHandle != 0L) {
            GTK.gtk_widget_show(this.boxHandle);
        }
        GTK.gtk_container_add(this.parent.handle, this.handle);
        GTK.gtk_box_set_child_packing(this.parent.handle, this.handle, false, false, 0, 0);
    }

    @Override
    long windowProc(long handle, long user_data) {
        switch ((int)user_data) {
            case 60: {
                this.expanded = GTK.gtk_expander_get_expanded(handle);
                this.parent.layoutItems(0, false);
                return 0L;
            }
        }
        return super.windowProc(handle, user_data);
    }
}

