/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnimatedIcon;
import com.intellij.vcs.git.shared.branch.popup.GitBranchesPopupActions;
import git4idea.actions.GitFetch;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lgit4idea/ui/branch/GitBranchPopupFetchAction;", "Lgit4idea/actions/GitFetch;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "isBusy", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
public final class GitBranchPopupFetchAction
extends GitFetch {
    public GitBranchPopupFetchAction() {
        this.getTemplatePresentation().setText(GitBundle.messagePointer((String)"action.fetch.text", (Object[])new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (!Intrinsics.areEqual((Object)e.getPlace(), (Object)GitBranchesPopupActions.INSTANCE.getMAIN_POPUP_ACTION_PLACE())) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        boolean busy = this.isBusy(project);
        if (busy) {
            presentation2.setEnabled(true);
        }
        presentation2.setIcon(busy ? (Icon)AnimatedIcon.Default.INSTANCE : AllIcons.Vcs.Fetch);
        presentation2.setText(busy ? GitBundle.message((String)"fetching", (Object[])new Object[0]) : GitBundle.message((String)"action.fetch.text", (Object[])new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || this.isBusy(project)) {
            return;
        }
        super.actionPerformed(e);
    }

    private final boolean isBusy(Project project) {
        return GitFetchSupport.fetchSupport(project).isFetchRunning() || GitBranchIncomingOutgoingManager.getInstance(project).isUpdating();
    }
}

