/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.javadoc.PsiSnippetAttribute;
import com.intellij.psi.javadoc.PsiSnippetAttributeValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSnippetAttributeValueImpl
extends LeafPsiElement
implements PsiSnippetAttributeValue {
    public PsiSnippetAttributeValueImpl(CharSequence text) {
        super(JavaDocElementType.DOC_SNIPPET_ATTRIBUTE_VALUE, text);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiSnippetAttributeValueImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSnippetAttributeValue(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiReference getReference() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiSnippetAttribute) {
            PsiSnippetAttribute attribute = (PsiSnippetAttribute)parent;
            String name = attribute.getName();
            if (name.equals("class")) {
                return new SnippetFileReference(false);
            }
            if (name.equals("file")) {
                return new SnippetFileReference(true);
            }
        }
        return null;
    }

    @NotNull
    public @NotNull Collection<? extends @NotNull PsiSymbolReference> getOwnReferences() {
        PsiSnippetAttribute attribute;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiSnippetAttribute && (attribute = (PsiSnippetAttribute)parent).getName().equals("region")) {
            Set<PsiSymbolReference> set = Collections.singleton(JavaPsiImplementationHelper.getInstance(this.getProject()).getSnippetRegionSymbol(this));
            if (set == null) {
                PsiSnippetAttributeValueImpl.$$$reportNull$$$0(1);
            }
            return set;
        }
        Collection collection = super.getOwnReferences();
        if (collection == null) {
            PsiSnippetAttributeValueImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public String toString() {
        return "PsiSnippetAttributeValue:" + this.getValue();
    }

    @Override
    @NotNull
    public String getValue() {
        String string = this.getValueRange().substring(this.getText());
        if (string == null) {
            PsiSnippetAttributeValueImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public TextRange getValueRange() {
        String text = this.getText();
        int start = 0;
        int end = text.length();
        if (text.startsWith("\"") || text.startsWith("'")) {
            ++start;
        }
        if (text.endsWith("\"") || text.endsWith("'")) {
            --end;
        }
        if (end <= start) {
            start = 0;
            end = text.length();
        }
        TextRange textRange = TextRange.create((int)start, (int)end);
        if (textRange == null) {
            PsiSnippetAttributeValueImpl.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/javadoc/PsiSnippetAttributeValueImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiSnippetAttributeValueImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnReferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SnippetFileReference
    implements PsiFileReference {
        private final String mySeparator;
        private final String myExtension;
        private final VirtualFile mySnippetRoot;

        private SnippetFileReference(boolean fileRef) {
            this.mySeparator = fileRef ? "/" : ".";
            this.myExtension = fileRef ? null : "java";
            PsiFile file = PsiSnippetAttributeValueImpl.this.getContainingFile().getOriginalFile();
            VirtualFile virtualFile = file.getVirtualFile();
            this.mySnippetRoot = virtualFile == null ? null : virtualFile.getParent().findChild("snippet-files");
        }

        @Nullable
        public PsiElement resolve() {
            VirtualFile targetFile;
            PsiFile file = PsiSnippetAttributeValueImpl.this.getContainingFile();
            VirtualFile dir = this.getDirectory();
            if (dir == null) {
                return null;
            }
            String lastComponent = this.getRangeInElement().substring(PsiSnippetAttributeValueImpl.this.getText());
            if (this.myExtension == null) {
                targetFile = dir.findChild(lastComponent);
            } else {
                targetFile = dir.findChild(lastComponent + '.' + this.myExtension);
                if (targetFile == null) {
                    targetFile = (VirtualFile)ContainerUtil.find((Object[])dir.getChildren(), f -> f.getNameWithoutExtension().equals(lastComponent) && this.myExtension.equalsIgnoreCase(f.getExtension()));
                }
            }
            if (targetFile == null) {
                return null;
            }
            return file.getManager().findFile(targetFile);
        }

        @Nullable
        private VirtualFile getDirectory() {
            if (this.mySnippetRoot == null) {
                return null;
            }
            List path = StringUtil.split((String)PsiSnippetAttributeValueImpl.this.getValue(), (String)this.mySeparator);
            if (path.isEmpty()) {
                return null;
            }
            VirtualFile dir = this.mySnippetRoot;
            for (int i = 0; i < path.size() - 1; ++i) {
                String component = (String)path.get(i);
                if ((dir = dir.findChild(component)) != null) continue;
                return null;
            }
            return dir;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                SnippetFileReference.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiFile)) {
                return false;
            }
            return this.getElement().getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public PsiSnippetAttributeValue getElement() {
            PsiSnippetAttributeValueImpl psiSnippetAttributeValueImpl = PsiSnippetAttributeValueImpl.this;
            if (psiSnippetAttributeValueImpl == null) {
                SnippetFileReference.$$$reportNull$$$0(1);
            }
            return psiSnippetAttributeValueImpl;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange range = PsiSnippetAttributeValueImpl.this.getValueRange();
            String text = PsiSnippetAttributeValueImpl.this.getText();
            int lastDot = text.lastIndexOf(this.mySeparator);
            if (lastDot != -1) {
                TextRange textRange = TextRange.create((int)(lastDot + 1), (int)range.getEndOffset());
                if (textRange == null) {
                    SnippetFileReference.$$$reportNull$$$0(2);
                }
                return textRange;
            }
            TextRange textRange = range;
            if (textRange == null) {
                SnippetFileReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @NotNull
        public @NotNull Object @NotNull [] getVariants() {
            VirtualFile directory = this.getDirectory();
            if (directory == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    SnippetFileReference.$$$reportNull$$$0(4);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            PsiManagerEx manager = PsiSnippetAttributeValueImpl.this.getManager();
            ArrayList<String> list = new ArrayList<String>();
            for (VirtualFile child : directory.getChildren()) {
                if (child.isDirectory()) {
                    list.add(child.getName() + this.mySeparator);
                    continue;
                }
                if (this.myExtension != null) {
                    if (!this.myExtension.equalsIgnoreCase(child.getExtension())) continue;
                    list.add(child.getNameWithoutExtension());
                    continue;
                }
                PsiFile psiFile = manager.findFile(child);
                ContainerUtil.addIfNotNull(list, (Object)psiFile);
            }
            Object[] objectArray = list.toArray();
            if (objectArray == null) {
                SnippetFileReference.$$$reportNull$$$0(5);
            }
            return objectArray;
        }

        @NotNull
        @NlsSafe
        public String getCanonicalText() {
            String text = PsiSnippetAttributeValueImpl.this.getValue();
            String string = "snippet-files/" + text.replace(this.mySeparator, "/") + (this.myExtension == null ? "" : "." + this.myExtension);
            if (string == null) {
                SnippetFileReference.$$$reportNull$$$0(6);
            }
            return string;
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            PsiElement element = this.resolve();
            ResolveResult[] resolveResultArray = element == null ? ResolveResult.EMPTY_ARRAY : PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{element});
            if (resolveResultArray == null) {
                SnippetFileReference.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                SnippetFileReference.$$$reportNull$$$0(8);
            }
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                SnippetFileReference.$$$reportNull$$$0(9);
            }
            if (!(element instanceof PsiFile)) {
                throw new IncorrectOperationException("PsiFile expected");
            }
            if (this.isReferenceTo(element)) {
                return PsiSnippetAttributeValueImpl.this;
            }
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)this.mySnippetRoot, (char)'.');
            if (relativePath == null) {
                throw new IncorrectOperationException("File not in " + this.mySnippetRoot + ": " + virtualFile);
            }
            if (this.myExtension != null) {
                if (!StringUtil.endsWithIgnoreCase((String)relativePath, (String)("." + this.myExtension))) {
                    throw new IncorrectOperationException("File name must end with ." + this.myExtension + ": " + virtualFile);
                }
                relativePath = relativePath.substring(0, relativePath.length() - this.myExtension.length() - 1);
            }
            String newText = !relativePath.contains(this.mySeparator) ? relativePath : (PsiSnippetAttributeValueImpl.this.getText().startsWith("'") ? "'" + relativePath + "'" : "\"" + relativePath + "\"");
            ASTNode node = PsiSnippetAttributeValueImpl.this.getNode();
            LeafElement newNode = ChangeUtil.copyLeafWithText((LeafElement)((LeafElement)node), (String)newText);
            node.getTreeParent().replaceChild(node, (ASTNode)newNode);
            return newNode.getPsi();
        }

        public boolean isSoft() {
            return false;
        }

        public String toString() {
            return this.getClass().getName() + "(" + PsiSnippetAttributeValueImpl.this.getValue() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/javadoc/PsiSnippetAttributeValueImpl$SnippetFileReference";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiSnippetAttributeValueImpl$SnippetFileReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

