/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.extensions.JupyterPsiCellExt;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionQueueStore;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterFileExecutionQueue;
import com.intellij.jupyter.core.jupyter.debugger.common.DebugConnectionNotifier;
import com.intellij.jupyter.core.jupyter.debugger.common.OutputConsumer;
import com.intellij.jupyter.core.jupyter.helper.JupyterPsiFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.py.connections.execution.core.PyJupyterRemoteVariables;
import com.intellij.jupyter.py.debugger.JupyterDebugLibs;
import com.intellij.jupyter.py.debugger.JupyterDebugProcessHandler;
import com.intellij.jupyter.py.debugger.JupyterPositionConverter;
import com.intellij.jupyter.py.variables.PythonVariablesUtil;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlineService;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PyPositionConverter;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.net.ServerSocket;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 52\u00020\u0001:\u00015BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0016\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010#\u001a\u00020\u0014H\u0014J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0006\u0010*\u001a\u00020\u0014J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0014H\u0016J\u0012\u0010.\u001a\u00020\u00142\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\r\u00101\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u00020 H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugProcess;", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "serverSocket", "Ljava/net/ServerSocket;", "executionConsole", "Lcom/intellij/execution/ui/ExecutionConsole;", "jupyterDebugProcessHandler", "Lcom/intellij/jupyter/py/debugger/JupyterDebugProcessHandler;", "jupyterPsiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "connectionNotifier", "Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "output", "Lcom/intellij/jupyter/core/jupyter/debugger/common/OutputConsumer;", "afterCellExecuted", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/xdebugger/XDebugSession;Ljava/net/ServerSocket;Lcom/intellij/execution/ui/ExecutionConsole;Lcom/intellij/jupyter/py/debugger/JupyterDebugProcessHandler;Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;Lcom/intellij/jupyter/core/jupyter/debugger/common/OutputConsumer;Lkotlin/jvm/functions/Function0;)V", "latestExecutedCell", "Lkotlin/Pair;", "getLatestExecutedCell", "()Lkotlin/Pair;", "setLatestExecutedCell", "(Lkotlin/Pair;)V", "inlineCallback", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "myLocalPort", "", "connect", "cell", "afterConnect", "getCurrentScopeOwner", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "loadFrame", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "executeAfterCell", "isSimplifiedView", "", "sessionInitialized", "showWarning", "warningId", "", "getConsolePromptCount", "()Ljava/lang/Integer;", "createPydevConnectionCommand", "portToConnect", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugProcess.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n24#2:299\n*S KotlinDebug\n*F\n+ 1 JupyterDebugProcess.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugProcess\n*L\n174#1:299\n*E\n"})
public final class JupyterDebugProcess
extends PyDebugProcess {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JupyterPsiCell jupyterPsiCell;
    @NotNull
    private final NotebookIntervalPointer cellPointer;
    @NotNull
    private final DebugConnectionNotifier connectionNotifier;
    @Nullable
    private final OutputConsumer output;
    @NotNull
    private final Function0<Unit> afterCellExecuted;
    @NotNull
    private Pair<? extends JupyterPsiCell, ? extends NotebookIntervalPointer> latestExecutedCell;
    @Nullable
    private JupyterInlineCallback inlineCallback;
    private final int myLocalPort;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PYDEV_COMMAND_PREFIX = "# pydev_util_command\n";
    @NotNull
    private static final String GET_CONSOLE_PROMPT_COUNT_COMMAND = "get_ipython().execution_count";
    @NotNull
    public static final String DONT_WRITE_BYTECODE = "import sys;sys.dont_write_bytecode = True\n";

    public JupyterDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @NotNull JupyterDebugProcessHandler jupyterDebugProcessHandler, @NotNull JupyterPsiCell jupyterPsiCell, @NotNull NotebookIntervalPointer cellPointer, @NotNull DebugConnectionNotifier connectionNotifier2, @Nullable OutputConsumer output, @NotNull Function0<Unit> afterCellExecuted) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterDebugProcessHandler), (String)"jupyterDebugProcessHandler");
        Intrinsics.checkNotNullParameter((Object)jupyterPsiCell, (String)"jupyterPsiCell");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)connectionNotifier2, (String)"connectionNotifier");
        Intrinsics.checkNotNullParameter(afterCellExecuted, (String)"afterCellExecuted");
        super(session, serverSocket, executionConsole, (ProcessHandler)jupyterDebugProcessHandler, false);
        this.jupyterPsiCell = jupyterPsiCell;
        this.cellPointer = cellPointer;
        this.connectionNotifier = connectionNotifier2;
        this.output = output;
        this.afterCellExecuted = afterCellExecuted;
        this.latestExecutedCell = new Pair((Object)this.jupyterPsiCell, (Object)this.cellPointer);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.myPositionConverter = (PyPositionConverter)new JupyterPositionConverter(project);
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiFileExtensionsKt.getVirtualFile((JupyterPsiCell)this.jupyterPsiCell);
        if (backedNotebookVirtualFile != null) {
            BackedNotebookVirtualFile file = backedNotebookVirtualFile;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            this.inlineCallback = JupyterInlineService.Companion.getInstance(project2).getInlineCallback(file);
        }
        this.myLocalPort = serverSocket.getLocalPort();
    }

    @NotNull
    public final Pair<JupyterPsiCell, NotebookIntervalPointer> getLatestExecutedCell() {
        return this.latestExecutedCell;
    }

    public final void setLatestExecutedCell(@NotNull Pair<? extends JupyterPsiCell, ? extends NotebookIntervalPointer> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"<set-?>");
        this.latestExecutedCell = pair;
    }

    public final void connect(@NotNull JupyterPsiCell cell, @NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        int portToConnect = this.myLocalPort;
        BackedNotebookVirtualFile notebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFileOrThrow(cell);
        String string = this.createPydevConnectionCommand(portToConnect);
        JupyterExecutionTask.Options options = new JupyterExecutionTask.Options(JupyterExecutionTask.Purpose.DEBUG, cellPointer, false, false, true, true, null, 64, null);
        Function2 function2 = (Function2)new Function2<Exception, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ JupyterDebugProcess this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Exception exception = (Exception)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void e;
                        ResultKt.throwOnFailure((Object)$result);
                        ProcessHandler processHandler = JupyterDebugProcess.access$doGetProcessHandler(this.this$0);
                        if (processHandler != null) {
                            processHandler.destroyProcess();
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                        this.label = 1;
                        Object object2 = JupyterNotification.INSTANCE.displayAndLogError(this.this$0.getProject(), (Throwable)e, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Exception p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterExecutionTask task2 = new JupyterExecutionTask(string, options, function2, null, notebookVirtualFile, null, project, null, null, 424, null);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        JupyterFileExecutionQueue.submitTask$default((JupyterFileExecutionQueue)JupyterExecutionQueueStore.Companion.getQueue(project2, notebookVirtualFile), (JupyterExecutionTask)task2, (boolean)false, (boolean)false, (int)6, null);
    }

    protected void afterConnect() {
        super.afterConnect();
        if (this.isConnected()) {
            ApplicationManager.getApplication().runReadAction(() -> JupyterDebugProcess.afterConnect$lambda$1(this));
        }
    }

    private final ScopeOwner getCurrentScopeOwner() {
        XSourcePosition xSourcePosition = this.getCurrentFrameSourcePosition();
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition position = xSourcePosition;
        return (ScopeOwner)ReadAction.compute(() -> JupyterDebugProcess.getCurrentScopeOwner$lambda$2(this, position));
    }

    @Nullable
    public XValueChildrenList loadFrame(@Nullable XStackFrame frame) {
        XValueChildrenList frameVariables;
        block2: {
            XValueChildrenList xValueChildrenList = frameVariables = super.loadFrame(frame);
            if (xValueChildrenList == null) break block2;
            XValueChildrenList it = xValueChildrenList;
            boolean bl = false;
            ScopeOwner scopeOwner = this.getCurrentScopeOwner();
            if (scopeOwner != null) {
                ScopeOwner scopeOwner2 = scopeOwner;
                boolean bl2 = false;
                JupyterInlineCallback jupyterInlineCallback = this.inlineCallback;
                if (jupyterInlineCallback != null) {
                    jupyterInlineCallback.frameChanged(it, scopeOwner2);
                }
            }
        }
        return frameVariables;
    }

    public final void executeAfterCell() {
        this.afterCellExecuted.invoke();
    }

    public boolean isSimplifiedView() {
        return PyDebuggerSettings.getInstance().isSimplifiedView();
    }

    public void sessionInitialized() {
        boolean bl = PyDebuggerOptionsProvider.getInstance((Project)this.getProject()).isRunDebuggerInServerMode() && Registry.Companion.is("python.debug.use.single.port");
        if (bl) {
            this.waitForConnection(this.getConnectionMessage(), this.getConnectionTitle());
        } else {
            super.sessionInitialized();
        }
    }

    public void showWarning(@Nullable String warningId) {
        super.showWarning(warningId);
        if (Intrinsics.areEqual((Object)warningId, (Object)"jupyter")) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JupyterDebugProcess.Companion.showCellEditedBetweenSessions(project);
        }
    }

    @Nullable
    public final Integer getConsolePromptCount() {
        Integer result2 = null;
        try {
            String string = this.evaluate(GET_CONSOLE_PROMPT_COUNT_COMMAND, false, false).getValue();
            result2 = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
        return result2;
    }

    private final String createPydevConnectionCommand(int portToConnect) {
        StringBuilder command = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiFileExtensionsKt.getVirtualFile((JupyterPsiCell)this.jupyterPsiCell);
        command.append(Companion.createHelpersCommand(project, (VirtualFile)(backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getFile() : null)));
        if (LOG.isDebugEnabled()) {
            command.append("import os\n");
            command.append("os.environ['PYCHARM_DEBUG'] = 'True'\n");
        }
        command.append(StringsKt.trimMargin$default((String)("\n        |import pydev_jupyter_utils\n        |pydev_jupyter_utils.attach_to_debugger(" + portToConnect + ")\n        |"), null, (int)1, null));
        String string = command.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void afterConnect$lambda$1(JupyterDebugProcess this$0) {
        DebugConnectionNotifier debugConnectionNotifier = this$0.connectionNotifier;
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterPsiCell jupyterPsiCell = this$0.jupyterPsiCell;
        NotebookIntervalPointer notebookIntervalPointer = this$0.cellPointer;
        XDebugSession xDebugSession = this$0.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        debugConnectionNotifier.executeAfterConnection(project, jupyterPsiCell, notebookIntervalPointer, xDebugSession, this$0.output);
    }

    private static final ScopeOwner getCurrentScopeOwner$lambda$2(JupyterDebugProcess this$0, XSourcePosition $position) {
        PsiFile psiFile2;
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = $position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        PsiFile psiFile3 = psiFile2 = PythonVariablesUtil.INSTANCE.getPythonJupyterPsiFile(project, virtualFile);
        PsiElement currentElement = psiFile3 != null ? psiFile3.findElementAt($position.getOffset()) : null;
        return ScopeUtil.getScopeOwner((PsiElement)currentElement);
    }

    public static final /* synthetic */ ProcessHandler access$doGetProcessHandler(JupyterDebugProcess $this) {
        return $this.doGetProcessHandler();
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001e\u0010\u0014\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u001a\u001a\u00020\tJ\u0006\u0010\u001b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PYDEV_COMMAND_PREFIX", "", "GET_CONSOLE_PROMPT_COUNT_COMMAND", "DONT_WRITE_BYTECODE", "showCellEditedBetweenSessions", "", "project", "Lcom/intellij/openapi/project/Project;", "showCellEditedDuringSession", "createHelpersCommand", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "initRemoteServerCommand", "command", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getHelpersPaths", "Lkotlin/Pair;", "enableTracingCommand", "disableTracingCommand", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final void showCellEditedBetweenSessions(Project project) {
            PyDebugProcess.getNotificationGroup().createNotification(JupyterBundle.message((String)"Jupyter.debugger.cell.changed.warning", (Object[])new Object[0]), NotificationType.WARNING).notify(project);
        }

        public final void showCellEditedDuringSession(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PyDebugProcess.getNotificationGroup().createNotification(JupyterBundle.message((String)"Jupyter.debugger.cell.changed.error", (Object[])new Object[0]), NotificationType.ERROR).notify(project);
        }

        @NotNull
        public final String createHelpersCommand(@NotNull Project project, @Nullable VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(JupyterDebugProcess.DONT_WRITE_BYTECODE);
            if (JupyterConnectionSettingsUtilKt.isRemoteRemoteJupyterServerSettings((Project)project, (VirtualFile)virtualFile)) {
                this.initRemoteServerCommand(virtualFile, command);
            } else {
                String string = StringUtil.escapeCharCharacters((String)JupyterDebugLibs.INSTANCE.getPythonHelper());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharCharacters(...)");
                String helpersPath = string;
                String string2 = StringUtil.escapeCharCharacters((String)JupyterDebugLibs.INSTANCE.getJupyterHelper());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeCharCharacters(...)");
                String helpersProPath = string2;
                command.append(StringsKt.trimMargin$default((String)("\n        |import sys\n        |if '" + helpersPath + "' not in sys.path:\n        |    sys.path.insert(0, '" + helpersPath + "')\n        |    sys.path.insert(0, '" + helpersProPath + "')\n        |"), null, (int)1, null));
            }
            command.append("from pydev_jupyter_utils import remove_imported_pydev_package\nremove_imported_pydev_package()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void initRemoteServerCommand(VirtualFile virtualFile, StringBuilder command) {
            if (virtualFile == null) {
                return;
            }
            Pair<String, String> pair = this.getHelpersPaths(virtualFile);
            String helpersPath = (String)pair.component1();
            String helpersProPath = (String)pair.component2();
            command.append(StringsKt.trimMargin$default((String)("\n            |import sys\n            |import os\n            |os_normed_helpers_path = os.path.normpath('" + helpersPath + "')\n            |os_normed_helpers_pro_path = os.path.normpath('" + helpersProPath + "')\n            |os_valid_helpers_path = os.path.normpath(os.path.join(os.getcwd(), os_normed_helpers_path))\n            |os_valid_helpers_pro_path = os.path.normpath(os.path.join(os.getcwd(), os_normed_helpers_pro_path))\n            |if os_valid_helpers_path not in sys.path:\n            |    sys.path.insert(0, os_valid_helpers_path)\n            |    sys.path.insert(0, os_valid_helpers_pro_path)\n            |del os_normed_helpers_path\n            |del os_normed_helpers_pro_path\n            |del os_valid_helpers_path\n            |del os_valid_helpers_pro_path\n            |"), null, (int)1, null));
        }

        private final Pair<String, String> getHelpersPaths(VirtualFile virtualFile) {
            String string = StringUtil.escapeCharCharacters((String)PyJupyterRemoteVariables.INSTANCE.remoteLibName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeCharCharacters(...)");
            String helpersLibDirectoryName = string;
            String helpersPath = null;
            String helpersProPath = null;
            if (!(virtualFile instanceof JupyterRemoteVirtualFile)) {
                String[] stringArray = new String[]{helpersLibDirectoryName, "pydev"};
                String string2 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
                helpersPath = string2;
                stringArray = new String[]{helpersLibDirectoryName, "jupyter_debug"};
                String string3 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
                helpersProPath = string3;
            } else {
                Path relativePathToNotebook = Path.of(((JupyterRemoteVirtualFile)virtualFile).getRemotePath().getJupyterPath(), new String[0]);
                String subDirPrefix = relativePathToNotebook.getNameCount() == 1 ? "" : StringsKt.repeat((CharSequence)"../", (int)(relativePathToNotebook.getNameCount() - 1));
                String helpersLibDirectoryPath = StringUtil.escapeCharCharacters((String)subDirPrefix) + helpersLibDirectoryName;
                String[] stringArray = new String[]{helpersLibDirectoryPath, "pydev"};
                String string4 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"join(...)");
                helpersPath = string4;
                stringArray = new String[]{helpersLibDirectoryPath, "jupyter_debug"};
                String string5 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"join(...)");
                helpersProPath = string5;
            }
            return new Pair((Object)FileUtil.toSystemIndependentName((String)helpersPath), (Object)FileUtil.toSystemIndependentName((String)helpersProPath));
        }

        @NotNull
        public final String enableTracingCommand() {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(JupyterDebugProcess.DONT_WRITE_BYTECODE);
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.enable_tracing()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final String disableTracingCommand() {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(JupyterDebugProcess.DONT_WRITE_BYTECODE);
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.disable_tracing()\n");
            String string = command.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

