/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    @Override
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText;
        if (expr == null) {
            StringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            StringLiteralManipulator.$$$reportNull$$$0(1);
        }
        if ((oldText = expr.getText()).startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters(newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getElementFactory(expr.getProject()).createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace(newExpr);
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            StringLiteralManipulator.$$$reportNull$$$0(2);
        }
        return StringLiteralManipulator.getValueRange(element);
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression expression2) {
        if (expression2 == null) {
            StringLiteralManipulator.$$$reportNull$$$0(3);
        }
        int length = expression2.getTextLength();
        if (expression2.isTextBlock()) {
            String text = expression2.getText();
            int startOffset = StringLiteralManipulator.findBlockStart(text);
            return startOffset < 0 ? new TextRange(0, length) : new TextRange(startOffset, length - (text.endsWith("\"\"\"") ? 3 : 0));
        }
        PsiType type2 = expression2.getType();
        boolean isQuoted = PsiTypes.charType().equals(type2) || type2 != null && type2.equalsToText("java.lang.String");
        TextRange textRange = isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from(0, length);
        if (textRange == null) {
            StringLiteralManipulator.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static int findBlockStart(String text) {
        if (!text.startsWith("\"\"\"")) {
            return -1;
        }
        int length = text.length();
        for (int i = 3; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                return i + 1;
            }
            if (Character.isWhitespace(c)) continue;
            return -1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/StringLiteralManipulator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValueRange";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

