/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Tuple2;
import io.vavr.collection.Collections;
import io.vavr.collection.HashArrayMappedTrie;
import io.vavr.collection.Iterator;
import io.vavr.collection.Set;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class HashSet<T>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashSet<?> EMPTY = new HashSet(HashArrayMappedTrie.empty());
    private final HashArrayMappedTrie<T, T> tree;

    private HashSet(HashArrayMappedTrie<T, T> tree) {
        this.tree = tree;
    }

    public static <T> HashSet<T> empty() {
        return EMPTY;
    }

    public static <T> HashSet<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof HashSet) {
            return (HashSet)elements;
        }
        HashArrayMappedTrie<T, T> tree = HashSet.addAll(HashArrayMappedTrie.empty(), elements);
        return tree.isEmpty() ? HashSet.empty() : new HashSet<T>(tree);
    }

    @Override
    public HashSet<T> add(T element) {
        return this.contains(element) ? this : new HashSet<T>(this.tree.put(element, element));
    }

    @Override
    public boolean contains(T element) {
        return this.tree.get(element).isDefined();
    }

    @Override
    public HashSet<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        HashSet<T> filtered = HashSet.ofAll(this.iterator().filter(predicate));
        if (filtered.isEmpty()) {
            return HashSet.empty();
        }
        if (filtered.length() == this.length()) {
            return this;
        }
        return filtered;
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.tree.isEmpty()) {
            throw new NoSuchElementException("head of empty set");
        }
        return (T)this.iterator().next();
    }

    @Override
    public HashSet<T> intersect(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty() || elements.isEmpty()) {
            return HashSet.empty();
        }
        int size = this.size();
        if (size <= elements.size()) {
            return this.retainAll(elements);
        }
        HashSet<T> results = HashSet.ofAll(elements).retainAll(this);
        return size == results.size() ? this : results;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.tree.keysIterator();
    }

    @Override
    public T last() {
        return Collections.last(this);
    }

    @Override
    public int length() {
        return this.tree.size();
    }

    @Override
    public <U> HashSet<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return HashSet.empty();
        }
        HashArrayMappedTrie that = this.foldLeft(HashArrayMappedTrie.empty(), (tree, t) -> {
            Object u = mapper.apply(t);
            return tree.put(u, u);
        });
        return new HashSet<T>(that);
    }

    @Override
    public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return this.iterator().mkString(prefix, delimiter, suffix);
    }

    public HashSet<T> remove(T element) {
        HashArrayMappedTrie<T, T> newTree = this.tree.remove(element);
        return newTree == this.tree ? this : new HashSet<T>(newTree);
    }

    public HashSet<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    public HashSet<T> tail() {
        if (this.tree.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty set");
        }
        return this.remove(this.head());
    }

    @Override
    public java.util.HashSet<T> toJavaSet() {
        return this.toJavaSet(java.util.HashSet::new);
    }

    public boolean equals(Object o) {
        return Collections.equals(this, o);
    }

    public int hashCode() {
        return Collections.hashUnordered(this);
    }

    @Override
    public String stringPrefix() {
        return "HashSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <T> HashArrayMappedTrie<T, T> addAll(HashArrayMappedTrie<T, T> initial, Iterable<? extends T> additional) {
        HashArrayMappedTrie<T, T> that = initial;
        for (T t : additional) {
            that = that.put(t, t);
        }
        return that;
    }

    private Object writeReplace() {
        return new SerializationProxy<T>(this.tree);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static final class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient HashArrayMappedTrie<T, T> tree;

        SerializationProxy(HashArrayMappedTrie<T, T> tree) {
            this.tree = tree;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeInt(this.tree.size());
            for (Tuple2 tuple2 : this.tree) {
                s.writeObject(tuple2._1);
            }
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
            int size = s.readInt();
            if (size < 0) {
                throw new InvalidObjectException("No elements");
            }
            HashArrayMappedTrie<Object, Object> temp = HashArrayMappedTrie.empty();
            for (int i = 0; i < size; ++i) {
                Object element = s.readObject();
                temp = temp.put(element, element);
            }
            this.tree = temp;
        }

        private Object readResolve() {
            return this.tree.isEmpty() ? HashSet.empty() : new HashSet(this.tree);
        }
    }
}

