/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.lux;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxTransform;", "", "<init>", "()V", "transformShape", "Ljava/awt/Shape;", "shape", "transform", "Ljava/awt/geom/AffineTransform;", "intersectShapes", "shape1", "shape2", "rectFromXY", "Ljava/awt/geom/Rectangle2D$Double;", "x1", "", "y1", "x2", "y2", "intellij.platform.split"})
public final class LuxTransform {
    @NotNull
    public static final LuxTransform INSTANCE = new LuxTransform();

    private LuxTransform() {
    }

    @Nullable
    public final Shape transformShape(@Nullable Shape shape, @NotNull AffineTransform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        if (shape == null) {
            return null;
        }
        if (transform.isIdentity()) {
            return shape;
        }
        if (shape instanceof Rectangle2D && (transform.getType() & 0xFFFFFFB8) == 0) {
            double[] dArray = new double[]{((Rectangle2D)shape).getMinX(), ((Rectangle2D)shape).getMinY(), ((Rectangle2D)shape).getMaxX(), ((Rectangle2D)shape).getMaxY()};
            double[] points = dArray;
            transform.transform(points, 0, points, 0, 2);
            boolean flipX = transform.getScaleX() < 0.0;
            boolean flipY = transform.getScaleY() < 0.0;
            double x1 = flipX ? points[2] : points[0];
            double x2 = flipX ? points[0] : points[2];
            double y1 = flipY ? points[3] : points[1];
            double y2 = flipY ? points[1] : points[3];
            return this.rectFromXY(x1, y1, x2, y2);
        }
        return transform.createTransformedShape(shape);
    }

    @Nullable
    public final Shape intersectShapes(@Nullable Shape shape1, @Nullable Shape shape2) {
        if (shape1 == null) {
            return shape2;
        }
        if (shape2 == null) {
            return shape1;
        }
        if (shape1 instanceof Rectangle2D && shape2 instanceof Rectangle2D) {
            Rectangle2D intersection = ((Rectangle2D)shape1).createIntersection((Rectangle2D)shape2);
            if (intersection.isEmpty()) {
                return new Area();
            }
            return intersection;
        }
        if (shape1 instanceof Rectangle2D && ((Rectangle2D)shape1).contains(shape2.getBounds2D())) {
            return shape2;
        }
        if (shape2 instanceof Rectangle2D && ((Rectangle2D)shape2).contains(shape1.getBounds2D())) {
            return shape1;
        }
        if (shape1 instanceof Area && ((Area)shape1).isEmpty()) {
            return new Area();
        }
        if (shape2 instanceof Area && ((Area)shape2).isEmpty()) {
            return new Area();
        }
        Area existingArea = new Area(shape1);
        existingArea.intersect(new Area(shape2));
        return existingArea;
    }

    private final Rectangle2D.Double rectFromXY(double x1, double y1, double x2, double y2) {
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }
}

