/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BitUtil;

public final class GroupVIntUtil {
    public static final int MAX_LENGTH_PER_GROUP = 17;
    private static final long[] MASKS = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL};

    public static void readGroupVInt(DataInput in, long[] dst, int offset) throws IOException {
        int flag = in.readByte() & 0xFF;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = GroupVIntUtil.readLongInGroup(in, n1Minus1);
        dst[offset + 1] = GroupVIntUtil.readLongInGroup(in, n2Minus1);
        dst[offset + 2] = GroupVIntUtil.readLongInGroup(in, n3Minus1);
        dst[offset + 3] = GroupVIntUtil.readLongInGroup(in, n4Minus1);
    }

    private static long readLongInGroup(DataInput in, int numBytesMinus1) throws IOException {
        switch (numBytesMinus1) {
            case 0: {
                return (long)in.readByte() & 0xFFL;
            }
            case 1: {
                return (long)in.readShort() & 0xFFFFL;
            }
            case 2: {
                return (long)in.readShort() & 0xFFFFL | ((long)in.readByte() & 0xFFL) << 16;
            }
        }
        return (long)in.readInt() & 0xFFFFFFFFL;
    }

    public static int readGroupVInt(DataInput in, long remaining, IntReader reader, long pos, long[] dst, int offset) throws IOException {
        if (remaining < 17L) {
            GroupVIntUtil.readGroupVInt(in, dst, offset);
            return 0;
        }
        int flag = in.readByte() & 0xFF;
        long posStart = ++pos;
        int n1Minus1 = flag >> 6;
        int n2Minus1 = flag >> 4 & 3;
        int n3Minus1 = flag >> 2 & 3;
        int n4Minus1 = flag & 3;
        dst[offset] = (long)reader.read(pos) & MASKS[n1Minus1];
        dst[offset + 1] = (long)reader.read(pos += (long)(1 + n1Minus1)) & MASKS[n2Minus1];
        dst[offset + 2] = (long)reader.read(pos += (long)(1 + n2Minus1)) & MASKS[n3Minus1];
        dst[offset + 3] = (long)reader.read(pos += (long)(1 + n3Minus1)) & MASKS[n4Minus1];
        return (int)((pos += (long)(1 + n4Minus1)) - posStart);
    }

    private static int numBytes(int v) {
        return 4 - (Integer.numberOfLeadingZeros(v | 1) >> 3);
    }

    private static int toInt(long value) {
        if (Long.compareUnsigned(value, 0xFFFFFFFFL) > 0) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public static void writeGroupVInts(DataOutput out, byte[] scratch, long[] values, int limit) throws IOException {
        int readPos = 0;
        while (limit - readPos >= 4) {
            int writePos = 0;
            int n1Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos])) - 1;
            int n2Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos + 1])) - 1;
            int n3Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos + 2])) - 1;
            int n4Minus1 = GroupVIntUtil.numBytes(GroupVIntUtil.toInt(values[readPos + 3])) - 1;
            int flag = n1Minus1 << 6 | n2Minus1 << 4 | n3Minus1 << 2 | n4Minus1;
            scratch[writePos++] = (byte)flag;
            BitUtil.VH_LE_INT.set(scratch, writePos, (int)values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n1Minus1 + 1, (int)values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n2Minus1 + 1, (int)values[readPos++]);
            BitUtil.VH_LE_INT.set(scratch, writePos += n3Minus1 + 1, (int)values[readPos++]);
            out.writeBytes(scratch, writePos += n4Minus1 + 1);
        }
        while (readPos < limit) {
            out.writeVInt(GroupVIntUtil.toInt(values[readPos]));
            ++readPos;
        }
    }

    @FunctionalInterface
    public static interface IntReader {
        public int read(long var1);
    }
}

