/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.configurations;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemHost;
import com.intellij.platform.execution.frontend.split.configurations.RunConfigurationOverProtocol;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientExternalSystemRunnableState;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfiguration;
import com.jetbrains.codeWithMe.model.BackendRunProcessModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationModel;
import com.jetbrains.codeWithMe.model.CwmRunConfigurationExecuteArgs;
import com.jetbrains.codeWithMe.model.ExternalSystemInfo;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.util.lifetime.Lifetime;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\n\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientExternalRunConfiguration;", "Lcom/intellij/platform/execution/frontend/split/configurations/RunConfigurationOverProtocol;", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "externalSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "configurationIcon", "Ljavax/swing/Icon;", "model", "Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;Ljavax/swing/Icon;Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationModel;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getModel", "()Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationModel;", "getIcon", "canRunOn", "", "target", "Lcom/intellij/execution/ExecutionTarget;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.platform.execution.frontend.split"})
public final class ThinClientExternalRunConfiguration
extends ExternalSystemRunConfiguration
implements RunConfigurationOverProtocol {
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private final Icon configurationIcon;
    @Nullable
    private final CodeWithMeRunConfigurationModel model;

    public ThinClientExternalRunConfiguration(@NotNull Lifetime lifetime, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name, @Nullable Icon configurationIcon, @Nullable CodeWithMeRunConfigurationModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)externalSystemId, (String)"externalSystemId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(externalSystemId, project, factory, name);
        this.lifetime = lifetime;
        this.configurationIcon = configurationIcon;
        this.model = model;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.getSettings();
        String string = project.getBasePath();
        if (string == null) {
            string = "";
        }
        externalSystemTaskExecutionSettings.setExternalProjectPath(string);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @Nullable
    public CodeWithMeRunConfigurationModel getModel() {
        return this.model;
    }

    @Nullable
    public Icon getIcon() {
        Icon icon = this.configurationIcon;
        if (icon == null) {
            icon = super.getIcon();
        }
        return icon;
    }

    public boolean canRunOn(@NotNull ExecutionTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CodeWithMeRunConfigurationModel codeWithMeRunConfigurationModel = this.getModel();
        return !(codeWithMeRunConfigurationModel != null ? !codeWithMeRunConfigurationModel.getCanRunDefaultTarget() : false) || !Intrinsics.areEqual((Object)target, (Object)DefaultExecutionTarget.INSTANCE);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        ThinClientExternalSystemRunnableState thinClientExternalSystemRunnableState;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        BackendRunProcessModel processModel = (BackendRunProcessModel)env.getUserData(ThinClientRunConfiguration.Companion.getRunProcessModelKey());
        if (processModel == null || processModel.getExecutionId() != env.getExecutionId()) {
            if (this.getModel() == null) {
                return null;
            }
            ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings2 = this.getSettings();
            Project project = this.getProject();
            return (RunProfileState)new ExternalSystemRunnableState(this, env, executor, externalSystemTaskExecutionSettings2, project){
                final /* synthetic */ ThinClientExternalRunConfiguration this$0;
                final /* synthetic */ Executor $executor;
                {
                    this.this$0 = $receiver;
                    this.$executor = $executor;
                    super($super_call_param$1, $super_call_param$2, false, (ExternalSystemRunConfiguration)$receiver, $env);
                }

                public ExecutionResult execute(Executor innerExecutor, ProgramRunner<?> runner) {
                    Intrinsics.checkNotNullParameter(runner, (String)"runner");
                    RdCall rdCall = this.this$0.getModel().getExecute();
                    Executor executor = innerExecutor;
                    if (executor == null) {
                        executor = this.$executor;
                    }
                    String string = executor.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    rdCall.start((Object)new CwmRunConfigurationExecuteArgs(string));
                    return null;
                }
            };
        }
        ExternalSystemInfo externalSystemInfo = processModel.getExternalSystemInfo();
        if (externalSystemInfo == null) {
            return null;
        }
        ExternalSystemInfo externalSystemInfo2 = externalSystemInfo;
        ExternalSystemTaskExecutionSettings $this$getState_u24lambda_u240 = externalSystemTaskExecutionSettings = this.getSettings().clone();
        boolean bl = false;
        $this$getState_u24lambda_u240.setTaskNames(externalSystemInfo2.getTaskNames());
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings3 = externalSystemTaskExecutionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings3, (String)"apply(...)");
        ExternalSystemTaskExecutionSettings stateSettings = externalSystemTaskExecutionSettings3;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ThinClientExternalSystemRunnableState $this$getState_u24lambda_u241 = thinClientExternalSystemRunnableState = new ThinClientExternalSystemRunnableState(this.lifetime, processModel, stateSettings, project, false, this, env);
        boolean bl2 = false;
        $this$getState_u24lambda_u241.putUserData(ThinClientExternalSystemHost.Companion.getMODEL_ID_KEY(), externalSystemInfo2.getTaskId().getId());
        $this$getState_u24lambda_u241.putUserData(ThinClientExternalSystemHost.Companion.getPROCESS_MODEL(), processModel);
        return (RunProfileState)thinClientExternalSystemRunnableState;
    }
}

