/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.list;

import com.intellij.collaboration.ui.codereview.avatar.CodeReviewAvatarUtils;
import com.intellij.collaboration.ui.codereview.list.NamedCollection;
import com.intellij.collaboration.ui.codereview.list.ReviewListComponentFactory;
import com.intellij.collaboration.ui.codereview.list.ReviewListItemPresentation;
import com.intellij.collaboration.ui.codereview.list.TagPresentation;
import com.intellij.collaboration.ui.codereview.list.UserPresentation;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import icons.CollaborationToolsIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDetails;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestState;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeStatus;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001f\u0010\u0017\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/list/GitLabMergeRequestsListComponentFactory;", "", "<init>", "()V", "create", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDetails;", "listModel", "Lcom/intellij/ui/CollectionListModel;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getLabelPresentation", "Lcom/intellij/collaboration/ui/codereview/list/TagPresentation;", "label", "", "userPresentation", "Lcom/intellij/collaboration/ui/codereview/list/UserPresentation;", "user", "getMergeableStatus", "Lcom/intellij/collaboration/ui/codereview/list/ReviewListItemPresentation$Status;", "mergeStatus", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeStatus;", "getMergeStateText", "Lcom/intellij/openapi/util/NlsSafe;", "mergeRequestState", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestState;", "isDraft", "", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestsListComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestsListComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/list/GitLabMergeRequestsListComponentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1563#2:86\n1634#2,3:87\n1563#2:90\n1634#2,3:91\n1563#2:94\n1634#2,3:95\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestsListComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/list/GitLabMergeRequestsListComponentFactory\n*L\n31#1:86\n31#1:87,3\n38#1:90\n38#1:91,3\n42#1:94\n42#1:95,3\n*E\n"})
public final class GitLabMergeRequestsListComponentFactory {
    @NotNull
    public static final GitLabMergeRequestsListComponentFactory INSTANCE = new GitLabMergeRequestsListComponentFactory();

    private GitLabMergeRequestsListComponentFactory() {
    }

    @NotNull
    public final JBList<GitLabMergeRequestDetails> create(@NotNull CollectionListModel<GitLabMergeRequestDetails> listModel, @NotNull IconsProvider<GitLabUserDTO> avatarIconsProvider) {
        Intrinsics.checkNotNullParameter(listModel, (String)"listModel");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        return new ReviewListComponentFactory((ListModel)listModel).create(arg_0 -> GitLabMergeRequestsListComponentFactory.create$lambda$2(avatarIconsProvider, arg_0));
    }

    private final TagPresentation getLabelPresentation(String label) {
        return (TagPresentation)new TagPresentation.Simple(label, null);
    }

    private final UserPresentation userPresentation(GitLabUserDTO user2, IconsProvider<GitLabUserDTO> avatarIconsProvider) {
        return (UserPresentation)new UserPresentation.Simple(user2.getUsername(), user2.getName(), avatarIconsProvider.getIcon((Object)user2, CodeReviewAvatarUtils.INSTANCE.expectedIconHeight(18)));
    }

    private final ReviewListItemPresentation.Status getMergeableStatus(GitLabMergeStatus mergeStatus) {
        if (mergeStatus == GitLabMergeStatus.CANNOT_BE_MERGED) {
            Icon icon = CollaborationToolsIcons.Review.NonMergeable;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NonMergeable");
            return new ReviewListItemPresentation.Status(icon, GitLabBundle.message("merge.request.list.renderer.merge.conflict.tooltip", new Object[0]));
        }
        return null;
    }

    private final String getMergeStateText(GitLabMergeRequestState mergeRequestState, boolean isDraft) {
        if (mergeRequestState == GitLabMergeRequestState.OPENED && !isDraft) {
            return null;
        }
        if (isDraft) {
            return GitLabBundle.message("merge.request.list.renderer.state.draft", new Object[0]);
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[mergeRequestState.ordinal()]) {
            case 1 -> GitLabBundle.message("merge.request.list.renderer.state.closed", new Object[0]);
            case 2 -> GitLabBundle.message("merge.request.list.renderer.state.merged", new Object[0]);
            default -> null;
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final ReviewListItemPresentation create$lambda$2(IconsProvider $avatarIconsProvider, GitLabMergeRequestDetails mergeRequest) {
        Collection<UserPresentation> collection;
        GitLabUserDTO assignee;
        Object object;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Collection<TagPresentation> collection2;
        void $this$mapTo$iv$iv2;
        Object $this$map$iv;
        Object object2 = new Object[]{mergeRequest.getLabels().size()};
        String string = GitLabBundle.message("merge.request.list.renderer.labels.popup", object2);
        object2 = mergeRequest.getLabels();
        GitLabMergeRequestsListComponentFactory gitLabMergeRequestsListComponentFactory = INSTANCE;
        String string2 = string;
        NamedCollection.Companion companion = NamedCollection.Companion;
        UserPresentation userPresentation = INSTANCE.userPresentation(mergeRequest.getAuthor(), (IconsProvider<GitLabUserDTO>)$avatarIconsProvider);
        Date date = mergeRequest.getCreatedAt();
        String string3 = "!" + mergeRequest.getIid();
        String string4 = mergeRequest.getTitle();
        boolean $i$f$map22 = false;
        void var5_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            String string5 = (String)item$iv$iv2;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(gitLabMergeRequestsListComponentFactory.getLabelPresentation((String)p0));
        }
        collection2 = (List)destination$iv$iv;
        NamedCollection namedCollection = companion.create(string2, (List)collection2);
        $this$map$iv = new Object[]{mergeRequest.getAssignees().size()};
        String string6 = GitLabBundle.message("merge.request.list.renderer.user.assignees", (Object[])$this$map$iv);
        $this$map$iv = mergeRequest.getAssignees();
        String string7 = string6;
        NamedCollection.Companion companion2 = NamedCollection.Companion;
        String string8 = INSTANCE.getMergeStateText(mergeRequest.getState(), mergeRequest.getDraft());
        collection2 = null;
        string2 = INSTANCE.getMergeableStatus(mergeRequest.getMergeStatus());
        companion = namedCollection;
        boolean $i$f$map = false;
        Object[] $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv2;
            item$iv$iv = iterator.next();
            item$iv$iv2 = (GitLabUserDTO)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(INSTANCE.userPresentation(assignee, (IconsProvider<GitLabUserDTO>)$avatarIconsProvider));
        }
        object = (List)destination$iv$iv2;
        NamedCollection namedCollection2 = companion2.create(string7, (List)object);
        $this$map$iv = new Object[]{mergeRequest.getReviewers().size()};
        String string9 = GitLabBundle.message("merge.request.list.renderer.user.reviewers", (Object[])$this$map$iv);
        $this$map$iv = mergeRequest.getReviewers();
        object = string9;
        string7 = NamedCollection.Companion;
        companion2 = namedCollection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void reviewer;
            item$iv$iv = iterator.next();
            assignee = (GitLabUserDTO)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(INSTANCE.userPresentation((GitLabUserDTO)reviewer, (IconsProvider<GitLabUserDTO>)$avatarIconsProvider));
        }
        collection = (List)destination$iv$iv2;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2048;
        Boolean bl = null;
        ReviewListItemPresentation.CommentsCounter commentsCounter = null;
        NamedCollection namedCollection3 = string7.create((String)object, collection);
        NamedCollection.Companion companion3 = companion2;
        String string10 = string8;
        Collection<TagPresentation> collection3 = collection2;
        String string11 = string2;
        NamedCollection.Companion companion4 = companion;
        UserPresentation userPresentation2 = userPresentation;
        Date date2 = date;
        String string12 = string3;
        String string13 = string4;
        return (ReviewListItemPresentation)new ReviewListItemPresentation.Simple(string13, string12, date2, userPresentation2, (NamedCollection)companion4, (ReviewListItemPresentation.Status)string11, collection3, string10, (NamedCollection)companion3, namedCollection3, commentsCounter, bl, n, defaultConstructorMarker);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitLabMergeRequestState.values().length];
            try {
                nArray[GitLabMergeRequestState.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabMergeRequestState.MERGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

