/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.ResourceBundle;
import org.languagetool.rules.AbstractDashRule;
import org.languagetool.rules.Example;
import org.languagetool.tools.Tools;

public class EnglishDashRule
extends AbstractDashRule {
    private static volatile AhoCorasickDoubleArrayTrie<String> trie;

    public EnglishDashRule(ResourceBundle messages) {
        super(messages);
        this.addExamplePair(Example.wrong((String)"I'll buy a new <marker>T\u2014shirt</marker>."), Example.fixed((String)"I'll buy a new <marker>T-shirt</marker>."));
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/post/hyphen/"));
    }

    public String getId() {
        return "EN_DASH_RULE";
    }

    public String getDescription() {
        return "Checks if hyphenated words were spelled with dashes (e.g., 'T \u2014 shirt' instead 'T-shirt').";
    }

    public String getMessage() {
        return "A dash was used instead of a hyphen.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AhoCorasickDoubleArrayTrie<String> getCompoundsData() {
        AhoCorasickDoubleArrayTrie data = trie;
        if (data != null) return data;
        Class<EnglishDashRule> clazz = EnglishDashRule.class;
        synchronized (EnglishDashRule.class) {
            data = trie;
            if (data != null) return data;
            trie = data = EnglishDashRule.loadCompoundFile((String)"/en/compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }
}

