/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.StructureType;
import com.openhtmltopdf.layout.BoxCollector;
import com.openhtmltopdf.layout.InlineBoxing;
import com.openhtmltopdf.layout.InlinePaintable;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.PaintingInfo;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.CharCounts;
import com.openhtmltopdf.render.ContentLimitContainer;
import com.openhtmltopdf.render.FloatDistances;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.render.MarkerData;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.TextDecoration;
import com.openhtmltopdf.util.XRRuntimeException;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineBox
extends Box
implements InlinePaintable {
    private static final float JUSTIFY_NON_SPACE_SHARE = 0.2f;
    private static final float JUSTIFY_SPACE_SHARE = 0.8f;
    private boolean _containsContent;
    private boolean _containsBlockLevelContent;
    private boolean _isEndsOnNL;
    private FloatDistances _floatDistances;
    private List<TextDecoration> _textDecorations;
    private int _paintingTop;
    private int _paintingHeight;
    private List<Box> _nonFlowContent;
    private MarkerData _markerData;
    private boolean _containsDynamicFunction;
    private int _contentStart;
    private int _baseline;
    private JustificationInfo _justificationInfo;
    private byte direction = 0;
    private List<BlockBox> referencedFootnoteBodies;

    @Override
    public String dump(LayoutContext c, String indent, int which) {
        if (which != 2) {
            throw new IllegalArgumentException();
        }
        StringBuilder result = new StringBuilder(indent);
        result.append(this);
        result.append('\n');
        this.dumpBoxes(c, indent, this.getNonFlowContent(), 2, result);
        if (this.getNonFlowContent().size() > 0) {
            result.append('\n');
        }
        this.dumpBoxes(c, indent, this.getChildren(), 2, result);
        return result.toString();
    }

    @Override
    public String toString() {
        return "LineBox: (" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getWidth() + "," + this.getHeight() + ")";
    }

    @Override
    public Rectangle getMarginEdge(CssContext cssCtx, int tx, int ty) {
        Rectangle result = new Rectangle(this.getX(), this.getY(), this.getContentWidth(), this.getHeight());
        result.translate(tx, ty);
        return result;
    }

    @Override
    public void paintInline(RenderingContext c) {
        if (!this.getParent().getStyle().isVisible(c, this)) {
            return;
        }
        if (this.isContainsDynamicFunction()) {
            this.lookForDynamicFunctions(c);
            int totalLineWidth = this.direction == 1 ? InlineBoxing.positionHorizontallyRTL(c, this, 0, 0) : InlineBoxing.positionHorizontally((CssContext)c, this, 0);
            this.setContentWidth(totalLineWidth);
            this.calcChildLocations();
            this.align(true, c);
            this.calcPaintingInfo(c, false);
        }
        if (this._textDecorations != null) {
            Object token = c.getOutputDevice().startStructure(StructureType.BACKGROUND, this);
            c.getOutputDevice().drawTextDecoration(c, this);
            c.getOutputDevice().endStructure(token);
        }
        if (c.debugDrawLineBoxes()) {
            c.getOutputDevice().drawDebugOutline(c, this, FSRGBColor.GREEN);
        }
    }

    private void lookForDynamicFunctions(RenderingContext c) {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                Box b = this.getChild(i);
                if (!(b instanceof InlineLayoutBox)) continue;
                ((InlineLayoutBox)b).lookForDynamicFunctions(c);
            }
        }
    }

    public boolean isFirstLine() {
        return super.isFirstChild();
    }

    public void prunePendingInlineBoxes(LayoutContext c) {
        if (this.getChildCount() > 0) {
            Box b;
            for (int i = this.getChildCount() - 1; i >= 0 && (b = this.getChild(i)) instanceof InlineLayoutBox; --i) {
                InlineLayoutBox iB = (InlineLayoutBox)b;
                iB.prunePending(c);
                if (!iB.isPending()) continue;
                if (iB.getElement() != null && iB.getElement().hasAttribute("id")) {
                    c.removeBoxId(iB.getElement().getAttribute("id"));
                }
                this.removeChild(i);
            }
        }
    }

    public boolean isContainsContent() {
        return this._containsContent;
    }

    public void setContainsContent(boolean containsContent) {
        this._containsContent = containsContent;
    }

    public void align(boolean dynamic, CssContext c) {
        IdentValue align = this.getParent().getStyle().getIdent(CSSName.TEXT_ALIGN);
        int calcX = 0;
        int dir = -1;
        if (align == IdentValue.START) {
            int n = dir = this.direction == 1 ? 1 : 0;
        }
        if (align == IdentValue.JUSTIFY && this.direction == 1) {
            int floatDistance = this.getFloatDistances().getRightFloatDistance();
            calcX = this.getParent().getContentWidth() - floatDistance - this.getContentWidth();
            if (align == IdentValue.JUSTIFY && dynamic) {
                this.justify(c);
            }
        } else if (align == IdentValue.LEFT || align == IdentValue.JUSTIFY || dir == 0) {
            int floatDistance = this.getFloatDistances().getLeftFloatDistance();
            calcX = this.getContentStart() + floatDistance;
            if (align == IdentValue.JUSTIFY && dynamic) {
                this.justify(c);
            }
        } else if (align == IdentValue.CENTER) {
            int leftFloatDistance = this.getFloatDistances().getLeftFloatDistance();
            int rightFloatDistance = this.getFloatDistances().getRightFloatDistance();
            int midpoint = leftFloatDistance + (this.getParent().getContentWidth() - leftFloatDistance - rightFloatDistance) / 2;
            calcX = midpoint - (this.getContentWidth() + this.getContentStart()) / 2;
        } else if (align == IdentValue.RIGHT || dir == 1) {
            int floatDistance = this.getFloatDistances().getRightFloatDistance();
            calcX = this.getParent().getContentWidth() - floatDistance - this.getContentWidth();
        }
        if (calcX != this.getX()) {
            this.setX(calcX);
            this.calcCanvasLocation();
            this.calcChildLocations();
        }
    }

    public void justify(CssContext c) {
        if (!(this.getParent().getStyle().hasLetterSpacing() || this.isLastLineWithContent() || this.isEndsOnNL())) {
            int leftFloatDistance = this.getFloatDistances().getLeftFloatDistance();
            int rightFloatDistance = this.getFloatDistances().getRightFloatDistance();
            int available = this.getParent().getContentWidth() - leftFloatDistance - rightFloatDistance - this.getContentStart();
            if (available > this.getContentWidth()) {
                float maxInterChar = this.getParent().getStyle().getFloatPropertyProportionalWidth(CSSName.FS_MAX_JUSTIFICATION_INTER_CHAR, this.getParent().getWidth(), c);
                float maxInterWord = this.getParent().getStyle().getFloatPropertyProportionalWidth(CSSName.FS_MAX_JUSTIFICATION_INTER_WORD, this.getParent().getWidth(), c);
                int toAdd = available - this.getContentWidth();
                CharCounts counts = this.countJustifiableChars();
                JustificationInfo info = new JustificationInfo();
                if (counts.getSpaceCount() > 0) {
                    if (counts.getNonSpaceCount() > 1) {
                        info.setNonSpaceAdjust(Math.min((float)toAdd * 0.2f / (float)(counts.getNonSpaceCount() - 1), maxInterChar));
                    } else {
                        info.setNonSpaceAdjust(0.0f);
                    }
                    if (counts.getSpaceCount() > 0) {
                        info.setSpaceAdjust(Math.min((float)toAdd * 0.8f / (float)counts.getSpaceCount(), maxInterWord));
                    } else {
                        info.setSpaceAdjust(0.0f);
                    }
                } else if (counts.getNonSpaceCount() > 1) {
                    info.setSpaceAdjust(0.0f);
                    info.setNonSpaceAdjust(Math.min((float)toAdd / (float)(counts.getNonSpaceCount() - 1), maxInterChar));
                } else {
                    info.setSpaceAdjust(0.0f);
                    info.setNonSpaceAdjust(0.0f);
                }
                this.adjustChildren(info);
                this.setJustificationInfo(info);
            }
        }
    }

    private void adjustChildren(JustificationInfo info) {
        if (this.isLayedOutRTL()) {
            this.adjustChildrenRTL(info);
            return;
        }
        float adjust = 0.0f;
        for (Box b : this.getChildren()) {
            b.setX(b.getX() + Math.round(adjust));
            if (!(b instanceof InlineLayoutBox)) continue;
            adjust += ((InlineLayoutBox)b).adjustHorizontalPosition(info, adjust);
        }
        this.calcChildLocations();
    }

    private void adjustChildrenRTL(JustificationInfo info) {
        float adjust = 0.0f;
        for (Box b : this.getChildren()) {
            b.setX(b.getX() - Math.round(adjust));
            if (!(b instanceof InlineLayoutBox)) continue;
            adjust += ((InlineLayoutBox)b).adjustHorizontalPositionRTL(info, adjust);
        }
        this.setContentWidth(this.getContentWidth() + Math.round(adjust));
        this.calcChildLocations();
    }

    private boolean isLastLineWithContent() {
        for (LineBox current = (LineBox)this.getNextSibling(); current != null; current = (LineBox)current.getNextSibling()) {
            if (!current.isContainsContent()) continue;
            return false;
        }
        return true;
    }

    private CharCounts countJustifiableChars() {
        CharCounts result = new CharCounts();
        for (Box b : this.getChildren()) {
            if (!(b instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)b).countJustifiableChars(result);
        }
        return result;
    }

    public FloatDistances getFloatDistances() {
        return this._floatDistances;
    }

    public void setFloatDistances(FloatDistances floatDistances) {
        this._floatDistances = floatDistances;
    }

    public boolean isContainsBlockLevelContent() {
        return this._containsBlockLevelContent;
    }

    public void setContainsBlockLevelContent(boolean containsBlockLevelContent) {
        this._containsBlockLevelContent = containsBlockLevelContent;
    }

    @Override
    public boolean intersects(CssContext cssCtx, Shape clip) {
        return clip == null || this.intersectsLine(cssCtx, clip) || this.isContainsBlockLevelContent() && this.intersectsInlineBlocks(cssCtx, clip);
    }

    private boolean intersectsLine(CssContext cssCtx, Shape clip) {
        Rectangle result = this.getPaintingClipEdge(cssCtx);
        return clip.intersects(result);
    }

    @Override
    public Rectangle getPaintingClipEdge(CssContext cssCtx) {
        BlockBox parent = this.getParent();
        Rectangle result = null;
        result = parent.getStyle().isIdent(CSSName.FS_TEXT_DECORATION_EXTENT, IdentValue.BLOCK) || this.getJustificationInfo() != null ? new Rectangle(this.getAbsX(), this.getAbsY() + this._paintingTop, parent.getAbsX() + parent.getTx() + parent.getContentWidth() - this.getAbsX(), this._paintingHeight) : new Rectangle(this.getAbsX(), this.getAbsY() + this._paintingTop, this.getContentWidth(), this._paintingHeight);
        return result;
    }

    private boolean intersectsInlineBlocks(CssContext cssCtx, Shape clip) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            BoxCollector collector;
            boolean possibleResult;
            Box child = this.getChild(i);
            if (!(child instanceof InlineLayoutBox ? (possibleResult = ((InlineLayoutBox)child).intersectsInlineBlocks(cssCtx, clip)) : (collector = new BoxCollector()).intersectsAny(cssCtx, clip, child))) continue;
            return true;
        }
        return false;
    }

    public List<TextDecoration> getTextDecorations() {
        return this._textDecorations;
    }

    public void setTextDecorations(List<TextDecoration> textDecorations) {
        this._textDecorations = textDecorations;
    }

    public int getPaintingHeight() {
        return this._paintingHeight;
    }

    public void setPaintingHeight(int paintingHeight) {
        this._paintingHeight = paintingHeight;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this._paintingTop = paintingTop;
    }

    public int getMinPaintingTop() {
        int paintingAbsTop = this.getAbsY() + this.getPaintingTop();
        int lineAbsTop = this.getAbsY();
        return Math.min(lineAbsTop, paintingAbsTop);
    }

    public int getMaxPaintingBottom() {
        int paintingAbsBottom = this.getAbsY() + this.getPaintingTop() + this.getPaintingHeight();
        int lineAbsBottom = this.getAbsY() + this.getHeight();
        return Math.max(paintingAbsBottom, lineAbsBottom);
    }

    public void addAllChildren(List<? super Box> list, Layer layer) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            if (this.getContainingLayer() != layer) continue;
            list.add(child);
            if (!(child instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)child).addAllChildren(list, layer);
        }
    }

    public List<Box> getNonFlowContent() {
        return this._nonFlowContent == null ? Collections.emptyList() : this._nonFlowContent;
    }

    public void addNonFlowContent(BlockBox box) {
        if (this._nonFlowContent == null) {
            this._nonFlowContent = new ArrayList<Box>();
        }
        this._nonFlowContent.add(box);
    }

    @Override
    public void reset(LayoutContext c) {
        if (this.hasFootnotes()) {
            c.getFootnoteManager().removeFootnoteBodies(c, this.getReferencedFootnoteBodies(), this);
        }
        for (int i = 0; i < this.getNonFlowContent().size(); ++i) {
            Box content = this.getNonFlowContent().get(i);
            content.reset(c);
        }
        if (this._markerData != null) {
            this._markerData.restorePreviousReferenceLine(this);
        }
        super.reset(c);
    }

    @Override
    public void calcCanvasLocation() {
        BlockBox parent = this.getParent();
        if (parent == null) {
            throw new XRRuntimeException("calcCanvasLocation() called with no parent");
        }
        this.setAbsX(parent.getAbsX() + parent.getTx() + this.getX());
        this.setAbsY(parent.getAbsY() + parent.getTy() + this.getY());
    }

    @Override
    public void calcChildLocations() {
        super.calcChildLocations();
        for (int i = 0; i < this.getNonFlowContent().size(); ++i) {
            Box content = this.getNonFlowContent().get(i);
            if (!content.getStyle().isAbsolute()) continue;
            content.calcCanvasLocation();
            content.calcChildLocations();
        }
    }

    public MarkerData getMarkerData() {
        return this._markerData;
    }

    public void setMarkerData(MarkerData markerData) {
        this._markerData = markerData;
    }

    public boolean isContainsDynamicFunction() {
        return this._containsDynamicFunction;
    }

    public void setContainsDynamicFunction(boolean containsPageCounter) {
        this._containsDynamicFunction |= containsPageCounter;
    }

    public int getContentStart() {
        return this._contentStart;
    }

    public void setContentStart(int contentOffset) {
        this._contentStart = contentOffset;
    }

    public InlineText findTrailingText() {
        if (this.getChildCount() == 0) {
            return null;
        }
        for (int offset = this.getChildCount() - 1; offset >= 0; --offset) {
            Box child = this.getChild(offset);
            if (child instanceof InlineLayoutBox) {
                InlineText result = ((InlineLayoutBox)child).findTrailingText();
                if (result != null && result.isEmpty()) continue;
                return result;
            }
            return null;
        }
        return null;
    }

    public void trimTrailingSpace(LayoutContext c) {
        InlineLayoutBox iB;
        IdentValue whitespace;
        InlineText text = this.findTrailingText();
        if (text != null && ((whitespace = (iB = text.getParent()).getStyle().getWhitespace()) == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP)) {
            text.trimTrailingSpace(c);
        }
    }

    @Override
    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        Box result = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box child = this.getChild(i);
            result = child.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    public boolean isContainsOnlyBlockLevelContent() {
        if (!this.isContainsBlockLevelContent()) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Box b = this.getChild(i);
            if (b instanceof BlockBox) continue;
            return false;
        }
        return true;
    }

    public boolean isContainsVisibleContent() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean maybeResult;
            Box b = this.getChild(i);
            if (!(b instanceof BlockBox ? b.getWidth() > 0 || b.getHeight() > 0 : (maybeResult = ((InlineLayoutBox)b).isContainsVisibleContent()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void collectText(RenderingContext c, StringBuilder buffer) {
        for (Box b : this.getNonFlowContent()) {
            b.collectText(c, buffer);
        }
        if (this.isContainsDynamicFunction()) {
            this.lookForDynamicFunctions(c);
        }
        super.collectText(c, buffer);
    }

    @Override
    public void exportText(RenderingContext c, Writer writer) throws IOException {
        int baselinePos = this.getAbsY() + this.getBaseline();
        if (baselinePos >= c.getPage().getBottom() && this.isInDocumentFlow()) {
            this.exportPageBoxText(c, writer, baselinePos);
        }
        for (Box b : this.getNonFlowContent()) {
            b.exportText(c, writer);
        }
        if (this.isContainsContent()) {
            StringBuilder result = new StringBuilder();
            this.collectText(c, result);
            writer.write(result.toString().trim());
            writer.write(LINE_SEPARATOR);
        }
    }

    @Override
    public void analyzePageBreaks(LayoutContext c, ContentLimitContainer container) {
        container.updateTop(c, this.getAbsY());
        container.updateBottom(c, this.getAbsY() + this.getHeight());
    }

    public void checkPagePosition(LayoutContext c, boolean alwaysBreak) {
        if (!c.isPageBreaksAllowed()) {
            return;
        }
        PageBox pageBox = c.getRootLayer().getFirstPage((CssContext)c, this);
        if (pageBox != null) {
            boolean needsPageBreak;
            int greatestAbsY = this.getMaxPaintingBottom();
            int leastAbsY = this.getMinPaintingTop();
            boolean overflowsPage = c.isInFloatBottom() ? greatestAbsY >= pageBox.getBottom() : greatestAbsY >= pageBox.getBottom(c) - c.getExtraSpaceBottom();
            boolean tooBig = greatestAbsY - leastAbsY > pageBox.getContentHeight(c);
            boolean bl = needsPageBreak = alwaysBreak || overflowsPage && !tooBig;
            if (needsPageBreak) {
                this.beforeChangePage(c);
                this.forcePageBreakBefore(c, IdentValue.ALWAYS, false, leastAbsY);
                this.calcCanvasLocation();
                this.checkFootnoteReservedPage(c, c.getRootLayer().getFirstPage((CssContext)c, this), false);
                this.afterChangePage(c);
            } else if (pageBox.getTop() + c.getExtraSpaceTop() > this.getAbsY()) {
                int diff = pageBox.getTop() + c.getExtraSpaceTop() - this.getAbsY();
                this.setY(this.getY() + diff);
                this.calcCanvasLocation();
                this.checkFootnoteReservedPage(c, pageBox, true);
            } else {
                this.checkFootnoteReservedPage(c, pageBox, true);
            }
        }
    }

    private void afterChangePage(LayoutContext c) {
        if (this.hasFootnotes()) {
            List<BlockBox> footnotes = this.getReferencedFootnoteBodies();
            for (BlockBox footnote : footnotes) {
                c.getFootnoteManager().addFootnoteBody(c, footnote, this);
            }
        }
    }

    private void beforeChangePage(LayoutContext c) {
        if (this.hasFootnotes()) {
            List<BlockBox> footnotes = this.getReferencedFootnoteBodies();
            c.getFootnoteManager().removeFootnoteBodies(c, footnotes, this);
        }
    }

    private void checkFootnoteReservedPage(LayoutContext c, PageBox pageBoxAfter, boolean runHooks) {
        if (c.hasActiveFootnotes() && !c.isInFloatBottom()) {
            while (pageBoxAfter != null && pageBoxAfter.isFootnoteReserved(c) || this.overlapsFootnote(pageBoxAfter)) {
                if (runHooks) {
                    this.beforeChangePage(c);
                }
                int delta = pageBoxAfter.getBottom() + c.getExtraSpaceTop() - this.getMinPaintingTop();
                this.setY(this.getY() + delta);
                this.calcCanvasLocation();
                pageBoxAfter = c.getRootLayer().getFirstPage((CssContext)c, this);
                if (!runHooks) continue;
                this.afterChangePage(c);
            }
        }
    }

    private boolean overlapsFootnote(PageBox pageBox) {
        return pageBox.getFootnoteAreaHeight() > 0 && this.getMaxPaintingBottom() > pageBox.getBottom() - pageBox.getFootnoteAreaHeight();
    }

    public JustificationInfo getJustificationInfo() {
        return this._justificationInfo;
    }

    private void setJustificationInfo(JustificationInfo justificationInfo) {
        this._justificationInfo = justificationInfo;
    }

    public void setDirectionality(byte direction) {
        this.direction = direction;
    }

    public boolean isLayedOutRTL() {
        return this.direction == 1;
    }

    @Override
    public boolean hasNonTextContent(CssContext c) {
        return this._textDecorations != null && this._textDecorations.size() > 0;
    }

    @Override
    public boolean isTerminalColumnBreak() {
        return true;
    }

    public boolean isEndsOnNL() {
        return this._isEndsOnNL;
    }

    public void setEndsOnNL(boolean endsOnNL) {
        this._isEndsOnNL = endsOnNL;
    }

    public List<BlockBox> getReferencedFootnoteBodies() {
        return this.referencedFootnoteBodies;
    }

    public boolean hasFootnotes() {
        return this.referencedFootnoteBodies != null;
    }

    public void addReferencedFootnoteBody(BlockBox footnoteBody) {
        if (this.referencedFootnoteBodies == null) {
            this.referencedFootnoteBodies = new ArrayList<BlockBox>(2);
        }
        this.referencedFootnoteBodies.add(footnoteBody);
    }

    @Override
    public BlockBox getParent() {
        return (BlockBox)super.getParent();
    }
}

