/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.util.format.MarkdownWriterBase;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class HtmlMarkdownWriter
extends MarkdownWriterBase<HtmlMarkdownWriter, Node, HtmlNodeConverterContext> {
    public HtmlMarkdownWriter() {
        this(null, 0);
    }

    public HtmlMarkdownWriter(int formatOptions) {
        this(null, formatOptions);
    }

    public HtmlMarkdownWriter(@Nullable Appendable builder, int formatOptions) {
        super(builder, formatOptions);
    }

    @Override
    @NotNull
    public HtmlMarkdownWriter getEmptyAppendable() {
        return new HtmlMarkdownWriter(this.appendable, this.appendable.getOptions());
    }

    @Override
    @NotNull
    public BasedSequence lastBlockQuoteChildPrefix(BasedSequence prefix) {
        Node node = ((HtmlNodeConverterContext)this.context).getCurrentNode();
        if (node instanceof Element) {
            Element parent;
            Element element = (Element)node;
            while (element.nextElementSibling() == null && (parent = element.parent()) != null) {
                int pos;
                if (parent.nodeName().toLowerCase().equals("blockquote") && (pos = prefix.lastIndexOf('>')) >= 0) {
                    prefix = ((SequenceBuilder)((SequenceBuilder)prefix.getBuilder().append(prefix.subSequence(0, pos))).append(' ').append((CharSequence)prefix.subSequence(pos + 1))).toSequence();
                }
                element = parent;
            }
        }
        return prefix;
    }
}

