/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Content;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ContentNode
extends Node
implements Content {
    protected List<BasedSequence> lineSegments = BasedSequence.EMPTY_LIST;

    public ContentNode() {
    }

    public ContentNode(@NotNull BasedSequence chars) {
        super(chars);
    }

    public ContentNode(@NotNull BasedSequence chars, @NotNull List<BasedSequence> lineSegments) {
        super(chars);
        this.lineSegments = lineSegments;
    }

    public ContentNode(@NotNull List<BasedSequence> lineSegments) {
        this(ContentNode.getSpanningChars(lineSegments), lineSegments);
    }

    public ContentNode(@NotNull BlockContent blockContent) {
        this(blockContent.getSpanningChars(), blockContent.getLines());
    }

    public void setContent(@NotNull BasedSequence chars, @NotNull List<BasedSequence> lineSegments) {
        this.setChars(chars);
        this.lineSegments = lineSegments;
    }

    public void setContent(@NotNull List<BasedSequence> lineSegments) {
        this.lineSegments = lineSegments;
        this.setChars(this.getSpanningChars());
    }

    public void setContent(@NotNull BlockContent blockContent) {
        this.setChars(blockContent.getSpanningChars());
        this.lineSegments = blockContent.getLines();
    }

    @Override
    @NotNull
    public BasedSequence getSpanningChars() {
        return ContentNode.getSpanningChars(this.lineSegments);
    }

    @NotNull
    private static BasedSequence getSpanningChars(@NotNull List<BasedSequence> lineSegments) {
        return lineSegments.isEmpty() ? BasedSequence.NULL : lineSegments.get(0).baseSubSequence(lineSegments.get(0).getStartOffset(), lineSegments.get(lineSegments.size() - 1).getEndOffset());
    }

    @Override
    public int getLineCount() {
        return this.lineSegments.size();
    }

    @Override
    @NotNull
    public BasedSequence getLineChars(int index) {
        return this.lineSegments.get(index);
    }

    @Override
    @NotNull
    public List<BasedSequence> getContentLines() {
        return this.lineSegments;
    }

    @Override
    @NotNull
    public List<BasedSequence> getContentLines(int startLine, int endLine) {
        return this.lineSegments.subList(startLine, endLine);
    }

    @Override
    @NotNull
    public BasedSequence getContentChars() {
        return this.lineSegments.isEmpty() ? BasedSequence.NULL : SegmentedSequence.create(this.lineSegments.get(0), this.lineSegments);
    }

    @Override
    @NotNull
    public BasedSequence getContentChars(int startLine, int endLine) {
        return this.lineSegments.isEmpty() ? BasedSequence.NULL : SegmentedSequence.create(this.lineSegments.get(0), this.getContentLines(startLine, endLine));
    }

    public void setContentLines(@NotNull List<BasedSequence> contentLines) {
        this.lineSegments = contentLines;
    }

    public void setContentLine(int lineIndex, @NotNull BasedSequence contentLine) {
        ArrayList<BasedSequence> lines = new ArrayList<BasedSequence>(this.lineSegments);
        lines.set(lineIndex, contentLine);
        this.lineSegments = lines;
        this.setCharsFromContent();
    }
}

