/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.compilation.FilteredJarConfigGenerator;
import org.jetbrains.idea.maven.project.compilation.ResourceConfigGenerator;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;

@ApiStatus.Internal
public final class MavenResourceConfigurationGeneratorCompileTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance(MavenResourceConfigurationGeneratorCompileTask.class);
    private static final Pattern SIMPLE_NEGATIVE_PATTERN = Pattern.compile("!\\?(\\*\\.\\w+)");

    public boolean execute(@NotNull CompileContext context2) {
        if (context2 == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().runReadAction(() -> MavenResourceConfigurationGeneratorCompileTask.generateBuildConfiguration(context2.isRebuild(), context2.getProject()));
        return true;
    }

    private static void generateBuildConfiguration(boolean force, @NotNull Project project) {
        MavenProjectsManager mavenProjectsManager;
        if (project == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(1);
        }
        if (!(mavenProjectsManager = MavenProjectsManager.getInstance(project)).isMavenizedProject()) {
            return;
        }
        BuildManager buildManager = BuildManager.getInstance();
        File projectSystemIoFile = buildManager.getProjectSystemDirectory(project);
        Path projectSystemDir = projectSystemIoFile.toPath();
        RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(project);
        Path mavenConfigFile = projectSystemDir.resolve("maven/configuration.xml");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        int projectRootModificationCount = (int)projectRootManager.getModificationCount();
        int mavenConfigCrc = mavenProjectsManager.getFilterConfigCrc(fileIndex);
        int crc = mavenConfigCrc + projectRootModificationCount;
        Path crcFile = mavenConfigFile.resolveSibling("configuration.crc");
        if (!force) {
            try (DataInputStream crcInput = new DataInputStream(Files.newInputStream(crcFile, StandardOpenOption.READ));){
                int lastCrc = crcInput.readInt();
                if (lastCrc == crc) {
                    return;
                }
                LOG.debug(String.format("project configuration changed: lastCrc = %d, currentCrc = %d, projectRootModificationCount = %d, mavenConfigCrc = %d", lastCrc, crc, projectRootModificationCount, mavenConfigCrc));
            }
            catch (IOException e) {
                LOG.debug("Unable to read or find config file: " + e.getMessage());
            }
        }
        MavenProjectConfiguration projectConfig = new MavenProjectConfiguration();
        for (MavenProject mavenProject : mavenProjectsManager.getProjects()) {
            new ResourceConfigGenerator(fileIndex, mavenProjectsManager, transformer, projectConfig, mavenProject).generateResourceConfig();
            new FilteredJarConfigGenerator(fileIndex, mavenProjectsManager, transformer, projectConfig, mavenProject).generateAdditionalJars();
        }
        MavenResourceConfigurationGeneratorCompileTask.addNonMavenResources(transformer, projectConfig, mavenProjectsManager, project);
        Element element = new Element("maven-project-configuration");
        XmlSerializer.serializeInto((Object)projectConfig, (Element)element);
        buildManager.runCommand(() -> {
            if (!project.isDefault()) {
                buildManager.clearState(project);
            }
            try {
                JDOMUtil.write((Element)element, (Path)mavenConfigFile);
                try (DataOutputStream crcOutput = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(crcFile, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE)));){
                    crcOutput.writeInt(crc);
                }
            }
            catch (IOException e) {
                LOG.debug("Unable to write config file", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private static void addNonMavenResources(RemotePathTransformerFactory.Transformer transformer, @NotNull MavenProjectConfiguration projectCfg, @NotNull MavenProjectsManager mavenProjectsManager, @NotNull Project project) {
        if (projectCfg == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(2);
        }
        if (mavenProjectsManager == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(3);
        }
        if (project == null) {
            MavenResourceConfigurationGeneratorCompileTask.$$$reportNull$$$0(4);
        }
        HashSet<VirtualFile> processedRoots = new HashSet<VirtualFile>();
        for (MavenProject mavenProject : mavenProjectsManager.getProjects()) {
            for (String dir : ContainerUtil.concat(mavenProject.getSources(), mavenProject.getTestSources())) {
                VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(dir);
                if (file2 == null) continue;
                processedRoots.add(file2);
            }
            for (MavenResource resource : ContainerUtil.concat(mavenProject.getResources(), mavenProject.getTestResources())) {
                String directory = resource.getDirectory();
                ContainerUtil.addIfNotNull(processedRoots, (Object)LocalFileSystem.getInstance().findFileByPath(directory));
            }
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!mavenProjectsManager.isMavenizedModule(module)) continue;
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                SourceFolder[] sourceFolders = contentEntry.getSourceFolders();
                if (sourceFolders.length == 0) continue;
                Set<VirtualFile> excludedRoots = Set.copyOf(Arrays.asList(contentEntry.getExcludeFolderFiles()));
                for (SourceFolder folder : sourceFolders) {
                    MavenModuleResourceConfiguration configuration;
                    VirtualFile file3 = folder.getFile();
                    if (file3 == null || compilerConfiguration.isExcludedFromCompilation(file3) || MavenResourceConfigurationGeneratorCompileTask.isUnderRoots(processedRoots, file3) || MavenResourceConfigurationGeneratorCompileTask.isUnderRoots(excludedRoots, file3) || (configuration = (MavenModuleResourceConfiguration)projectCfg.moduleConfigurations.get(module.getName())) == null) continue;
                    List resourcesList = folder.isTestSource() ? configuration.testResources : configuration.resources;
                    ResourceRootConfiguration cfg = new ResourceRootConfiguration();
                    cfg.directory = transformer.toRemotePathOrSelf(FileUtil.toSystemIndependentName((String)file3.getPath()));
                    CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
                    if (compilerModuleExtension == null) continue;
                    String compilerOutputUrl = folder.isTestSource() ? compilerModuleExtension.getCompilerOutputUrlForTests() : compilerModuleExtension.getCompilerOutputUrl();
                    cfg.targetPath = transformer.toRemotePathOrSelf(VfsUtilCore.urlToPath((String)compilerOutputUrl));
                    MavenResourceConfigurationGeneratorCompileTask.convertIdeaExcludesToMavenExcludes(cfg, (CompilerConfigurationImpl)compilerConfiguration);
                    resourcesList.add(cfg);
                }
            }
        }
    }

    private static void convertIdeaExcludesToMavenExcludes(ResourceRootConfiguration cfg, CompilerConfigurationImpl compilerConfiguration) {
        for (String pattern : compilerConfiguration.getResourceFilePatterns()) {
            Matcher matcher = SIMPLE_NEGATIVE_PATTERN.matcher(pattern);
            if (!matcher.matches()) continue;
            cfg.excludes.add("**/" + matcher.group(1));
        }
    }

    private static boolean isUnderRoots(Set<VirtualFile> roots, VirtualFile file2) {
        for (VirtualFile f = file2; f != null; f = f.getParent()) {
            if (!roots.contains(f)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectCfg";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjectsManager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenResourceConfigurationGeneratorCompileTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "generateBuildConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addNonMavenResources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

