/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspacePersistedSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;

@State(name="MavenImportPreferences", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class MavenWorkspaceSettingsComponent
implements PersistentStateComponent<MavenWorkspacePersistedSettings> {
    private MavenWorkspacePersistedSettings mySettings;
    private final Project myProject;

    public MavenWorkspaceSettingsComponent(@NotNull Project project) {
        if (project == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySettings = new MavenWorkspacePersistedSettings(new MavenWorkspaceSettings());
        this.mySettings.getGeneralSettings().setProject(project);
        this.applyDefaults(this.mySettings.getRealSettings());
    }

    public static MavenWorkspaceSettingsComponent getInstance(@NotNull Project project) {
        if (project == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(1);
        }
        return (MavenWorkspaceSettingsComponent)project.getService(MavenWorkspaceSettingsComponent.class);
    }

    @NotNull
    public MavenWorkspacePersistedSettings getState() {
        MavenExplicitProfiles profiles2 = MavenProjectsManager.getInstance(this.myProject).getExplicitProfiles();
        this.mySettings.explicitlyEnabledProfiles = StringUtil.nullize((String)StringUtil.join((Collection)profiles2.getEnabledProfiles(), (String)","));
        this.mySettings.explicitlyDisabledProfiles = StringUtil.nullize((String)StringUtil.join((Collection)profiles2.getDisabledProfiles(), (String)","));
        this.mySettings.getRealSettings().enabledProfiles = new ArrayList<String>(profiles2.getEnabledProfiles());
        this.mySettings.getRealSettings().disabledProfiles = new ArrayList<String>(profiles2.getDisabledProfiles());
        MavenWorkspacePersistedSettings mavenWorkspacePersistedSettings = this.mySettings;
        if (mavenWorkspacePersistedSettings == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(2);
        }
        return mavenWorkspacePersistedSettings;
    }

    public void loadState(@NotNull MavenWorkspacePersistedSettings state) {
        if (state == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(3);
        }
        this.mySettings = state;
        MavenWorkspaceSettingsComponent.applyProfiles(this.mySettings);
        this.applyDefaults(this.mySettings.getRealSettings());
        this.migrateSettings(this.mySettings.getRealSettings());
    }

    private static void applyProfiles(MavenWorkspacePersistedSettings settings) {
        MavenWorkspaceSettings wrappee = settings.getRealSettings();
        if (settings.explicitlyEnabledProfiles != null) {
            settings.getRealSettings().setEnabledProfiles(StringUtil.split((String)settings.explicitlyEnabledProfiles, (String)","));
        }
        if (settings.explicitlyDisabledProfiles != null) {
            settings.getRealSettings().setDisabledProfiles(StringUtil.split((String)settings.explicitlyDisabledProfiles, (String)","));
        }
    }

    public MavenWorkspaceSettings getSettings() {
        return this.mySettings.getRealSettings();
    }

    private void applyDefaults(MavenWorkspaceSettings settings) {
        settings.getGeneralSettings().setProject(this.myProject);
    }

    private void migrateSettings(MavenWorkspaceSettings settings) {
        MavenImportingSettings importingSettings = settings.getImportingSettings();
        if (importingSettings.isImportAutomatically()) {
            importingSettings.setImportAutomatically(false);
            ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.getInstance((Project)this.myProject);
            projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.ALL);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

