/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellProperty;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUniqueNameGenerator;
import com.intellij.jupyter.core.jupyter.data.input.VariableField;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001)B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0003J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\r\u0010\u001e\u001a\u00070\u0011\u00a2\u0006\u0002\b\u001fH\u0014J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020(H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputVariablePopup;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "editor", "Lcom/intellij/openapi/editor/Editor;", "name", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellProperty;", "nameGenerator", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUniqueNameGenerator;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputCellProperty;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputUniqueNameGenerator;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getAndUpdateVariableName", "", "actionPerformed", "createLabel", "Ljavax/swing/JLabel;", "text", "font", "Ljava/awt/Font;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "storeVariableName", "getTextBeforeVariableName", "Lorg/jetbrains/annotations/Nls;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "textField", "Lcom/intellij/jupyter/core/jupyter/data/input/VariableField;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getPopupListener", "Lcom/intellij/openapi/ui/popup/JBPopupListener;", "Ljavax/swing/JTextField;", "VariablePopupListener", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputVariablePopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputVariablePopup.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputVariablePopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public class JupyterDataInputVariablePopup
extends AnAction
implements CustomComponentAction,
DumbAware {
    @NotNull
    private final Editor editor;
    @NotNull
    private final JupyterDataInputCellProperty name;
    @NotNull
    private final JupyterDataInputUniqueNameGenerator nameGenerator;

    public JupyterDataInputVariablePopup(@NotNull Editor editor, @NotNull JupyterDataInputCellProperty name, @NotNull JupyterDataInputUniqueNameGenerator nameGenerator) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)nameGenerator, (String)"nameGenerator");
        this.editor = editor;
        this.name = name;
        this.nameGenerator = nameGenerator;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setText(this.getAndUpdateVariableName());
    }

    @NlsSafe
    private final String getAndUpdateVariableName() {
        String variableName = this.name.get();
        if (variableName == null) {
            variableName = this.nameGenerator.makeUniqueName(JupyterEditorExtensionsKt.getNotebookFile(this.editor).getNotebook());
            this.storeVariableName(variableName);
        }
        String string = StringUtil.escapeMnemonics((String)variableName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeMnemonics(...)");
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        JComponent component2 = jComponent;
        String string = e.getPresentation().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        VariableField textField2 = new VariableField(string);
        JBPopup popup = this.createPopup(textField2);
        popup.showUnderneathOf((Component)component2);
    }

    private final JLabel createLabel(@Nls String text, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        label.setForeground(UIUtil.getLabelInfoForeground());
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        return label;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText button2 = new ActionButtonWithText(this, presentation, place, dimension){

            public Insets getInsets() {
                JBInsets jBInsets = JBInsets.emptyInsets();
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
                return (Insets)jBInsets;
            }

            protected boolean shallPaintDownArrow() {
                return true;
            }
        };
        button2.setHorizontalTextAlignment(2);
        button2.setFont((Font)JBFont.small());
        JPanel panel = new JPanel(new GridBagLayout());
        String string = this.getTextBeforeVariableName();
        Font font = button2.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        panel.add(this.createLabel(string, font));
        panel.add((Component)button2);
        return panel;
    }

    private final void storeVariableName(String text) {
        this.name.set(text);
        Project project = this.editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ReadAction.run(() -> JupyterDataInputVariablePopup.storeVariableName$lambda$1(project2, this));
    }

    @NotNull
    protected String getTextBeforeVariableName() {
        return JupyterBundle.message("jupyter.data.input.toolbar.variable", new Object[0]);
    }

    private final JBPopup createPopup(VariableField textField2) {
        JPanel textPanel = new JPanel(new GridLayout(1, 1));
        textPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)3, (int)0));
        textPanel.add(new JLabel(JupyterBundle.message("jupyter.data.input.toolbar.variable.popup", new Object[0])));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder((Border)JBUI.Borders.empty((int)3, (int)10, (int)8, (int)10));
        panel.add(textPanel);
        panel.add(textField2);
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)textField2).setCancelOnClickOutside(true).setRequestFocus(true);
        Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"setRequestFocus(...)");
        ComponentPopupBuilder builder = componentPopupBuilder;
        JBPopup jBPopup = builder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        popup.addListener(this.getPopupListener(textField2));
        popup.setMinimumSize((Dimension)new JBDimension(200, 50));
        AnAction closePopup2 = (AnAction)new DumbAwareAction(this, textField2, popup, panel){
            final /* synthetic */ JupyterDataInputVariablePopup this$0;
            final /* synthetic */ VariableField $textField;
            final /* synthetic */ JBPopup $popup;
            final /* synthetic */ JPanel $panel;
            {
                this.this$0 = $receiver;
                this.$textField = $textField;
                this.$popup = $popup;
                this.$panel = $panel;
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JupyterDataInputCellProperty jupyterDataInputCellProperty = JupyterDataInputVariablePopup.access$getName$p(this.this$0);
                String string = this.$textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (jupyterDataInputCellProperty.isValid(string, JupyterDataInputVariablePopup.access$getEditor$p(this.this$0).getProject())) {
                    this.$popup.closeOk(e.getInputEvent());
                } else {
                    void $this$actionPerformed_u24lambda_u240;
                    this.$textField.errorView();
                    JPanel jPanel = new JPanel(new GridLayout(1, 1));
                    JupyterDataInputVariablePopup jupyterDataInputVariablePopup = this.this$0;
                    JPanel jPanel2 = jPanel;
                    JPanel jPanel3 = this.$panel;
                    boolean bl = false;
                    String string2 = JupyterBundle.message("jupyter.data.input.toolbar.variable.validation.error", new Object[0]);
                    JBFont jBFont = JBFont.small().lessOn(2.0f);
                    Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"lessOn(...)");
                    $this$actionPerformed_u24lambda_u240.add(JupyterDataInputVariablePopup.access$createLabel(jupyterDataInputVariablePopup, string2, (Font)jBFont));
                    jPanel3.add(jPanel);
                    this.$panel.updateUI();
                }
            }
        };
        closePopup2.registerCustomShortcutSet(CommonShortcuts.ENTER, popup.getContent());
        return popup;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    protected JBPopupListener getPopupListener(@NotNull JTextField textField2) {
        Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
        return new VariablePopupListener(this, textField2);
    }

    private static final void storeVariableName$lambda$1(Project $project, JupyterDataInputVariablePopup this$0) {
        block0: {
            PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile(this$0.editor.getVirtualFile());
            if (psiFile == null) break block0;
            PsiFile it = psiFile;
            boolean bl = false;
            DaemonCodeAnalyzer.getInstance((Project)$project).restart(it);
        }
    }

    public static final /* synthetic */ JLabel access$createLabel(JupyterDataInputVariablePopup $this, String text, Font font) {
        return $this.createLabel(text, font);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputVariablePopup$VariablePopupListener;", "Lcom/intellij/openapi/ui/popup/JBPopupListener;", "variablePopup", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputVariablePopup;", "textField", "Ljavax/swing/JTextField;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputVariablePopup;Ljavax/swing/JTextField;)V", "onClosed", "", "event", "Lcom/intellij/openapi/ui/popup/LightweightWindowEvent;", "intellij.jupyter.core"})
    protected static class VariablePopupListener
    implements JBPopupListener {
        @NotNull
        private final JupyterDataInputVariablePopup variablePopup;
        @NotNull
        private final JTextField textField;

        public VariablePopupListener(@NotNull JupyterDataInputVariablePopup variablePopup, @NotNull JTextField textField2) {
            Intrinsics.checkNotNullParameter((Object)((Object)variablePopup), (String)"variablePopup");
            Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
            this.variablePopup = variablePopup;
            this.textField = textField2;
        }

        public void onClosed(@NotNull LightweightWindowEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            JupyterDataInputCellProperty name = this.variablePopup.name;
            Editor editor = this.variablePopup.editor;
            String string = this.textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() > 0) {
                String string2 = this.textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (!StringsKt.isBlank((CharSequence)string2)) {
                    String string3 = this.textField.getText();
                    String string4 = name.get();
                    if (string4 == null) {
                        string4 = name.default();
                    }
                    if (!Intrinsics.areEqual((Object)string3, (Object)string4)) {
                        String string5 = this.textField.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                        if (name.isValid(string5, editor.getProject())) {
                            String string6 = this.textField.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
                            this.variablePopup.storeVariableName(string6);
                        }
                    }
                }
            }
        }
    }
}

