/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.controllers.below.execution;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterShowExecutionTimeMode;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.ui.SpinningProgressIcon;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0017\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J(\u0010\u001b\u001a\u0004\u0018\u00010\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0003J\u001e\u0010 \u001a\u0004\u0018\u00010\r2\b\u0010!\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0003J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001aH\u0007J\u0018\u0010%\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001aH\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R!\u0010&\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b'*\u0004\u0018\u00010\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\n ,*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n ,*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/controllers/below/execution/ExecutionStatusTextProvider;", "", "<init>", "()V", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "getSettings", "()Lcom/intellij/jupyter/core/editor/settings/JupyterSettings;", "calculateIcon", "Ljavax/swing/Icon;", "executionStatus", "Lcom/intellij/notebooks/visualization/ui/EditorCell$ExecutionStatus;", "calculateLabel", "", "isUnderDebug", "", "calculateTooltip", "getExecutionInfoLabelText", "getExecutionCountLabelText", "executionCount", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "getStoppedTimeTooltipText", "Lorg/jetbrains/annotations/Nls;", "err", "executionEndTime", "Ljava/time/ZonedDateTime;", "getExecutionDurationString", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "startTime", "endTime", "computeExecutionDuration", "executionStartTime", "presentableTimeDiff", "startDateTime", "endDateTime", "detailedTimeDiff", "icon", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "(Lcom/intellij/notebooks/visualization/ui/ProgressStatus;)Ljavax/swing/Icon;", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "timeFormatter", "msTimeUnit", "sTimeUnit", "mTimeUnit", "hTimeUnit", "dTimeUnit", "intellij.jupyter.core"})
public final class ExecutionStatusTextProvider {
    @NotNull
    public static final ExecutionStatusTextProvider INSTANCE = new ExecutionStatusTextProvider();
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy.MM.dd");
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    @Nls
    @NotNull
    private static final String msTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.milliseconds", new Object[0]);
    @Nls
    @NotNull
    private static final String sTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.seconds", new Object[0]);
    @Nls
    @NotNull
    private static final String mTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.minutes", new Object[0]);
    @Nls
    @NotNull
    private static final String hTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.hours", new Object[0]);
    @Nls
    @NotNull
    private static final String dTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.days", new Object[0]);

    private ExecutionStatusTextProvider() {
    }

    private final JupyterSettings getSettings() {
        return JupyterSettings.Companion.getInstance();
    }

    @Nullable
    public final Icon calculateIcon(@NotNull EditorCell.ExecutionStatus executionStatus) {
        Intrinsics.checkNotNullParameter((Object)executionStatus, (String)"executionStatus");
        if (this.getSettings().getExecutionTimeShowMode() == JupyterShowExecutionTimeMode.HIDDEN) {
            return null;
        }
        return this.getIcon(executionStatus.getStatus());
    }

    @Nls
    @Nullable
    public final String calculateLabel(@NotNull EditorCell.ExecutionStatus executionStatus, boolean isUnderDebug) {
        Intrinsics.checkNotNullParameter((Object)executionStatus, (String)"executionStatus");
        String executionCountText = this.getExecutionCountLabelText(executionStatus.getCount());
        String string = this.getExecutionInfoLabelText(executionStatus, isUnderDebug);
        if (string == null) {
            string = "";
        }
        String durationLabelText = string;
        String labelText = switch (WhenMappings.$EnumSwitchMapping$0[this.getSettings().getExecutionTimeShowMode().ordinal()]) {
            case 1 -> {
                String v1 = this.calculateTooltip(executionStatus);
                if (v1 == null) {
                    v1 = "";
                }
                String tooltip = v1;
                yield executionCountText + " " + durationLabelText + " " + tooltip;
            }
            case 2 -> executionCountText + " " + durationLabelText;
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
        return labelText;
    }

    @Nls
    @Nullable
    public final String calculateTooltip(@NotNull EditorCell.ExecutionStatus executionStatus) {
        Intrinsics.checkNotNullParameter((Object)executionStatus, (String)"executionStatus");
        ProgressStatus progressStatus = executionStatus.getStatus();
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[progressStatus.ordinal()]) {
            case 1 -> JupyterBundle.message("jupyter.cell.status.execution.not.started", new Object[0]);
            case 2 -> JupyterBundle.message("jupyter.cell.status.is.running", new Object[0]);
            case 3 -> JupyterBundle.message("jupyter.cell.status.queued.for.execution", new Object[0]);
            case 4 -> JupyterBundle.message("jupyter.cell.status.execution.cancelled", new Object[0]);
            case 5 -> this.getStoppedTimeTooltipText(false, executionStatus.getEndTime());
            case 6 -> this.getStoppedTimeTooltipText(true, executionStatus.getEndTime());
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getExecutionInfoLabelText(EditorCell.ExecutionStatus executionStatus, boolean isUnderDebug) {
        if (isUnderDebug) {
            return JupyterBundle.message("jupyter.inlay.progress.cell.is.debugging", new Object[0]);
        }
        String string = this.getExecutionDurationString(executionStatus.getStatus(), executionStatus.getStartTime(), executionStatus.getEndTime());
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getExecutionCountLabelText(Integer executionCount) {
        return executionCount == null ? "" : (executionCount == 0 ? "" : "[" + executionCount + "]");
    }

    private final String getStoppedTimeTooltipText(boolean err, ZonedDateTime executionEndTime) {
        String string;
        if (executionEndTime == null) {
            return null;
        }
        ZoneId userTimeZone = ZoneId.systemDefault();
        ZonedDateTime localDateTime = executionEndTime.withZoneSameInstant(userTimeZone);
        String formattedDate = localDateTime.format(dateFormatter);
        String formattedTime = localDateTime.format(timeFormatter);
        boolean bl = err;
        if (bl) {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)formattedDate);
            objectArray[0] = formattedDate;
            Intrinsics.checkNotNull((Object)formattedTime);
            objectArray[1] = formattedTime;
            string = JupyterBundle.message("jupyter.inlay.progress.time.crashed", objectArray);
        } else if (!bl) {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)formattedDate);
            objectArray[0] = formattedDate;
            Intrinsics.checkNotNull((Object)formattedTime);
            objectArray[1] = formattedTime;
            string = JupyterBundle.message("jupyter.inlay.progress.time.finished", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    static /* synthetic */ String getStoppedTimeTooltipText$default(ExecutionStatusTextProvider executionStatusTextProvider, boolean bl, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return executionStatusTextProvider.getStoppedTimeTooltipText(bl, zonedDateTime);
    }

    @Nls
    private final String getExecutionDurationString(ProgressStatus status, ZonedDateTime startTime, ZonedDateTime endTime) {
        ProgressStatus progressStatus = status;
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[progressStatus.ordinal()]) {
            case 2 -> this.computeExecutionDuration(startTime, ZonedDateTime.now());
            case 5, 6 -> this.computeExecutionDuration(startTime, endTime);
            case -1, 1, 3, 4 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nls
    private final String computeExecutionDuration(ZonedDateTime executionStartTime, ZonedDateTime executionEndTime) {
        if (executionStartTime == null || executionEndTime == null) {
            return null;
        }
        JupyterShowExecutionTimeMode displayMode = this.getSettings().getExecutionTimeShowMode();
        return switch (WhenMappings.$EnumSwitchMapping$0[displayMode.ordinal()]) {
            case 2 -> this.presentableTimeDiff(executionStartTime, executionEndTime);
            case 1 -> this.detailedTimeDiff(executionStartTime, executionEndTime);
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nls
    @VisibleForTesting
    @NotNull
    public final String presentableTimeDiff(@NotNull ZonedDateTime startDateTime, @NotNull ZonedDateTime endDateTime) {
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        Intrinsics.checkNotNullParameter((Object)endDateTime, (String)"endDateTime");
        Duration diff = Duration.between(startDateTime, endDateTime);
        return diff.compareTo(Duration.ofMillis(10L)) < 0 ? "< 10 " + msTimeUnit : (diff.compareTo(Duration.ofSeconds(1L)) < 0 ? diff.toMillis() + msTimeUnit : (diff.compareTo(Duration.ofMinutes(1L)) < 0 ? diff.toSecondsPart() + sTimeUnit + " " + diff.toMillisPart() + msTimeUnit : (diff.compareTo(Duration.ofHours(1L)) < 0 ? diff.toMinutesPart() + mTimeUnit + " " + diff.toSecondsPart() + sTimeUnit : (diff.compareTo(Duration.ofDays(1L)) < 0 ? diff.toHoursPart() + hTimeUnit + " " + diff.toMinutesPart() + mTimeUnit : diff.toDaysPart() + dTimeUnit + " " + diff.toHoursPart() + hTimeUnit + " " + diff.toMinutesPart() + mTimeUnit))));
    }

    @Nls
    private final String detailedTimeDiff(ZonedDateTime startDateTime, ZonedDateTime endDateTime) {
        Duration diff = Duration.between(startDateTime, endDateTime);
        return diff.compareTo(Duration.ofSeconds(1L)) < 0 ? diff.toMillis() + msTimeUnit : (diff.compareTo(Duration.ofMinutes(1L)) < 0 ? diff.toSecondsPart() + sTimeUnit + " " + diff.toMillisPart() + msTimeUnit : (diff.compareTo(Duration.ofHours(1L)) < 0 ? diff.toMinutesPart() + mTimeUnit + " " + diff.toSecondsPart() + sTimeUnit + " " + diff.toMillisPart() + msTimeUnit : (diff.compareTo(Duration.ofDays(1L)) < 0 ? diff.toHoursPart() + hTimeUnit + " " + diff.toMinutesPart() + mTimeUnit + " " + diff.toSecondsPart() + sTimeUnit + " " + diff.toMillisPart() + msTimeUnit : diff.toDaysPart() + dTimeUnit + " " + diff.toHoursPart() + hTimeUnit + " " + diff.toMinutesPart() + mTimeUnit + " " + diff.toSecondsPart() + sTimeUnit + " " + diff.toMillisPart() + msTimeUnit)));
    }

    private final Icon getIcon(ProgressStatus $this$icon) {
        ProgressStatus progressStatus = $this$icon;
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$1[progressStatus.ordinal()]) {
            case 2 -> (Icon)new SpinningProgressIcon(null, 0, 3, null);
            case 5 -> AllIcons.General.GreenCheckmark;
            case 6 -> JupyterCoreIcons.ResultIncorrect;
            case 1 -> AllIcons.Empty;
            case 3 -> AllIcons.General.History;
            case 4 -> AllIcons.Run.ShowIgnored;
            default -> null;
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[JupyterShowExecutionTimeMode.values().length];
            try {
                nArray[JupyterShowExecutionTimeMode.EXACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterShowExecutionTimeMode.COMPACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterShowExecutionTimeMode.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.NOT_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.QUEUED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_OK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

