/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.openapi.util.TextRange;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CantBeParsedCall;
import com.intellij.profiler.model.NativeCall;
import com.intellij.profiler.ui.NativeCallStackElementRenderer;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ultimate.JavaFlameChartColorScheme;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.jfr.KotlinInlineJFRMethodCall;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.UtilKt;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J6\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u001e\u001a\u00020\u00152\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\"H\u0016J \u0010$\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002\u00a8\u0006+"}, d2={"Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer;", "Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "<init>", "()V", "fillTextInsideNode", "", "node", "Lcom/intellij/profiler/api/BaseCallStackElement;", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "getText", "getCommentInfo", "appendStackElementInRenderer", "", "label", "Lcom/intellij/ui/SimpleColoredComponent;", "component", "Ljavax/swing/JComponent;", "selected", "", "doAppendStackElementInRenderer", "speedSearchHighlightedRanges", "", "Lcom/intellij/openapi/util/TextRange;", "styledText", "", "Lkotlin/Pair;", "Lcom/intellij/ui/SimpleTextAttributes;", "withComment", "getRegularAttributes", "getBoldAttributes", "getColorScheme", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "getRootColorScheme", "fillJavaMethodText", "Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "buildString", "pkg", "cls", "method", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJavaCallStackElementRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCallStackElementRenderer.kt\ncom/intellij/profiler/ultimate/JavaCallStackElementRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n967#2,7:164\n1563#2:171\n1634#2,3:172\n1563#2:176\n1634#2,3:177\n1#3:175\n*S KotlinDebug\n*F\n+ 1 JavaCallStackElementRenderer.kt\ncom/intellij/profiler/ultimate/JavaCallStackElementRenderer\n*L\n66#1:164,7\n76#1:171\n76#1:172,3\n135#1:176\n135#1:177,3\n*E\n"})
public class JavaCallStackElementRenderer
extends NativeCallStackElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JavaCallStackElementRenderer INSTANCE = new JavaCallStackElementRenderer();

    protected JavaCallStackElementRenderer() {
    }

    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        if (node instanceof BaseJavaMethodCall) {
            try {
                return this.fillJavaMethodText((BaseJavaMethodCall)node, rect, fontMetrics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.fillTextInsideNode(node, rect, fontMetrics);
    }

    @NotNull
    public String getText(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return CollectionsKt.joinToString$default((Iterable)JavaCallStackElementRenderer.styledText$default(this, node, false, false, 6, null), (CharSequence)"", null, null, (int)0, null, JavaCallStackElementRenderer::getText$lambda$0, (int)30, null);
    }

    @Nullable
    public String getCommentInfo(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof KotlinInlineJFRMethodCall) {
            return UltimateProfilerBundleKt.profilerMessage("profiler.kotlin.inline.frame.label", new Object[0]);
        }
        return super.getCommentInfo(node);
    }

    public void appendStackElementInRenderer(@NotNull BaseCallStackElement node, @NotNull SimpleColoredComponent label2, @NotNull JComponent component, boolean selected) {
        Iterable highlightedRanges;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        SpeedSearchSupply speedSearchSupply = SpeedSearchSupply.getSupply((JComponent)component);
        Iterable iterable = highlightedRanges = speedSearchSupply != null ? speedSearchSupply.matchingFragments(this.getText(node)) : null;
        if (highlightedRanges == null) {
            for (Pair<String, SimpleTextAttributes> pair : this.styledText(node, true, selected)) {
                String text = (String)pair.component1();
                SimpleTextAttributes style = (SimpleTextAttributes)pair.component2();
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)component, (String)text, (SimpleTextAttributes)style, (boolean)selected, (SimpleColoredComponent)label2);
            }
        } else {
            this.doAppendStackElementInRenderer(node, highlightedRanges, label2, selected);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void doAppendStackElementInRenderer(@NotNull BaseCallStackElement node, @NotNull Iterable<? extends TextRange> speedSearchHighlightedRanges, @NotNull SimpleColoredComponent label2, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(speedSearchHighlightedRanges, (String)"speedSearchHighlightedRanges");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        List highlightedRanges = CollectionsKt.toMutableList(speedSearchHighlightedRanges);
        int prefixLength = 0;
        TextRange overlappingFromPreviousStep = null;
        for (Pair<String, SimpleTextAttributes> pair : this.styledText(node, true, selected)) {
            void $this$mapTo$iv$iv;
            Object item$iv2;
            String text = (String)pair.component1();
            SimpleTextAttributes attributes = (SimpleTextAttributes)pair.component2();
            List rangesForText = new ArrayList();
            UtilKt.addIfNotNull((List)rangesForText, overlappingFromPreviousStep);
            Iterable $this$takeWhile$iv = highlightedRanges;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv2 : $this$takeWhile$iv) {
                TextRange it = (TextRange)item$iv2;
                boolean bl = false;
                if (!(it.getStartOffset() < prefixLength + text.length())) break;
                list$iv.add(item$iv2);
            }
            List taken = list$iv;
            highlightedRanges.removeAll(taken);
            rangesForText.addAll(taken);
            TextRange lastMaybeOverlappingRange = (TextRange)CollectionsKt.lastOrNull((List)rangesForText);
            if (lastMaybeOverlappingRange != null && lastMaybeOverlappingRange.getEndOffset() >= prefixLength + text.length()) {
                rangesForText.set(CollectionsKt.getLastIndex((List)rangesForText), new TextRange(lastMaybeOverlappingRange.getStartOffset(), prefixLength + text.length()));
                overlappingFromPreviousStep = new TextRange(prefixLength + text.length(), lastMaybeOverlappingRange.getEndOffset());
            } else {
                overlappingFromPreviousStep = null;
            }
            Iterable $this$map$iv = rangesForText;
            boolean $i$f$map = false;
            item$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.shiftLeft(prefixLength));
            }
            List shifted = (List)destination$iv$iv;
            prefixLength += text.length();
            SpeedSearchUtil.appendSpeedSearchColoredFragments((SimpleColoredComponent)label2, (String)text, (Iterable)shifted, (SimpleTextAttributes)attributes, (boolean)selected);
        }
    }

    private final List<Pair<String, SimpleTextAttributes>> styledText(BaseCallStackElement node, boolean withComment, boolean selected) {
        List result = new ArrayList();
        if (node instanceof BaseJavaMethodCall) {
            if (((CharSequence)((BaseJavaMethodCall)node).getFullPackageName()).length() > 0) {
                result.add(new Pair((Object)(((BaseJavaMethodCall)node).getFullPackageName() + "."), (Object)this.getRegularAttributes(node)));
            }
            if (((CharSequence)((BaseJavaMethodCall)node).getClassName()).length() > 0) {
                result.add(new Pair((Object)(((BaseJavaMethodCall)node).getClassName() + "." + ((BaseJavaMethodCall)node).getMethodName()), (Object)this.getBoldAttributes(node)));
                if (((BaseJavaMethodCall)node).getArgumentTypes() != null) {
                    result.add(new Pair((Object)((BaseJavaMethodCall)node).argumentTypesString(), (Object)this.getRegularAttributes(node)));
                }
            } else {
                result.add(new Pair((Object)((BaseJavaMethodCall)node).getMethodName(), (Object)this.getRegularAttributes(node)));
            }
            if (withComment) {
                String string = this.getCommentInfo(node);
                if (string != null) {
                    String string2;
                    String comment = string2 = string;
                    boolean bl = false;
                    SimpleTextAttributes style = selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    result.add(new Pair((Object)("  " + comment), (Object)style));
                }
            }
        } else {
            result.add(new Pair((Object)node.fullName(), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
        }
        return result;
    }

    static /* synthetic */ List styledText$default(JavaCallStackElementRenderer javaCallStackElementRenderer, BaseCallStackElement baseCallStackElement, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: styledText");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return javaCallStackElementRenderer.styledText(baseCallStackElement, bl, bl2);
    }

    @NotNull
    public SimpleTextAttributes getRegularAttributes(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        return simpleTextAttributes;
    }

    @NotNull
    public SimpleTextAttributes getBoldAttributes(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
        return simpleTextAttributes;
    }

    @NotNull
    public FlameChartColorScheme getColorScheme(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BaseCallStackElement baseCallStackElement = node;
        return baseCallStackElement instanceof BaseJavaCall ? (FlameChartColorScheme)JavaFlameChartColorScheme.PROJECT.INSTANCE : (baseCallStackElement instanceof NativeCall || baseCallStackElement instanceof CantBeParsedCall ? (FlameChartColorScheme)JavaFlameChartColorScheme.NATIVE.INSTANCE : super.getColorScheme(node));
    }

    @NotNull
    public FlameChartColorScheme getRootColorScheme() {
        return (FlameChartColorScheme)JavaFlameChartColorScheme.ROOT.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final String fillJavaMethodText(BaseJavaMethodCall node, Rectangle2D rect, FontMetrics fontMetrics) {
        void $this$mapTo$iv$iv;
        int n;
        double maxWidthWithoutComment = rect.getWidth() - 0.0;
        String string = this.getCommentInfo(node);
        if (string != null) {
            String it = string;
            boolean bl = false;
            n = fontMetrics.stringWidth(it) + 5;
        } else {
            n = 0;
        }
        int commentLength = n;
        double maxWidth = maxWidthWithoutComment - (double)commentLength;
        String fullName = this.buildString(node.getFullPackageName(), node.getClassName(), node.getMethodName());
        if ((double)fontMetrics.stringWidth(fullName) < maxWidth) {
            return fullName;
        }
        char[] bl = new char[]{'.'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)node.getFullPackageName(), (char[])bl, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(Character.valueOf(Character.toLowerCase(StringsKt.first((CharSequence)((CharSequence)it)))));
        }
        String abbrevPackage = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        String shortPkg = this.buildString(abbrevPackage, node.getClassName(), node.getMethodName());
        if ((double)fontMetrics.stringWidth(shortPkg) < maxWidth) {
            return shortPkg;
        }
        String clsMethod = this.buildString("", node.getClassName(), node.getMethodName());
        if ((double)fontMetrics.stringWidth(clsMethod) < maxWidth) {
            return clsMethod;
        }
        String method = this.buildString("", "", node.getMethodName());
        String trimmedMethod = StringsKt.take((String)method, (int)3);
        if ((double)fontMetrics.stringWidth(trimmedMethod) < maxWidthWithoutComment) {
            return method;
        }
        return "";
    }

    private final String buildString(String pkg, String cls, String method) {
        String[] stringArray;
        StringBuilder stringBuilder;
        StringBuilder $this$buildString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)pkg).length() > 0) {
            stringArray = new String[]{pkg, "."};
            StringsKt.append((StringBuilder)$this$buildString_u24lambda_u246, (String[])stringArray);
        }
        if (((CharSequence)cls).length() > 0) {
            stringArray = new String[]{cls, "."};
            StringsKt.append((StringBuilder)$this$buildString_u24lambda_u246, (String[])stringArray);
        }
        $this$buildString_u24lambda_u246.append(method);
        return stringBuilder.toString();
    }

    private static final CharSequence getText$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getFirst();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer;", "getINSTANCE", "()Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer;", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaCallStackElementRenderer getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

