/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.profiler.ultimate.hprof.utils.IntList;
import java.io.Closeable;

public class IntRoundQueue
implements Closeable {
    private final IntList queue;
    private int head;
    private int tail;
    private int size;
    private final int maximumSize;

    public IntRoundQueue(int maximumSize) {
        this.queue = this.create(maximumSize);
        this.maximumSize = maximumSize;
    }

    protected IntList create(int maximumSize) {
        return new IntList.InMemory(maximumSize);
    }

    public void offer(int t) {
        if (this.size == this.maximumSize) {
            throw new FullQueueException();
        }
        this.queue.put(this.tail++, t);
        ++this.size;
        if (this.tail == this.maximumSize) {
            this.tail = 0;
        }
    }

    public int poll() {
        if (this.size == 0) {
            throw new EmptyQueueException();
        }
        int value = this.queue.get(this.head++);
        --this.size;
        if (this.head == this.maximumSize) {
            this.head = 0;
        }
        return value;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void close() {
        this.queue.close();
    }

    public static class FullQueueException
    extends RuntimeException {
    }

    public static class EmptyQueueException
    extends RuntimeException {
    }
}

