/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sh.codeStyle.ShCodeStyleSettings;
import com.intellij.sh.psi.ShFile;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;

final class ShLineEndingsAdapter
implements FileDocumentManagerListener {
    private boolean statusBarUpdated;

    ShLineEndingsAdapter() {
    }

    public void beforeAllDocumentsSaving() {
        this.statusBarUpdated = false;
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        VirtualFile virtualFile;
        if (document == null) {
            ShLineEndingsAdapter.$$$reportNull$$$0(0);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(document)) == null) {
            return;
        }
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
        if (project == null) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(psiFile instanceof ShFile)) {
            return;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)psiFile);
        ShCodeStyleSettings shSettings = (ShCodeStyleSettings)settings.getCustomSettings(ShCodeStyleSettings.class);
        String expectedLineSeparator = shSettings.USE_UNIX_LINE_SEPARATOR ? LineSeparator.LF.getSeparatorString() : LineSeparator.getSystemLineSeparator().getSeparatorString();
        String fileDetectedLineSeparator = virtualFile.getDetectedLineSeparator();
        if (fileDetectedLineSeparator == null || !fileDetectedLineSeparator.equals(expectedLineSeparator)) {
            virtualFile.setDetectedLineSeparator(expectedLineSeparator);
            if (!this.statusBarUpdated) {
                this.statusBarUpdated = true;
                ShLineEndingsAdapter.updateStatusBar(project);
            }
        }
    }

    private static void updateStatusBar(@NotNull Project project) {
        if (project == null) {
            ShLineEndingsAdapter.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            StatusBarWidget widget;
            IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
            StatusBar statusBar = frame != null ? frame.getStatusBar() : null;
            StatusBarWidget statusBarWidget = widget = statusBar != null ? statusBar.getWidget("LineSeparator") : null;
            if (widget instanceof LineSeparatorPanel) {
                ((LineSeparatorPanel)widget).selectionChanged(null);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/formatter/ShLineEndingsAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeDocumentSaving";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStatusBar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

