/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineDebugConfigurationExtensionKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.DebuggerConnection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u0005\"\f\b\u0000\u0010\u0006*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebugConfigurationExtension;", "Lcom/intellij/execution/RunConfigurationExtension;", "<init>", "()V", "updateJavaParameters", "", "T", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "configuration", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "isApplicableFor", "", "kotlin.jvm-debugger.coroutines"})
final class CoroutineDebugConfigurationExtension
extends RunConfigurationExtension {
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration2, @NotNull JavaParameters params, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        boolean coroutineDebugIsDisabledInSettings = KotlinDebuggerSettings.Companion.getInstance().getDebugDisableCoroutineAgent();
        boolean coroutineDebugIsDisabledInParameters = CoroutineDebugConfigurationExtensionKt.access$isKotlinxCoroutinesDebugDisabled(params);
        if (!coroutineDebugIsDisabledInSettings && !coroutineDebugIsDisabledInParameters && runnerSettings instanceof DebuggingRunnerData) {
            Project project = configuration2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            new DebuggerConnection(project, configuration2, params, true, false, 16, null);
        }
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration2) {
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        return true;
    }
}

