/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.codeInsight.EnumValuesSoftDeprecateKt;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.searching.usages.KotlinFindUsagesHandlerFactory;
import org.jetbrains.kotlin.idea.base.searching.usages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.AnalysisUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.EnumUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt;
import org.jetbrains.kotlin.idea.highlighting.SafeDeleteFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchParameters;
import org.jetbrains.kotlin.idea.searching.inheritors.KotlinSearchUtilKt;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001f\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ)\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dR\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\f*\u00020 H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010!J\f\u0010\"\u001a\u00020\f*\u00020#H\u0002J\f\u0010$\u001a\u00020\f*\u00020%H\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0002J-\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010,J)\u0010-\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000eH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010/J7\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u00101\u001a\u0004\u0018\u0001022\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u00105JE\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u00101\u001a\u0004\u0018\u0001022\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u00109J3\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010>\u001a\u0004\u0018\u00010\u000eH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010?JE\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020B2\u0006\u0010\r\u001a\u00020\u000e2\b\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010C\u001a\u00020DH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010EJ \u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020H2\u0006\u0010\r\u001a\u00020I2\u0006\u0010A\u001a\u00020BH\u0002J5\u0010J\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u00103\u001a\u0004\u0018\u0001042\b\u0010>\u001a\u0004\u0018\u00010\u000eH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010KJ,\u0010L\u001a\u00020\f2\u0006\u0010M\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020D2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020\f0PH\u0002J+\u0010R\u001a\u00020\f2\b\u0010S\u001a\u0004\u0018\u0001022\u0006\u0010C\u001a\u00020DH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010TJ\u001d\u0010U\u001a\u00020\f*\u00020VH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010WJ!\u0010X\u001a\u00020\f2\u0006\u0010S\u001a\u000202H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010YJ)\u0010R\u001a\u00020\f2\u0006\u0010Z\u001a\u00020Q2\u0006\u0010S\u001a\u000202H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010[J\u000e\u0010\\\u001a\u0004\u0018\u00010]*\u00020^H\u0002J\u0016\u0010_\u001a\u0004\u0018\u00010`*\u00020`2\u0006\u0010S\u001a\u000202H\u0002J\u0016\u0010a\u001a\u0004\u0018\u00010b*\u00020`2\u0006\u0010S\u001a\u000202H\u0002J\f\u0010c\u001a\u00020\f*\u00020dH\u0002J\u001f\u0010e\u001a\u0004\u0018\u00010f*\u00020]H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010gJ\u001d\u0010c\u001a\u00020\f*\u00020]H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010hJ\f\u0010i\u001a\u00020\f*\u00020jH\u0002J\u0014\u0010i\u001a\u00020\f*\u00020k2\u0006\u0010S\u001a\u000202H\u0002J'\u0010l\u001a\u00020\f*\u00020I2\b\u00103\u001a\u0004\u0018\u000104H\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010mJ\u001d\u0010n\u001a\u00020\f*\u00020oH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010pJ\u0010\u0010q\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010r\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010s\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010t\u001a\u00020\f2\u0006\u0010u\u001a\u00020vH\u0002J\u0019\u0010w\u001a\b\u0012\u0004\u0012\u00020y0x2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010zJ7\u0010{\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u00106\u001a\b\u0012\u0004\u0012\u000208072\u0006\u0010|\u001a\u00020\u001dH\u0002R\u00020\u0016j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010}R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010:\u001a\u00020\f*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006~"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil;", "", "<init>", "()V", "KOTLIN_ADDITIONAL_ANNOTATIONS", "", "", "DEPRECATION_LEVEL_HIDDEN", "Lorg/jetbrains/kotlin/name/FqName;", "DEPRECATION_LEVEL_PARAMETER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "isApplicableByPsi", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isExpectedOrActual", "owner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "isEffectivelyAbstractFunction", "ownerFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isHiddenFromResolution", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "KaSession", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "isLocalDeclaration", "getPsiToReportProblem", "Lcom/intellij/psi/PsiElement;", "isJavaEntryPointInspection", "Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;)Lcom/intellij/psi/PsiElement;", "hasKotlinAdditionalAnnotation", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "isSerializationImplicitlyUsedField", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isSerializationImplicitlyUsedMethod", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isAnnotationParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "checkAnnotatedUsingPatterns", "annotationPatterns", "", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Ljava/util/Collection;)Z", "checkDeclaration", "importedDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "hasNonTrivialUsages", "declarationContainingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "isCheapEnough", "Lkotlin/Lazy;", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Lazy;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "isObjectOrEnum", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "checkReference", "refElement", "originalDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "hasReferences", "project", "Lcom/intellij/openapi/project/Project;", "useScope", "Lcom/intellij/psi/search/SearchScope;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/psi/KtClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lcom/intellij/psi/search/SearchScope;)Z", "isTooManyOccurrencesToCheck", "method", "Lcom/intellij/psi/PsiMethod;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "checkPrivateDeclaration", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Z", "referenceExists", "psiElement", "scope", "predicate", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiReference;", "hasBuiltInEnumFunctionReference", "enumClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtClass;Lcom/intellij/psi/search/SearchScope;)Z", "isReferenceToBuiltInEnumEntries", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)Z", "hasEnumFunctionReferenceInEnumClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtClass;)Z", "reference", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lcom/intellij/psi/PsiReference;Lorg/jetbrains/kotlin/psi/KtClass;)Z", "normalizeImportDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/psi/KtElement;", "normalizeEnumQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "normalizeEnumCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "isUsedStarImportOfEnumStaticFunctions", "Lcom/intellij/psi/PsiImportStaticStatement;", "resolveReferenceToSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtImportDirective;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtImportDirective;)Z", "isReferenceToBuiltInEnumFunction", "Lcom/intellij/psi/PsiImportStaticReferenceElement;", "Lcom/intellij/psi/PsiReferenceExpression;", "canBeHandledByLightMethods", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Z", "hasInlineClassParameters", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;)Z", "hasOverrides", "hasFakeOverrides", "hasPlatformImplementations", "classOrObjectHasTextUsages", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "createQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)[Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "isEntryPoint", "isJavaEntryPoint", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lkotlin/Lazy;Lcom/intellij/codeInspection/deadCode/UnusedDeclarationInspectionBase;)Z", "kotlin.highlighting.k2"})
@SourceDebugExtension(value={"SMAP\nK2UnusedSymbolUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2UnusedSymbolUtil.kt\norg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 7 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,793:1\n1#2:794\n1#2:812\n1#2:835\n217#3:795\n217#3:796\n196#3:818\n384#3:844\n395#3,10:845\n417#3:855\n384#3:856\n395#3,10:857\n417#3:867\n384#3:868\n395#3,10:869\n417#3:879\n384#3:880\n395#3,10:881\n417#3:891\n225#3:892\n384#3:897\n395#3,10:898\n417#3:908\n213#3:982\n213#3:983\n213#3:1002\n213#3:1003\n12637#4,2:797\n12434#4,2:973\n12637#4,2:975\n1761#5,3:799\n1617#5,9:802\n1869#5:811\n1870#5:813\n1626#5:814\n1761#5,3:815\n2746#5,3:819\n1761#5,3:822\n1617#5,9:825\n1869#5:834\n1870#5:836\n1626#5:837\n774#5:838\n865#5,2:839\n1761#5,3:841\n1563#5:893\n1634#5,3:894\n1563#5:909\n1634#5,3:910\n1563#5:913\n1634#5,3:914\n1761#5,3:917\n1761#5,3:965\n1761#5,2:971\n1763#5:977\n1761#5,3:979\n1563#5:984\n1634#5,3:985\n2746#5,3:988\n1563#5:1025\n1634#5,3:1026\n30#6,2:920\n30#6,2:938\n30#6,2:991\n30#6,2:1008\n35#7,15:922\n35#7,14:940\n49#7:968\n45#7,2:969\n35#7,9:993\n48#7,2:1004\n45#7,2:1006\n35#7,15:1010\n1255#8:937\n385#8,11:954\n1256#8:978\n*S KotlinDebug\n*F\n+ 1 K2UnusedSymbolUtil.kt\norg/jetbrains/kotlin/idea/highlighting/K2UnusedSymbolUtil\n*L\n219#1:812\n477#1:835\n197#1:795\n199#1:796\n336#1:818\n510#1:844\n510#1:845,10\n510#1:855\n515#1:856\n515#1:857,10\n515#1:867\n521#1:868\n521#1:869,10\n521#1:879\n573#1:880\n573#1:881,10\n573#1:891\n579#1:892\n598#1:897\n598#1:898,10\n598#1:908\n303#1:982\n304#1:983\n390#1:1002\n391#1:1003\n203#1:797,2\n684#1:973,2\n685#1:975,2\n207#1:799,3\n219#1:802,9\n219#1:811\n219#1:813\n219#1:814\n229#1:815,3\n346#1:819,3\n401#1:822,3\n477#1:825,9\n477#1:834\n477#1:836\n477#1:837\n478#1:838\n478#1:839,2\n479#1:841,3\n589#1:893\n589#1:894,3\n610#1:909\n610#1:910,3\n616#1:913\n616#1:914,3\n635#1:917,3\n678#1:965,3\n682#1:971,2\n682#1:977\n748#1:979,3\n307#1:984\n307#1:985,3\n309#1:988,3\n570#1:1025\n570#1:1026,3\n655#1:920,2\n666#1:938,2\n389#1:991,2\n493#1:1008,2\n655#1:922,15\n666#1:940,14\n666#1:968\n666#1:969,2\n389#1:993,9\n389#1:1004,2\n389#1:1006,2\n493#1:1010,15\n663#1:937\n673#1:954,11\n663#1:978\n*E\n"})
public final class K2UnusedSymbolUtil {
    @NotNull
    public static final K2UnusedSymbolUtil INSTANCE = new K2UnusedSymbolUtil();
    @NotNull
    private static final List<String> KOTLIN_ADDITIONAL_ANNOTATIONS;
    @NotNull
    private static final FqName DEPRECATION_LEVEL_HIDDEN;
    @NotNull
    private static final Name DEPRECATION_LEVEL_PARAMETER_NAME;

    private K2UnusedSymbolUtil() {
    }

    public final boolean isApplicableByPsi(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)declaration).isCompanion()) {
            return false;
        }
        if (declaration instanceof KtParameter) {
            if (UtilsKt.isExplicitlyIgnoredByName(declaration)) {
                return false;
            }
            if (((KtParameter)declaration).isFunctionTypeParameter()) {
                return false;
            }
            KtDeclaration ownerFunction = ((KtParameter)declaration).getOwnerDeclaration();
            if (ownerFunction instanceof KtConstructor) {
                KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration));
                if (containingClass != null) {
                    if (containingClass.isData()) {
                        return false;
                    }
                    if (containingClass.isValue() && ((KtParameter)declaration).hasValOrVar()) {
                        return false;
                    }
                    if (containingClass.isInline() && ((KtParameter)declaration).hasValOrVar()) {
                        return false;
                    }
                    if (this.isExpectedOrActual((KtModifierListOwner)containingClass)) {
                        return false;
                    }
                }
            } else if (ownerFunction instanceof KtFunction) {
                if (((KtFunction)ownerFunction).hasModifier(KtTokens.OPERATOR_KEYWORD)) {
                    return false;
                }
                if (this.isEffectivelyAbstractFunction((KtFunction)ownerFunction) || this.isExpectedOrActual((KtModifierListOwner)ownerFunction)) {
                    return false;
                }
            }
        }
        KtNamedDeclaration owner = null;
        if (declaration instanceof KtTypeParameter) {
            PsiElement psiElement;
            PsiElement parent2 = ((KtTypeParameter)declaration).getParent();
            if (parent2 != null && !(parent2 instanceof KtTypeParameterListOwner)) {
                parent2 = parent2.getParent();
            }
            KtTypeParameterListOwner ktTypeParameterListOwner = (psiElement = parent2) instanceof KtTypeParameterListOwner ? (KtTypeParameterListOwner)psiElement : null;
            owner = ktTypeParameterListOwner != null ? (KtNamedDeclaration)ktTypeParameterListOwner : declaration;
        } else {
            owner = declaration;
        }
        return !owner.hasModifier(KtTokens.OVERRIDE_KEYWORD);
    }

    private final boolean isExpectedOrActual(KtModifierListOwner owner) {
        KtModifierList modifierList = owner.getModifierList();
        return modifierList != null && (modifierList.hasModifier(KtTokens.EXPECT_KEYWORD) || modifierList.hasModifier(KtTokens.ACTUAL_KEYWORD));
    }

    private final boolean isEffectivelyAbstractFunction(KtFunction ownerFunction) {
        KtModifierList modifierList = ownerFunction.getModifierList();
        if (modifierList != null && (modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD) || modifierList.hasModifier(KtTokens.EXPECT_KEYWORD) || modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) || modifierList.hasModifier(KtTokens.OPEN_KEYWORD))) {
            return true;
        }
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ownerFunction));
        return ktClass != null ? ktClass.isInterface() : false;
    }

    public final boolean isHiddenFromResolution(@NotNull KaSession $context_receiver_0, @NotNull KtNamedDeclaration declaration) {
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            KtAnnotationEntry ktAnnotationEntry = AnnotationModificationUtilsKt.findAnnotation((KtAnnotated)declaration, ClassId.Companion.topLevel(StandardNames.FqNames.deprecated), null, false);
            if (ktAnnotationEntry == null) {
                return false;
            }
            KtAnnotationEntry anno = ktAnnotationEntry;
            KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)anno);
            if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
                return false;
            }
            KaLifetimeOwner call2 = kaLifetimeOwner;
            Iterable iterable = call2.getArgumentMapping().entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((KaValueParameterSymbol)((KaVariableSignature)it.getValue()).getSymbol()).getName(), (Object)DEPRECATION_LEVEL_PARAMETER_NAME)) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        Map.Entry entry = v2;
        if (entry == null) {
            return false;
        }
        Map.Entry levelArgument = entry;
        KaLifetimeOwner kaLifetimeOwner = $context_receiver_0.resolveToCall((KtElement)levelArgument.getKey());
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulVariableAccessCall(kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner levelArgumentCall = kaLifetimeOwner;
        return Intrinsics.areEqual((Object)$context_receiver_0.getImportableFqName((KaSymbol)KaCallKt.getSymbol((KaCallableMemberCall)levelArgumentCall)), (Object)DEPRECATION_LEVEL_HIDDEN);
    }

    public final boolean isLocalDeclaration(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtProperty && ((KtProperty)declaration).isLocal()) {
            return true;
        }
        return declaration instanceof KtParameter && (!(((KtParameter)declaration).getParent().getParent() instanceof KtPrimaryConstructor) || !((KtParameter)declaration).hasValOrVar());
    }

    @Nullable
    public final PsiElement getPsiToReportProblem(@NotNull KaSession $context_receiver_0, @NotNull KtNamedDeclaration declaration, @NotNull UnusedDeclarationInspectionBase isJavaEntryPointInspection) {
        Lazy isCheapEnough;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)isJavaEntryPointInspection, (String)"isJavaEntryPointInspection");
        KtParameter ktParameter = declaration instanceof KtParameter ? (KtParameter)declaration : null;
        PsiElement psiElement = ktParameter != null && (ktParameter = ktParameter.getParent()) != null ? ktParameter.getParent() : null;
        KtModifierListOwner ktModifierListOwner = psiElement instanceof KtModifierListOwner ? (KtModifierListOwner)psiElement : null;
        boolean bl = ktModifierListOwner != null ? ktModifierListOwner.hasModifier(KtTokens.EXTERNAL_KEYWORD) : false;
        if (bl) {
            return null;
        }
        KaDeclarationSymbol symbol = $context_receiver_0.getSymbol((KtDeclaration)declaration);
        if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration).getFlag(AnalysisFlags.getExplicitApiMode()) != ExplicitApiMode.DISABLED && symbol.getCompilerVisibility().isPublicAPI()) {
            return null;
        }
        if (symbol instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)symbol).isOperator()) {
            boolean bl2;
            String string = declaration.getName();
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                bl2 = DataClassResolver.INSTANCE.isComponentLike(it);
            } else {
                bl2 = false;
            }
            if (!bl2) {
                return null;
            }
        }
        if (this.isEntryPoint($context_receiver_0, declaration, (Lazy<? extends PsiSearchHelper.SearchCostResult>)(isCheapEnough = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> K2UnusedSymbolUtil.getPsiToReportProblem$lambda$2(declaration))), isJavaEntryPointInspection)) {
            return null;
        }
        if (AnalysisUtilsKt.isFinalizeMethod($context_receiver_0, (KtDeclaration)declaration)) {
            return null;
        }
        if (declaration instanceof KtProperty && this.isSerializationImplicitlyUsedField((KtProperty)declaration)) {
            return null;
        }
        if (declaration instanceof KtNamedFunction && this.isSerializationImplicitlyUsedMethod((KtNamedFunction)declaration)) {
            return null;
        }
        KtClass declarationContainingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration));
        if (KotlinPsiUtils.isConstructorDeclaredProperty(declaration)) {
            KtClass ktClass = declarationContainingClass;
            boolean bl4 = ktClass != null ? KotlinPsiUtils.mustHaveNonEmptyPrimaryConstructor(ktClass) : false;
            if (bl4) {
                return null;
            }
        }
        if (symbol instanceof KaClassSymbol && ((KaClassSymbol)symbol).getClassKind() == KaClassKind.ANNOTATION_CLASS) {
            String string = KaClassLikeSymbolKt.getNameOrAnonymous((KaClassifierSymbol)symbol).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String fqName2 = string;
            LanguageVersionSettings languageVersionSettings = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration);
            if (((List)languageVersionSettings.getFlag(AnalysisFlags.getOptIn())).contains(fqName2)) {
                return null;
            }
        }
        if (this.hasNonTrivialUsages($context_receiver_0, declaration, declarationContainingClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)isCheapEnough, symbol)) {
            return null;
        }
        if (declaration instanceof KtClassOrObject && this.classOrObjectHasTextUsages((KtClassOrObject)declaration)) {
            return null;
        }
        Object object = declaration.getNameIdentifier();
        if (object == null) {
            KtConstructor ktConstructor = declaration instanceof KtConstructor ? (KtConstructor)declaration : null;
            object = ktConstructor != null ? ktConstructor.getConstructorKeyword() : null;
        }
        return object;
    }

    private final boolean hasKotlinAdditionalAnnotation(KaSession $context_receiver_0, KtDeclaration $this$hasKotlinAdditionalAnnotation) {
        return $this$hasKotlinAdditionalAnnotation instanceof KtNamedDeclaration && this.checkAnnotatedUsingPatterns($context_receiver_0, (KtNamedDeclaration)$this$hasKotlinAdditionalAnnotation, (Collection<String>)KOTLIN_ADDITIONAL_ANNOTATIONS);
    }

    private final boolean isSerializationImplicitlyUsedField(KtProperty $this$isSerializationImplicitlyUsedField) {
        boolean bl;
        block5: {
            Object object;
            PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isSerializationImplicitlyUsedField;
            boolean $i$f$getNonStrictParentOfType = false;
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
            KtObjectDeclaration ktObjectDeclaration = psiElement instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiElement : null;
            if (ktObjectDeclaration == null) {
                return false;
            }
            KtObjectDeclaration ownerObject = ktObjectDeclaration;
            if (ownerObject.isCompanion()) {
                PsiElement $this$getNonStrictParentOfType$iv2 = (PsiElement)ownerObject;
                boolean $i$f$getNonStrictParentOfType2 = false;
                KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv2, KtClass.class, (boolean)false);
                object = ktClass != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass)) : null;
            } else {
                object = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ownerObject));
            }
            if (object == null) {
                return false;
            }
            KtLightClass lightClass = object;
            PsiField[] psiFieldArray = lightClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            Object[] $this$any$iv = psiFieldArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiField it = (PsiField)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$isSerializationImplicitlyUsedField.getName()) && SerializationUtils.isSerializationImplicitlyUsedField((PsiField)it))) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSerializationImplicitlyUsedMethod(KtNamedFunction $this$isSerializationImplicitlyUsedMethod) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)$this$isSerializationImplicitlyUsedMethod));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiMethod it = (PsiMethod)element$iv;
                    boolean bl2 = false;
                    if (!JavaHighlightUtil.isSerializationRelatedMethod((PsiMethod)it, (PsiClass)it.getContainingClass())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isAnnotationParameter(KtParameter parameter) {
        KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
        KtConstructor ktConstructor = ktDeclarationWithBody instanceof KtConstructor ? (KtConstructor)ktDeclarationWithBody : null;
        if (ktConstructor == null) {
            return false;
        }
        KtConstructor constructor = ktConstructor;
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)constructor));
        return ktClassOrObject != null ? ktClassOrObject.isAnnotation() : false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkAnnotatedUsingPatterns(@NotNull KaSession $context_receiver_0, @NotNull KtNamedDeclaration declaration, @NotNull Collection<String> annotationPatterns) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(annotationPatterns, (String)"annotationPatterns");
        if (declaration.getAnnotationEntries().isEmpty()) {
            return false;
        }
        List list2 = declaration.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            KaConstructorSymbol constructorSymbol;
            ClassId classId;
            KaSymbol symbol;
            KtAnnotationEntry reference;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv$iv;
            boolean bl2 = false;
            KtAnnotationEntry ktAnnotationEntry = it;
            if ((ktAnnotationEntry == null || (ktAnnotationEntry = ktAnnotationEntry.getCalleeExpression()) == null || (ktAnnotationEntry = ktAnnotationEntry.getConstructorReferenceExpression()) == null || (ktAnnotationEntry = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktAnnotationEntry)) == null ? null : ($context_receiver_0.resolveToSymbol((KtReference)(reference = ktAnnotationEntry)) == null ? null : ((symbol instanceof KaConstructorSymbol ? (KaConstructorSymbol)symbol : null) == null ? null : ((classId = (constructorSymbol = constructorSymbol).getContainingClassId()) != null && (classId = classId.asSingleFqName()) != null ? classId.asString() : null)))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotationsPresent = (List)destination$iv$iv;
        if (annotationsPresent.isEmpty()) {
            return false;
        }
        for (String pattern2 : annotationPatterns) {
            boolean hasAnnotation;
            boolean bl;
            block9: {
                if (StringsKt.endsWith$default((String)pattern2, (String)".*", (boolean)false, (int)2, null)) {
                    Iterable $this$any$iv = annotationsPresent;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)StringsKt.dropLast((String)pattern2, (int)1), (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                } else {
                    bl = annotationsPresent.contains(pattern2);
                }
            }
            if (!(hasAnnotation = bl)) continue;
            return true;
        }
        return false;
    }

    private final boolean checkDeclaration(KaSession $context_receiver_0, KtNamedDeclaration declaration, KtNamedDeclaration importedDeclaration) {
        return !SequencesKt.contains((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)importedDeclaration)), (Object)declaration) && !K2UnusedSymbolUtil.hasNonTrivialUsages$default(this, $context_receiver_0, importedDeclaration, KtPsiUtilKt.containingClass((KtElement)((KtElement)importedDeclaration)), null, 8, null);
    }

    private final boolean hasNonTrivialUsages(KaSession $context_receiver_0, KtNamedDeclaration declaration, KtClass declarationContainingClass, KaDeclarationSymbol symbol) {
        Lazy isCheapEnough = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> K2UnusedSymbolUtil.hasNonTrivialUsages$lambda$7(declaration));
        return this.hasNonTrivialUsages($context_receiver_0, declaration, declarationContainingClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)isCheapEnough, symbol);
    }

    static /* synthetic */ boolean hasNonTrivialUsages$default(K2UnusedSymbolUtil k2UnusedSymbolUtil, KaSession kaSession, KtNamedDeclaration ktNamedDeclaration, KtClass ktClass, KaDeclarationSymbol kaDeclarationSymbol, int n, Object object) {
        if ((n & 8) != 0) {
            kaDeclarationSymbol = null;
        }
        return k2UnusedSymbolUtil.hasNonTrivialUsages(kaSession, ktNamedDeclaration, ktClass, kaDeclarationSymbol);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNonTrivialUsages(KaSession $context_receiver_0, KtNamedDeclaration declaration, KtClass declarationContainingClass, Lazy<? extends PsiSearchHelper.SearchCostResult> isCheapEnough, KaDeclarationSymbol symbol) {
        SearchScope restrictedScope;
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
        PsiSearchHelper psiSearchHelper2 = psiSearchHelper;
        SearchScope searchScope = psiSearchHelper2.getUseScope((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        SearchScope useScope = searchScope;
        if (useScope instanceof GlobalSearchScope) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[((PsiSearchHelper.SearchCostResult)isCheapEnough.getValue()).ordinal()]) {
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    return true;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean zeroOccurrences = bl;
            if (zeroOccurrences && !PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
                if (!(declaration instanceof KtObjectDeclaration)) return false;
                if (!((KtObjectDeclaration)declaration).isCompanion()) {
                    return false;
                }
            }
            v4 = (SearchScope)(PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration)) ? KotlinSourceFilterScope.Companion.projectSourcesAndResources(KotlinScopeUtils.projectScope(project2), project2) : KotlinSourceFilterScope.Companion.projectSourcesAndResources((GlobalSearchScope)useScope, project2));
        } else {
            v4 = restrictedScope = useScope;
        }
        if (declaration instanceof KtTypeParameter && declarationContainingClass != null) {
            boolean isOpenClass;
            boolean bl = isOpenClass = declarationContainingClass.isInterface() || declarationContainingClass.hasModifier(KtTokens.ABSTRACT_KEYWORD) || declarationContainingClass.hasModifier(KtTokens.SEALED_KEYWORD) || declarationContainingClass.hasModifier(KtTokens.OPEN_KEYWORD);
            if (isOpenClass && this.hasOverrides((KtNamedDeclaration)declarationContainingClass)) {
                return true;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            GlobalSearchScope containingClassSearchScope = globalSearchScope;
            boolean isRequiredToCallFunction = this.referenceExists((PsiElement)declarationContainingClass, (SearchScope)containingClassSearchScope, (Function1<? super PsiReference, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.hasNonTrivialUsages$lambda$12(containingClassSearchScope, arg_0)));
            if (isRequiredToCallFunction) {
                return true;
            }
        }
        if (declaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)declaration).isCompanion()) {
            boolean bl;
            Object object = ((KtObjectDeclaration)declaration).getBody();
            if (object != null && (object = object.getDeclarations()) != null) {
                if (!((Collection)object).isEmpty()) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if (this.hasOverrides(declaration)) return true;
        if (this.hasReferences($context_receiver_0, project2, declaration, declarationContainingClass, symbol, restrictedScope)) return true;
        if (this.hasFakeOverrides(declaration, restrictedScope)) return true;
        if (!this.hasPlatformImplementations(declaration)) return false;
        return true;
    }

    static /* synthetic */ boolean hasNonTrivialUsages$default(K2UnusedSymbolUtil k2UnusedSymbolUtil, KaSession kaSession, KtNamedDeclaration ktNamedDeclaration, KtClass ktClass, Lazy lazy, KaDeclarationSymbol kaDeclarationSymbol, int n, Object object) {
        if ((n & 0x10) != 0) {
            kaDeclarationSymbol = null;
        }
        return k2UnusedSymbolUtil.hasNonTrivialUsages(kaSession, ktNamedDeclaration, ktClass, (Lazy<? extends PsiSearchHelper.SearchCostResult>)lazy, kaDeclarationSymbol);
    }

    private final boolean isObjectOrEnum(KtNamedDeclaration $this$isObjectOrEnum) {
        return $this$isObjectOrEnum instanceof KtObjectDeclaration || $this$isObjectOrEnum instanceof KtClass && ((KtClass)$this$isObjectOrEnum).isEnum();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkReference(KaSession $context_receiver_0, PsiElement refElement, KtNamedDeclaration declaration, KtNamedDeclaration originalDeclaration) {
        KtExpression ktExpression;
        FqName declarationFqName;
        void $this$getParentOfType$iv;
        if (PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)declaration), (PsiElement)refElement, (boolean)false, (int)2, null)) {
            return true;
        }
        if (refElement.getParent() instanceof KtValueArgumentName) {
            return true;
        }
        PsiElement psiElement = refElement;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType2 = false;
        KtImportDirective ktImportDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, (boolean)strict$iv);
        if (ktImportDirective == null) {
            return false;
        }
        KtImportDirective ktImportDirective2 = ktImportDirective;
        String aliasName = ktImportDirective2.getAliasName();
        if (aliasName != null && !Intrinsics.areEqual((Object)aliasName, (Object)declaration.getName())) {
            return false;
        }
        if (!(declaration instanceof KtClassOrObject) && !(originalDeclaration instanceof KtClassOrObject)) {
            return true;
        }
        if (ktImportDirective2.isAllUnder()) {
            boolean bl;
            block16: {
                KtExpression ktExpression2 = ktImportDirective2.getImportedReference();
                PsiElement $i$f$getParentOfType2 = ktExpression2 != null && (ktExpression2 = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression2))) != null && (ktExpression2 = ReferenceUtilsKt.getMainReference((KtElement)ktExpression2)) != null ? ktExpression2.resolve() : null;
                KtClassOrObject ktClassOrObject = $i$f$getParentOfType2 instanceof KtClassOrObject ? (KtClassOrObject)$i$f$getParentOfType2 : null;
                if (ktClassOrObject == null) {
                    return true;
                }
                KtClassOrObject importedFrom = ktClassOrObject;
                Iterable $this$none$iv = importedFrom.getDeclarations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtNamedDeclaration && K2UnusedSymbolUtil.hasNonTrivialUsages$default(INSTANCE, $context_receiver_0, (KtNamedDeclaration)it, KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), null, 8, null))) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        FqName importedFqName = ktImportDirective2.getImportedFqName();
        if (Intrinsics.areEqual((Object)importedFqName, (Object)(declarationFqName = declaration.getFqName()))) {
            return true;
        }
        if (declarationFqName != null) {
            FqName fqName2 = importedFqName;
            boolean bl = fqName2 != null ? fqName2.startsWith(declarationFqName) : false;
            if (bl) {
                return false;
            }
        }
        PsiElement psiElement2 = (ktExpression = ktImportDirective2.getImportedReference()) != null && (ktExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression))) != null && (ktExpression = ReferenceUtilsKt.getMainReference((KtElement)ktExpression)) != null ? ktExpression.resolve() : null;
        KtNamedDeclaration ktNamedDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
        if (ktNamedDeclaration == null) {
            return true;
        }
        KtNamedDeclaration importedDeclaration = ktNamedDeclaration;
        if (this.isObjectOrEnum(declaration) || KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)importedDeclaration)) instanceof KtObjectDeclaration) {
            return this.checkDeclaration($context_receiver_0, declaration, importedDeclaration);
        }
        KtNamedDeclaration ktNamedDeclaration2 = originalDeclaration;
        boolean bl = ktNamedDeclaration2 != null ? this.isObjectOrEnum(ktNamedDeclaration2) : false;
        if (bl) {
            return this.checkDeclaration($context_receiver_0, originalDeclaration, importedDeclaration);
        }
        return true;
    }

    private final boolean hasReferences(KaSession $context_receiver_0, Project project, KtNamedDeclaration declaration, KtClass declarationContainingClass, KaDeclarationSymbol symbol, SearchScope useScope) {
        KtNamedDeclaration originalDeclaration;
        KaLifetimeOwner kaLifetimeOwner = symbol instanceof KaTypeAliasSymbol ? (KaTypeAliasSymbol)symbol : null;
        PsiElement psiElement = kaLifetimeOwner != null && (kaLifetimeOwner = ((KaTypeAliasSymbol)kaLifetimeOwner).getExpandedType()) != null && (kaLifetimeOwner = $context_receiver_0.getExpandedSymbol((KaType)kaLifetimeOwner)) != null ? kaLifetimeOwner.getPsi() : null;
        KtNamedDeclaration ktNamedDeclaration = originalDeclaration = psiElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement : null;
        if (!(symbol instanceof KaNamedFunctionSymbol) || !((KaNamedFunctionSymbol)symbol).getAnnotations().contains(JvmStandardClassIds.Annotations.INSTANCE.getJvmName())) {
            List lightMethods;
            KaSymbolPointer<KaDeclarationSymbol> symbolPointer2;
            KaDeclarationSymbol kaDeclarationSymbol = symbol;
            KaSymbolPointer<KaDeclarationSymbol> kaSymbolPointer = symbolPointer2 = kaDeclarationSymbol != null ? kaDeclarationSymbol.createPointer() : null;
            if (declaration instanceof KtSecondaryConstructor && declarationContainingClass != null && (UtilsKt.isCheapEnoughToSearchUsages((KtNamedDeclaration)declarationContainingClass) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES || this.referenceExists((PsiElement)declarationContainingClass, useScope, (Function1<? super PsiReference, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$15(symbolPointer2, arg_0))))) {
                return true;
            }
            if (declaration instanceof KtCallableDeclaration && this.canBeHandledByLightMethods($context_receiver_0, (KtCallableDeclaration)declaration, symbol) && !((Collection)(lightMethods = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)declaration)))).isEmpty()) {
                boolean lightMethodsUsed;
                block14: {
                    Iterable $this$any$iv = lightMethods;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiMethod method = (PsiMethod)element$iv;
                            boolean bl = false;
                            boolean bl2 = INSTANCE.isTooManyOccurrencesToCheck(method, (KtCallableDeclaration)declaration, project) || !MethodReferencesSearch.search((PsiMethod)method).forEach(arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$17$lambda$16($context_receiver_0, declaration, originalDeclaration, arg_0));
                            if (!bl2) continue;
                            v4 = true;
                            break block14;
                        }
                        v4 = lightMethodsUsed = false;
                    }
                }
                if (lightMethodsUsed) {
                    return true;
                }
                if (!PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration))) {
                    return false;
                }
            }
            if (declaration instanceof KtEnumEntry) {
                KtClass enumClass;
                KtClass ktClass = declarationContainingClass;
                if (ktClass != null) {
                    KtClass lightMethodsUsed;
                    KtClass it = lightMethodsUsed = ktClass;
                    boolean bl = false;
                    v7 = it.isEnum() ? lightMethodsUsed : null;
                } else {
                    v7 = enumClass = null;
                }
                if (this.hasBuiltInEnumFunctionReference($context_receiver_0, enumClass, useScope)) {
                    return true;
                }
            }
        }
        FindManager findManager = FindManager.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)findManager, (String)"null cannot be cast to non-null type com.intellij.find.impl.FindManagerImpl");
        FindUsagesHandler handler2 = ((FindManagerImpl)findManager).getFindUsagesManager().getFindUsagesHandler((PsiElement)declaration, true);
        if (handler2 != null) {
            FindUsagesOptions findUsagesOptions = handler2.getFindUsagesOptions();
            Intrinsics.checkNotNullExpressionValue((Object)findUsagesOptions, (String)"getFindUsagesOptions(...)");
            FindUsagesOptions options2 = findUsagesOptions;
            options2.isSearchForTextOccurrences = false;
            boolean result2 = handler2.processElementUsages((PsiElement)declaration, arg_0 -> K2UnusedSymbolUtil.hasReferences$lambda$19($context_receiver_0, declaration, originalDeclaration, arg_0), options2);
            if (!result2) {
                return true;
            }
        }
        return this.checkPrivateDeclaration($context_receiver_0, declaration, symbol, originalDeclaration);
    }

    private final boolean isTooManyOccurrencesToCheck(PsiMethod method, KtCallableDeclaration declaration, Project project) {
        SearchScope searchScope = method.getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        SearchScope searchScope2 = searchScope;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        return !StringsKt.equals$default((String)declaration.getName(), (String)name2, (boolean)false, (int)2, null) && searchScope2 instanceof GlobalSearchScope && PsiSearchHelper.getInstance((Project)project).isCheapEnoughToSearch(name2, (GlobalSearchScope)searchScope2, null) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkPrivateDeclaration(KaSession $context_receiver_0, KtNamedDeclaration declaration, KaDeclarationSymbol symbol, KtNamedDeclaration originalDeclaration) {
        boolean bl;
        block7: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            if (symbol == null || !KtPsiUtilKt.isPrivateNestedClassOrObject((KtNamedDeclaration)declaration)) {
                return false;
            }
            HashSet setOfImportedDeclarations = new HashSet();
            KtImportList ktImportList = declaration.getContainingKtFile().getImportList();
            if (ktImportList != null) {
                ktImportList.acceptChildren((PsiElementVisitor)VisitorWrappersKt.simpleNameExpressionRecursiveVisitor(arg_0 -> K2UnusedSymbolUtil.checkPrivateDeclaration$lambda$20(setOfImportedDeclarations, arg_0)));
            }
            Iterable $this$mapNotNull$iv = setOfImportedDeclarations;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtReferenceExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                KtSimpleNameExpression it = (KtSimpleNameExpression)element$iv$iv;
                boolean bl3 = false;
                if (KtPsiUtilKt.referenceExpression((KtExpression)((KtExpression)it)) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtReferenceExpression it = (KtReferenceExpression)element$iv$iv;
                boolean bl5 = false;
                if (!$context_receiver_0.resolveToSymbols(ReferenceUtilsKt.getMainReference((KtReferenceExpression)it)).contains(symbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtReferenceExpression it = (KtReferenceExpression)element$iv;
                    boolean bl6 = false;
                    if (!(!INSTANCE.checkReference($context_receiver_0, (PsiElement)ReferenceUtilsKt.getMainReference((KtReferenceExpression)it).getElement(), declaration, originalDeclaration))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean referenceExists(PsiElement psiElement, SearchScope scope, Function1<? super PsiReference, Boolean> predicate2) {
        return !ReferencesSearch.search((ReferencesSearch.SearchParameters)new KotlinReferencesSearchParameters(psiElement, scope, false, null, null, 28, null)).forEach(arg_0 -> K2UnusedSymbolUtil.referenceExists$lambda$24(predicate2, arg_0));
    }

    private final boolean hasBuiltInEnumFunctionReference(KaSession $context_receiver_0, KtClass enumClass, SearchScope useScope) {
        if (enumClass == null) {
            return false;
        }
        boolean isFoundEnumFunctionReferenceViaSearch = this.referenceExists((PsiElement)enumClass, useScope, (Function1<? super PsiReference, Boolean>)((Function1)arg_0 -> K2UnusedSymbolUtil.hasBuiltInEnumFunctionReference$lambda$26(enumClass, arg_0)));
        return isFoundEnumFunctionReferenceViaSearch || this.hasEnumFunctionReferenceInEnumClass($context_receiver_0, enumClass);
    }

    private final boolean isReferenceToBuiltInEnumEntries(KaSession $context_receiver_0, KtSimpleNameExpression $this$isReferenceToBuiltInEnumEntries) {
        return EnumValuesSoftDeprecateKt.isEnumValuesSoftDeprecateEnabled((PsiElement)$this$isReferenceToBuiltInEnumEntries) && Intrinsics.areEqual((Object)$this$isReferenceToBuiltInEnumEntries.getReferencedNameAsName(), (Object)StandardNames.ENUM_ENTRIES) && KotlinPsiUtilsKt.isSynthesizedFunction($context_receiver_0, (KtExpression)$this$isReferenceToBuiltInEnumEntries);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasEnumFunctionReferenceInEnumClass(KaSession $context_receiver_0, KtClass enumClass) {
        boolean isFoundSimpleNameExpression;
        PsiElement $this$findDescendantOfType$iv$iv$iv;
        PsiElement $this$findDescendantOfType$iv$iv;
        PsiElement $this$anyDescendantOfType$iv;
        boolean isFoundCallableReference;
        void $this$findDescendantOfType$iv$iv$iv2;
        void $this$findDescendantOfType$iv$iv2;
        void $this$anyDescendantOfType$iv2;
        PsiElement psiElement = (PsiElement)enumClass;
        Function1 predicate$iv = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$27(enumClass, $context_receiver_0, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void var7_8 = $this$anyDescendantOfType$iv2;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        void var10_13 = $this$findDescendantOfType$iv$iv2;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv2);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallableReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        boolean bl = isFoundCallableReference = (PsiElement)result$iv$iv$iv.element != null;
        if (isFoundCallableReference) {
            return true;
        }
        predicate$iv = (PsiElement)enumClass;
        Function1 predicate$iv2 = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$28(enumClass, $context_receiver_0, arg_0);
        boolean $i$f$anyDescendantOfType2 = false;
        predicate$iv$iv = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv2 = predicate$iv2;
        boolean $i$f$findDescendantOfType3 = false;
        predicate$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv2 = predicate$iv$iv2;
        boolean $i$f$findDescendantOfType4 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv2 = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv2, result$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtSimpleNameExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        boolean bl2 = isFoundSimpleNameExpression = (PsiElement)result$iv$iv$iv2.element != null;
        if (isFoundSimpleNameExpression) {
            return true;
        }
        $this$anyDescendantOfType$iv = (PsiElement)enumClass;
        predicate$iv2 = arg_0 -> K2UnusedSymbolUtil.hasEnumFunctionReferenceInEnumClass$lambda$29(enumClass, $context_receiver_0, arg_0);
        $i$f$anyDescendantOfType2 = false;
        $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        predicate$iv$iv2 = predicate$iv2;
        $i$f$findDescendantOfType3 = false;
        $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        predicate$iv$iv$iv2 = predicate$iv$iv2;
        $i$f$findDescendantOfType4 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        result$iv$iv$iv2 = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv2, result$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv2.element != null;
    }

    private final boolean hasBuiltInEnumFunctionReference(KaSession $context_receiver_0, PsiReference reference, KtClass enumClass) {
        KtQualifiedExpression ktQualifiedExpression;
        KtQualifiedExpression ktQualifiedExpression2;
        PsiElement parent2 = reference.getElement().getParent();
        KtQualifiedExpression ktQualifiedExpression3 = ktQualifiedExpression2 = parent2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)parent2 : null;
        boolean bl = ktQualifiedExpression2 != null && (ktQualifiedExpression = this.normalizeEnumQualifiedExpression(ktQualifiedExpression2, enumClass)) != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction(ktQualifiedExpression) : false;
        if (bl) {
            return true;
        }
        KtQualifiedExpression ktQualifiedExpression4 = ktQualifiedExpression2 = parent2 instanceof KtQualifiedExpression ? (KtQualifiedExpression)parent2 : null;
        boolean bl2 = ktQualifiedExpression2 != null && (ktQualifiedExpression = this.normalizeEnumCallableReferenceExpression(ktQualifiedExpression2, enumClass)) != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction((KtCallableReferenceExpression)ktQualifiedExpression) : false;
        if (bl2) {
            return true;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = parent2 instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)parent2 : null;
        boolean bl3 = ktCallableReferenceExpression != null ? EnumUtilsKt.canBeReferenceToBuiltInEnumFunction(ktCallableReferenceExpression) : false;
        if (bl3) {
            return true;
        }
        KtTypeElement ktTypeElement = parent2 instanceof KtTypeElement ? (KtTypeElement)parent2 : null;
        ktQualifiedExpression = ktTypeElement != null ? ktTypeElement.getParent() : null;
        KtTypeReference ktTypeReference = ktQualifiedExpression instanceof KtTypeReference ? (KtTypeReference)ktQualifiedExpression : null;
        boolean bl4 = ktTypeReference != null ? KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction($context_receiver_0, ktTypeReference) : false;
        if (bl4) {
            return true;
        }
        PsiImportStaticReferenceElement psiImportStaticReferenceElement = parent2 instanceof PsiImportStaticReferenceElement ? (PsiImportStaticReferenceElement)parent2 : null;
        boolean bl5 = psiImportStaticReferenceElement != null ? this.isReferenceToBuiltInEnumFunction(psiImportStaticReferenceElement) : false;
        if (bl5) {
            return true;
        }
        PsiReferenceExpression psiReferenceExpression = parent2 instanceof PsiReferenceExpression ? (PsiReferenceExpression)parent2 : null;
        boolean bl6 = psiReferenceExpression != null ? this.isReferenceToBuiltInEnumFunction(psiReferenceExpression, enumClass) : false;
        if (bl6) {
            return true;
        }
        KtElement ktElement = ktQualifiedExpression2 = parent2 instanceof KtElement ? (KtElement)parent2 : null;
        boolean bl7 = ktQualifiedExpression2 != null && (ktQualifiedExpression = this.normalizeImportDirective((KtElement)ktQualifiedExpression2)) != null ? this.isUsedStarImportOfEnumStaticFunctions($context_receiver_0, (KtImportDirective)ktQualifiedExpression) : false;
        if (bl7) {
            return true;
        }
        PsiImportStaticStatement psiImportStaticStatement = parent2 instanceof PsiImportStaticStatement ? (PsiImportStaticStatement)parent2 : null;
        return psiImportStaticStatement != null ? this.isUsedStarImportOfEnumStaticFunctions(psiImportStaticStatement) : false;
    }

    private final KtImportDirective normalizeImportDirective(KtElement $this$normalizeImportDirective) {
        if ($this$normalizeImportDirective instanceof KtImportDirective) {
            return (KtImportDirective)$this$normalizeImportDirective;
        }
        PsiElement psiElement = $this$normalizeImportDirective.getParent();
        return psiElement instanceof KtImportDirective ? (KtImportDirective)psiElement : null;
    }

    private final KtQualifiedExpression normalizeEnumQualifiedExpression(KtQualifiedExpression $this$normalizeEnumQualifiedExpression, KtClass enumClass) {
        if (Intrinsics.areEqual((Object)$this$normalizeEnumQualifiedExpression.getReceiverExpression().getText(), (Object)enumClass.getName())) {
            return $this$normalizeEnumQualifiedExpression;
        }
        KtExpression ktExpression = $this$normalizeEnumQualifiedExpression.getSelectorExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)enumClass.getName())) {
            PsiElement psiElement = $this$normalizeEnumQualifiedExpression.getParent();
            return psiElement instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement : null;
        }
        return null;
    }

    private final KtCallableReferenceExpression normalizeEnumCallableReferenceExpression(KtQualifiedExpression $this$normalizeEnumCallableReferenceExpression, KtClass enumClass) {
        KtExpression ktExpression = $this$normalizeEnumCallableReferenceExpression.getSelectorExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)enumClass.getName())) {
            PsiElement psiElement = $this$normalizeEnumCallableReferenceExpression.getParent();
            return psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUsedStarImportOfEnumStaticFunctions(PsiImportStaticStatement $this$isUsedStarImportOfEnumStaticFunctions) {
        void $this$findDescendantOfType$iv$iv$iv;
        void $this$findDescendantOfType$iv$iv;
        void $this$anyDescendantOfType$iv;
        Object object = $this$isUsedStarImportOfEnumStaticFunctions.getImportReference();
        if (object == null || (object = object.getQualifiedName()) == null) {
            return false;
        }
        Object importedEnumQualifiedName = object;
        PsiClass psiClass = $this$isUsedStarImportOfEnumStaticFunctions.resolveTargetClass();
        KtLightClass ktLightClass = psiClass instanceof KtLightClass ? (KtLightClass)psiClass : null;
        if (!(ktLightClass != null ? ktLightClass.isEnum() : false)) {
            return false;
        }
        PsiFile psiFile = $this$isUsedStarImportOfEnumStaticFunctions.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiElement psiElement = (PsiElement)psiFile;
        Function1 predicate$iv = (Function1)new Function1<PsiReferenceExpression, Boolean>((String)importedEnumQualifiedName){
            final /* synthetic */ String $importedEnumQualifiedName;
            {
                this.$importedEnumQualifiedName = $importedEnumQualifiedName;
                super(1, Intrinsics.Kotlin.class, "isQualifiedNameInEnumStaticMethods", "isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(Lcom/intellij/psi/PsiReference;Ljava/lang/String;)Z", 0);
            }

            public final Boolean invoke(PsiReferenceExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return K2UnusedSymbolUtil.access$isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods((PsiReference)p0, this.$importedEnumQualifiedName);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void var6_6 = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        void var9_9 = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final KaSymbol resolveReferenceToSymbol(KaSession $context_receiver_0, KtImportDirective $this$resolveReferenceToSymbol) {
        KtReference ktReference;
        KtReferenceExpression ktReferenceExpression;
        if ($this$resolveReferenceToSymbol.getImportedReference() instanceof KtReferenceExpression) {
            KtExpression ktExpression = $this$resolveReferenceToSymbol.getImportedReference();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtReferenceExpression");
            ktReferenceExpression = (KtReferenceExpression)ktExpression;
        } else {
            KtExpression ktExpression = $this$resolveReferenceToSymbol.getImportedReference();
            if (ktExpression != null) {
                PsiElement $this$getChildOfType$iv = (PsiElement)ktExpression;
                boolean $i$f$getChildOfType = false;
                ktReferenceExpression = (KtReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtReferenceExpression.class);
            } else {
                ktReferenceExpression = null;
            }
        }
        KtReferenceExpression ktReferenceExpression2 = ktReferenceExpression;
        return ktReferenceExpression2 != null && (ktReference = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression2)) != null ? $context_receiver_0.resolveToSymbol(ktReference) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUsedStarImportOfEnumStaticFunctions(KaSession $context_receiver_0, KtImportDirective $this$isUsedStarImportOfEnumStaticFunctions) {
        void $this$findDescendantOfType$iv$iv$iv;
        void $this$findDescendantOfType$iv$iv;
        void $this$anyDescendantOfType$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        ImportPath importPath = $this$isUsedStarImportOfEnumStaticFunctions.getImportPath();
        if (!(importPath != null ? importPath.isAllUnder() : false)) {
            return false;
        }
        FqName fqName2 = $this$isUsedStarImportOfEnumStaticFunctions.getImportedFqName();
        if (fqName2 == null) {
            return false;
        }
        FqName importedEnumFqName = fqName2;
        KaSymbol kaSymbol = this.resolveReferenceToSymbol($context_receiver_0, $this$isUsedStarImportOfEnumStaticFunctions);
        KaClassSymbol kaClassSymbol = kaSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol : null;
        if (kaClassSymbol == null) {
            return false;
        }
        KaClassSymbol importedClass = kaClassSymbol;
        if (importedClass.getClassKind() != KaClassKind.ENUM_CLASS) {
            return false;
        }
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(importedEnumFqName + "." + (Name)it));
        }
        List enumStaticMethods = (List)destination$iv$iv;
        PsiFile psiFile = $this$isUsedStarImportOfEnumStaticFunctions.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        $this$map$iv = (PsiElement)psiFile;
        Function1 predicate$iv = arg_0 -> K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$lambda$32($context_receiver_0, enumStaticMethods, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        destination$iv$iv = $this$anyDescendantOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$findDescendantOfType = false;
        item$iv$iv2 = $this$findDescendantOfType$iv$iv;
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv$iv$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isReferenceToBuiltInEnumFunction(PsiImportStaticReferenceElement $this$isReferenceToBuiltInEnumFunction) {
        void $this$mapTo$iv$iv;
        String importedEnumQualifiedName = $this$isReferenceToBuiltInEnumFunction.getClassReference().getQualifiedName();
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName(importedEnumQualifiedName + "." + (Name)it));
        }
        List enumStaticMethods = (List)destination$iv$iv;
        String string = $this$isReferenceToBuiltInEnumFunction.getQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedName(...)");
        return enumStaticMethods.contains(new FqName(string));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReferenceToBuiltInEnumFunction(PsiReferenceExpression $this$isReferenceToBuiltInEnumFunction, KtClass enumClass) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = $this$isReferenceToBuiltInEnumFunction.resolve();
        if (!(psiElement instanceof KtLightMethod)) return false;
        KtLightMethod ktLightMethod = (KtLightMethod)psiElement;
        if (ktLightMethod == null) {
            return false;
        }
        KtLightMethod reference = ktLightMethod;
        if (!Intrinsics.areEqual((Object)((KtLightClass)reference.getContainingClass()).getName(), (Object)enumClass.getName())) return false;
        if (!(reference instanceof SyntheticElement)) return false;
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        if (!((List)destination$iv$iv).contains(reference.getName())) return false;
        return true;
    }

    private final boolean canBeHandledByLightMethods(KaSession $context_receiver_0, KtCallableDeclaration $this$canBeHandledByLightMethods, KaDeclarationSymbol symbol) {
        boolean bl;
        if (symbol instanceof KaConstructorSymbol) {
            KaDeclarationSymbol kaDeclarationSymbol = $context_receiver_0.getContainingDeclaration(symbol);
            KaNamedClassSymbol kaNamedClassSymbol = kaDeclarationSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaDeclarationSymbol : null;
            if (kaNamedClassSymbol == null) {
                return false;
            }
            KaNamedClassSymbol classSymbol = kaNamedClassSymbol;
            bl = !classSymbol.isInline() && classSymbol.getVisibility() != KaSymbolVisibility.PRIVATE;
        } else {
            bl = $this$canBeHandledByLightMethods.hasModifier(KtTokens.INTERNAL_KEYWORD) ? false : (!(symbol instanceof KaNamedFunctionSymbol) ? true : !this.hasInlineClassParameters($context_receiver_0, (KaNamedFunctionSymbol)symbol));
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasInlineClassParameters(KaSession $context_receiver_0, KaNamedFunctionSymbol $this$hasInlineClassParameters) {
        boolean bl;
        boolean bl2;
        KaNamedClassSymbol receiverParameterClassSymbol;
        KaType kaType = KaCallableSymbolKt.getReceiverType($this$hasInlineClassParameters);
        KaClassSymbol kaClassSymbol = kaType != null ? $context_receiver_0.getExpandedSymbol(kaType) : null;
        KaNamedClassSymbol kaNamedClassSymbol = receiverParameterClassSymbol = kaClassSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaClassSymbol : null;
        if (kaNamedClassSymbol != null) {
            if (kaNamedClassSymbol.isInline()) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        Iterable $this$any$iv = $this$hasInlineClassParameters.getValueParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            KaNamedClassSymbol namedClassOrObjectSymbol;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KaValueParameterSymbol it = (KaValueParameterSymbol)element$iv;
            boolean bl3 = false;
            KaClassSymbol kaClassSymbol2 = $context_receiver_0.getExpandedSymbol(it.getReturnType());
            if ((kaClassSymbol2 instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaClassSymbol2 : null) == null) {
                bl = false;
                continue;
            }
            namedClassOrObjectSymbol = namedClassOrObjectSymbol;
            bl = namedClassOrObjectSymbol.isInline();
        } while (!bl);
        return true;
    }

    private final boolean hasOverrides(KtNamedDeclaration declaration) {
        KtNamedDeclaration ktNamedDeclaration = declaration;
        boolean overrides2 = ktNamedDeclaration instanceof KtCallableDeclaration ? KotlinSearchUtilKt.hasAnyOverridings((KtCallableDeclaration)declaration) : (ktNamedDeclaration instanceof KtClass ? KotlinSearchUtilKt.hasAnyInheritors((KtClass)declaration) : false);
        return overrides2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean hasFakeOverrides(KtNamedDeclaration declaration, SearchScope useScope) {
        var5_3 = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
        if (var5_3 instanceof KtClass == false) return false;
        v0 = (KtClass)var5_3;
        if (v0 == null) {
            return false;
        }
        ownerClass = v0;
        if (!KotlinPsiUtilsKt.isInheritable(ownerClass)) {
            return false;
        }
        useSiteElement$iv = (KtElement)declaration;
        $i$f$analyze = false;
        v1 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
        var8_9 = KaSessionProvider.Companion.getInstance(v1);
        useSiteElement$iv$iv = useSiteElement$iv;
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            var13_14 = lock$iv$iv = new Object();
            synchronized (var13_14) {
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                $this$hasFakeOverrides_u24lambda_u2436 = analysisSession$iv$iv;
                $i$a$-analyze-K2UnusedSymbolUtil$hasFakeOverrides$callableName$1 = false;
                symbol = $this$hasFakeOverrides_u24lambda_u2436.getSymbol((KtDeclaration)declaration);
                if (!(symbol instanceof KaCallableSymbol)) {
                    var22_27 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 38, 14] lbl29 : MonitorExitStatement: MONITOREXIT : var13_14
                    var23_29 = var22_27;
                    return var23_29;
                }
                modality = symbol.getModality();
                if (modality == KaSymbolModality.ABSTRACT) {
                    var20_35 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 37, 14] lbl35 : MonitorExitStatement: MONITOREXIT : var13_14
                    var21_37 = var20_35;
                    return var21_37;
                }
                v2 = ((KaCallableSymbol)symbol).getCallableId();
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv /* !! */  = v2 != null ? v2.getCallableName() : null;
            }
            lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv /* !! */ ;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        v3 = lock$iv$iv;
        if (v3 == null) {
            return false;
        }
        callableName = v3;
        $this$any$iv = KotlinSearchUtilKt.findAllInheritors(ownerClass, useScope);
        $i$f$any = false;
        var7_8 = $this$any$iv.iterator();
        do {
            block50: {
                if (!var7_8.hasNext()) {
                    return false;
                }
                element$iv = var7_8.next();
                element = (PsiElement)element$iv;
                $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1 = false;
                var11_12 = element;
                if (!(var11_12 instanceof KtClassOrObject)) break block50;
                useSiteElement$iv = (KtElement)element;
                $i$f$analyze = false;
                v4 = useSiteElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getProject(...)");
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv /* !! */  = KaSessionProvider.Companion.getInstance(v4);
                useSiteElement$iv$iv = useSiteElement$iv;
                $i$f$analyze = false;
                analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                try {
                    var19_41 = lock$iv$iv = new Object();
                    synchronized (var19_41) {
                        block51: {
                            block46: {
                                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                                $this$hasFakeOverrides_u24lambda_u2443_u24lambda_u2439 = analysisSession$iv$iv;
                                $i$a$-analyze-K2UnusedSymbolUtil$hasFakeOverrides$1$1 = false;
                                if (!$this$hasFakeOverrides_u24lambda_u2443_u24lambda_u2439.canBeAnalysed(element)) {
                                    var23_30 = false;
                                    // MONITOREXIT @DISABLED, blocks:[34, 22, 7, 15] lbl86 : MonitorExitStatement: MONITOREXIT : var19_41
                                    var24_44 = var23_30;
                                    v5 = var24_44;
                                    continue;
                                }
                                v6 = $this$hasFakeOverrides_u24lambda_u2443_u24lambda_u2439.getSymbol((KtDeclaration)declaration);
                                Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol");
                                callableSymbol = (KaCallableSymbol)v6;
                                var26_46 = $this$hasFakeOverrides_u24lambda_u2443_u24lambda_u2439.getClassSymbol((KtClassOrObject)element);
                                if (var26_46 == null || (var27_47 = $this$hasFakeOverrides_u24lambda_u2443_u24lambda_u2439.getMemberScope(var26_46)) == null || (var29_51 = var27_47.callables(var28_50 /* !! */  = new Name[]{callableName})) == null) break block51;
                                var30_52 = var29_51;
                                $i$f$singleOrNull = false;
                                single$iv = null;
                                found$iv = false;
                                for (E element$iv : $this$singleOrNull$iv) {
                                    it = (KaCallableSymbol)element$iv;
                                    $i$a$-singleOrNull-K2UnusedSymbolUtil$hasFakeOverrides$1$1$overridingCallableSymbol$1 = false;
                                    if (!Intrinsics.areEqual((Object)$this$hasFakeOverrides_u24lambda_u2443_u24lambda_u2439.getFakeOverrideOriginal(it), (Object)callableSymbol)) continue;
                                    if (found$iv) {
                                        v7 = null;
                                        break block46;
                                    }
                                    single$iv = element$iv;
                                    found$iv = true;
                                }
                                v7 = found$iv == false ? null : single$iv;
                            }
                            var28_50 /* !! */  = v7;
                            if (var28_50 /* !! */  == null) break block51;
                            overridingCallableSymbol /* !! */  = var28_50 /* !! */ ;
                            if (Intrinsics.areEqual((Object)overridingCallableSymbol /* !! */ , (Object)callableSymbol)) ** GOTO lbl-1000
                            ** break block52
                        }
                        var38_60 = false;
                    }
                    var39_61 = var38_60;
                    v5 = var39_61;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        block47: {
                            $this$any$iv = $this$hasFakeOverrides_u24lambda_u2443_u24lambda_u2439.getIntersectionOverriddenSymbols((KaCallableSymbol)overridingCallableSymbol /* !! */ );
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v8 = false;
                            } else {
                                var29_51 = $this$any$iv.iterator();
                                while (var29_51.hasNext()) {
                                    element$iv = var29_51.next();
                                    it = (KaCallableSymbol)element$iv;
                                    $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1$1$1 = false;
                                    if (!(Intrinsics.areEqual((Object)it, (Object)callableSymbol) == false)) continue;
                                    v8 = true;
                                    break block47;
                                }
                                v8 = false;
                            }
                        }
                        if (v8) {
                            v9 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v9 = false;
                        }
                        $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = v9;
                    }
                    lock$iv$iv = $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv;
                }
                catch (Throwable throwable$iv$iv) {
                    this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                    throw new KotlinNothingValueException();
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                }
                v5 = lock$iv$iv;
                continue;
            }
            if (var11_12 instanceof PsiClass) {
                $this$any$iv = LightClassUtilsKt.toLightMethods((PsiElement)((PsiElement)declaration));
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v5 = false;
                    continue;
                }
                for (T element$iv : $this$any$iv) {
                    block49: {
                        lightMethod = (PsiMethod)element$iv;
                        $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1$2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiClass)element).findMethodsBySignature(lightMethod, true), (String)"findMethodsBySignature(...)");
                        $this$all$iv = sameMethods;
                        $i$f$all = false;
                        var22_28 = $this$all$iv.length;
                        for (var21_39 = 0; var21_39 < var22_28; ++var21_39) {
                            it = element$iv = $this$all$iv[var21_39];
                            $i$a$-all-K2UnusedSymbolUtil$hasFakeOverrides$1$2$1 = false;
                            if (Intrinsics.areEqual((Object)it.getContainingClass(), (Object)element) == false) continue;
                            v10 = false;
                            break block49;
                        }
                        v10 = true;
                    }
                    if (v10) {
                        $this$any$iv = sameMethods;
                        $i$f$any = false;
                        var22_28 = $this$any$iv.length;
                        for (var21_39 = 0; var21_39 < var22_28; ++var21_39) {
                            it = element$iv = $this$any$iv[var21_39];
                            $i$a$-any-K2UnusedSymbolUtil$hasFakeOverrides$1$2$2 = false;
                            if (!Intrinsics.areEqual((Object)it.getContainingClass(), (Object)lightMethod.getContainingClass())) {
                                return true;
                            }
                            v11 = false;
                            if (!v11) continue;
                            return true;
                        }
                        v12 = false;
                        if (v12) {
                            return true;
                        }
                    }
                    v13 = false;
                    if (!v13) continue;
                    return true;
                }
                v5 = false;
                continue;
            }
            v5 = false;
        } while (!v5);
        return true;
    }

    private final boolean hasPlatformImplementations(KtNamedDeclaration declaration) {
        return PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)declaration));
    }

    private final boolean classOrObjectHasTextUsages(KtClassOrObject classOrObject) {
        Ref.BooleanRef hasTextUsages = new Ref.BooleanRef();
        if (classOrObject.getUseScope() instanceof GlobalSearchScope) {
            Project project = classOrObject.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KotlinFindClassUsagesHandler findClassUsagesHandler = new KotlinFindClassUsagesHandler(classOrObject, new KotlinFindUsagesHandlerFactory(project));
            findClassUsagesHandler.processUsagesInText((PsiElement)classOrObject, arg_0 -> K2UnusedSymbolUtil.classOrObjectHasTextUsages$lambda$45(arg_0 -> K2UnusedSymbolUtil.classOrObjectHasTextUsages$lambda$44(hasTextUsages, arg_0), arg_0), GlobalSearchScope.projectScope((Project)classOrObject.getProject()));
        }
        return hasTextUsages.element;
    }

    @NotNull
    public final LocalQuickFixAndIntentionActionOnPsiElement[] createQuickFixes(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof KtParameter) {
            if (((KtParameter)declaration).isLoopParameter()) {
                return new LocalQuickFixAndIntentionActionOnPsiElement[0];
            }
            if (((KtParameter)declaration).isCatchParameter()) {
                LocalQuickFixAndIntentionActionOnPsiElement[] localQuickFixAndIntentionActionOnPsiElementArray;
                if (Intrinsics.areEqual((Object)((KtParameter)declaration).getName(), (Object)"_")) {
                    localQuickFixAndIntentionActionOnPsiElementArray = new LocalQuickFixAndIntentionActionOnPsiElement[]{};
                } else {
                    LocalQuickFixAndIntentionActionOnPsiElement[] localQuickFixAndIntentionActionOnPsiElementArray2 = new LocalQuickFixAndIntentionActionOnPsiElement[]{new RenameElementFix((PsiNamedElement)declaration, "_")};
                    localQuickFixAndIntentionActionOnPsiElementArray = localQuickFixAndIntentionActionOnPsiElementArray2;
                }
                return localQuickFixAndIntentionActionOnPsiElementArray;
            }
            KtDeclarationWithBody ownerFunction = ((KtParameter)declaration).getOwnerFunction();
            if (ownerFunction instanceof KtPropertyAccessor && ((KtPropertyAccessor)ownerFunction).isSetter()) {
                return new LocalQuickFixAndIntentionActionOnPsiElement[0];
            }
            if (ownerFunction instanceof KtFunctionLiteral) {
                LocalQuickFixAndIntentionActionOnPsiElement[] localQuickFixAndIntentionActionOnPsiElementArray = new LocalQuickFixAndIntentionActionOnPsiElement[]{new RenameElementFix((PsiNamedElement)declaration, "_")};
                return localQuickFixAndIntentionActionOnPsiElementArray;
            }
        }
        LocalQuickFixAndIntentionActionOnPsiElement[] localQuickFixAndIntentionActionOnPsiElementArray = new LocalQuickFixAndIntentionActionOnPsiElement[]{new SafeDeleteFix(declaration)};
        return localQuickFixAndIntentionActionOnPsiElementArray;
    }

    private final boolean isEntryPoint(KaSession $context_receiver_0, KtNamedDeclaration declaration, Lazy<? extends PsiSearchHelper.SearchCostResult> isCheapEnough, UnusedDeclarationInspectionBase isJavaEntryPoint) {
        PsiElement psiElement;
        if (this.hasKotlinAdditionalAnnotation($context_receiver_0, (KtDeclaration)declaration)) {
            return true;
        }
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtClass) {
            boolean bl;
            block22: {
                Iterable $this$any$iv = ((KtClass)declaration).getDeclarations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.hasKotlinAdditionalAnnotation($context_receiver_0, it)) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            psiElement = (PsiElement)LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration));
        } else if (ktNamedDeclaration instanceof KtObjectDeclaration) {
            psiElement = (PsiElement)LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)declaration));
        } else if (ktNamedDeclaration instanceof KtNamedFunction) {
            if (KotlinMainFunctionDetector.isMain$default(KotlinMainFunctionDetector.Companion.getInstance(), (KtNamedFunction)declaration, null, 2, null)) {
                return true;
            }
            KtNamedDeclaration ktNamedDeclaration2 = declaration;
            Intrinsics.checkNotNull((Object)ktNamedDeclaration2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            psiElement = (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktNamedDeclaration2);
        } else if (ktNamedDeclaration instanceof KtSecondaryConstructor) {
            KtNamedDeclaration ktNamedDeclaration3 = declaration;
            Intrinsics.checkNotNull((Object)ktNamedDeclaration3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            psiElement = (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)ktNamedDeclaration3);
        } else {
            if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtParameter) {
                if (declaration instanceof KtParameter) {
                    KtDeclarationWithBody ownerFunction = ((KtParameter)declaration).getOwnerFunction();
                    if (ownerFunction instanceof KtNamedFunction && KotlinMainFunctionDetector.isMain$default(KotlinMainFunctionDetector.Companion.getInstance(), (KtNamedFunction)ownerFunction, null, 2, null)) {
                        return AnnotationModificationUtilsKt.findAnnotation$default((KtAnnotated)ownerFunction, new ClassId(new FqName("kotlin.jvm"), new FqName("JvmStatic"), false), null, false, 6, null) != null;
                    }
                    if (!((KtParameter)declaration).hasValOrVar()) {
                        return false;
                    }
                }
                if (declaration instanceof KtParameter && this.isAnnotationParameter((KtParameter)declaration)) {
                    List lightAnnotationMethods = CollectionsKt.toList((Iterable)((Iterable)LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)declaration)));
                    for (PsiMethod javaParameterPsi : lightAnnotationMethods) {
                        if (!isJavaEntryPoint.isEntryPoint((PsiElement)javaParameterPsi)) continue;
                        return true;
                    }
                }
                EntryPointsManager entryPointsManager = EntryPointsManager.getInstance((Project)declaration.getProject());
                Intrinsics.checkNotNull((Object)entryPointsManager, (String)"null cannot be cast to non-null type com.intellij.codeInspection.ex.EntryPointsManagerBase");
                EntryPointsManagerBase entryPointsManager2 = (EntryPointsManagerBase)entryPointsManager;
                Collection collection = entryPointsManager2.getAdditionalAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAdditionalAnnotations(...)");
                JDOMExternalizableStringList jDOMExternalizableStringList = entryPointsManager2.ADDITIONAL_ANNOTATIONS;
                Intrinsics.checkNotNullExpressionValue((Object)jDOMExternalizableStringList, (String)"ADDITIONAL_ANNOTATIONS");
                return this.checkAnnotatedUsingPatterns($context_receiver_0, declaration, CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)jDOMExternalizableStringList)));
            }
            return false;
        }
        if (psiElement == null) {
            return false;
        }
        PsiElement lightElement = psiElement;
        if (isCheapEnough.getValue() == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return false;
        }
        return isJavaEntryPoint.isEntryPoint(lightElement);
    }

    private static final PsiSearchHelper.SearchCostResult getPsiToReportProblem$lambda$2(KtNamedDeclaration $declaration) {
        return UtilsKt.isCheapEnoughToSearchUsages($declaration);
    }

    private static final PsiSearchHelper.SearchCostResult hasNonTrivialUsages$lambda$7(KtNamedDeclaration $declaration) {
        return UtilsKt.isCheapEnoughToSearchUsages($declaration);
    }

    private static final boolean hasNonTrivialUsages$lambda$12$lambda$11(PsiReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getElement().getParent();
        KtCallElement callElement = psiElement instanceof KtCallElement ? (KtCallElement)psiElement : null;
        return callElement != null && callElement.getTypeArgumentList() == null;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasNonTrivialUsages$lambda$12(GlobalSearchScope $containingClassSearchScope, PsiReference ref) {
        boolean bl;
        KtCallableDeclaration callableDeclaration;
        block13: {
            void $this$mapTo$iv$iv;
            Object it;
            KtCallableDeclaration ktCallableDeclaration;
            List typeArguments2;
            block15: {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                    PsiElement psiElement = ref.getElement().getParent();
                    KtUserType ktUserType = psiElement instanceof KtUserType ? (KtUserType)psiElement : null;
                    if (ktUserType == null) {
                        return false;
                    }
                    KtUserType userType = ktUserType;
                    List list2 = userType.getTypeArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeArguments(...)");
                    typeArguments2 = list2;
                    if (typeArguments2.isEmpty()) {
                        return false;
                    }
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)userType;
                    boolean $i$f$getStrictParentOfType = false;
                    KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtParameter.class, (boolean)true);
                    if (ktParameter == null) {
                        return false;
                    }
                    KtParameter parameter = ktParameter;
                    PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)parameter;
                    boolean $i$f$getStrictParentOfType2 = false;
                    ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtCallableDeclaration.class, (boolean)true);
                    if (ktCallableDeclaration == null) break block14;
                    it = ktCallableDeclaration;
                    boolean bl2 = false;
                    KtNamedFunction ktNamedFunction = it instanceof KtNamedFunction ? (KtNamedFunction)it : null;
                    KtTypeParameterListOwnerStub ktTypeParameterListOwnerStub = ktNamedFunction != null ? (KtTypeParameterListOwnerStub)ktNamedFunction : (KtTypeParameterListOwnerStub)KtPsiUtilKt.containingClass((KtElement)((KtElement)it));
                    ktCallableDeclaration = ktTypeParameterListOwnerStub;
                    if (ktTypeParameterListOwnerStub != null) break block15;
                }
                return false;
            }
            callableDeclaration = ktCallableDeclaration;
            List list3 = callableDeclaration.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getTypeParameters(...)");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                KtTypeParameter ktTypeParameter = (KtTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it2.getName());
            }
            List typeParameters2 = (List)destination$iv$iv;
            if (typeParameters2.isEmpty()) {
                return false;
            }
            Iterable $this$none$iv = typeArguments2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtTypeProjection it3 = (KtTypeProjection)element$iv;
                    boolean bl4 = false;
                    if (!typeParameters2.contains(it3.getText())) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        return INSTANCE.referenceExists((PsiElement)callableDeclaration, (SearchScope)$containingClassSearchScope, (Function1<? super PsiReference, Boolean>)((Function1)K2UnusedSymbolUtil::hasNonTrivialUsages$lambda$12$lambda$11));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final boolean hasReferences$lambda$15(KaSymbolPointer $symbolPointer, PsiReference it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        v0 = it.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getElement(...)");
        refElement = v0;
        if (!(refElement instanceof KtElement)) ** GOTO lbl-1000
        useSiteElement$iv = (KtElement)refElement;
        $i$f$analyze = false;
        v1 = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
        var5_5 = KaSessionProvider.Companion.getInstance(v1);
        useSiteElement$iv$iv = useSiteElement$iv;
        $i$f$analyze = false;
        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            var10_11 = lock$iv$iv = new Object();
            synchronized (var10_11) {
                $i$a$-synchronized-KaSessionProvider$analyze$1$iv$iv = false;
                $this$hasReferences_u24lambda_u2415_u24lambda_u2414 = analysisSession$iv$iv;
                $i$a$-analyze-K2UnusedSymbolUtil$hasReferences$1$1 = false;
                $this$getStrictParentOfType$iv = refElement;
                $i$f$getStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeAlias.class, (boolean)true) != null) ** GOTO lbl-1000
                $this$getStrictParentOfType$iv = refElement;
                $i$f$getStrictParentOfType = false;
                var14_17 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
                v2 = var14_17 != null && (var15_19 = $this$hasReferences_u24lambda_u2415_u24lambda_u2414.resolveToCall((KtElement)var14_17)) != null && (var16_21 = KaCallInfoKt.singleFunctionCallOrNull(var15_19)) != null && (var17_22 = var16_21.getPartiallyAppliedSymbol()) != null ? (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(var17_22) : null;
                v3 = $symbolPointer;
                if (Intrinsics.areEqual(v2, v3 != null ? (KaDeclarationSymbol)$this$hasReferences_u24lambda_u2415_u24lambda_u2414.restoreSymbol(v3) : null)) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                var11_14 = v4;
            }
            var9_10 = var11_14;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        if (var9_10) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        return v5;
    }

    private static final boolean hasReferences$lambda$17$lambda$16(KaSession $$context_receiver_0, KtNamedDeclaration $declaration, KtNamedDeclaration $originalDeclaration, PsiReference it) {
        PsiElement psiElement = it.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        boolean checkReference = INSTANCE.checkReference($$context_receiver_0, psiElement, $declaration, $originalDeclaration);
        return checkReference;
    }

    private static final boolean hasReferences$lambda$19(KaSession $$context_receiver_0, KtNamedDeclaration $declaration, KtNamedDeclaration $originalDeclaration, UsageInfo it) {
        PsiElement refElement = it.getElement();
        return refElement == null || INSTANCE.checkReference($$context_receiver_0, refElement, $declaration, $originalDeclaration);
    }

    private static final Unit checkPrivateDeclaration$lambda$20(HashSet $setOfImportedDeclarations, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)$setOfImportedDeclarations).add(it);
        return Unit.INSTANCE;
    }

    private static final boolean referenceExists$lambda$24(Function1 $predicate, PsiReference it) {
        Intrinsics.checkNotNull((Object)it);
        return (Boolean)$predicate.invoke((Object)it) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean hasBuiltInEnumFunctionReference$lambda$26(KtClass $enumClass, PsiReference it) {
        boolean bl;
        void this_$iv$iv;
        KtElement ktElement;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getElement();
        KtElement ktElement2 = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        if (ktElement2 == null) {
            return false;
        }
        KtElement useSiteElement$iv = ktElement = ktElement2;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl3 = false;
                KaSession $this$hasBuiltInEnumFunctionReference_u24lambda_u2426_u24lambda_u2425 = analysisSession$iv$iv;
                boolean bl4 = false;
                bl2 = INSTANCE.hasBuiltInEnumFunctionReference($this$hasBuiltInEnumFunctionReference_u24lambda_u2426_u24lambda_u2425, it, $enumClass);
            }
            bl = bl2;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return bl;
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$27(KtClass $enumClass, KaSession $$context_receiver_0, KtCallableReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getReceiverExpression() == null && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction($$context_receiver_0, it);
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$28(KtClass $enumClass, KaSession $$context_receiver_0, KtSimpleNameExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it.getParent() instanceof KtCallableReferenceExpression) && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)it)) == null && INSTANCE.isReferenceToBuiltInEnumEntries($$context_receiver_0, it);
    }

    private static final boolean hasEnumFunctionReferenceInEnumClass$lambda$29(KtClass $enumClass, KaSession $$context_receiver_0, KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)it)) == null && Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)it)), (Object)$enumClass) && KotlinPsiUtilsKt.isReferenceToBuiltInEnumFunction($$context_receiver_0, it);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(PsiReference $this$isUsedStarImportOfEnumStaticFunctions_u24isQualifiedNameInEnumStaticMethods, String importedEnumQualifiedName) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = $this$isUsedStarImportOfEnumStaticFunctions_u24isQualifiedNameInEnumStaticMethods.resolve();
        if (!(psiElement instanceof PsiMember)) return false;
        PsiMember psiMember = (PsiMember)psiElement;
        if (psiMember == null) {
            return false;
        }
        PsiMember referenceExpression = psiMember;
        PsiClass psiClass = referenceExpression.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? JavaPsiUtils.getKotlinFqName((PsiElement)psiClass) : null), (Object)new FqName(importedEnumQualifiedName))) return false;
        Iterable $this$map$iv = EnumUtilsKt.getENUM_STATIC_METHOD_NAMES_WITH_ENTRIES_IN_JAVA();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Name name2 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asString());
        }
        if (!CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)referenceExpression.getName())) return false;
        return true;
    }

    private static final boolean isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods(KtExpression $this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods, KaSession $$context_receiver_0, List<FqName> enumStaticMethods) {
        if (KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods)) != null) {
            return false;
        }
        KtNameReferenceExpression ktNameReferenceExpression = $this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods : null;
        PsiElement psiElement = ktNameReferenceExpression != null ? ktNameReferenceExpression.getParent() : null;
        KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        if ((ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getReceiverExpression() : null) != null) {
            return false;
        }
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)$this$isUsedStarImportOfEnumStaticFunctions_u24isNameInEnumStaticMethods));
        KaSymbol kaSymbol = ktReference != null ? $$context_receiver_0.resolveToSymbol(ktReference) : null;
        KaCallableSymbol kaCallableSymbol = kaSymbol instanceof KaCallableSymbol ? (KaCallableSymbol)kaSymbol : null;
        if (kaCallableSymbol == null) {
            return false;
        }
        KaCallableSymbol symbol = kaCallableSymbol;
        CallableId callableId = symbol.getCallableId();
        return CollectionsKt.contains((Iterable)enumStaticMethods, (Object)(callableId != null ? callableId.asSingleFqName() : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUsedStarImportOfEnumStaticFunctions$lambda$32(KaSession $$context_receiver_0, List $enumStaticMethods, KtExpression it) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtCallExpression ktCallExpression = it instanceof KtCallExpression ? (KtCallExpression)it : null;
        if (ktCallExpression != null) {
            if (K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktCallExpression, $$context_receiver_0, $enumStaticMethods)) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        KtCallableReferenceExpression ktCallableReferenceExpression = it instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)it : null;
        if (ktCallableReferenceExpression != null && (ktCallableReferenceExpression = ktCallableReferenceExpression.getCallableReference()) != null) {
            if (K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktCallableReferenceExpression, $$context_receiver_0, $enumStaticMethods)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!(it instanceof KtReferenceExpression)) return false;
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)it;
        if (ktReferenceExpression == null) return false;
        if (!K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isNameInEnumStaticMethods((KtExpression)ktReferenceExpression, $$context_receiver_0, $enumStaticMethods)) return false;
        return true;
    }

    private static final boolean classOrObjectHasTextUsages$lambda$44(Ref.BooleanRef $hasTextUsages, UsageInfo it) {
        $hasTextUsages.element = true;
        return false;
    }

    private static final boolean classOrObjectHasTextUsages$lambda$45(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods(PsiReference $receiver, String importedEnumQualifiedName) {
        return K2UnusedSymbolUtil.isUsedStarImportOfEnumStaticFunctions$isQualifiedNameInEnumStaticMethods($receiver, importedEnumQualifiedName);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.test.*", "kotlin.js.JsExport"};
        KOTLIN_ADDITIONAL_ANNOTATIONS = CollectionsKt.listOf((Object[])objectArray);
        Name name2 = Name.identifier((String)"HIDDEN");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DEPRECATION_LEVEL_HIDDEN = StandardNames.FqNames.deprecationLevel.child(name2);
        Name name3 = Name.identifier((String)"level");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        DEPRECATION_LEVEL_PARAMETER_NAME = name3;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiSearchHelper.SearchCostResult.values().length];
            try {
                nArray[PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

