/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.compatibility;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ExternalCompilerVersionProvider;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.configuration.KotlinLibraryVersionProvider;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinLibrariesCompatibilityStore;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/DefaultKotlinLibraryVersionProvider;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinLibraryVersionProvider;", "<init>", "()V", "getKotlinVersion", "Lkotlin/KotlinVersion;", "Lcom/intellij/openapi/module/Module;", "getVersion", "", "module", "groupId", "artifactId", "kotlin.project-wizard.core"})
@SourceDebugExtension(value={"SMAP\nDefaultKotlinLibraryVersionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultKotlinLibraryVersionProvider.kt\norg/jetbrains/kotlin/tools/projectWizard/compatibility/DefaultKotlinLibraryVersionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
public final class DefaultKotlinLibraryVersionProvider
implements KotlinLibraryVersionProvider {
    private final KotlinVersion getKotlinVersion(Module $this$getKotlinVersion) {
        IdeKotlinVersion ideKotlinVersion = ExternalCompilerVersionProvider.INSTANCE.get($this$getKotlinVersion);
        if (ideKotlinVersion == null || (ideKotlinVersion = ideKotlinVersion.getKotlinVersion()) == null) {
            Project project = $this$getKotlinVersion.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String it = KotlinJpsPluginSettings.Companion.jpsVersion(project);
            boolean bl = false;
            IdeKotlinVersion ideKotlinVersion2 = IdeKotlinVersion.Companion.opt(it);
            ideKotlinVersion = ideKotlinVersion2 != null ? ideKotlinVersion2.getKotlinVersion() : null;
        }
        return ideKotlinVersion;
    }

    @Override
    @Nullable
    public String getVersion(@NotNull Module module, @NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        KotlinVersion kotlinVersion = this.getKotlinVersion(module);
        if (kotlinVersion == null) {
            return null;
        }
        KotlinVersion kotlinVersion2 = kotlinVersion;
        Map map2 = KotlinLibrariesCompatibilityStore.Companion.getInstance().getVersions(groupId, artifactId);
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map versions = map2;
        String kotlinShortVersion = kotlinVersion2.getMajor() + "." + kotlinVersion2.getMinor();
        return (String)versions.get(kotlinShortVersion);
    }
}

