/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.old.descriptor;

import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class TemplateDescriptor {
    private boolean filtered = true;
    private String encoding;

    public TemplateDescriptor() {
        this.setFiltered(true);
        this.setEncoding(TemplateDescriptor.getDefaultEncoding());
    }

    private static String getDefaultEncoding() {
        String name = System.getProperty("file.encoding");
        if (name == null) {
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            name = out.getEncoding();
        }
        name = Charset.forName(name).name();
        return name;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) throws IllegalCharsetNameException, UnsupportedCharsetException {
        Charset.forName(encoding);
        this.encoding = encoding;
    }
}

