/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.php.correctness;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.ml.inline.completion.features.correctness.HighlightedRange;
import com.intellij.ml.inline.completion.features.correctness.RawEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.SpecialRange;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionEventsReporter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/inline/completion/php/correctness/PhpHighlightingEnricher;", "Lcom/intellij/ml/inline/completion/features/correctness/RawEnrichmentTool;", "<init>", "()V", "run", "", "Lcom/intellij/ml/inline/completion/features/correctness/SpecialRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "Lcom/intellij/psi/PsiFile;", "suggestionOffset", "", "suggestion", "", "fileWithSuggestion", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "PhpHighlightingVisitor", "intellij.fullLine.php"})
final class PhpHighlightingEnricher
extends RawEnrichmentTool {
    @Override
    @NotNull
    public List<SpecialRange> run(@NotNull Editor editor2, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull PsiFile fileWithSuggestion, @NotNull TextRange suggestionRange, @Nullable MLCompletionSessionEventsReporter sessionLogger) {
        List list;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)fileWithSuggestion, (String)"fileWithSuggestion");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        if (!(fileWithSuggestion instanceof PhpFile)) {
            return CollectionsKt.emptyList();
        }
        HighlightInfoFilter[] highlightInfoFilterArray = new HighlightInfoFilter[]{};
        HighlightInfoHolder highlightInfoHolder2 = new HighlightInfoHolder(fileWithSuggestion, editor2, highlightInfoFilterArray){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
                super($fileWithSuggestion, $super_call_param$1);
            }

            public TextAttributesScheme getColorsScheme() {
                EditorColorsScheme editorColorsScheme = this.$editor.getColorsScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                return (TextAttributesScheme)editorColorsScheme;
            }
        };
        PhpHighlightingVisitor visitor2 = new PhpHighlightingVisitor((PhpFile)fileWithSuggestion, highlightInfoHolder2);
        visitor2.highlight(suggestionRange);
        List $this$run_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = highlightInfoHolder2.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightingInfo;
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfoHolder2.get(i), (String)"get(...)");
            TextAttributes attributes = highlightingInfo.forcedTextAttributes;
            TextRange textRange = new TextRange(highlightingInfo.startOffset, highlightingInfo.endOffset);
            Intrinsics.checkNotNull((Object)attributes);
            $this$run_u24lambda_u240.add(new HighlightedRange(textRange, attributes));
        }
        return CollectionsKt.build((List)list);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\t2\u0006\u0010&\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020\t2\u0006\u0010,\u001a\u00020-R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/ml/inline/completion/php/correctness/PhpHighlightingEnricher$PhpHighlightingVisitor;", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "file", "Lcom/jetbrains/php/lang/psi/PhpFile;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "<init>", "(Lcom/intellij/ml/inline/completion/php/correctness/PhpHighlightingEnricher;Lcom/jetbrains/php/lang/psi/PhpFile;Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "visitPhpFunction", "", "function", "Lcom/jetbrains/php/lang/psi/elements/Function;", "visitPhpMethod", "method", "Lcom/jetbrains/php/lang/psi/elements/Method;", "visitPhpField", "field", "Lcom/jetbrains/php/lang/psi/elements/Field;", "visitPhpConstant", "constant", "Lcom/jetbrains/php/lang/psi/elements/Constant;", "visitPhpClassReference", "classReference", "Lcom/jetbrains/php/lang/psi/elements/ClassReference;", "visitPhpFunctionCall", "reference", "Lcom/jetbrains/php/lang/psi/elements/FunctionReference;", "visitPhpFieldReference", "fieldReference", "Lcom/jetbrains/php/lang/psi/elements/FieldReference;", "visitPhpConstantReference", "Lcom/jetbrains/php/lang/psi/elements/ConstantReference;", "visitPhpClassConstantReference", "constantReference", "Lcom/jetbrains/php/lang/psi/elements/ClassConstantReference;", "visitPhpMethodReference", "Lcom/jetbrains/php/lang/psi/elements/MethodReference;", "highlightNameIdentifier", "element", "Lcom/jetbrains/php/lang/psi/elements/PhpNamedElement;", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "highlight", "Lcom/intellij/psi/PsiElement;", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.fullLine.php"})
    @SourceDebugExtension(value={"SMAP\nPhpSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/php/correctness/PhpHighlightingEnricher$PhpHighlightingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1869#2,2:200\n*S KotlinDebug\n*F\n+ 1 PhpSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/php/correctness/PhpHighlightingEnricher$PhpHighlightingVisitor\n*L\n160#1:200,2\n*E\n"})
    public final class PhpHighlightingVisitor
    extends PhpElementVisitor {
        @Nullable
        private PhpFile file;
        @Nullable
        private HighlightInfoHolder holder;

        public PhpHighlightingVisitor(@Nullable PhpFile file, HighlightInfoHolder holder) {
            this.file = file;
            this.holder = holder;
        }

        public void visitPhpFunction(@NotNull Function function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            PhpNamedElement phpNamedElement = (PhpNamedElement)function;
            TextAttributesKey textAttributesKey = PhpHighlightingData.FUNCTION;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"FUNCTION");
            this.highlightNameIdentifier(phpNamedElement, textAttributesKey);
        }

        public void visitPhpMethod(@NotNull Method method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            PhpNamedElement phpNamedElement = (PhpNamedElement)method;
            TextAttributesKey textAttributesKey = PhpHighlightingData.FUNCTION;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"FUNCTION");
            this.highlightNameIdentifier(phpNamedElement, textAttributesKey);
        }

        public void visitPhpField(@NotNull Field field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Field it = field;
            boolean bl = false;
            TextAttributesKey key = it.getModifier().isPrivate() ? PhpHighlightingData.PRIVATE_INSTANCE_FIELD : (it.getModifier().isProtected() ? PhpHighlightingData.PROTECTED_INSTANCE_FIELD : PhpHighlightingData.INSTANCE_FIELD);
            PhpNamedElement phpNamedElement = (PhpNamedElement)field;
            Intrinsics.checkNotNull((Object)key);
            this.highlightNameIdentifier(phpNamedElement, key);
        }

        public void visitPhpConstant(@NotNull Constant constant) {
            Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
            PhpNamedElement phpNamedElement = (PhpNamedElement)constant;
            TextAttributesKey textAttributesKey = PhpHighlightingData.CONSTANT;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CONSTANT");
            this.highlightNameIdentifier(phpNamedElement, textAttributesKey);
        }

        public void visitPhpClassReference(@NotNull ClassReference classReference) {
            Intrinsics.checkNotNullParameter((Object)classReference, (String)"classReference");
            if (PhpType.isPrimitiveType((String)classReference.getText())) {
                PsiElement psiElement = (PsiElement)classReference;
                TextAttributesKey textAttributesKey = PhpHighlightingData.KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KEYWORD");
                this.highlight(psiElement, textAttributesKey);
            }
            String string = classReference.getName();
            if (string == null) {
                return;
            }
            String name = string;
            if (PhpLangUtil.isParentReference((String)name) || PhpLangUtil.isSelfReference((String)name) || PhpLangUtil.isStaticReference((String)name)) {
                PsiElement psiElement = (PsiElement)classReference;
                TextAttributesKey textAttributesKey = PhpHighlightingData.KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KEYWORD");
                this.highlight(psiElement, textAttributesKey);
            } else {
                PsiElement psiElement = (PsiElement)classReference;
                TextAttributesKey textAttributesKey = PhpHighlightingData.IDENTIFIER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"IDENTIFIER");
                this.highlight(psiElement, textAttributesKey);
            }
        }

        public void visitPhpFunctionCall(@NotNull FunctionReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            ASTNode aSTNode = reference.getNameNode();
            if (aSTNode == null || (aSTNode = aSTNode.getPsi()) == null) {
                return;
            }
            ASTNode identifier = aSTNode;
            TextAttributesKey textAttributesKey = PhpHighlightingData.FUNCTION_CALL;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"FUNCTION_CALL");
            this.highlight((PsiElement)identifier, textAttributesKey);
        }

        public void visitPhpFieldReference(@NotNull FieldReference fieldReference) {
            ASTNode aSTNode;
            Intrinsics.checkNotNullParameter((Object)fieldReference, (String)"fieldReference");
            PhpExpression phpExpression = fieldReference.getClassReference();
            if (phpExpression != null) {
                phpExpression.accept((PsiElementVisitor)this);
            }
            if ((aSTNode = fieldReference.getNameNode()) == null || (aSTNode = aSTNode.getPsi()) == null) {
                return;
            }
            ASTNode identifier = aSTNode;
            if (fieldReference.getReferenceType().isStatic()) {
                TextAttributesKey textAttributesKey = PhpHighlightingData.STATIC_FIELD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"STATIC_FIELD");
                this.highlight((PsiElement)identifier, textAttributesKey);
            } else {
                TextAttributesKey textAttributesKey = PhpHighlightingData.INSTANCE_FIELD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"INSTANCE_FIELD");
                this.highlight((PsiElement)identifier, textAttributesKey);
            }
        }

        public void visitPhpConstantReference(@NotNull ConstantReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            if (PhpType.isPrimitiveType((String)reference.getText())) {
                PsiElement psiElement = (PsiElement)reference;
                TextAttributesKey textAttributesKey = PhpHighlightingData.KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KEYWORD");
                this.highlight(psiElement, textAttributesKey);
            } else {
                PsiElement psiElement = (PsiElement)reference;
                TextAttributesKey textAttributesKey = PhpHighlightingData.CONSTANT;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CONSTANT");
                this.highlight(psiElement, textAttributesKey);
            }
        }

        public void visitPhpClassConstantReference(@NotNull ClassConstantReference constantReference) {
            ASTNode aSTNode;
            Intrinsics.checkNotNullParameter((Object)constantReference, (String)"constantReference");
            PhpExpression phpExpression = constantReference.getClassReference();
            if (phpExpression != null) {
                phpExpression.accept((PsiElementVisitor)this);
            }
            if ((aSTNode = constantReference.getNameNode()) == null || (aSTNode = aSTNode.getPsi()) == null) {
                return;
            }
            ASTNode identifier = aSTNode;
            if (Intrinsics.areEqual((Object)identifier.getText(), (Object)"class")) {
                TextAttributesKey textAttributesKey = PhpHighlightingData.KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"KEYWORD");
                this.highlight((PsiElement)identifier, textAttributesKey);
            } else {
                TextAttributesKey textAttributesKey = PhpHighlightingData.CONSTANT;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"CONSTANT");
                this.highlight((PsiElement)identifier, textAttributesKey);
            }
        }

        public void visitPhpMethodReference(@NotNull MethodReference reference) {
            ASTNode aSTNode;
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            PhpExpression phpExpression = reference.getClassReference();
            if (phpExpression != null) {
                phpExpression.accept((PsiElementVisitor)this);
            }
            if ((aSTNode = reference.getNameNode()) == null || (aSTNode = aSTNode.getPsi()) == null) {
                return;
            }
            ASTNode identifier = aSTNode;
            if (reference.getReferenceType().isStatic()) {
                TextAttributesKey textAttributesKey = PhpHighlightingData.STATIC_METHOD_CALL;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"STATIC_METHOD_CALL");
                this.highlight((PsiElement)identifier, textAttributesKey);
            } else {
                TextAttributesKey textAttributesKey = PhpHighlightingData.FUNCTION_CALL;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"FUNCTION_CALL");
                this.highlight((PsiElement)identifier, textAttributesKey);
            }
        }

        private final void highlightNameIdentifier(PhpNamedElement element, TextAttributesKey key) {
            PsiElement psiElement = element.getNameIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement nameIdentifier = psiElement;
            this.highlight(nameIdentifier, key);
        }

        private final void highlight(PsiElement element, TextAttributesKey key) {
            block1: {
                HighlightInfoHolder highlightInfoHolder2 = this.holder;
                if (highlightInfoHolder2 == null || (highlightInfoHolder2 = highlightInfoHolder2.getColorsScheme()) == null || (highlightInfoHolder2 = highlightInfoHolder2.getAttributes(key)) == null) {
                    return;
                }
                HighlightInfoHolder attributes = highlightInfoHolder2;
                HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(element.getTextRange()).textAttributes((TextAttributes)attributes);
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"textAttributes(...)");
                HighlightInfo.Builder builder3 = builder2;
                HighlightInfoHolder highlightInfoHolder3 = this.holder;
                if (highlightInfoHolder3 == null) break block1;
                highlightInfoHolder3.add(builder3.createUnconditionally());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void highlight(@NotNull TextRange suggestionRange) {
            Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
            try {
                List list = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.file)).onRange(suggestionRange).toList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
                List elements = list;
                Iterable $this$forEach$iv = elements;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    it.accept((PsiElementVisitor)this);
                }
            }
            finally {
                this.file = null;
                this.holder = null;
            }
        }
    }
}

