/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.feedback;

import com.intellij.codeInsight.inline.completion.InlineCompletionEventAdapter;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventType;
import com.intellij.codeInsight.inline.completion.InlineCompletionProvider;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.impl.feedback.ide.SurveyConfigProvider;
import org.jetbrains.completion.full.line.impl.platform.inline.FullLineInlineCompletionProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u0011*\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0002J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/impl/feedback/ExplicitFeedbackInlineCompletionListener;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventAdapter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "state", "Lorg/jetbrains/completion/full/line/impl/feedback/ExplicitFeedbackInlineCompletionListener$State;", "onRequest", "", "event", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Request;", "onShow", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Show;", "onHide", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionEventType$Hide;", "isCloudProvider", "", "Ljava/lang/Class;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProvider;", "isFeedbackSupported", "State", "intellij.fullLine.core.impl"})
final class ExplicitFeedbackInlineCompletionListener
implements InlineCompletionEventAdapter {
    @NotNull
    private final Editor editor;
    @Nullable
    private State state;

    public ExplicitFeedbackInlineCompletionListener(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    public void onRequest(@NotNull InlineCompletionEventType.Request event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean bl = this.isCloudProvider(event.getProvider());
        Language language = event.getRequest().getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        this.state = new State(bl, false, language, 2, null);
    }

    public void onShow(@NotNull InlineCompletionEventType.Show event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (((CharSequence)event.getElement().getText()).length() > 0) {
            State state = this.state;
            this.state = state != null ? State.copy$default(state, false, true, null, 5, null) : null;
        }
    }

    public void onHide(@NotNull InlineCompletionEventType.Hide event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        State state = this.state;
        if (state == null) {
            return;
        }
        State state2 = state;
        if (this.isFeedbackSupported(state2) && event.isCurrentlyDisplaying() && SurveyConfigProvider.INSTANCE.isSupported()) {
            SurveyConfigProvider.INSTANCE.registerCompletion(event.getFinishType() == InlineCompletionUsageTracker.ShownEvents.FinishType.SELECTED, state2.getLanguage());
        }
        this.state = null;
    }

    private final boolean isCloudProvider(Class<? extends InlineCompletionProvider> $this$isCloudProvider) {
        return $this$isCloudProvider.getName() == FullLineInlineCompletionProvider.class.getName();
    }

    private final boolean isFeedbackSupported(State $this$isFeedbackSupported) {
        return $this$isFeedbackSupported.isCloudProvider() && $this$isFeedbackSupported.getElementsShown();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/completion/full/line/impl/feedback/ExplicitFeedbackInlineCompletionListener$State;", "", "isCloudProvider", "", "elementsShown", "language", "Lcom/intellij/lang/Language;", "<init>", "(ZZLcom/intellij/lang/Language;)V", "()Z", "getElementsShown", "getLanguage", "()Lcom/intellij/lang/Language;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.fullLine.core.impl"})
    private static final class State {
        private final boolean isCloudProvider;
        private final boolean elementsShown;
        @NotNull
        private final Language language;

        public State(boolean isCloudProvider, boolean elementsShown, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.isCloudProvider = isCloudProvider;
            this.elementsShown = elementsShown;
            this.language = language;
        }

        public /* synthetic */ State(boolean bl, boolean bl2, Language language, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2, language);
        }

        public final boolean isCloudProvider() {
            return this.isCloudProvider;
        }

        public final boolean getElementsShown() {
            return this.elementsShown;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        public final boolean component1() {
            return this.isCloudProvider;
        }

        public final boolean component2() {
            return this.elementsShown;
        }

        @NotNull
        public final Language component3() {
            return this.language;
        }

        @NotNull
        public final State copy(boolean isCloudProvider, boolean elementsShown, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new State(isCloudProvider, elementsShown, language);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, boolean bl2, Language language, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isCloudProvider;
            }
            if ((n & 2) != 0) {
                bl2 = state.elementsShown;
            }
            if ((n & 4) != 0) {
                language = state.language;
            }
            return state.copy(bl, bl2, language);
        }

        @NotNull
        public String toString() {
            return "State(isCloudProvider=" + this.isCloudProvider + ", elementsShown=" + this.elementsShown + ", language=" + this.language + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isCloudProvider);
            result2 = result2 * 31 + Boolean.hashCode(this.elementsShown);
            result2 = result2 * 31 + this.language.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.isCloudProvider != state.isCloudProvider) {
                return false;
            }
            if (this.elementsShown != state.elementsShown) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)state.language);
        }
    }
}

