/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HexagonsHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0016J0\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/HexGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "heightUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getHeightUnit", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "setHeightUnit", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;)V", "widthUnit", "getWidthUnit", "setWidthUnit", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "getUnitResolution", "", "unit", "axisAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "heightSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "coordAes", "resolution", "isDiscrete", "", "widthSpan", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nHexGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/HexGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1855#2,2:146\n*S KotlinDebug\n*F\n+ 1 HexGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/HexGeom\n*L\n35#1:146,2\n*E\n"})
public final class HexGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DimensionUnit widthUnit = DEF_WIDTH_UNIT;
    @NotNull
    private DimensionUnit heightUnit = DEF_HEIGHT_UNIT;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final DimensionUnit DEF_WIDTH_UNIT = DimensionUnit.RESOLUTION;
    @NotNull
    private static final DimensionUnit DEF_HEIGHT_UNIT = DimensionUnit.RESOLUTION;
    private static final double HALF_HEX_HEIGHT = 1.0 / Math.sqrt(3.0);

    @NotNull
    public final DimensionUnit getWidthUnit() {
        return this.widthUnit;
    }

    public final void setWidthUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.widthUnit = dimensionUnit;
    }

    @NotNull
    public final DimensionUnit getHeightUnit() {
        return this.heightUnit;
    }

    public final void setHeightUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.heightUnit = dimensionUnit;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Function1 transformWidthToUnits2 = (Function1)new Function1<Double, Double>(this, coord, ctx2){
            final /* synthetic */ HexGeom this$0;
            final /* synthetic */ CoordinateSystem $coord;
            final /* synthetic */ GeomContext $ctx;
            {
                this.this$0 = $receiver;
                this.$coord = $coord;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Double invoke(double w) {
                return w * HexGeom.access$getUnitResolution(this.this$0, this.this$0.getWidthUnit(), Aes.Companion.getX(), this.$coord, this.$ctx);
            }
        };
        Function1 transformHeightToUnits2 = (Function1)new Function1<Double, Double>(this, coord, ctx2){
            final /* synthetic */ HexGeom this$0;
            final /* synthetic */ CoordinateSystem $coord;
            final /* synthetic */ GeomContext $ctx;
            {
                this.this$0 = $receiver;
                this.$coord = $coord;
                this.$ctx = $ctx;
                super(1);
            }

            @NotNull
            public final Double invoke(double h) {
                return h * HexGeom.access$getUnitResolution(this.this$0, this.this$0.getHeightUnit(), Aes.Companion.getY(), this.$coord, this.$ctx);
            }
        };
        HexagonsHelper helper2 = new HexagonsHelper(aesthetics2, pos, coord, ctx2, Companion.clientHexByDataPoint((Function1<? super Double, Double>)transformWidthToUnits2, (Function1<? super Double, Double>)transformHeightToUnits2));
        helper2.setResamplingEnabled(!coord.isLinear());
        Iterable $this$forEach$iv = helper2.createHexagons();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LinePath hexLinePath = (LinePath)element$iv;
            boolean bl = false;
            root.add(hexLinePath.getRootGroup());
        }
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        double d;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        Double d2 = p.finiteOrNull(coordAes);
        if (d2 == null) {
            return null;
        }
        double loc = d2;
        Double d3 = p.finiteOrNull(Aes.Companion.getWIDTH());
        if (d3 == null) {
            return null;
        }
        double width2 = d3;
        switch (WhenMappings.$EnumSwitchMapping$0[this.widthUnit.ordinal()]) {
            case 1: {
                d = width2 * resolution;
                break;
            }
            case 2: {
                d = width2 / 2.0;
                break;
            }
            case 3: {
                d = 0.0;
                break;
            }
            case 4: {
                d = 0.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double expand = d;
        return new DoubleSpan(loc - expand, loc + expand);
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        double d;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        Double d2 = p.finiteOrNull(coordAes);
        if (d2 == null) {
            return null;
        }
        double loc = d2;
        Double d3 = p.finiteOrNull(Aes.Companion.getHEIGHT());
        if (d3 == null) {
            return null;
        }
        double height = d3;
        switch (WhenMappings.$EnumSwitchMapping$0[this.heightUnit.ordinal()]) {
            case 1: {
                d = height * resolution * HALF_HEX_HEIGHT;
                break;
            }
            case 2: {
                d = height * HALF_HEX_HEIGHT;
                break;
            }
            case 3: {
                d = 0.0;
                break;
            }
            case 4: {
                d = 0.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double expand = d;
        return new DoubleSpan(loc - expand, loc + expand);
    }

    private final double getUnitResolution(DimensionUnit unit, Aes<Double> axisAes, CoordinateSystem coord, GeomContext ctx2) {
        double d;
        double d2;
        Aes<Double> aes2 = axisAes;
        if (Intrinsics.areEqual(aes2, Aes.Companion.getX())) {
            d2 = coord.unitSize(new DoubleVector(1.0, 0.0)).getX();
        } else if (Intrinsics.areEqual(aes2, Aes.Companion.getY())) {
            d2 = coord.unitSize(new DoubleVector(0.0, 1.0)).getY();
        } else {
            throw new IllegalStateException(("Unsupported axis aes: " + axisAes).toString());
        }
        double unitSize = d2;
        switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1: {
                double d3;
                Aes<Double> aes3 = axisAes;
                if (Intrinsics.areEqual(aes3, Aes.Companion.getX())) {
                    d3 = ctx2.getResolution(Aes.Companion.getX());
                } else if (Intrinsics.areEqual(aes3, Aes.Companion.getY())) {
                    d3 = HALF_HEX_HEIGHT * ctx2.getResolution(Aes.Companion.getY());
                } else {
                    throw new IllegalStateException(("Unsupported axis aes: " + axisAes).toString());
                }
                double resolution = d3;
                d = 2.0 * resolution;
                break;
            }
            case 2: {
                d = 1.0;
                break;
            }
            case 3: {
                d = 2.2 / unitSize;
                break;
            }
            case 4: {
                d = 1.0 / unitSize;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public static final /* synthetic */ double access$getUnitResolution(HexGeom $this, DimensionUnit unit, Aes axisAes, CoordinateSystem coord, GeomContext ctx2) {
        return $this.getUnitResolution(unit, axisAes, coord, ctx2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/HexGeom$Companion;", "", "()V", "DEF_HEIGHT_UNIT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getDEF_HEIGHT_UNIT", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "DEF_WIDTH_UNIT", "getDEF_WIDTH_UNIT", "HALF_HEX_HEIGHT", "", "HANDLES_GROUPS", "", "clientHexByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "transformWidthToUnits", "transformHeightToUnits", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DimensionUnit getDEF_WIDTH_UNIT() {
            return DEF_WIDTH_UNIT;
        }

        @NotNull
        public final DimensionUnit getDEF_HEIGHT_UNIT() {
            return DEF_HEIGHT_UNIT;
        }

        @NotNull
        public final Function1<DataPointAesthetics, List<DoubleVector>> clientHexByDataPoint(@NotNull Function1<? super Double, Double> transformWidthToUnits2, @NotNull Function1<? super Double, Double> transformHeightToUnits2) {
            Intrinsics.checkNotNullParameter(transformWidthToUnits2, (String)"transformWidthToUnits");
            Intrinsics.checkNotNullParameter(transformHeightToUnits2, (String)"transformHeightToUnits");
            return (Function1)new Function1<DataPointAesthetics, List<? extends DoubleVector>>(transformWidthToUnits2, transformHeightToUnits2){
                final /* synthetic */ Function1<Double, Double> $transformWidthToUnits;
                final /* synthetic */ Function1<Double, Double> $transformHeightToUnits;
                {
                    this.$transformWidthToUnits = $transformWidthToUnits;
                    this.$transformHeightToUnits = $transformHeightToUnits;
                    super(1, Intrinsics.Kotlin.class, "factory", "clientHexByDataPoint$factory(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Ljava/util/List;", 0);
                }

                @Nullable
                public final List<DoubleVector> invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.HexGeom$Companion.access$clientHexByDataPoint$factory(this.$transformWidthToUnits, this.$transformHeightToUnits, p0);
                }
            };
        }

        private static final List<DoubleVector> clientHexByDataPoint$factory(Function1<? super Double, Double> $transformWidthToUnits, Function1<? super Double, Double> $transformHeightToUnits, DataPointAesthetics p) {
            Double d = p.finiteOrNull(Aes.Companion.getX());
            if (d == null) {
                return null;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(Aes.Companion.getY());
            if (d2 == null) {
                return null;
            }
            double y2 = d2;
            Double d3 = p.finiteOrNull(Aes.Companion.getWIDTH());
            if (d3 == null) {
                return null;
            }
            double w = d3;
            Double d4 = p.finiteOrNull(Aes.Companion.getHEIGHT());
            if (d4 == null) {
                return null;
            }
            double h = d4;
            double width2 = ((Number)$transformWidthToUnits.invoke((Object)w)).doubleValue();
            double height = ((Number)$transformHeightToUnits.invoke((Object)h)).doubleValue();
            DoubleVector origin = new DoubleVector(x2, y2);
            Object[] objectArray = new DoubleVector[]{new DoubleVector(origin.getX(), origin.getY() - height * HALF_HEX_HEIGHT), new DoubleVector(origin.getX() + width2 / (double)2, origin.getY() - height * HALF_HEX_HEIGHT / 2.0), new DoubleVector(origin.getX() + width2 / (double)2, origin.getY() + height * HALF_HEX_HEIGHT / 2.0), new DoubleVector(origin.getX(), origin.getY() + height / Math.sqrt(3.0)), new DoubleVector(origin.getX() - width2 / (double)2, origin.getY() + height * HALF_HEX_HEIGHT / 2.0), new DoubleVector(origin.getX() - width2 / (double)2, origin.getY() - height * HALF_HEX_HEIGHT / 2.0), new DoubleVector(origin.getX(), origin.getY() - height * HALF_HEX_HEIGHT)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public static final /* synthetic */ List access$clientHexByDataPoint$factory(Function1 $transformWidthToUnits, Function1 $transformHeightToUnits, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.HexGeom$Companion.clientHexByDataPoint$factory((Function1<? super Double, Double>)$transformWidthToUnits, (Function1<? super Double, Double>)$transformHeightToUnits, p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DimensionUnit.values().length];
            try {
                nArray[DimensionUnit.RESOLUTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.IDENTITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.SIZE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.PIXEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

