/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.cache;

import io.ktor.client.HttpClient;
import io.ktor.client.call.HttpClientCall;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.cache.CacheControl;
import io.ktor.client.plugins.cache.HttpCache;
import io.ktor.client.plugins.cache.HttpCacheEntryKt;
import io.ktor.client.plugins.cache.HttpCacheKt;
import io.ktor.client.plugins.cache.HttpCacheLegacyKt;
import io.ktor.client.plugins.cache.InvalidCacheStateException;
import io.ktor.client.plugins.cache.RequestForCache;
import io.ktor.client.plugins.cache.ValidateStatus;
import io.ktor.client.plugins.cache.storage.CacheStorage;
import io.ktor.client.plugins.cache.storage.CachedResponseData;
import io.ktor.client.plugins.cache.storage.HttpCacheStorage;
import io.ktor.client.plugins.cache.storage.HttpCacheStorageKt;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.request.HttpResponseData;
import io.ktor.client.request.HttpSendPipeline;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.statement.HttpReceivePipeline;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpResponseKt;
import io.ktor.events.EventDefinition;
import io.ktor.http.HeaderValue;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.AttributeKey;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import io.ktor.util.logging.LoggerJvmKt;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.KtorDsl;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 .2\u00020\u0001:\u0002/.B9\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0082@\u00a2\u0006\u0004\b\u0010\u0010\u0011J\"\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0082@\u00a2\u0006\u0004\b\u0014\u0010\u0015J>\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00052\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\"\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 H\u0082@\u00a2\u0006\u0004\b\u001c\u0010\"R \u0010\u0003\u001a\u00020\u00028\u0000X\u0081\u0004\u00a2\u0006\u0012\n\u0004\b\u0003\u0010#\u0012\u0004\b&\u0010'\u001a\u0004\b$\u0010%R \u0010\u0004\u001a\u00020\u00028\u0000X\u0081\u0004\u00a2\u0006\u0012\n\u0004\b\u0004\u0010#\u0012\u0004\b)\u0010'\u001a\u0004\b(\u0010%R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010*R\u0014\u0010\u0007\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010*R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010+R\u001a\u0010\n\u001a\u00020\b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\n\u0010+\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lio/ktor/client/plugins/cache/HttpCache;", "", "Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;", "publicStorage", "privateStorage", "Lio/ktor/client/plugins/cache/storage/CacheStorage;", "publicStorageNew", "privateStorageNew", "", "useOldStorage", "isSharedClient", "<init>", "(Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;Lio/ktor/client/plugins/cache/storage/CacheStorage;Lio/ktor/client/plugins/cache/storage/CacheStorage;ZZ)V", "Lio/ktor/client/statement/HttpResponse;", "response", "Lio/ktor/client/plugins/cache/storage/CachedResponseData;", "cacheResponse", "(Lio/ktor/client/statement/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/client/request/HttpRequest;", "request", "findAndRefresh", "(Lio/ktor/client/request/HttpRequest;Lio/ktor/client/statement/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "storage", "", "", "varyKeys", "Lio/ktor/http/Url;", "url", "findResponse", "(Lio/ktor/client/plugins/cache/storage/CacheStorage;Ljava/util/Map;Lio/ktor/http/Url;Lio/ktor/client/request/HttpRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/client/request/HttpRequestBuilder;", "context", "Lio/ktor/http/content/OutgoingContent;", "content", "(Lio/ktor/client/request/HttpRequestBuilder;Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;", "getPublicStorage$ktor_client_core", "()Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;", "getPublicStorage$ktor_client_core$annotations", "()V", "getPrivateStorage$ktor_client_core", "getPrivateStorage$ktor_client_core$annotations", "Lio/ktor/client/plugins/cache/storage/CacheStorage;", "Z", "isSharedClient$ktor_client_core", "()Z", "Companion", "Config", "ktor-client-core"})
@SourceDebugExtension(value={"SMAP\nHttpCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCache.kt\nio/ktor/client/plugins/cache/HttpCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Attributes.kt\nio/ktor/util/AttributesKt\n+ 6 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,394:1\n1#2:395\n1062#3:396\n295#3:397\n296#3:401\n168#4,3:398\n168#4,3:402\n18#5:405\n58#6,16:406\n*S KotlinDebug\n*F\n+ 1 HttpCache.kt\nio/ktor/client/plugins/cache/HttpCache\n*L\n337#1:396\n337#1:397\n337#1:401\n338#1:398,3\n350#1:402,3\n128#1:405\n128#1:406,16\n*E\n"})
public final class HttpCache {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final HttpCacheStorage publicStorage;
    @NotNull
    private final HttpCacheStorage privateStorage;
    @NotNull
    private final CacheStorage publicStorageNew;
    @NotNull
    private final CacheStorage privateStorageNew;
    private final boolean useOldStorage;
    private final boolean isSharedClient;
    @NotNull
    private static final AttributeKey<HttpCache> key;
    @NotNull
    private static final EventDefinition<HttpResponse> HttpResponseFromCache;

    private HttpCache(HttpCacheStorage publicStorage, HttpCacheStorage privateStorage, CacheStorage publicStorageNew, CacheStorage privateStorageNew, boolean useOldStorage, boolean isSharedClient) {
        this.publicStorage = publicStorage;
        this.privateStorage = privateStorage;
        this.publicStorageNew = publicStorageNew;
        this.privateStorageNew = privateStorageNew;
        this.useOldStorage = useOldStorage;
        this.isSharedClient = isSharedClient;
    }

    @NotNull
    public final HttpCacheStorage getPublicStorage$ktor_client_core() {
        return this.publicStorage;
    }

    @Deprecated(message="This will become internal", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getPublicStorage$ktor_client_core$annotations() {
    }

    @NotNull
    public final HttpCacheStorage getPrivateStorage$ktor_client_core() {
        return this.privateStorage;
    }

    @Deprecated(message="This will become internal", level=DeprecationLevel.ERROR)
    public static /* synthetic */ void getPrivateStorage$ktor_client_core$annotations() {
    }

    public final boolean isSharedClient$ktor_client_core() {
        return this.isSharedClient;
    }

    private final Object cacheResponse(HttpResponse response2, Continuation<? super CachedResponseData> $completion) {
        CacheStorage storage;
        HttpRequest request2 = response2.getCall().getRequest();
        List<HeaderValue> responseCacheControl = HttpMessagePropertiesKt.cacheControl(response2);
        List<HeaderValue> requestCacheControl = HttpMessagePropertiesKt.cacheControl(request2);
        boolean isPrivate = responseCacheControl.contains(CacheControl.INSTANCE.getPRIVATE$ktor_client_core());
        if (isPrivate && this.isSharedClient) {
            return null;
        }
        CacheStorage cacheStorage = storage = isPrivate ? this.privateStorageNew : this.publicStorageNew;
        if (responseCacheControl.contains(CacheControl.INSTANCE.getNO_STORE$ktor_client_core()) || requestCacheControl.contains(CacheControl.INSTANCE.getNO_STORE$ktor_client_core())) {
            return null;
        }
        return HttpCacheStorageKt.store(storage, response2, HttpCacheEntryKt.varyKeys(response2), this.isSharedClient, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object findAndRefresh(HttpRequest var1_1, HttpResponse var2_2, Continuation<? super HttpResponse> $completion) {
        if (!($completion instanceof findAndRefresh.1)) ** GOTO lbl-1000
        var14_4 = $completion;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ HttpCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpCache.access$findAndRefresh(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                url = response.getCall().getRequest().getUrl();
                cacheControl = HttpMessagePropertiesKt.cacheControl(response);
                isPrivate = cacheControl.contains(CacheControl.INSTANCE.getPRIVATE$ktor_client_core());
                if (isPrivate && this.isSharedClient) {
                    return null;
                }
                storage = isPrivate != false ? this.privateStorageNew : this.publicStorageNew;
                varyKeysFrom304 = HttpCacheEntryKt.varyKeys(response);
                $continuation.L$0 = this;
                $continuation.L$1 = request;
                $continuation.L$2 = response;
                $continuation.L$3 = storage;
                $continuation.L$4 = varyKeysFrom304;
                $continuation.label = 1;
                v0 = this.findResponse(storage, varyKeysFrom304, url, request, (Continuation<? super CachedResponseData>)$continuation);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl38
            }
            case 1: {
                varyKeysFrom304 = (Map<String, String>)$continuation.L$4;
                storage = (CacheStorage)$continuation.L$3;
                response = (HttpResponse)$continuation.L$2;
                request = (HttpRequest)$continuation.L$1;
                this = (HttpCache)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                v1 = (CachedResponseData)v0;
                if (v1 == null) {
                    return null;
                }
                cache = v1;
                var11_13 = varyKeysFrom304;
                if (var11_13.isEmpty()) {
                    $i$a$-ifEmpty-HttpCache$findAndRefresh$newVaryKeys$1 = false;
                    v2 = cache.getVaryKeys();
                } else {
                    v2 = var11_13;
                }
                newVaryKeys = v2;
                $continuation.L$0 = request;
                $continuation.L$1 = response;
                $continuation.L$2 = cache;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v3 = storage.store(request.getUrl(), cache.copy$ktor_client_core(newVaryKeys, HttpCacheEntryKt.cacheExpires$default(response, this.isSharedClient, null, 2, null)), (Continuation<? super Unit>)$continuation);
                if (v3 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl65
            }
            case 2: {
                cache = (CachedResponseData)$continuation.L$2;
                response = (HttpResponse)$continuation.L$1;
                request = (HttpRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl65:
                // 2 sources

                return HttpCacheStorageKt.createResponse(cache, request.getCall().getClient(), request, response.getCoroutineContext());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object findResponse(CacheStorage var1_1, Map<String, String> var2_2, Url var3_3, HttpRequest var4_4, Continuation<? super CachedResponseData> $completion) {
        if (!($completion instanceof findResponse.1)) ** GOTO lbl-1000
        var22_6 = $completion;
        if ((var22_6.label & -2147483648) != 0) {
            var22_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ HttpCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpCache.access$findResponse(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var23_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(varyKeys.isEmpty() == false)) break;
                $continuation.label = 1;
                v0 = storage.find((Url)url, (Map<String, String>)varyKeys, (Continuation<? super CachedResponseData>)$continuation);
                if (v0 == var23_8) {
                    return var23_8;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return v0;
            }
        }
        $continuation.L$0 = requestHeaders = HttpCacheKt.mergedHeadersLookup(request.getContent(), (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)request.getHeaders()){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Headers)this.receiver).get(p0);
            }
        }), (Function1<? super String, ? extends List<String>>)((Function1)new Function1<String, List<? extends String>>((Object)request.getHeaders()){

            public final List<String> invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Headers)this.receiver).getAll(p0);
            }
        }));
        $continuation.label = 2;
        v1 = storage.findAll((Url)url, (Continuation<? super Set<CachedResponseData>>)$continuation);
        if (v1 == var23_8) {
            return var23_8;
        }
        ** GOTO lbl33
        {
            case 2: {
                requestHeaders = (Function1<String, String>)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                $this$sortedByDescending$iv = (Iterable)v1;
                $i$f$sortedByDescending = false;
                $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CachedResponseData it = (CachedResponseData)b;
                        boolean bl = false;
                        Comparable comparable = it.getResponseTime();
                        it = (CachedResponseData)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getResponseTime());
                    }
                });
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    cachedResponse = (CachedResponseData)element$iv;
                    $i$a$-firstOrNull-HttpCache$findResponse$3 = false;
                    $this$all$iv = cachedResponse.getVaryKeys();
                    $i$f$all = false;
                    if (!$this$all$iv.isEmpty()) ** GOTO lbl45
                    v2 = true;
                    ** GOTO lbl56
lbl45:
                    // 1 sources

                    var15_18 = $this$all$iv.entrySet().iterator();
                    while (var15_18.hasNext()) {
                        var17_20 = element$iv = var15_18.next();
                        $i$a$-all-HttpCache$findResponse$3$1 = false;
                        key = var17_20.getKey();
                        value = var17_20.getValue();
                        if (Intrinsics.areEqual((Object)requestHeaders.invoke((Object)key), (Object)value)) continue;
                        v2 = false;
                        ** GOTO lbl56
                    }
                    v2 = true;
lbl56:
                    // 3 sources

                    if (!v2) continue;
                    v3 = element$iv;
                    ** GOTO lbl60
                }
                v3 = null;
lbl60:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object findResponse(HttpRequestBuilder var1_1, OutgoingContent var2_2, Continuation<? super CachedResponseData> $completion) {
        if (!($completion instanceof findResponse.4)) ** GOTO lbl-1000
        var20_4 = $completion;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ HttpCache this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpCache.access$findResponse(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                url = URLUtilsKt.Url(context.getUrl());
                lookup = HttpCacheKt.mergedHeadersLookup((OutgoingContent)content, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)context.getHeaders()){

                    public final String invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((HeadersBuilder)this.receiver).get(p0);
                    }
                }), (Function1<? super String, ? extends List<String>>)((Function1)new Function1<String, List<? extends String>>((Object)context.getHeaders()){

                    public final List<String> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((HeadersBuilder)this.receiver).getAll(p0);
                    }
                }));
                $continuation.L$0 = this;
                $continuation.L$1 = url;
                $continuation.L$2 = lookup;
                $continuation.label = 1;
                v0 = this.privateStorageNew.findAll(url, (Continuation<? super Set<CachedResponseData>>)$continuation);
                if (v0 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                lookup = (Function1<String, String>)$continuation.L$2;
                url = (Url)$continuation.L$1;
                this = (HttpCache)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                var18_9 = (Set)v0;
                $continuation.L$0 = lookup;
                $continuation.L$1 = var18_9;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = this.publicStorageNew.findAll(url, (Continuation<? super Set<CachedResponseData>>)$continuation);
                if (v1 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl42
            }
            case 2: {
                var18_9 = (Set)$continuation.L$1;
                lookup = (Function1)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                cachedResponses = SetsKt.plus((Set)var18_9, (Iterable)((Iterable)v1));
                for (CachedResponseData item : cachedResponses) {
                    varyKeys = item.getVaryKeys();
                    if (varyKeys.isEmpty()) ** GOTO lbl62
                    $this$all$iv = varyKeys;
                    $i$f$all = false;
                    if (!$this$all$iv.isEmpty()) ** GOTO lbl51
                    v2 = true;
                    ** GOTO lbl61
lbl51:
                    // 1 sources

                    var12_16 = $this$all$iv.entrySet().iterator();
                    while (var12_16.hasNext()) {
                        var14_18 = element$iv = var12_16.next();
                        $i$a$-all-HttpCache$findResponse$5 = false;
                        key = var14_18.getKey();
                        value = var14_18.getValue();
                        if (Intrinsics.areEqual((Object)lookup.invoke((Object)key), (Object)value)) continue;
                        v2 = false;
                        ** GOTO lbl61
                    }
                    v2 = true;
lbl61:
                    // 3 sources

                    if (!v2) continue;
lbl62:
                    // 2 sources

                    return item;
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ boolean access$getUseOldStorage$p(HttpCache $this) {
        return $this.useOldStorage;
    }

    public static final /* synthetic */ Object access$findResponse(HttpCache $this, HttpRequestBuilder context, OutgoingContent content2, Continuation $completion) {
        return $this.findResponse(context, content2, (Continuation<? super CachedResponseData>)$completion);
    }

    public static final /* synthetic */ Object access$cacheResponse(HttpCache $this, HttpResponse response2, Continuation $completion) {
        return $this.cacheResponse(response2, (Continuation<? super CachedResponseData>)$completion);
    }

    public static final /* synthetic */ Object access$findAndRefresh(HttpCache $this, HttpRequest request2, HttpResponse response2, Continuation $completion) {
        return $this.findAndRefresh(request2, response2, (Continuation<? super HttpResponse>)$completion);
    }

    public /* synthetic */ HttpCache(HttpCacheStorage publicStorage, HttpCacheStorage privateStorage, CacheStorage publicStorageNew, CacheStorage privateStorageNew, boolean useOldStorage, boolean isSharedClient, DefaultConstructorMarker $constructor_marker) {
        this(publicStorage, privateStorage, publicStorageNew, privateStorageNew, useOldStorage, isSharedClient);
    }

    public static final /* synthetic */ Object access$findResponse(HttpCache $this, CacheStorage storage, Map varyKeys, Url url, HttpRequest request2, Continuation $completion) {
        return $this.findResponse(storage, varyKeys, url, request2, (Continuation<? super CachedResponseData>)$completion);
    }

    static {
        KType kType;
        Companion = new Companion(null);
        String name$iv = "HttpCache";
        boolean $i$f$AttributeKey = false;
        String string = name$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(HttpCache.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(HttpCache.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        String string2 = string;
        key = new AttributeKey(string2, typeInfo);
        HttpResponseFromCache = new EventDefinition();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\n\u001a\u00020\u00032\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J0\u0010\u0018\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014H\u0080@\u00a2\u0006\u0004\b\u0016\u0010\u0017J8\u0010\u001d\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0004\b\u001d\u0010\u001eJ(\u0010!\u001a\u00020\u0007*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u000e\u001a\u00020\rH\u0080@\u00a2\u0006\u0004\b\u001f\u0010 R \u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\"8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u001d\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lio/ktor/client/plugins/cache/HttpCache$Companion;", "Lio/ktor/client/plugins/HttpClientPlugin;", "Lio/ktor/client/plugins/cache/HttpCache$Config;", "Lio/ktor/client/plugins/cache/HttpCache;", "<init>", "()V", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "prepare", "(Lkotlin/jvm/functions/Function1;)Lio/ktor/client/plugins/cache/HttpCache;", "plugin", "Lio/ktor/client/HttpClient;", "scope", "install", "(Lio/ktor/client/plugins/cache/HttpCache;Lio/ktor/client/HttpClient;)V", "Lio/ktor/util/pipeline/PipelineContext;", "", "Lio/ktor/client/request/HttpRequestBuilder;", "Lio/ktor/client/call/HttpClientCall;", "cachedCall", "proceedWithCache$ktor_client_core", "(Lio/ktor/util/pipeline/PipelineContext;Lio/ktor/client/HttpClient;Lio/ktor/client/call/HttpClientCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "proceedWithCache", "Lio/ktor/client/plugins/cache/storage/CachedResponseData;", "cachedResponse", "Lkotlin/coroutines/CoroutineContext;", "callContext", "proceedWithWarning", "(Lio/ktor/util/pipeline/PipelineContext;Lio/ktor/client/plugins/cache/storage/CachedResponseData;Lio/ktor/client/HttpClient;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "proceedWithMissingCache$ktor_client_core", "(Lio/ktor/util/pipeline/PipelineContext;Lio/ktor/client/HttpClient;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "proceedWithMissingCache", "Lio/ktor/util/AttributeKey;", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "Lio/ktor/events/EventDefinition;", "Lio/ktor/client/statement/HttpResponse;", "HttpResponseFromCache", "Lio/ktor/events/EventDefinition;", "getHttpResponseFromCache", "()Lio/ktor/events/EventDefinition;", "ktor-client-core"})
    @SourceDebugExtension(value={"SMAP\nHttpCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCache.kt\nio/ktor/client/plugins/cache/HttpCache$Companion\n+ 2 Headers.kt\nio/ktor/http/Headers$Companion\n*L\n1#1,394:1\n23#2:395\n*S KotlinDebug\n*F\n+ 1 HttpCache.kt\nio/ktor/client/plugins/cache/HttpCache$Companion\n*L\n255#1:395\n*E\n"})
    public static final class Companion
    implements HttpClientPlugin<Config, HttpCache> {
        private Companion() {
        }

        @Override
        @NotNull
        public AttributeKey<HttpCache> getKey() {
            return key;
        }

        @NotNull
        public final EventDefinition<HttpResponse> getHttpResponseFromCache() {
            return HttpResponseFromCache;
        }

        @Override
        @NotNull
        public HttpCache prepare(@NotNull Function1<? super Config, Unit> block) {
            Config config2;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Config config3 = new Config();
            block.invoke((Object)config3);
            Config $this$prepare_u24lambda_u240 = config2 = config3;
            boolean bl = false;
            return new HttpCache($this$prepare_u24lambda_u240.getPublicStorage(), $this$prepare_u24lambda_u240.getPrivateStorage(), $this$prepare_u24lambda_u240.getPublicStorageNew$ktor_client_core(), $this$prepare_u24lambda_u240.getPrivateStorageNew$ktor_client_core(), $this$prepare_u24lambda_u240.getUseOldStorage$ktor_client_core(), $this$prepare_u24lambda_u240.isShared(), null);
        }

        @Override
        public void install(@NotNull HttpCache plugin, @NotNull HttpClient scope) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            PipelinePhase cacheRequestPhase = new PipelinePhase("Cache");
            scope.getSendPipeline().insertPhaseAfter(HttpSendPipeline.Phases.getState(), cacheRequestPhase);
            scope.getSendPipeline().intercept(cacheRequestPhase, (Function3)new Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object>(plugin, scope, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ HttpCache $plugin;
                final /* synthetic */ HttpClient $scope;
                {
                    this.$plugin = $plugin;
                    this.$scope = $scope;
                    super(3, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block24: {
                        block23: {
                            var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$intercept = (PipelineContext)this.L$0;
                                    content = this.L$1;
                                    if (!(content instanceof OutgoingContent.NoContent)) {
                                        return Unit.INSTANCE;
                                    }
                                    if (!Intrinsics.areEqual((Object)((HttpRequestBuilder)$this$intercept.getContext()).getMethod(), (Object)HttpMethod.Companion.getGet()) || !HttpCacheKt.access$canStore(((HttpRequestBuilder)$this$intercept.getContext()).getUrl().getProtocol())) {
                                        return Unit.INSTANCE;
                                    }
                                    if (this.$plugin.isSharedClient$ktor_client_core() && ((HttpRequestBuilder)$this$intercept.getContext()).getHeaders().contains(HttpHeaders.INSTANCE.getAuthorization())) {
                                        return Unit.INSTANCE;
                                    }
                                    if (!HttpCache.access$getUseOldStorage$p(this.$plugin)) break;
                                    this.L$0 = null;
                                    this.label = 1;
                                    v0 = HttpCacheLegacyKt.interceptSendLegacy($this$intercept, this.$plugin, (OutgoingContent)content, this.$scope, (Continuation<? super Unit>)((Continuation)this));
                                    if (v0 == var15_2) {
                                        return var15_2;
                                    }
                                    ** GOTO lbl23
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl23:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            this.L$0 = $this$intercept;
                            this.label = 2;
                            v1 = HttpCache.access$findResponse(this.$plugin, (HttpRequestBuilder)$this$intercept.getContext(), (OutgoingContent)content, (Continuation)this);
                            if (v1 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl34
                            {
                                case 2: {
                                    $this$intercept = (PipelineContext)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl34:
                                    // 2 sources

                                    if ((cache = (CachedResponseData)v1) != null) break;
                                    $this$trace$iv = HttpCacheKt.getLOGGER();
                                    $i$f$trace = false;
                                    if (LoggerJvmKt.isTraceEnabled($this$trace$iv)) {
                                        var14_11 = $this$trace$iv;
                                        $i$a$-trace-HttpCache$Companion$install$1$1 = false;
                                        var14_11.trace("No cached response for " + ((HttpRequestBuilder)$this$intercept.getContext()).getUrl() + " found");
                                    }
                                    header = HttpHeaderValueParserKt.parseHeaderValue(((HttpRequestBuilder)$this$intercept.getContext()).getHeaders().get(HttpHeaders.INSTANCE.getCacheControl()));
                                    if (header.contains(CacheControl.INSTANCE.getONLY_IF_CACHED$ktor_client_core())) {
                                        $this$trace$iv = HttpCacheKt.getLOGGER();
                                        $i$f$trace = false;
                                        if (LoggerJvmKt.isTraceEnabled($this$trace$iv)) {
                                            var14_11 = $this$trace$iv;
                                            $i$a$-trace-HttpCache$Companion$install$1$2 = false;
                                            var14_11.trace("No cache found and \"only-if-cached\" set for " + ((HttpRequestBuilder)$this$intercept.getContext()).getUrl());
                                        }
                                        this.L$0 = null;
                                        this.label = 3;
                                        v2 = HttpCache.Companion.proceedWithMissingCache$ktor_client_core($this$intercept, this.$scope, (Continuation<? super Unit>)((Continuation)this));
                                        if (v2 == var15_2) {
                                            return var15_2;
                                        }
                                    }
                                    ** GOTO lbl60
                                }
                                case 3: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl60:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            validateStatus = HttpCacheEntryKt.shouldValidate(cache.getExpires(), cache.getHeaders(), (HttpRequestBuilder)$this$intercept.getContext());
                            if (validateStatus != ValidateStatus.ShouldNotValidate) break block23;
                            cachedCall = HttpCacheStorageKt.createResponse(cache, this.$scope, new RequestForCache(((HttpRequestBuilder)$this$intercept.getContext()).build()), (CoroutineContext)((HttpRequestBuilder)$this$intercept.getContext()).getExecutionContext()).getCall();
                            this.L$0 = null;
                            this.label = 4;
                            v3 = HttpCache.Companion.proceedWithCache$ktor_client_core($this$intercept, this.$scope, cachedCall, (Continuation<? super Unit>)((Continuation)this));
                            if (v3 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl73
                            {
                                case 4: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v3 = $result;
lbl73:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        if (validateStatus != ValidateStatus.ShouldWarn) break block24;
                        this.L$0 = null;
                        this.label = 5;
                        v4 = io.ktor.client.plugins.cache.HttpCache$Companion.access$proceedWithWarning(HttpCache.Companion, $this$intercept, cache, this.$scope, (CoroutineContext)((HttpRequestBuilder)$this$intercept.getContext()).getExecutionContext(), (Continuation)this);
                        if (v4 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl85
                        {
                            case 5: {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl85:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                    }
                    v5 = cache.getHeaders().get(HttpHeaders.INSTANCE.getETag());
                    if (v5 != null) {
                        etag = v5;
                        $i$a$-let-HttpCache$Companion$install$1$3 = false;
                        $this$trace$iv = HttpCacheKt.getLOGGER();
                        $i$f$trace = false;
                        if (LoggerJvmKt.isTraceEnabled($this$trace$iv)) {
                            var12_18 = $this$trace$iv;
                            $i$a$-trace-HttpCache$Companion$install$1$3$1 = false;
                            var12_18.trace("Adding If-None-Match=" + etag + " for " + ((HttpRequestBuilder)$this$intercept.getContext()).getUrl());
                        }
                        UtilsKt.header((HttpMessageBuilder)$this$intercept.getContext(), HttpHeaders.INSTANCE.getIfNoneMatch(), etag);
                    }
                    v6 = cache.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
                    if (v6 != null) {
                        it = v6;
                        $i$a$-let-HttpCache$Companion$install$1$4 = false;
                        $this$trace$iv = HttpCacheKt.getLOGGER();
                        $i$f$trace = false;
                        if (LoggerJvmKt.isTraceEnabled($this$trace$iv)) {
                            var12_18 = $this$trace$iv;
                            $i$a$-trace-HttpCache$Companion$install$1$4$1 = false;
                            var12_18.trace("Adding If-Modified-Since=" + it + " for " + ((HttpRequestBuilder)$this$intercept.getContext()).getUrl());
                        }
                        UtilsKt.header((HttpMessageBuilder)$this$intercept.getContext(), HttpHeaders.INSTANCE.getIfModifiedSince(), it);
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(PipelineContext<Object, HttpRequestBuilder> p1, Object p2, Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, HttpRequestBuilder>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            PipelinePhase cacheResponsePhase = new PipelinePhase("Cache");
            scope.getReceivePipeline().insertPhaseAfter(HttpReceivePipeline.Phases.getState(), cacheResponsePhase);
            scope.getReceivePipeline().intercept(cacheResponsePhase, (Function3)new Function3<PipelineContext<HttpResponse, Unit>, HttpResponse, Continuation<? super Unit>, Object>(plugin, scope, null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;
                final /* synthetic */ HttpCache $plugin;
                final /* synthetic */ HttpClient $scope;
                {
                    this.$plugin = $plugin;
                    this.$scope = $scope;
                    super(3, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block17: {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$intercept = (PipelineContext)this.L$0;
                                response = (HttpResponse)this.L$1;
                                if (!Intrinsics.areEqual((Object)response.getCall().getRequest().getMethod(), (Object)HttpMethod.Companion.getGet())) {
                                    return Unit.INSTANCE;
                                }
                                if (!HttpCache.access$getUseOldStorage$p(this.$plugin)) break;
                                this.L$0 = null;
                                this.label = 1;
                                v0 = HttpCacheLegacyKt.interceptReceiveLegacy($this$intercept, response, this.$plugin, this.$scope, (Continuation<? super Unit>)((Continuation)this));
                                if (v0 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl19
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl19:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        if (!HttpStatusCodeKt.isSuccess(response.getStatus())) break block17;
                        $this$trace$iv = HttpCacheKt.getLOGGER();
                        $i$f$trace = false;
                        if (LoggerJvmKt.isTraceEnabled($this$trace$iv)) {
                            var7_8 = $this$trace$iv;
                            $i$a$-trace-HttpCache$Companion$install$2$1 = false;
                            var7_8.trace("Caching response for " + response.getCall().getRequest().getUrl());
                        }
                        this.L$0 = $this$intercept;
                        this.L$1 = response;
                        this.label = 2;
                        v1 = HttpCache.access$cacheResponse(this.$plugin, response, (Continuation)this);
                        if (v1 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl40
                        {
                            case 2: {
                                response = (HttpResponse)this.L$1;
                                $this$intercept = (PipelineContext)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl40:
                                // 2 sources

                                if ((cachedData = (CachedResponseData)v1) == null) break;
                                reusableResponse = HttpCacheStorageKt.createResponse(cachedData, this.$scope, HttpResponseKt.getRequest(response), response.getCoroutineContext());
                                this.L$0 = null;
                                this.L$1 = null;
                                this.label = 3;
                                v2 = $this$intercept.proceedWith(reusableResponse, (Continuation)this);
                                if (v2 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl52
                            }
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl52:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                    }
                    if (!Intrinsics.areEqual((Object)response.getStatus(), (Object)HttpStatusCode.Companion.getNotModified())) ** GOTO lbl89
                    $this$trace$iv = HttpCacheKt.getLOGGER();
                    $i$f$trace = false;
                    if (LoggerJvmKt.isTraceEnabled($this$trace$iv)) {
                        var7_8 = $this$trace$iv;
                        $i$a$-trace-HttpCache$Companion$install$2$2 = false;
                        var7_8.trace("Not modified response for " + response.getCall().getRequest().getUrl() + ", replying from cache");
                    }
                    this.L$0 = $this$intercept;
                    this.L$1 = response;
                    this.label = 4;
                    v3 = HttpCache.access$findAndRefresh(this.$plugin, response.getCall().getRequest(), response, (Continuation)this);
                    if (v3 == var8_2) {
                        return var8_2;
                    }
                    ** GOTO lbl74
                    {
                        case 4: {
                            response = (HttpResponse)this.L$1;
                            $this$intercept = (PipelineContext)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl74:
                            // 2 sources

                            v4 = (HttpResponse)v3;
                            if (v4 == null) {
                                throw new InvalidCacheStateException(response.getCall().getRequest().getUrl());
                            }
                            responseFromCache = v4;
                            this.$scope.getMonitor().raise(HttpCache.Companion.getHttpResponseFromCache(), responseFromCache);
                            this.L$0 = null;
                            this.L$1 = null;
                            this.label = 5;
                            v5 = $this$intercept.proceedWith(responseFromCache, (Continuation)this);
                            if (v5 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl89
                        }
                        case 5: {
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl89:
                            // 3 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(PipelineContext<HttpResponse, Unit> p1, HttpResponse p2, Continuation<? super Unit> p3) {
                    Function3<PipelineContext<HttpResponse, Unit>, HttpResponse, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
        }

        @Nullable
        public final Object proceedWithCache$ktor_client_core(@NotNull PipelineContext<Object, HttpRequestBuilder> $this$proceedWithCache, @NotNull HttpClient scope, @NotNull HttpClientCall cachedCall, @NotNull Continuation<? super Unit> $completion) {
            $this$proceedWithCache.finish();
            scope.getMonitor().raise(this.getHttpResponseFromCache(), cachedCall.getResponse());
            Object object = $this$proceedWithCache.proceedWith(cachedCall, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private final Object proceedWithWarning(PipelineContext<Object, HttpRequestBuilder> $this$proceedWithWarning, CachedResponseData cachedResponse, HttpClient scope, CoroutineContext callContext, Continuation<? super Unit> $completion) {
            void $this$proceedWithWarning_u24lambda_u241;
            HeadersBuilder headersBuilder;
            HttpRequestData request2 = $this$proceedWithWarning.getContext().build();
            Headers.Companion this_$iv = Headers.Companion;
            boolean $i$f$build = false;
            HeadersBuilder headersBuilder2 = headersBuilder = new HeadersBuilder(0, 1, null);
            GMTDate gMTDate = cachedResponse.getRequestTime();
            HttpStatusCode httpStatusCode = cachedResponse.getStatusCode();
            boolean bl = false;
            $this$proceedWithWarning_u24lambda_u241.appendAll(cachedResponse.getHeaders());
            $this$proceedWithWarning_u24lambda_u241.append(HttpHeaders.INSTANCE.getWarning(), "110");
            Unit unit = Unit.INSTANCE;
            CoroutineContext coroutineContext = callContext;
            ByteReadChannel byteReadChannel = ByteChannelCtorKt.ByteReadChannel$default(cachedResponse.getBody(), 0, 0, 6, null);
            HttpProtocolVersion httpProtocolVersion = cachedResponse.getVersion();
            Headers headers = headersBuilder.build();
            GMTDate gMTDate2 = gMTDate;
            HttpStatusCode httpStatusCode2 = httpStatusCode;
            HttpResponseData response2 = new HttpResponseData(httpStatusCode2, gMTDate2, headers, httpProtocolVersion, byteReadChannel, coroutineContext);
            HttpClientCall call = new HttpClientCall(scope, request2, response2);
            $this$proceedWithWarning.finish();
            scope.getMonitor().raise(this.getHttpResponseFromCache(), call.getResponse());
            Object object = $this$proceedWithWarning.proceedWith(call, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @Nullable
        public final Object proceedWithMissingCache$ktor_client_core(@NotNull PipelineContext<Object, HttpRequestBuilder> $this$proceedWithMissingCache, @NotNull HttpClient scope, @NotNull Continuation<? super Unit> $completion) {
            $this$proceedWithMissingCache.finish();
            HttpRequestData request2 = $this$proceedWithMissingCache.getContext().build();
            HttpResponseData response2 = new HttpResponseData(HttpStatusCode.Companion.getGatewayTimeout(), DateJvmKt.GMTDate$default(null, 1, null), Headers.Companion.getEmpty(), HttpProtocolVersion.Companion.getHTTP_1_1(), ByteChannelCtorKt.ByteReadChannel$default(new byte[0], 0, 0, 6, null), (CoroutineContext)request2.getExecutionContext());
            HttpClientCall call = new HttpClientCall(scope, request2, response2);
            Object object = $this$proceedWithMissingCache.proceedWith(call, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$proceedWithWarning(Companion $this, PipelineContext $receiver, CachedResponseData cachedResponse, HttpClient scope, CoroutineContext callContext, Continuation $completion) {
            return $this.proceedWithWarning($receiver, cachedResponse, scope, callContext, (Continuation<? super Unit>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @KtorDsl
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bR\"\u0010\n\u001a\u00020\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\bR\"\u0010\u000f\u001a\u00020\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\bR\"\u0010\u0013\u001a\u00020\u00128\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R0\u0010\u0007\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b8\u0006@FX\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u0007\u0010\u001d\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R0\u0010\t\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b8\u0006@FX\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\t\u0010\u001d\u0012\u0004\b%\u0010\u0003\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!\u00a8\u0006&"}, d2={"Lio/ktor/client/plugins/cache/HttpCache$Config;", "", "<init>", "()V", "Lio/ktor/client/plugins/cache/storage/CacheStorage;", "storage", "", "publicStorage", "(Lio/ktor/client/plugins/cache/storage/CacheStorage;)V", "privateStorage", "publicStorageNew", "Lio/ktor/client/plugins/cache/storage/CacheStorage;", "getPublicStorageNew$ktor_client_core", "()Lio/ktor/client/plugins/cache/storage/CacheStorage;", "setPublicStorageNew$ktor_client_core", "privateStorageNew", "getPrivateStorageNew$ktor_client_core", "setPrivateStorageNew$ktor_client_core", "", "useOldStorage", "Z", "getUseOldStorage$ktor_client_core", "()Z", "setUseOldStorage$ktor_client_core", "(Z)V", "isShared", "setShared", "Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;", "value", "Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;", "getPublicStorage", "()Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;", "setPublicStorage", "(Lio/ktor/client/plugins/cache/storage/HttpCacheStorage;)V", "getPublicStorage$annotations", "getPrivateStorage", "setPrivateStorage", "getPrivateStorage$annotations", "ktor-client-core"})
    public static final class Config {
        @NotNull
        private CacheStorage publicStorageNew = (CacheStorage)CacheStorage.Companion.getUnlimited().invoke();
        @NotNull
        private CacheStorage privateStorageNew = (CacheStorage)CacheStorage.Companion.getUnlimited().invoke();
        private boolean useOldStorage;
        private boolean isShared;
        @NotNull
        private HttpCacheStorage publicStorage = (HttpCacheStorage)HttpCacheStorage.Companion.getUnlimited().invoke();
        @NotNull
        private HttpCacheStorage privateStorage = (HttpCacheStorage)HttpCacheStorage.Companion.getUnlimited().invoke();

        @NotNull
        public final CacheStorage getPublicStorageNew$ktor_client_core() {
            return this.publicStorageNew;
        }

        public final void setPublicStorageNew$ktor_client_core(@NotNull CacheStorage cacheStorage) {
            Intrinsics.checkNotNullParameter((Object)cacheStorage, (String)"<set-?>");
            this.publicStorageNew = cacheStorage;
        }

        @NotNull
        public final CacheStorage getPrivateStorageNew$ktor_client_core() {
            return this.privateStorageNew;
        }

        public final void setPrivateStorageNew$ktor_client_core(@NotNull CacheStorage cacheStorage) {
            Intrinsics.checkNotNullParameter((Object)cacheStorage, (String)"<set-?>");
            this.privateStorageNew = cacheStorage;
        }

        public final boolean getUseOldStorage$ktor_client_core() {
            return this.useOldStorage;
        }

        public final void setUseOldStorage$ktor_client_core(boolean bl) {
            this.useOldStorage = bl;
        }

        public final boolean isShared() {
            return this.isShared;
        }

        public final void setShared(boolean bl) {
            this.isShared = bl;
        }

        @NotNull
        public final HttpCacheStorage getPublicStorage() {
            return this.publicStorage;
        }

        public final void setPublicStorage(@NotNull HttpCacheStorage value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.useOldStorage = true;
            this.publicStorage = value;
        }

        @Deprecated(message="This will become internal. Use setter method instead with new storage interface", level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getPublicStorage$annotations() {
        }

        @NotNull
        public final HttpCacheStorage getPrivateStorage() {
            return this.privateStorage;
        }

        public final void setPrivateStorage(@NotNull HttpCacheStorage value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.useOldStorage = true;
            this.privateStorage = value;
        }

        @Deprecated(message="This will become internal. Use setter method instead with new storage interface", level=DeprecationLevel.ERROR)
        public static /* synthetic */ void getPrivateStorage$annotations() {
        }

        public final void publicStorage(@NotNull CacheStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.publicStorageNew = storage;
        }

        public final void privateStorage(@NotNull CacheStorage storage) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            this.privateStorageNew = storage;
        }
    }
}

