/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.api;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.scientific.tables.api.FilterComparisonType;
import com.intellij.scientific.tables.api.FilterOperator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \n2\u00020\u0001:\u0004\u0007\b\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0082\u0001\u0003\u000b\f\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/scientific/tables/api/FilterExpression;", "", "<init>", "()V", "getFlatFilterExpression", "", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "SingleExpression", "Or", "And", "Companion", "Lcom/intellij/scientific/tables/api/FilterExpression$And;", "Lcom/intellij/scientific/tables/api/FilterExpression$Or;", "intellij.scientific.tables"})
public abstract class FilterExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FilterExpression() {
    }

    @NotNull
    public final List<SingleExpression> getFlatFilterExpression() {
        List list;
        FilterExpression filterExpression = this;
        if (filterExpression instanceof SingleExpression) {
            list = CollectionsKt.listOf((Object)this);
        } else if (filterExpression instanceof Or) {
            list = CollectionsKt.plus((Collection)((Or)this).getLeft().getFlatFilterExpression(), (Iterable)((Or)this).getRight().getFlatFilterExpression());
        } else if (filterExpression instanceof And) {
            list = CollectionsKt.plus((Collection)((And)this).getLeft().getFlatFilterExpression(), (Iterable)((And)this).getRight().getFlatFilterExpression());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    public /* synthetic */ FilterExpression(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/scientific/tables/api/FilterExpression$And;", "Lcom/intellij/scientific/tables/api/FilterExpression;", "left", "right", "<init>", "(Lcom/intellij/scientific/tables/api/FilterExpression;Lcom/intellij/scientific/tables/api/FilterExpression;)V", "getLeft", "()Lcom/intellij/scientific/tables/api/FilterExpression;", "getRight", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.scientific.tables"})
    public static final class And
    extends FilterExpression {
        @NotNull
        private final FilterExpression left;
        @NotNull
        private final FilterExpression right;

        public And(@NotNull FilterExpression left, @NotNull FilterExpression right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            super(null);
            this.left = left;
            this.right = right;
        }

        @NotNull
        public final FilterExpression getLeft() {
            return this.left;
        }

        @NotNull
        public final FilterExpression getRight() {
            return this.right;
        }

        @NotNull
        public final FilterExpression component1() {
            return this.left;
        }

        @NotNull
        public final FilterExpression component2() {
            return this.right;
        }

        @NotNull
        public final And copy(@NotNull FilterExpression left, @NotNull FilterExpression right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return new And(left, right);
        }

        public static /* synthetic */ And copy$default(And and, FilterExpression filterExpression, FilterExpression filterExpression2, int n, Object object) {
            if ((n & 1) != 0) {
                filterExpression = and.left;
            }
            if ((n & 2) != 0) {
                filterExpression2 = and.right;
            }
            return and.copy(filterExpression, filterExpression2);
        }

        @NotNull
        public String toString() {
            return "And(left=" + this.left + ", right=" + this.right + ")";
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof And)) {
                return false;
            }
            And and = (And)other;
            if (!Intrinsics.areEqual((Object)this.left, (Object)and.left)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.right, (Object)and.right);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/scientific/tables/api/FilterExpression$Companion;", "", "<init>", "()V", "fromFlatExpression", "Lcom/intellij/scientific/tables/api/FilterExpression;", "filters", "", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "operator", "Lcom/intellij/scientific/tables/api/FilterOperator;", "intellij.scientific.tables"})
    @SourceDebugExtension(value={"SMAP\nFilterExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterExpression.kt\ncom/intellij/scientific/tables/api/FilterExpression$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n2851#2,7:35\n*S KotlinDebug\n*F\n+ 1 FilterExpression.kt\ncom/intellij/scientific/tables/api/FilterExpression$Companion\n*L\n26#1:35,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FilterExpression fromFlatExpression(@NotNull List<SingleExpression> filters, @NotNull FilterOperator operator) {
            Object v0;
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
            Iterable $this$reduceOrNull$iv = filters;
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    SingleExpression singleExpression = (SingleExpression)iterator$iv.next();
                    FilterExpression acc = (FilterExpression)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
                        case 1 -> {
                            void s;
                            yield new Or(acc, (FilterExpression)s);
                        }
                        case 2 -> {
                            void s;
                            yield new And(acc, (FilterExpression)s);
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                }
                v0 = accumulator$iv;
            }
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FilterOperator.values().length];
                try {
                    nArray[FilterOperator.OR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FilterOperator.AND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/scientific/tables/api/FilterExpression$Or;", "Lcom/intellij/scientific/tables/api/FilterExpression;", "left", "right", "<init>", "(Lcom/intellij/scientific/tables/api/FilterExpression;Lcom/intellij/scientific/tables/api/FilterExpression;)V", "getLeft", "()Lcom/intellij/scientific/tables/api/FilterExpression;", "getRight", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.scientific.tables"})
    public static final class Or
    extends FilterExpression {
        @NotNull
        private final FilterExpression left;
        @NotNull
        private final FilterExpression right;

        public Or(@NotNull FilterExpression left, @NotNull FilterExpression right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            super(null);
            this.left = left;
            this.right = right;
        }

        @NotNull
        public final FilterExpression getLeft() {
            return this.left;
        }

        @NotNull
        public final FilterExpression getRight() {
            return this.right;
        }

        @NotNull
        public final FilterExpression component1() {
            return this.left;
        }

        @NotNull
        public final FilterExpression component2() {
            return this.right;
        }

        @NotNull
        public final Or copy(@NotNull FilterExpression left, @NotNull FilterExpression right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return new Or(left, right);
        }

        public static /* synthetic */ Or copy$default(Or or, FilterExpression filterExpression, FilterExpression filterExpression2, int n, Object object) {
            if ((n & 1) != 0) {
                filterExpression = or.left;
            }
            if ((n & 2) != 0) {
                filterExpression2 = or.right;
            }
            return or.copy(filterExpression, filterExpression2);
        }

        @NotNull
        public String toString() {
            return "Or(left=" + this.left + ", right=" + this.right + ")";
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Or)) {
                return false;
            }
            Or or = (Or)other;
            if (!Intrinsics.areEqual((Object)this.left, (Object)or.left)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.right, (Object)or.right);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "Lcom/intellij/scientific/tables/api/FilterExpression;", "column", "Lcom/intellij/database/datagrid/GridColumn;", "condition", "Lcom/intellij/scientific/tables/api/FilterComparisonType;", "filterValue", "", "<init>", "(Lcom/intellij/database/datagrid/GridColumn;Lcom/intellij/scientific/tables/api/FilterComparisonType;Ljava/lang/String;)V", "getColumn", "()Lcom/intellij/database/datagrid/GridColumn;", "getCondition", "()Lcom/intellij/scientific/tables/api/FilterComparisonType;", "getFilterValue", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.scientific.tables"})
    public static final class SingleExpression
    extends FilterExpression {
        @NotNull
        private final GridColumn column;
        @NotNull
        private final FilterComparisonType condition;
        @NotNull
        private final String filterValue;

        public SingleExpression(@NotNull GridColumn column, @NotNull FilterComparisonType condition, @NotNull String filterValue) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)((Object)condition), (String)"condition");
            Intrinsics.checkNotNullParameter((Object)filterValue, (String)"filterValue");
            super(null);
            this.column = column;
            this.condition = condition;
            this.filterValue = filterValue;
        }

        @NotNull
        public final GridColumn getColumn() {
            return this.column;
        }

        @NotNull
        public final FilterComparisonType getCondition() {
            return this.condition;
        }

        @NotNull
        public final String getFilterValue() {
            return this.filterValue;
        }

        @NotNull
        public final GridColumn component1() {
            return this.column;
        }

        @NotNull
        public final FilterComparisonType component2() {
            return this.condition;
        }

        @NotNull
        public final String component3() {
            return this.filterValue;
        }

        @NotNull
        public final SingleExpression copy(@NotNull GridColumn column, @NotNull FilterComparisonType condition, @NotNull String filterValue) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)((Object)condition), (String)"condition");
            Intrinsics.checkNotNullParameter((Object)filterValue, (String)"filterValue");
            return new SingleExpression(column, condition, filterValue);
        }

        public static /* synthetic */ SingleExpression copy$default(SingleExpression singleExpression, GridColumn gridColumn, FilterComparisonType filterComparisonType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                gridColumn = singleExpression.column;
            }
            if ((n & 2) != 0) {
                filterComparisonType = singleExpression.condition;
            }
            if ((n & 4) != 0) {
                string = singleExpression.filterValue;
            }
            return singleExpression.copy(gridColumn, filterComparisonType, string);
        }

        @NotNull
        public String toString() {
            return "SingleExpression(column=" + this.column + ", condition=" + this.condition + ", filterValue=" + this.filterValue + ")";
        }

        public int hashCode() {
            int result = this.column.hashCode();
            result = result * 31 + this.condition.hashCode();
            result = result * 31 + this.filterValue.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SingleExpression)) {
                return false;
            }
            SingleExpression singleExpression = (SingleExpression)other;
            if (!Intrinsics.areEqual((Object)this.column, (Object)singleExpression.column)) {
                return false;
            }
            if (this.condition != singleExpression.condition) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filterValue, (Object)singleExpression.filterValue);
        }
    }
}

