/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.CompositeFont;
import sun.font.CompositeGlyphMapper;
import sun.font.FontUtilities;

public final class CCompositeGlyphMapper
extends CompositeGlyphMapper {
    private CompositeFont font;
    private CharToGlyphMapper[] slotMappers;

    public CCompositeGlyphMapper(CompositeFont compositeFont) {
        super(compositeFont);
        this.font = compositeFont;
        this.slotMappers = new CharToGlyphMapper[this.font.numSlots];
        this.missingGlyph = 0;
    }

    private CharToGlyphMapper getSlotMapper(int n) {
        CharToGlyphMapper charToGlyphMapper = this.slotMappers[n];
        if (charToGlyphMapper == null) {
            this.slotMappers[n] = charToGlyphMapper = this.font.getSlotFont(n).getMapper();
        }
        return charToGlyphMapper;
    }

    @Override
    public boolean canDisplay(char c) {
        int n = this.charToGlyph(c);
        return n != this.missingGlyph;
    }

    private int convertToGlyph(int n) {
        for (int i = 0; i < this.font.numSlots; ++i) {
            CharToGlyphMapper charToGlyphMapper = this.getSlotMapper(i);
            int n2 = charToGlyphMapper.charToGlyph(n);
            if (n2 <= 0) continue;
            n2 = this.compositeGlyphCode(i, n2);
            return n2;
        }
        return this.missingGlyph;
    }

    @Override
    public int getNumGlyphs() {
        int n = 0;
        for (int i = 0; i < 1; ++i) {
            CharToGlyphMapper charToGlyphMapper = this.slotMappers[i];
            if (charToGlyphMapper == null) {
                this.slotMappers[i] = charToGlyphMapper = this.font.getSlotFont(i).getMapper();
            }
            n += charToGlyphMapper.getNumGlyphs();
        }
        return n;
    }

    @Override
    public int charToGlyph(int n) {
        return this.convertToGlyph(n);
    }

    @Override
    public int charToGlyph(char c) {
        return this.convertToGlyph(c);
    }

    @Override
    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = this.convertToGlyph(n2);
            if (n2 < 768) continue;
            if (FontUtilities.isComplexCharCode(n2)) {
                return true;
            }
            if (n2 < 65536) continue;
            ++i;
        }
        return false;
    }

    @Override
    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i] = this.convertToGlyph(n2);
                nArray[++i] = 65535;
                continue;
            }
            nArray[i] = this.convertToGlyph(n2);
        }
    }

    @Override
    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.convertToGlyph(nArray[i]);
        }
    }
}

