/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// KmipMoveServer kmipMoveServer is a command that Moves the root location of the kmip server and all associated items to a new root location
type KmipMoveServer struct {
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// New root for the kmip server
	NewRoot string `json:"new-root"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewKmipMoveServer instantiates a new KmipMoveServer object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKmipMoveServer(newRoot string, ) *KmipMoveServer {
	this := KmipMoveServer{}
	var json bool = false
	this.Json = &json
	this.NewRoot = newRoot
	return &this
}

// NewKmipMoveServerWithDefaults instantiates a new KmipMoveServer object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKmipMoveServerWithDefaults() *KmipMoveServer {
	this := KmipMoveServer{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *KmipMoveServer) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipMoveServer) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *KmipMoveServer) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *KmipMoveServer) SetJson(v bool) {
	o.Json = &v
}

// GetNewRoot returns the NewRoot field value
func (o *KmipMoveServer) GetNewRoot() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.NewRoot
}

// GetNewRootOk returns a tuple with the NewRoot field value
// and a boolean to check if the value has been set.
func (o *KmipMoveServer) GetNewRootOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.NewRoot, true
}

// SetNewRoot sets field value
func (o *KmipMoveServer) SetNewRoot(v string) {
	o.NewRoot = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *KmipMoveServer) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipMoveServer) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *KmipMoveServer) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *KmipMoveServer) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *KmipMoveServer) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KmipMoveServer) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *KmipMoveServer) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *KmipMoveServer) SetUidToken(v string) {
	o.UidToken = &v
}

func (o KmipMoveServer) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["new-root"] = o.NewRoot
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableKmipMoveServer struct {
	value *KmipMoveServer
	isSet bool
}

func (v NullableKmipMoveServer) Get() *KmipMoveServer {
	return v.value
}

func (v *NullableKmipMoveServer) Set(val *KmipMoveServer) {
	v.value = val
	v.isSet = true
}

func (v NullableKmipMoveServer) IsSet() bool {
	return v.isSet
}

func (v *NullableKmipMoveServer) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKmipMoveServer(val *KmipMoveServer) *NullableKmipMoveServer {
	return &NullableKmipMoveServer{value: val, isSet: true}
}

func (v NullableKmipMoveServer) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKmipMoveServer) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


