"""
Python 'utf-8-sig' Codec
This work similar to UTF-8 with the following changes:

* On encoding/writing a UTF-8 encoded BOM will be prepended/written as the
  first three bytes.

* On decoding/reading if the first three bytes are a UTF-8 encoded BOM, these
  bytes will be skipped.
"""

import codecs
from _typeshed import ReadableBuffer

class IncrementalEncoder(codecs.IncrementalEncoder):
    def __init__(self, errors: str = "strict") -> None: ...
    def encode(self, input: str, final: bool = False) -> bytes: ...
    def getstate(self) -> int: ...
    def setstate(self, state: int) -> None: ...  # type: ignore[override]

class IncrementalDecoder(codecs.BufferedIncrementalDecoder):
    def __init__(self, errors: str = "strict") -> None: ...
    def _buffer_decode(self, input: ReadableBuffer, errors: str | None, final: bool) -> tuple[str, int]: ...

class StreamWriter(codecs.StreamWriter):
    def encode(self, input: str, errors: str | None = "strict") -> tuple[bytes, int]: ...

class StreamReader(codecs.StreamReader):
    def decode(self, input: ReadableBuffer, errors: str | None = "strict") -> tuple[str, int]: ...

def getregentry() -> codecs.CodecInfo: ...
def encode(input: str, errors: str | None = "strict") -> tuple[bytes, int]: ...
def decode(input: ReadableBuffer, errors: str | None = "strict") -> tuple[str, int]: ...
