# Announce: Rakudo compiler, Release #156 (2022.06)

On behalf of the Rakudo development team, I’m very happy to announce the
June 2022 release of Rakudo #156. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2022.06:

+ Changes:
    + Allow optional : on LHS of signature binding declaration [20fd4f04]
    + Make &[max] and &[min] return RHS for ties [175e716f]
    + Make handles on attribute of type object more natural [1c04360d]
    + Allow openbsd to locate shared libraries by version [5abd57a8]
    + Allow :from<Raku> in identities [3051eefa]
    + Reconsider the way `$*PERL` is deprecated [10d73ada]
    + Allow setting ThreadPoolScheduler's max_threads to semi-infinite
      value [4e56f241] [b0ebb5e6] [febff8fb]

+ Additions:
    + Categorize exceptions thrown by role appliers [7a2f3b19][9155b92b]
      [d79a261d][86d2a75a]
    + Add :real named argument to DateTime.posix [1ffedd66]
    + Introduce (Exception|Cool).Failure coercer [51c00fdd]

+ Removals:

+ Efficiency:
    + Slightly speedup exponentiation by Ints [6f6fd1f7][1a12c34d]
    + Fix unneeded dependency check [636c805e]
    + Make .tail() on native arrays 25x as fast [7a25fc91]
    + Make .head/.tail faster on native arrays [7a25fc91][3c47f1d4][73b43e5f]
    + Make Date.new(Str) a few % faster [39298f10]
    + Make block exit handling faster for blocks having phasers [9a29735d]
      [080abcd8]

+ Fixes:
    + Fix install issue on JVM [e4ba84af]
    + Fix exponentiation by large negative Ints and speedup exponentiation by
      any sized negative Ints [c66c98fe][e4ae4737][b2c44bf3]
    + Fix for positional argument binding [83ea6474]
    + Fix infix le on two native strings [e93447cf]
    + Fix execution error when referencing non-existing captures [aaa5615c]
    + Remove counterproductive fallback from ModuleLoader [217960e2]
    + Resolve race conditions when working with symbols and repositories
      [6fc2e6c6][0293ae58][ad2fdca4][d1b58910][f5dbd15a][082c7122][466a21d3]
      [cef53ac1][2e17ca3d][8940d688][95fb9260][3b4061f6][c2f495b0][18c19fc9]
      [6b117a36][2c6bccb4][ddef6461][a5cf1227]
    + Make "make test" clean on newer MacOSes [a6a856a4]
    + Fix my %h is (Set|Bag|Mix|)Hash = foo [62b6792a][51fd091a]

+ Internal:
    + Update BUILDPLAN helper module to uint renumbering [bea59762][9fd893f7]
    + Let core module installer use information from Compiler object [ce86a7db]
    + Put CATCH blocks at the start of the scope for maintainability [9f8eea41]
    + Various micro optimizations and dead code removal [ca5cfed8][0e55e9ff]
      [36bdd01a][280a2090][b01c493a][a84e1684][64317c4e][8f70f8db][b84a6d2e]
      [59d07871][556f1a2a][bf979d08][e9de06b8][ce86a7db]

The following people contributed to this release:

Elizabeth Mattijsen, Vadim Belman, Will "Coke" Coleda, Daniel Green,
Justin DeVuyst, Stefan Seifert, Daniel Sockwell,
Peter du Marchie van Voorthuysen, Altai-man, David Warring,
Geoffrey Broadwell, casaca24

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2022 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#157), is tentatively scheduled for 2022-07-29.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
