/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.internal;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.annotation.Arg;
import net.sourceforge.argparse4j.helper.HelpScreenException;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.ReflectHelper;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.helper.TextWidthCounter;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.ArgumentGroupImpl;
import net.sourceforge.argparse4j.internal.ArgumentImpl;
import net.sourceforge.argparse4j.internal.ArgumentParserConfigurationImpl;
import net.sourceforge.argparse4j.internal.ParseState;
import net.sourceforge.argparse4j.internal.SubparsersImpl;
import net.sourceforge.argparse4j.internal.UnrecognizedArgumentException;
import net.sourceforge.argparse4j.internal.UnrecognizedCommandException;

public final class ArgumentParserImpl
implements ArgumentParser {
    private static final int SUBSTITUTION_COST = 2;
    private static final int SWAP_COST = 0;
    private static final int DELETION_COST = 4;
    private static final int ADDITION_COST = 1;
    private final Map<String, ArgumentImpl> namedArgIndex_ = new HashMap<String, ArgumentImpl>();
    private final List<ArgumentImpl> namedArgs_ = new ArrayList<ArgumentImpl>();
    private final List<ArgumentImpl> posArgs_ = new ArrayList<ArgumentImpl>();
    private final List<ArgumentGroupImpl> argGroups_ = new ArrayList<ArgumentGroupImpl>();
    private final Map<String, Object> defaults_ = new HashMap<String, Object>();
    private final SubparsersImpl subparsers_ = new SubparsersImpl(this);
    private final ArgumentParserImpl mainParser_;
    private final String command_;
    private final ArgumentParserConfigurationImpl config_;
    private String usage_ = "";
    private String description_ = "";
    private String epilog_ = "";
    private String version_ = "";
    private boolean defaultHelp_ = false;
    private boolean negNumFlag_ = false;
    private static final Pattern NEG_NUM_PATTERN = Pattern.compile("-\\d+");
    private static final Pattern SHORT_OPTS_PATTERN = Pattern.compile("-[^-].*");

    public ArgumentParserImpl(ArgumentParserConfigurationImpl config) {
        this(config, null, null);
    }

    public ArgumentParserImpl(ArgumentParserConfigurationImpl config, String command, ArgumentParserImpl mainParser) {
        this.config_ = config;
        this.command_ = command;
        this.mainParser_ = mainParser;
        if (config.prefixChars_ == null || config.prefixChars_.isEmpty()) {
            throw new IllegalArgumentException("prefixChars cannot be a null or empty");
        }
        if (config.formatWidth_ <= 0) {
            throw new IllegalArgumentException("formatWidth must be greater than 0");
        }
        if (config.addHelp_) {
            String prefix = config.prefixChars_.substring(0, 1);
            this.addArgument(prefix + "h", prefix + prefix + "help").action(Arguments.help()).help(this.localize("help")).setDefault(Arguments.SUPPRESS);
        }
    }

    @Override
    public ArgumentImpl addArgument(String ... nameOrFlags) {
        return this.addArgument((ArgumentGroupImpl)null, nameOrFlags);
    }

    public ArgumentImpl addArgument(ArgumentGroupImpl group, String ... nameOrFlags) {
        ArgumentImpl arg = new ArgumentImpl(this.config_, group, nameOrFlags);
        if (arg.isNamedArgument()) {
            for (String flag : arg.getFlags()) {
                ArgumentImpl another = this.namedArgIndex_.get(flag);
                if (another == null) continue;
                throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, this.localize("conflictingOptionStringsError"), flag, another.textualName()));
            }
            for (String flag : arg.getFlags()) {
                if (NEG_NUM_PATTERN.matcher(flag).matches()) {
                    this.negNumFlag_ = true;
                }
                this.namedArgIndex_.put(flag, arg);
            }
            this.namedArgs_.add(arg);
        } else {
            for (ArgumentImpl another : this.posArgs_) {
                if (!arg.getName().equals(another.getName())) continue;
                throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, this.localize("conflictingOptionStringsError"), arg.getName(), another.textualName()));
            }
            this.posArgs_.add(arg);
        }
        return arg;
    }

    @Override
    public SubparsersImpl addSubparsers() {
        return this.subparsers_;
    }

    @Override
    public ArgumentGroup addArgumentGroup(String title) {
        ArgumentGroupImpl group = new ArgumentGroupImpl(this, title);
        group.setIndex(this.argGroups_.size());
        this.argGroups_.add(group);
        return group;
    }

    @Override
    public MutuallyExclusiveGroup addMutuallyExclusiveGroup() {
        return this.addMutuallyExclusiveGroup("");
    }

    @Override
    public MutuallyExclusiveGroup addMutuallyExclusiveGroup(String title) {
        ArgumentGroupImpl group = new ArgumentGroupImpl(this, title);
        group.setIndex(this.argGroups_.size());
        group.setMutex(true);
        this.argGroups_.add(group);
        return group;
    }

    @Override
    public ArgumentParserImpl usage(String usage) {
        this.usage_ = TextHelper.nonNull(usage);
        return this;
    }

    @Override
    public ArgumentParserImpl description(String description) {
        this.description_ = TextHelper.nonNull(description);
        return this;
    }

    @Override
    public ArgumentParserImpl epilog(String epilog) {
        this.epilog_ = TextHelper.nonNull(epilog);
        return this;
    }

    @Override
    public ArgumentParserImpl version(String version) {
        this.version_ = TextHelper.nonNull(version);
        return this;
    }

    @Override
    public ArgumentParserImpl defaultHelp(boolean defaultHelp) {
        this.defaultHelp_ = defaultHelp;
        return this;
    }

    boolean isDefaultHelp() {
        return this.defaultHelp_;
    }

    private void printArgumentHelp(PrintWriter writer, List<ArgumentImpl> args, int format_width) {
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isSeparateHelp()) continue;
            arg.printHelp(writer, this.defaultHelp_, this.config_.textWidthCounter_, format_width);
        }
    }

    @Override
    public void printHelp() {
        PrintWriter writer = new PrintWriter(System.out);
        this.printHelp(writer);
        writer.flush();
    }

    @Override
    public void printHelp(PrintWriter writer) {
        int formatWidth = this.config_.formatWidth_;
        this.printUsage(writer, formatWidth);
        if (!this.description_.isEmpty()) {
            writer.println();
            writer.println(TextHelper.wrap(this.config_.textWidthCounter_, this.description_, formatWidth, 0, "", ""));
        }
        boolean subparsersUntitled = this.subparsers_.getTitle().isEmpty() && this.subparsers_.getDescription().isEmpty();
        boolean hasSubCommand = this.subparsers_.hasNotSuppressedSubCommand();
        if (this.checkDefaultGroup(this.posArgs_) || hasSubCommand && subparsersUntitled) {
            writer.println();
            writer.println(this.localize("positional.arguments"));
            this.printArgumentHelp(writer, this.posArgs_, formatWidth);
            if (hasSubCommand && subparsersUntitled) {
                this.subparsers_.printSubparserHelp(writer, formatWidth);
            }
        }
        if (this.checkDefaultGroup(this.namedArgs_)) {
            writer.println();
            writer.println(this.localize("named.arguments"));
            this.printArgumentHelp(writer, this.namedArgs_, formatWidth);
        }
        if (hasSubCommand && !subparsersUntitled) {
            writer.println();
            writer.print(this.subparsers_.getTitle().isEmpty() ? this.localize("sub-commands") : this.subparsers_.getTitle());
            writer.println(":");
            if (!this.subparsers_.getDescription().isEmpty()) {
                writer.print("  ");
                writer.println(TextHelper.wrap(this.config_.textWidthCounter_, this.subparsers_.getDescription(), formatWidth, 2, "", "  "));
                writer.println();
            }
            this.subparsers_.printSubparserHelp(writer, formatWidth);
        }
        for (ArgumentGroupImpl group : this.argGroups_) {
            if (!group.isSeparateHelp()) continue;
            writer.println();
            group.printHelp(writer, formatWidth);
        }
        if (!this.epilog_.isEmpty()) {
            writer.println();
            writer.println(TextHelper.wrap(this.config_.textWidthCounter_, this.epilog_, formatWidth, 0, "", ""));
        }
    }

    private boolean checkDefaultGroup(List<ArgumentImpl> args) {
        if (args.isEmpty()) {
            return false;
        }
        for (ArgumentImpl arg : args) {
            if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isSeparateHelp()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String formatHelp() {
        StringWriter writer = new StringWriter();
        this.printHelp(new PrintWriter(writer));
        return writer.toString();
    }

    private void printArgumentUsage(PrintWriter writer, List<String> opts, int offset, String firstIndent, String subsequentIndent, int format_width) {
        int currentWidth = offset + firstIndent.length();
        writer.print(firstIndent);
        boolean first = true;
        for (String syntax : opts) {
            if (!first && currentWidth + syntax.length() + 1 > format_width) {
                writer.println();
                writer.print(subsequentIndent);
                writer.print(" ");
                writer.print(syntax);
                currentWidth = subsequentIndent.length() + 1 + syntax.length();
                continue;
            }
            writer.print(" ");
            writer.print(syntax);
            currentWidth += 1 + syntax.length();
            first = false;
        }
        writer.println();
    }

    @Override
    public void printUsage() {
        PrintWriter writer = new PrintWriter(System.out);
        this.printUsage(writer);
        writer.flush();
    }

    @Override
    public void printUsage(PrintWriter writer) {
        this.printUsage(writer, this.config_.formatWidth_);
    }

    private void printUsage(PrintWriter writer, int format_width) {
        String firstIndent;
        String subsequentIndent;
        int offset;
        if (!this.usage_.isEmpty()) {
            writer.print(this.localize("usage") + " ");
            writer.println(this.substitutePlaceholder(this.usage_));
            return;
        }
        String usageProg = this.localize("usage") + " " + this.config_.prog_;
        writer.print(usageProg);
        String indent = "                              ";
        int usageProgWidth = this.config_.textWidthCounter_.width(usageProg);
        if (usageProgWidth > indent.length()) {
            writer.println();
            offset = 6;
            firstIndent = subsequentIndent = indent.substring(0, offset);
        } else {
            offset = usageProgWidth;
            firstIndent = "";
            subsequentIndent = indent.substring(0, offset);
        }
        ArrayList<String> opts = new ArrayList<String>();
        this.addUpperParserUsage(opts, this.mainParser_);
        if (this.command_ != null) {
            opts.add(this.command_);
        }
        for (ArgumentImpl arg : this.namedArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS || arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) continue;
            opts.add(arg.formatShortSyntax());
        }
        for (ArgumentGroupImpl group : this.argGroups_) {
            List<ArgumentImpl> args = ArgumentParserImpl.filterSuppressedArgs(group.getArgs());
            int numArgs = args.size();
            if (!group.isMutex()) continue;
            if (numArgs > 1) {
                opts.add((group.isRequired() ? "(" : "[") + args.get(0).formatShortSyntaxNoBracket());
                for (int i = 1; i < numArgs - 1; ++i) {
                    ArgumentImpl arg = args.get(i);
                    opts.add("|");
                    opts.add(arg.formatShortSyntaxNoBracket());
                }
                opts.add("|");
                opts.add(args.get(numArgs - 1).formatShortSyntaxNoBracket() + (group.isRequired() ? ")" : "]"));
                continue;
            }
            if (numArgs != 1) continue;
            if (group.isRequired()) {
                opts.add(args.get(0).formatShortSyntaxNoBracket());
                continue;
            }
            opts.add(args.get(0).formatShortSyntax());
        }
        for (ArgumentImpl arg : this.posArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            opts.add(arg.formatShortSyntax());
        }
        if (this.subparsers_.hasNotSuppressedSubCommand()) {
            opts.add(this.subparsers_.formatShortSyntax());
            opts.add("...");
        }
        this.printArgumentUsage(writer, opts, offset, firstIndent, subsequentIndent, format_width);
    }

    private static List<ArgumentImpl> filterSuppressedArgs(Collection<ArgumentImpl> args) {
        ArrayList<ArgumentImpl> res = new ArrayList<ArgumentImpl>();
        for (ArgumentImpl arg : args) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            res.add(arg);
        }
        return res;
    }

    private void addUpperParserUsage(List<String> opts, ArgumentParserImpl parser) {
        if (parser == null) {
            return;
        }
        this.addUpperParserUsage(opts, parser.mainParser_);
        if (parser.command_ != null) {
            opts.add(parser.command_);
        }
        for (ArgumentImpl arg : parser.namedArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS || !arg.isRequired() || arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) continue;
            opts.add(arg.formatShortSyntax());
        }
        for (ArgumentGroupImpl group : parser.argGroups_) {
            List<ArgumentImpl> args = ArgumentParserImpl.filterSuppressedArgs(group.getArgs());
            int numArgs = args.size();
            if (!group.isMutex()) continue;
            if (numArgs > 1) {
                if (!group.isRequired()) continue;
                opts.add("(" + args.get(0).formatShortSyntaxNoBracket());
                for (int i = 1; i < numArgs - 1; ++i) {
                    ArgumentImpl arg = args.get(i);
                    opts.add("|");
                    opts.add(arg.formatShortSyntaxNoBracket());
                }
                opts.add("|");
                opts.add(args.get(numArgs - 1).formatShortSyntaxNoBracket() + ")");
                continue;
            }
            if (numArgs != 1) continue;
            if (group.isRequired()) {
                opts.add(args.get(0).formatShortSyntaxNoBracket());
                continue;
            }
            if (!args.get(0).isRequired()) continue;
            opts.add(args.get(0).formatShortSyntax());
        }
        for (ArgumentImpl arg : parser.posArgs_) {
            if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
            opts.add(arg.formatShortSyntax());
        }
    }

    @Override
    public String formatUsage() {
        StringWriter writer = new StringWriter();
        this.printUsage(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public ArgumentParserImpl setDefault(String dest, Object value) {
        this.defaults_.put(dest, value);
        return this;
    }

    @Override
    public ArgumentParserImpl setDefaults(Map<String, Object> attrs) {
        this.defaults_.putAll(attrs);
        return this;
    }

    @Override
    public Object getDefault(String dest) {
        for (ArgumentImpl arg : this.namedArgs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        for (ArgumentImpl arg : this.posArgs_) {
            if (!dest.equals(arg.getDest()) || arg.getDefault() == null) continue;
            return arg.getDefault();
        }
        return this.defaults_.get(dest);
    }

    @Override
    public Namespace parseArgsOrFail(String[] args) {
        try {
            return this.parseArgs(args);
        }
        catch (HelpScreenException e) {
            this.handleError(e);
            System.exit(0);
        }
        catch (ArgumentParserException e) {
            this.handleError(e);
            System.exit(1);
        }
        return null;
    }

    @Override
    public Namespace parseKnownArgsOrFail(String[] args, List<String> unknown) {
        try {
            return this.parseKnownArgs(args, unknown);
        }
        catch (HelpScreenException e) {
            this.handleError(e);
            System.exit(0);
        }
        catch (ArgumentParserException e) {
            this.handleError(e);
            System.exit(1);
        }
        return null;
    }

    @Override
    public Namespace parseArgs(String[] args) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseArgs(args, attrs);
        return new Namespace(attrs);
    }

    @Override
    public Namespace parseKnownArgs(String[] args, List<String> unknown) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseKnownArgs(args, unknown, attrs);
        return new Namespace(attrs);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs) throws ArgumentParserException {
        this.parseArgsAtOffsetZero(args, null, attrs);
    }

    @Override
    public void parseKnownArgs(String[] args, List<String> unknown, Map<String, Object> attrs) throws ArgumentParserException {
        this.parseKnownArgsCreatingUnknownIfNeeded(args, unknown, attrs);
    }

    @Override
    public void parseArgs(String[] args, Object userData) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseArgs(args, attrs, userData);
    }

    @Override
    public void parseKnownArgs(String[] args, List<String> unknown, Object userData) throws ArgumentParserException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        this.parseKnownArgs(args, unknown, attrs, userData);
    }

    @Override
    public void parseArgs(String[] args, Map<String, Object> attrs, Object userData) throws ArgumentParserException {
        this.parseArgsAtOffsetZero(args, null, attrs);
        this.fillUserDataFromAttrs(userData, attrs);
    }

    @Override
    public void parseKnownArgs(String[] args, List<String> unknown, Map<String, Object> attrs, Object userData) throws ArgumentParserException {
        this.parseKnownArgsCreatingUnknownIfNeeded(args, unknown, attrs);
        this.fillUserDataFromAttrs(userData, attrs);
    }

    private void fillUserDataFromAttrs(Object userData, Map<String, Object> attrs) {
        for (Class<?> userClass = userData.getClass(); userClass != null; userClass = userClass.getSuperclass()) {
            Object val;
            String argDest;
            Arg ann;
            for (Field field : userClass.getDeclaredFields()) {
                ann = field.getAnnotation(Arg.class);
                if (ann == null) continue;
                argDest = ann.dest();
                if (argDest.isEmpty()) {
                    argDest = field.getName();
                }
                if (!attrs.containsKey(argDest)) continue;
                val = attrs.get(argDest);
                try {
                    AccessController.doPrivileged(() -> {
                        field.setAccessible(true);
                        return null;
                    });
                    field.set(userData, ReflectHelper.list2Array(field.getType(), val));
                }
                catch (RuntimeException e) {
                    if (ann.ignoreError()) continue;
                    throw e;
                }
                catch (Exception e) {
                    if (ann.ignoreError()) continue;
                    throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "Could not set %s to field %s", val, field.getName()), e);
                }
            }
            for (AccessibleObject accessibleObject : userClass.getDeclaredMethods()) {
                ann = ((Method)accessibleObject).getAnnotation(Arg.class);
                if (ann == null) continue;
                argDest = ann.dest();
                if (argDest.isEmpty()) {
                    argDest = ((Method)accessibleObject).getName();
                }
                if (!attrs.containsKey(argDest)) continue;
                val = attrs.get(argDest);
                Class<?>[] fargs = ((Method)accessibleObject).getParameterTypes();
                if (fargs.length != 1) {
                    throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "Method %s must have one formal parameter", ((Method)accessibleObject).getName()));
                }
                try {
                    AccessController.doPrivileged(() -> ArgumentParserImpl.lambda$fillUserDataFromAttrs$1((Method)accessibleObject));
                    ((Method)accessibleObject).invoke(userData, ReflectHelper.list2Array(fargs[0], val));
                }
                catch (RuntimeException e) {
                    if (ann.ignoreError()) continue;
                    throw e;
                }
                catch (Exception e) {
                    if (ann.ignoreError()) continue;
                    throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "Could not call method %s with %s", ((Method)accessibleObject).getName(), val), e);
                }
            }
        }
    }

    private void parseKnownArgsCreatingUnknownIfNeeded(String[] args, List<String> unknown, Map<String, Object> attrs) throws ArgumentParserException {
        if (unknown == null) {
            unknown = new ArrayList<String>();
        }
        this.parseArgsAtOffsetZero(args, unknown, attrs);
    }

    private void parseArgsAtOffsetZero(String[] args, List<String> unknown, Map<String, Object> attrs) throws ArgumentParserException {
        ParseState state = new ParseState(args, this.negNumFlag_, unknown);
        this.parseArgs(state, attrs);
        if (state.deferredException != null) {
            throw state.deferredException;
        }
    }

    private boolean checkConcatenatedShortOpts(String term) {
        if (SHORT_OPTS_PATTERN.matcher(term).matches()) {
            int termLen = term.length();
            for (int i = 1; i < termLen; ++i) {
                String shortFlag = "-" + term.charAt(i);
                ArgumentImpl arg = this.namedArgIndex_.get(shortFlag);
                if (arg == null) {
                    return false;
                }
                if (!arg.getAction().consumeArgument()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private ArgumentImpl resolveNextFlag(String flag) throws ArgumentParserException {
        ArgumentImpl arg = this.namedArgIndex_.get(flag);
        if (arg != null) {
            return arg;
        }
        List<String> cand = TextHelper.findPrefix(this.namedArgIndex_.keySet(), flag);
        if (cand.isEmpty()) {
            return null;
        }
        if (this.checkConcatenatedShortOpts(flag)) {
            cand.add(flag.substring(0, 2));
        } else if (cand.size() == 1) {
            return this.namedArgIndex_.get(cand.get(0));
        }
        Collections.sort(cand);
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("ambiguousOptionError"), flag, TextHelper.concat(cand, 0, ", ")), (ArgumentParser)this);
    }

    void parseArgs(ParseState state, Map<String, Object> attrs) throws ArgumentParserException {
        this.populateDefaults(attrs);
        HashSet<ArgumentImpl> used = new HashSet<ArgumentImpl>();
        ArgumentImpl[] groupUsed = new ArgumentImpl[this.argGroups_.size()];
        int posArgsLen = this.posArgs_.size();
        while (state.isArgAvail()) {
            if (this.flagFound(state) && !"--".equals(state.getArg())) {
                String embeddedValue;
                String flag;
                String term = state.getArg();
                int p = term.indexOf("=");
                if (p == -1) {
                    flag = term;
                    embeddedValue = null;
                } else {
                    flag = term.substring(0, p);
                    embeddedValue = term.substring(p + 1);
                }
                ArgumentImpl arg = this.resolveNextFlag(flag);
                if (arg == null) {
                    embeddedValue = null;
                    boolean shortOptsFound = false;
                    int unknownStart = -1;
                    if (this.config_.prefixPattern_.matchShortFlag(term)) {
                        shortOptsFound = true;
                        int termLen = term.length();
                        for (int i = 1; i < termLen; ++i) {
                            String shortFlag = term.substring(0, 1) + term.charAt(i);
                            arg = this.namedArgIndex_.get(shortFlag);
                            if (arg == null) {
                                shortOptsFound = false;
                                unknownStart = i;
                                break;
                            }
                            if (arg.getAction().consumeArgument()) {
                                flag = shortFlag;
                                shortOptsFound = true;
                                if (term.length() <= i + 1) break;
                                embeddedValue = term.substring(i + 1);
                                break;
                            }
                            this.checkMutex(arg, groupUsed);
                            ArgumentImpl finalArg = arg;
                            arg.run(this, attrs, shortFlag, null, value -> this.addArgValue(attrs, finalArg, value));
                            used.add(arg);
                            arg = null;
                        }
                    }
                    if (!shortOptsFound) {
                        if (state.unknown == null) {
                            throw new UnrecognizedArgumentException(this.formatUnrecognizedArgumentErrorMessage(state, term), (ArgumentParser)this, term);
                        }
                        state.unknown.add(unknownStart == -1 ? term : term.charAt(0) + term.substring(unknownStart));
                    }
                }
                ++state.index;
                if (arg == null) continue;
                this.checkMutex(arg, groupUsed);
                this.processArg(attrs, state, arg, flag, embeddedValue);
                used.add(arg);
                continue;
            }
            if ("--".equals(state.getArg()) && !state.consumedSeparator) {
                state.consumedSeparator = true;
                state.negNumFlag = false;
                ++state.index;
                continue;
            }
            if (state.posArgIndex < posArgsLen) {
                ArgumentImpl arg = this.posArgs_.get(state.posArgIndex);
                this.accumulatePositionalArg(state, arg);
                continue;
            }
            if (!state.consumedSeparator && this.subparsers_.hasSubCommand()) {
                this.processPositionalArgs(attrs, state);
                this.checkRequiredArgument(state, used);
                this.checkRequiredMutex(state, groupUsed);
                state.resetPosArgs();
                this.subparsers_.parseArg(state, attrs);
                return;
            }
            if (state.unknown == null) {
                throw new ArgumentParserException(this.formatUnrecognizedArgumentErrorMessage(state, TextHelper.concat(state.args, state.index, " ")), (ArgumentParser)this);
            }
            state.unknown.add(state.getArg());
            ++state.index;
        }
        if (this.subparsers_.hasSubCommand()) {
            throw new ArgumentParserException(this.localize("tooFewArgumentsError"), (ArgumentParser)this);
        }
        this.processPositionalArgs(attrs, state);
        this.checkRequiredArgument(state, used);
        this.checkRequiredMutex(state, groupUsed);
    }

    private String formatUnrecognizedArgumentErrorMessage(ParseState state, String args) {
        return String.format(TextHelper.LOCALE_ROOT, this.localize("unrecognizedArgumentsError"), args, state.index > state.lastFromFileArgIndex ? "" : String.format(TextHelper.LOCALE_ROOT, this.localize("trailingWhiteSpacesInFileTip"), this.config_.fromFilePrefixPattern_.getPrefixChars().length() == 1 ? this.config_.fromFilePrefixPattern_.getPrefixChars() : "[" + this.config_.fromFilePrefixPattern_.getPrefixChars() + "]"));
    }

    private void checkMutex(ArgumentImpl arg, ArgumentImpl[] groupUsed) throws ArgumentParserException {
        if (arg.getArgumentGroup() != null && arg.getArgumentGroup().isMutex()) {
            ArgumentImpl usedMutexArg = groupUsed[arg.getArgumentGroup().getIndex()];
            if (usedMutexArg == null) {
                groupUsed[arg.getArgumentGroup().getIndex()] = arg;
            } else if (usedMutexArg != arg) {
                throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("notAllowedWithArgumentError"), usedMutexArg.textualName()), this, arg);
            }
        }
    }

    private void processArg(Map<String, Object> res, ParseState state, ArgumentImpl arg, String flag, String embeddedValue) throws ArgumentParserException {
        if (!arg.getAction().consumeArgument()) {
            if (embeddedValue == null) {
                arg.run(this, res, flag, null, value -> this.addArgValue(res, arg, value));
                return;
            }
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("ignoreImplicitArgumentError"), embeddedValue), this, arg);
        }
        if (arg.getMinNumArg() == -1 || arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
            String argVal = null;
            if (embeddedValue == null) {
                if (state.isArgAvail() && !this.flagFound(state)) {
                    argVal = state.getArg();
                    ++state.index;
                }
            } else {
                argVal = embeddedValue;
            }
            if (argVal == null) {
                if (arg.getMinNumArg() == -1) {
                    throw new ArgumentParserException(this.localize("expectedOneArgumentError"), this, arg);
                }
                arg.run(this, res, flag, arg.getConst(), value -> this.addArgValue(res, arg, value));
            } else {
                arg.run(this, res, flag, arg.convert(this, argVal), value -> this.addArgValue(res, arg, value));
            }
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (embeddedValue == null) {
            int i = 0;
            while (i < arg.getMaxNumArg() && state.isArgAvail() && !this.flagFound(state)) {
                list.add(arg.convert(this, state.getArg()));
                ++i;
                ++state.index;
            }
        } else {
            list.add(arg.convert(this, embeddedValue));
        }
        if (list.size() < arg.getMinNumArg()) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("expectedNArgumentsError"), arg.getMinNumArg()), this, arg);
        }
        arg.run(this, res, flag, list, value -> this.addArgValue(res, arg, value));
    }

    private void accumulatePositionalArg(ParseState state, ArgumentImpl arg) throws ArgumentParserException {
        if (!arg.getAction().consumeArgument()) {
            ++state.posArgIndex;
            return;
        }
        if (arg.getMinNumArg() == -1 || arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
            state.posArgArgs.add(state.getArg());
            ++state.index;
            ++state.posArgIndex;
            return;
        }
        while (state.posArgConsumed < arg.getMaxNumArg() && state.isArgAvail() && !this.flagFound(state)) {
            state.posArgArgs.add(state.getArg());
            ++state.posArgConsumed;
            ++state.index;
        }
        if (state.posArgConsumed == arg.getMaxNumArg()) {
            ++state.posArgIndex;
            state.posArgConsumed = 0;
        }
    }

    private void processPositionalArgs(Map<String, Object> res, ParseState state) throws ArgumentParserException {
        int i;
        int[] mustLeft = new int[this.posArgs_.size() + 1];
        for (i = 0; i < this.posArgs_.size(); ++i) {
            ArgumentImpl arg = this.posArgs_.get(i);
            mustLeft[i] = !arg.getAction().consumeArgument() ? 0 : (arg.getMinNumArg() == -1 ? 1 : arg.getMinNumArg());
        }
        mustLeft[this.posArgs_.size()] = 0;
        for (i = this.posArgs_.size() - 1; i >= 0; --i) {
            int n = i;
            mustLeft[n] = mustLeft[n] + mustLeft[i + 1];
        }
        if (mustLeft[0] > state.posArgArgs.size()) {
            throw new ArgumentParserException(this.localize("tooFewArgumentsError"), (ArgumentParser)this);
        }
        int argIndex = 0;
        for (int i2 = 0; i2 < this.posArgs_.size(); ++i2) {
            ArgumentImpl arg = this.posArgs_.get(i2);
            if (!arg.getAction().consumeArgument()) {
                arg.run(this, res, null, null, value -> this.addArgValue(res, arg, value));
                continue;
            }
            if (arg.getMinNumArg() == -1) {
                arg.run(this, res, null, arg.convert(this, state.posArgArgs.get(argIndex++)), value -> this.addArgValue(res, arg, value));
                continue;
            }
            if (arg.getMinNumArg() == 0 && arg.getMaxNumArg() == 1) {
                if (mustLeft[i2 + 1] == state.posArgArgs.size() - argIndex) continue;
                arg.run(this, res, null, arg.convert(this, state.posArgArgs.get(argIndex++)), value -> this.addArgValue(res, arg, value));
                continue;
            }
            int n = Math.min(arg.getMaxNumArg(), state.posArgArgs.size() - argIndex - mustLeft[i2 + 1]);
            if (n == 0) continue;
            ArrayList<Object> list = new ArrayList<Object>(n);
            while (n > 0) {
                list.add(arg.convert(this, state.posArgArgs.get(argIndex++)));
                --n;
            }
            arg.run(this, res, null, list, value -> this.addArgValue(res, arg, value));
        }
    }

    private boolean flagFound(ParseState state) throws ArgumentParserException {
        while (this.fromFileFound(state)) {
            this.extendArgs(state, this.config_.fromFilePrefixPattern_.removePrefix(state.getArg()));
        }
        String term = state.getArg();
        if (state.consumedSeparator) {
            return false;
        }
        if ("--".equals(term)) {
            return true;
        }
        return this.config_.prefixPattern_.match(term) && (state.negNumFlag || !NEG_NUM_PATTERN.matcher(term).matches());
    }

    private boolean fromFileFound(ParseState state) {
        return this.config_.fromFilePrefixPattern_ != null && this.config_.fromFilePrefixPattern_.match(state.getArg());
    }

    private void extendArgs(ParseState state, String file) throws ArgumentParserException {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("couldNotReadFromFileError"), file), e, this);
        }
        int offset = state.index + 1;
        String[] newArgs = new String[list.size() + state.args.length - offset];
        list.toArray(newArgs);
        System.arraycopy(state.args, offset, newArgs, list.size(), state.args.length - offset);
        state.lastFromFileArgIndex = state.lastFromFileArgIndex < offset ? list.size() - 1 : (state.lastFromFileArgIndex += -offset + list.size());
        state.resetArgs(newArgs);
    }

    private void checkRequiredArgument(ParseState state, Set<ArgumentImpl> used) {
        if (state.deferredException != null) {
            return;
        }
        for (ArgumentImpl arg : this.namedArgs_) {
            if (!arg.isRequired() || used.contains(arg)) continue;
            state.deferredException = new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("argumentIsRequiredError"), arg.textualName()), (ArgumentParser)this);
        }
    }

    private void checkRequiredMutex(ParseState state, ArgumentImpl[] used) {
        if (state.deferredException != null) {
            return;
        }
        for (int i = 0; i < this.argGroups_.size(); ++i) {
            ArgumentGroupImpl group = this.argGroups_.get(i);
            if (!group.isMutex() || !group.isRequired() || used[i] != null) continue;
            StringBuilder sb = new StringBuilder();
            for (ArgumentImpl arg : group.getArgs()) {
                if (arg.getHelpControl() == Arguments.SUPPRESS) continue;
                sb.append(arg.textualName()).append(" ");
            }
            state.deferredException = new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, this.localize("oneOfTheArgumentsIsRequiredError"), sb.toString()), (ArgumentParser)this);
        }
    }

    private void populateDefaults(Map<String, Object> opts) {
        for (ArgumentImpl argumentImpl : this.posArgs_) {
            this.addArgDefaultIfNotSuppressed(opts, argumentImpl);
        }
        for (ArgumentImpl argumentImpl : this.namedArgs_) {
            this.addArgDefaultIfNotSuppressed(opts, argumentImpl);
        }
        for (Map.Entry entry : this.defaults_.entrySet()) {
            opts.put((String)entry.getKey(), entry.getValue());
        }
    }

    private void addArgDefaultIfNotSuppressed(Map<String, Object> opts, ArgumentImpl arg) {
        if (arg.getDefaultControl() != Arguments.SUPPRESS) {
            this.addArgValue(opts, arg, arg.getDefault());
        }
    }

    private void addArgValue(Map<String, Object> opts, ArgumentImpl arg, Object value) {
        opts.put(arg.getDest(), value);
        if (this.config_.includeArgumentNamesAsKeysInResult_) {
            opts.put(this.getActualArgumentName(arg), value);
        }
    }

    private String getActualArgumentName(ArgumentImpl arg) {
        return arg.getName() == null ? this.removePrefix(arg.getPrimaryFlag()) : arg.getName();
    }

    private String removePrefix(String flag) {
        return this.config_.prefixPattern_.removePrefix(flag);
    }

    @Override
    public ArgumentParserConfigurationImpl getConfig() {
        return this.config_;
    }

    public String getProg() {
        return this.config_.prog_;
    }

    @Override
    public void printVersion() {
        PrintWriter writer = new PrintWriter(System.out);
        this.printVersion(writer);
        writer.flush();
    }

    @Override
    public void printVersion(PrintWriter writer) {
        writer.println(this.formatVersion());
    }

    @Override
    public String formatVersion() {
        return this.substitutePlaceholder(this.version_);
    }

    @Override
    public void handleError(ArgumentParserException e) {
        this.handleError(e, new PrintWriter(System.err));
    }

    @Override
    public void handleError(ArgumentParserException e, PrintWriter writer) {
        if (e.getParser() != this) {
            e.getParser().handleError(e, writer);
            return;
        }
        if (e instanceof HelpScreenException) {
            return;
        }
        this.printUsage(writer);
        writer.write(TextHelper.wrap(this.config_.textWidthCounter_, String.format(TextHelper.LOCALE_ROOT, this.localize("errorLine"), this.config_.prog_, e.getMessage()), this.config_.formatWidth_, 0, "", ""));
        if (e instanceof UnrecognizedArgumentException) {
            String flagBody;
            UnrecognizedArgumentException ex = (UnrecognizedArgumentException)e;
            String argument = ex.getArgument();
            if (this.config_.prefixPattern_.match(argument) && (flagBody = this.config_.prefixPattern_.removePrefix(argument)).length() >= 2) {
                this.printFlagCandidates(flagBody, writer);
            }
        } else if (e instanceof UnrecognizedCommandException) {
            UnrecognizedCommandException ex = (UnrecognizedCommandException)e;
            String command = ex.getCommand();
            this.printCommandCandidates(command, writer);
        }
        writer.flush();
    }

    private int levenshtein(String a, String b) {
        int i;
        int aLen = a.length();
        int bLen = b.length();
        int[][] dp = new int[3][bLen + 1];
        for (i = 0; i <= bLen; ++i) {
            dp[1][i] = i;
        }
        for (i = 1; i <= aLen; ++i) {
            dp[0][0] = i;
            for (int j = 1; j <= bLen; ++j) {
                dp[0][j] = dp[1][j - 1] + (a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 2);
                if (i >= 2 && j >= 2 && a.charAt(i - 1) != b.charAt(j - 1) && a.charAt(i - 2) == b.charAt(j - 1) && a.charAt(i - 1) == b.charAt(j - 2)) {
                    dp[0][j] = Math.min(dp[0][j], dp[2][j - 2] + 0);
                }
                dp[0][j] = Math.min(dp[0][j], Math.min(dp[1][j] + 4, dp[0][j - 1] + 1));
            }
            int[] temp = dp[2];
            dp[2] = dp[1];
            dp[1] = dp[0];
            dp[0] = temp;
        }
        return dp[1][bLen];
    }

    private void printFlagCandidates(String flagBody, PrintWriter writer) {
        ArrayList<SubjectBody> subjects = new ArrayList<SubjectBody>();
        for (ArgumentImpl arg : this.namedArgs_) {
            String[] flags;
            for (String flag : flags = arg.getFlags()) {
                String body = this.config_.prefixPattern_.removePrefix(flag);
                if (body.length() <= 1) continue;
                subjects.add(new SubjectBody(flag, body));
            }
        }
        this.printCandidates(flagBody, subjects, writer);
    }

    private void printCommandCandidates(String command, PrintWriter writer) {
        ArrayList<SubjectBody> subjects = new ArrayList<SubjectBody>();
        for (String com : this.subparsers_.getCommands()) {
            subjects.add(new SubjectBody(com, com));
        }
        this.printCandidates(command, subjects, writer);
    }

    private void printCandidates(String body, List<SubjectBody> subjects, PrintWriter writer) {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (SubjectBody sub : subjects) {
            if (sub.body.startsWith(body)) {
                candidates.add(new Candidate(0, sub.subject));
                continue;
            }
            candidates.add(new Candidate(this.levenshtein(body, sub.body), sub.subject));
        }
        if (candidates.isEmpty()) {
            return;
        }
        Collections.sort(candidates);
        int threshold = ((Candidate)candidates.get((int)0)).similarity;
        if (threshold >= 7) {
            return;
        }
        writer.println();
        writer.println(this.localize("didYouMean"));
        for (Candidate candidate : candidates) {
            if (candidate.similarity > threshold) break;
            writer.print("\t");
            writer.println(candidate.subject);
        }
    }

    private String substitutePlaceholder(String src) {
        return src.replaceAll(Pattern.quote("${prog}"), this.config_.prog_);
    }

    public String getCommand() {
        return this.command_;
    }

    TextWidthCounter getTextWidthCounter() {
        return this.config_.textWidthCounter_;
    }

    public String getPrefixChars() {
        return this.config_.prefixPattern_.getPrefixChars();
    }

    public String getFromFilePrefixChars() {
        return this.config_.fromFilePrefixPattern_ == null ? null : this.config_.fromFilePrefixPattern_.getPrefixChars();
    }

    ArgumentParserImpl getMainParser() {
        return this.mainParser_;
    }

    String localize(String messageKey) {
        return MessageLocalization.localize(this.config_.getResourceBundle(), messageKey);
    }

    private static /* synthetic */ Void lambda$fillUserDataFromAttrs$1(Method method) {
        method.setAccessible(true);
        return null;
    }

    public static class Candidate
    implements Comparable<Candidate> {
        int similarity;
        public String subject;

        Candidate(int similarity, String subject) {
            this.similarity = similarity;
            this.subject = subject;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Candidate other = (Candidate)obj;
            if (this.subject == null) {
                if (other.subject != null) {
                    return false;
                }
            } else {
                if (other.subject == null) {
                    return false;
                }
                if (!this.subject.equals(other.subject)) {
                    return false;
                }
            }
            return this.similarity == other.similarity;
        }

        public int hashCode() {
            int prime = 31;
            int hash = 1;
            hash = hash * prime + (this.subject == null ? 0 : this.subject.hashCode());
            hash = hash * prime + this.similarity;
            return hash;
        }

        @Override
        public int compareTo(Candidate rhs) {
            if (this.similarity < rhs.similarity) {
                return -1;
            }
            if (this.similarity == rhs.similarity) {
                return this.subject.compareTo(rhs.subject);
            }
            return 1;
        }
    }

    private static class SubjectBody {
        public String subject;
        String body;

        SubjectBody(String subject, String body) {
            this.subject = subject;
            this.body = body;
        }
    }
}

