/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/internal/http/StatusLine;", "", "protocol", "Lokhttp3/Protocol;", "code", "", "message", "", "<init>", "(Lokhttp3/Protocol;ILjava/lang/String;)V", "toString", "Companion", "okhttp"})
public final class StatusLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Protocol protocol;
    @JvmField
    public final int code;
    @JvmField
    @NotNull
    public final String message;

    public StatusLine(@NotNull Protocol protocol, int code, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.protocol = protocol;
        this.code = code;
        this.message = message;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = this.protocol == Protocol.HTTP_1_0 ? $this$toString_u24lambda_u240.append("HTTP/1.0") : $this$toString_u24lambda_u240.append("HTTP/1.1");
        $this$toString_u24lambda_u240.append(' ').append(this.code);
        $this$toString_u24lambda_u240.append(' ').append(this.message);
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/http/StatusLine$Companion;", "", "<init>", "()V", "get", "Lokhttp3/internal/http/StatusLine;", "response", "Lokhttp3/Response;", "parse", "statusLine", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatusLine get(@NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return new StatusLine(response.protocol(), response.code(), response.message());
        }

        @NotNull
        public final StatusLine parse(@NotNull String statusLine) throws IOException {
            Intrinsics.checkNotNullParameter((Object)statusLine, (String)"statusLine");
            int codeStart = 0;
            Protocol protocol = null;
            if (StringsKt.startsWith$default((String)statusLine, (String)"HTTP/1.", (boolean)false, (int)2, null)) {
                Protocol protocol2;
                if (statusLine.length() < 9 || statusLine.charAt(8) != ' ') {
                    throw new ProtocolException("Unexpected status line: " + statusLine);
                }
                int httpMinorVersion = statusLine.charAt(7) - 48;
                codeStart = 9;
                switch (httpMinorVersion) {
                    case 0: {
                        protocol2 = Protocol.HTTP_1_0;
                        break;
                    }
                    case 1: {
                        protocol2 = Protocol.HTTP_1_1;
                        break;
                    }
                    default: {
                        throw new ProtocolException("Unexpected status line: " + statusLine);
                    }
                }
                protocol = protocol2;
            } else if (StringsKt.startsWith$default((String)statusLine, (String)"ICY ", (boolean)false, (int)2, null)) {
                protocol = Protocol.HTTP_1_0;
                codeStart = 4;
            } else if (StringsKt.startsWith$default((String)statusLine, (String)"SOURCETABLE ", (boolean)false, (int)2, null)) {
                protocol = Protocol.HTTP_1_1;
                codeStart = 12;
            } else {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            if (statusLine.length() < codeStart + 3) {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            String string = statusLine.substring(codeStart, codeStart + 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            int code = n;
            String message = "";
            if (statusLine.length() > codeStart + 3) {
                if (statusLine.charAt(codeStart + 3) != ' ') {
                    throw new ProtocolException("Unexpected status line: " + statusLine);
                }
                String string2 = statusLine.substring(codeStart + 4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                message = string2;
            }
            return new StatusLine(protocol, code, message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

