/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.fingerprint;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.fingerprint.DisplayableFingerprint;
import org.signal.libsignal.protocol.fingerprint.Fingerprint;
import org.signal.libsignal.protocol.fingerprint.FingerprintGenerator;
import org.signal.libsignal.protocol.fingerprint.ScannableFingerprint;

public class NumericFingerprintGenerator
implements FingerprintGenerator {
    private final int iterations;

    public NumericFingerprintGenerator(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public Fingerprint createFor(int version, byte[] localStableIdentifier, IdentityKey localIdentityKey, byte[] remoteStableIdentifier, IdentityKey remoteIdentityKey) {
        try (NativeHandleGuard localIdentityKeyGuard = localIdentityKey.getPublicKey().guard();){
            NativeHandleGuard remoteIdentityKeyGuard = remoteIdentityKey.getPublicKey().guard();
            try {
                Fingerprint fingerprint = FilterExceptions.filterExceptions(() -> {
                    long handle = Native.NumericFingerprintGenerator_New(this.iterations, version, localStableIdentifier, localIdentityKeyGuard.nativeHandle(), remoteStableIdentifier, remoteIdentityKeyGuard.nativeHandle());
                    DisplayableFingerprint displayableFingerprint = new DisplayableFingerprint(Native.NumericFingerprintGenerator_GetDisplayString(handle));
                    ScannableFingerprint scannableFingerprint = new ScannableFingerprint(Native.NumericFingerprintGenerator_GetScannableEncoding(handle));
                    Native.NumericFingerprintGenerator_Destroy(handle);
                    return new Fingerprint(displayableFingerprint, scannableFingerprint);
                });
                if (remoteIdentityKeyGuard != null) {
                    remoteIdentityKeyGuard.close();
                }
                return fingerprint;
            }
            catch (Throwable throwable) {
                if (remoteIdentityKeyGuard != null) {
                    try {
                        remoteIdentityKeyGuard.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

