###############################################################################
#
# Tests for XlsxWriter.
#
# SPDX-License-Identifier: BSD-2-Clause
#
# Copyright (c), 2013-2025, John McNamara, jmcnamara@cpan.org
#

from xlsxwriter.workbook import Workbook

from ..excel_comparison_test import ExcelComparisonTest


class TestCompareXLSXFiles(ExcelComparisonTest):
    """
    Test file created by XlsxWriter against a file created by Excel.

    """

    def setUp(self):
        self.set_filename("tutorial02.xlsx")

        self.ignore_files = [
            "xl/calcChain.xml",
            "[Content_Types].xml",
            "xl/_rels/workbook.xml.rels",
        ]

    def test_create_file(self):
        """Example spreadsheet used in the tutorial 2."""

        workbook = Workbook(self.got_filename)
        worksheet = workbook.add_worksheet()

        # Add a bold format to use to highlight cells.
        bold = workbook.add_format({"bold": True})

        # Add a number format for cells with money.
        money_format = workbook.add_format({"num_format": "\\$#,##0"})

        # Write some data headers.
        worksheet.write("A1", "Item", bold)
        worksheet.write("B1", "Cost", bold)

        # Some data we want to write to the worksheet.
        expenses = (
            ["Rent", 1000],
            ["Gas", 100],
            ["Food", 300],
            ["Gym", 50],
        )

        # Start from the first cell below the headers.
        row = 1
        col = 0

        # Iterate over the data and write it out row by row.
        for item, cost in expenses:
            worksheet.write(row, col, item)
            worksheet.write(row, col + 1, cost, money_format)
            row += 1

        # Write a total using a formula.
        worksheet.write(row, 0, "Total", bold)
        worksheet.write(row, 1, "=SUM(B2:B5)", money_format, 1450)

        workbook.close()

        self.assertExcelEqual()
