# JDT Core

This is the core part of Eclipse's Java development tools. It contains the non-UI support for compiling and working with Java code, including the following:

* an incremental or batch Java compiler that can run standalone or as part of the Eclipse IDE
* Java source and class file indexer and search infrastructure
* a Java source code formatter
* APIs for code assist, access to the AST and structured manipulation of Java source.

For more information and important links, refer to the [JDT wiki page](https://github.com/eclipse-jdt/eclipse.jdt.core/wiki) or the [JDT project overview page](https://projects.eclipse.org/projects/eclipse.jdt).

## Snapshot builds

- Latest nightly, milestone and release SDK and ECJ builds are available at https://download.eclipse.org/eclipse/downloads/
- Weekly maven snapshot builds are available at https://repo.eclipse.org/content/repositories/eclipse-snapshots/

## Contributing

[Contributions are always welcome!](https://github.com/eclipse-jdt/.github/blob/main/CONTRIBUTING.md)

Please bear in mind that this project is almost entirely developed by volunteers.
If you do not provide the implementation yourself (or pay someone to do it for you), the bug might never get fixed.
If it is a serious bug, other people than you might care enough to provide a fix.

[![Create Eclipse Development Environment for JDT Core](https://download.eclipse.org/oomph/www/setups/svg/JDT_Core.svg)](
https://www.eclipse.org/setups/installer/?url=https://raw.githubusercontent.com/eclipse-jdt/eclipse.jdt.core/master/org.eclipse.jdt.core.setup/JdtCoreConfiguration.setup&show=true
"Click to open Eclipse-Installer Auto Launch or drag into your running installer")

## License

[Eclipse Public License (EPL) v2.0](https://www.eclipse.org/legal/epl-2.0/)

## Links

- https://github.com/eclipse-jdt/eclipse.jdt.core/wiki
- https://github.com/eclipse-jdt/.github/blob/main/CONTRIBUTING.md
- https://projects.eclipse.org/projects/eclipse.jdt
