/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/scheduling/v1"
	schedulingv1 "k8s.io/client-go/applyconfigurations/scheduling/v1"
	gentype "k8s.io/client-go/gentype"
	typedschedulingv1 "k8s.io/client-go/kubernetes/typed/scheduling/v1"
)

// fakePriorityClasses implements PriorityClassInterface
type fakePriorityClasses struct {
	*gentype.FakeClientWithListAndApply[*v1.PriorityClass, *v1.PriorityClassList, *schedulingv1.PriorityClassApplyConfiguration]
	Fake *FakeSchedulingV1
}

func newFakePriorityClasses(fake *FakeSchedulingV1) typedschedulingv1.PriorityClassInterface {
	return &fakePriorityClasses{
		gentype.NewFakeClientWithListAndApply[*v1.PriorityClass, *v1.PriorityClassList, *schedulingv1.PriorityClassApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("priorityclasses"),
			v1.SchemeGroupVersion.WithKind("PriorityClass"),
			func() *v1.PriorityClass { return &v1.PriorityClass{} },
			func() *v1.PriorityClassList { return &v1.PriorityClassList{} },
			func(dst, src *v1.PriorityClassList) { dst.ListMeta = src.ListMeta },
			func(list *v1.PriorityClassList) []*v1.PriorityClass { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.PriorityClassList, items []*v1.PriorityClass) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
