/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 Marvell International Ltd.
 *
 * Configuration and status register (CSR) type definitions for
 * Octeon pciercx.
 */

#ifndef __CVMX_PCIERCX_DEFS_H__
#define __CVMX_PCIERCX_DEFS_H__

static inline u64 CVMX_PCIERCX_CFG000(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000000ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000000ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000000ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000000ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000000ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000000ull;
	}
	return 0x0000020000000000ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG001(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000004ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000004ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000004ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000004ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000004ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000004ull;
	}
	return 0x0000020000000004ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG002(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000008ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000008ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000008ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000008ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000008ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000008ull;
	}
	return 0x0000020000000008ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG003(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000000Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000000Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000000Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000000Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000000Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000000Cull;
	}
	return 0x000002000000000Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG004(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000010ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000010ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000010ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000010ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000010ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000010ull;
	}
	return 0x0000020000000010ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG005(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000014ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000014ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000014ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000014ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000014ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000014ull;
	}
	return 0x0000020000000014ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG006(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000018ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000018ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000018ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000018ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000018ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000018ull;
	}
	return 0x0000020000000018ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG007(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000001Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000001Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000001Cull;
	}
	return 0x000002000000001Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG008(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000020ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000020ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000020ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000020ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000020ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000020ull;
	}
	return 0x0000020000000020ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG009(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000024ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000024ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000024ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000024ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000024ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000024ull;
	}
	return 0x0000020000000024ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG010(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000028ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000028ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000028ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000028ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000028ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000028ull;
	}
	return 0x0000020000000028ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG011(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000002Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000002Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000002Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000002Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000002Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000002Cull;
	}
	return 0x000002000000002Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG012(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000030ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000030ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000030ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000030ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000030ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000030ull;
	}
	return 0x0000020000000030ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG013(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000034ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000034ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000034ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000034ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000034ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000034ull;
	}
	return 0x0000020000000034ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG014(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000038ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000038ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000038ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000038ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000038ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000038ull;
	}
	return 0x0000020000000038ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG015(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000003Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000003Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000003Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000003Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000003Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000003Cull;
	}
	return 0x000002000000003Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG016(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000040ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000040ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000040ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000040ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000040ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000040ull;
	}
	return 0x0000020000000040ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG017(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000044ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000044ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000044ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000044ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000044ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000044ull;
	}
	return 0x0000020000000044ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG020(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000050ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000050ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000050ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000050ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000050ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000050ull;
	}
	return 0x0000020000000050ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG021(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000054ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000054ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000054ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000054ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000054ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000054ull;
	}
	return 0x0000020000000054ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG022(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000058ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000058ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000058ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000058ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000058ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000058ull;
	}
	return 0x0000020000000058ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG023(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000005Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000005Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000005Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000005Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000005Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000005Cull;
	}
	return 0x000002000000005Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG028(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000070ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000070ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000070ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000070ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000070ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000070ull;
	}
	return 0x0000020000000070ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG029(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000074ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000074ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000074ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000074ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000074ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000074ull;
	}
	return 0x0000020000000074ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG030(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000078ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000078ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000078ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000078ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000078ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000078ull;
	}
	return 0x0000020000000078ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG031(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000007Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000007Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000007Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000007Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000007Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000007Cull;
	}
	return 0x000002000000007Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG032(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000080ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000080ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000080ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000080ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000080ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000080ull;
	}
	return 0x0000020000000080ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG033(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000084ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000084ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000084ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000084ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000084ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000084ull;
	}
	return 0x0000020000000084ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG034(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000088ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000088ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000088ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000088ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000088ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000088ull;
	}
	return 0x0000020000000088ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG035(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000008Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000008Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000008Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000008Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000008Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000008Cull;
	}
	return 0x000002000000008Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG036(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000090ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000090ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000090ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000090ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000090ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000090ull;
	}
	return 0x0000020000000090ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG037(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000094ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000094ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000094ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000094ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000094ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000094ull;
	}
	return 0x0000020000000094ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG038(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000098ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000098ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000098ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000098ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000098ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000098ull;
	}
	return 0x0000020000000098ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG039(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000009Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000009Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000009Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000009Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000009Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000009Cull;
	}
	return 0x000002000000009Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG040(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A0ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A0ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000200000000A0ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000200000000A0ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A0ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000000A0ull;
	}
	return 0x00000200000000A0ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG041(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A4ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A4ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000200000000A4ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000200000000A4ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A4ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000000A4ull;
	}
	return 0x00000200000000A4ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG042(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A8ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A8ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x00000200000000A8ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x00000200000000A8ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x00000200000000A8ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000000A8ull;
	}
	return 0x00000200000000A8ull + (offset) * 0x100000000ull;
}

#define CVMX_PCIERCX_CFG044(offset) (0x00000200000000B0ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG045(offset) (0x00000200000000B4ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG046(offset) (0x00000200000000B8ull + ((offset) & 3) * 0x100000000ull)
static inline u64 CVMX_PCIERCX_CFG064(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000100ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000100ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000100ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000100ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000100ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000100ull;
	}
	return 0x0000020000000100ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG065(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000104ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000104ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000104ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000104ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000104ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000104ull;
	}
	return 0x0000020000000104ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG066(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000108ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000108ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000108ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000108ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000108ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000108ull;
	}
	return 0x0000020000000108ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG067(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000010Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000010Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000010Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000010Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000010Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000010Cull;
	}
	return 0x000002000000010Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG068(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000110ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000110ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000110ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000110ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000110ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000110ull;
	}
	return 0x0000020000000110ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG069(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000114ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000114ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000114ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000114ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000114ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000114ull;
	}
	return 0x0000020000000114ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG070(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000118ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000118ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000118ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000118ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000118ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000118ull;
	}
	return 0x0000020000000118ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG071(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000011Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000011Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000011Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000011Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000011Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000011Cull;
	}
	return 0x000002000000011Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG072(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000120ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000120ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000120ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000120ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000120ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000120ull;
	}
	return 0x0000020000000120ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG073(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000124ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000124ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000124ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000124ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000124ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000124ull;
	}
	return 0x0000020000000124ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG074(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000128ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000128ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000128ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000128ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000128ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000128ull;
	}
	return 0x0000020000000128ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG075(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000012Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000012Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000012Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000012Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000012Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000012Cull;
	}
	return 0x000002000000012Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG076(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000130ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000130ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000130ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000130ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000130ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000130ull;
	}
	return 0x0000020000000130ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG077(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000134ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000134ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000134ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000134ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000134ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000134ull;
	}
	return 0x0000020000000134ull + (offset) * 0x100000000ull;
}

#define CVMX_PCIERCX_CFG086(offset) (0x0000020000000158ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG087(offset) (0x000002000000015Cull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG088(offset) (0x0000020000000160ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG089(offset) (0x0000020000000164ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG090(offset) (0x0000020000000168ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG091(offset) (0x000002000000016Cull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG092(offset) (0x0000020000000170ull + ((offset) & 3) * 0x100000000ull)
static inline u64 CVMX_PCIERCX_CFG448(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000700ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000700ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000700ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000700ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000700ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000700ull;
	}
	return 0x0000020000000700ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG449(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000704ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000704ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000704ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000704ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000704ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000704ull;
	}
	return 0x0000020000000704ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG450(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000708ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000708ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000708ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000708ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000708ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000708ull;
	}
	return 0x0000020000000708ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG451(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000070Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000070Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000070Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000070Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000070Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000070Cull;
	}
	return 0x000002000000070Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG452(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000710ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000710ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000710ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000710ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000710ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000710ull;
	}
	return 0x0000020000000710ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG453(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000714ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000714ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000714ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000714ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000714ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000714ull;
	}
	return 0x0000020000000714ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG454(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000718ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000718ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000718ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000718ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000718ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000718ull;
	}
	return 0x0000020000000718ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG455(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000071Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000071Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000071Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000071Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000071Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000071Cull;
	}
	return 0x000002000000071Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG456(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000720ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000720ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000720ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000720ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000720ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000720ull;
	}
	return 0x0000020000000720ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG458(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000728ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000728ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000728ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000728ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000728ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000728ull;
	}
	return 0x0000020000000728ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG459(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000072Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000072Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000072Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000072Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000072Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000072Cull;
	}
	return 0x000002000000072Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG460(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000730ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000730ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000730ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000730ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000730ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000730ull;
	}
	return 0x0000020000000730ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG461(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000734ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000734ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000734ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000734ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000734ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000734ull;
	}
	return 0x0000020000000734ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG462(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000738ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000738ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000738ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000738ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000738ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000738ull;
	}
	return 0x0000020000000738ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG463(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000073Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000073Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000073Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000073Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000073Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000073Cull;
	}
	return 0x000002000000073Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG464(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000740ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000740ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000740ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000740ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000740ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000740ull;
	}
	return 0x0000020000000740ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG465(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000744ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000744ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000744ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000744ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000744ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000744ull;
	}
	return 0x0000020000000744ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG466(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000748ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000748ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000748ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000748ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000748ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000748ull;
	}
	return 0x0000020000000748ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG467(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000074Cull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000074Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000074Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000074Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000074Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000074Cull;
	}
	return 0x000002000000074Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG468(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000750ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000750ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000750ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000750ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000750ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000750ull;
	}
	return 0x0000020000000750ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG490(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000007A8ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000200000007A8ull + (offset) * 0x100000000ull;
	}
	return 0x00000000000007A8ull;
}

static inline u64 CVMX_PCIERCX_CFG491(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000007ACull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000200000007ACull + (offset) * 0x100000000ull;
	}
	return 0x00000000000007ACull;
}

static inline u64 CVMX_PCIERCX_CFG492(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x00000000000007B0ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x00000200000007B0ull + (offset) * 0x100000000ull;
	}
	return 0x00000000000007B0ull;
}

static inline u64 CVMX_PCIERCX_CFG515(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x000002000000080Cull + (offset) * 0x100000000ull;
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x000002000000080Cull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x000002000000080Cull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x000002000000080Cull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x000002000000080Cull + (offset) * 0x100000000ull;
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x000000000000080Cull;
	}
	return 0x000002000000080Cull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG516(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000810ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000810ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000810ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000810ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000810ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000810ull;
	}
	return 0x0000020000000810ull + (offset) * 0x100000000ull;
}

static inline u64 CVMX_PCIERCX_CFG517(unsigned long offset)
{
	switch (cvmx_get_octeon_family()) {
	case OCTEON_CNF75XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000814ull + (offset) * 0x100000000ull;
	case OCTEON_CN70XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000814ull + (offset) * 0x100000000ull;
	case OCTEON_CN78XX & OCTEON_FAMILY_MASK:
		if (OCTEON_IS_MODEL(OCTEON_CN78XX_PASS1_X))
			return 0x0000020000000814ull + (offset) * 0x100000000ull;
		if (OCTEON_IS_MODEL(OCTEON_CN78XX))
			return 0x0000020000000814ull + (offset) * 0x100000000ull;
	case OCTEON_CN73XX & OCTEON_FAMILY_MASK:
		return 0x0000020000000814ull + (offset) * 0x100000000ull;
	case OCTEON_CNF71XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN61XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN66XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN63XX & OCTEON_FAMILY_MASK:
	case OCTEON_CN68XX & OCTEON_FAMILY_MASK:
		return 0x0000000000000814ull;
	}
	return 0x0000020000000814ull + (offset) * 0x100000000ull;
}

#define CVMX_PCIERCX_CFG548(offset) (0x0000020000000890ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG554(offset) (0x00000200000008A8ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG558(offset) (0x00000200000008B8ull + ((offset) & 3) * 0x100000000ull)
#define CVMX_PCIERCX_CFG559(offset) (0x00000200000008BCull + ((offset) & 3) * 0x100000000ull)

/**
 * cvmx_pcierc#_cfg000
 *
 * This register contains the first 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg000 {
	u32 u32;
	struct cvmx_pciercx_cfg000_s {
		u32 devid : 16;
		u32 vendid : 16;
	} s;
	struct cvmx_pciercx_cfg000_s cn52xx;
	struct cvmx_pciercx_cfg000_s cn52xxp1;
	struct cvmx_pciercx_cfg000_s cn56xx;
	struct cvmx_pciercx_cfg000_s cn56xxp1;
	struct cvmx_pciercx_cfg000_s cn61xx;
	struct cvmx_pciercx_cfg000_s cn63xx;
	struct cvmx_pciercx_cfg000_s cn63xxp1;
	struct cvmx_pciercx_cfg000_s cn66xx;
	struct cvmx_pciercx_cfg000_s cn68xx;
	struct cvmx_pciercx_cfg000_s cn68xxp1;
	struct cvmx_pciercx_cfg000_s cn70xx;
	struct cvmx_pciercx_cfg000_s cn70xxp1;
	struct cvmx_pciercx_cfg000_s cn73xx;
	struct cvmx_pciercx_cfg000_s cn78xx;
	struct cvmx_pciercx_cfg000_s cn78xxp1;
	struct cvmx_pciercx_cfg000_s cnf71xx;
	struct cvmx_pciercx_cfg000_s cnf75xx;
};

typedef union cvmx_pciercx_cfg000 cvmx_pciercx_cfg000_t;

/**
 * cvmx_pcierc#_cfg001
 *
 * This register contains the second 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg001 {
	u32 u32;
	struct cvmx_pciercx_cfg001_s {
		u32 dpe : 1;
		u32 sse : 1;
		u32 rma : 1;
		u32 rta : 1;
		u32 sta : 1;
		u32 devt : 2;
		u32 mdpe : 1;
		u32 fbb : 1;
		u32 reserved_22_22 : 1;
		u32 m66 : 1;
		u32 cl : 1;
		u32 i_stat : 1;
		u32 reserved_11_18 : 8;
		u32 i_dis : 1;
		u32 fbbe : 1;
		u32 see : 1;
		u32 ids_wcc : 1;
		u32 per : 1;
		u32 vps : 1;
		u32 mwice : 1;
		u32 scse : 1;
		u32 me : 1;
		u32 msae : 1;
		u32 isae : 1;
	} s;
	struct cvmx_pciercx_cfg001_s cn52xx;
	struct cvmx_pciercx_cfg001_s cn52xxp1;
	struct cvmx_pciercx_cfg001_s cn56xx;
	struct cvmx_pciercx_cfg001_s cn56xxp1;
	struct cvmx_pciercx_cfg001_s cn61xx;
	struct cvmx_pciercx_cfg001_s cn63xx;
	struct cvmx_pciercx_cfg001_s cn63xxp1;
	struct cvmx_pciercx_cfg001_s cn66xx;
	struct cvmx_pciercx_cfg001_s cn68xx;
	struct cvmx_pciercx_cfg001_s cn68xxp1;
	struct cvmx_pciercx_cfg001_s cn70xx;
	struct cvmx_pciercx_cfg001_s cn70xxp1;
	struct cvmx_pciercx_cfg001_s cn73xx;
	struct cvmx_pciercx_cfg001_s cn78xx;
	struct cvmx_pciercx_cfg001_s cn78xxp1;
	struct cvmx_pciercx_cfg001_s cnf71xx;
	struct cvmx_pciercx_cfg001_s cnf75xx;
};

typedef union cvmx_pciercx_cfg001 cvmx_pciercx_cfg001_t;

/**
 * cvmx_pcierc#_cfg002
 *
 * This register contains the third 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg002 {
	u32 u32;
	struct cvmx_pciercx_cfg002_s {
		u32 bcc : 8;
		u32 sc : 8;
		u32 pi : 8;
		u32 rid : 8;
	} s;
	struct cvmx_pciercx_cfg002_s cn52xx;
	struct cvmx_pciercx_cfg002_s cn52xxp1;
	struct cvmx_pciercx_cfg002_s cn56xx;
	struct cvmx_pciercx_cfg002_s cn56xxp1;
	struct cvmx_pciercx_cfg002_s cn61xx;
	struct cvmx_pciercx_cfg002_s cn63xx;
	struct cvmx_pciercx_cfg002_s cn63xxp1;
	struct cvmx_pciercx_cfg002_s cn66xx;
	struct cvmx_pciercx_cfg002_s cn68xx;
	struct cvmx_pciercx_cfg002_s cn68xxp1;
	struct cvmx_pciercx_cfg002_s cn70xx;
	struct cvmx_pciercx_cfg002_s cn70xxp1;
	struct cvmx_pciercx_cfg002_s cn73xx;
	struct cvmx_pciercx_cfg002_s cn78xx;
	struct cvmx_pciercx_cfg002_s cn78xxp1;
	struct cvmx_pciercx_cfg002_s cnf71xx;
	struct cvmx_pciercx_cfg002_s cnf75xx;
};

typedef union cvmx_pciercx_cfg002 cvmx_pciercx_cfg002_t;

/**
 * cvmx_pcierc#_cfg003
 *
 * This register contains the fourth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg003 {
	u32 u32;
	struct cvmx_pciercx_cfg003_s {
		u32 bist : 8;
		u32 mfd : 1;
		u32 chf : 7;
		u32 lt : 8;
		u32 cls : 8;
	} s;
	struct cvmx_pciercx_cfg003_s cn52xx;
	struct cvmx_pciercx_cfg003_s cn52xxp1;
	struct cvmx_pciercx_cfg003_s cn56xx;
	struct cvmx_pciercx_cfg003_s cn56xxp1;
	struct cvmx_pciercx_cfg003_s cn61xx;
	struct cvmx_pciercx_cfg003_s cn63xx;
	struct cvmx_pciercx_cfg003_s cn63xxp1;
	struct cvmx_pciercx_cfg003_s cn66xx;
	struct cvmx_pciercx_cfg003_s cn68xx;
	struct cvmx_pciercx_cfg003_s cn68xxp1;
	struct cvmx_pciercx_cfg003_s cn70xx;
	struct cvmx_pciercx_cfg003_s cn70xxp1;
	struct cvmx_pciercx_cfg003_s cn73xx;
	struct cvmx_pciercx_cfg003_s cn78xx;
	struct cvmx_pciercx_cfg003_s cn78xxp1;
	struct cvmx_pciercx_cfg003_s cnf71xx;
	struct cvmx_pciercx_cfg003_s cnf75xx;
};

typedef union cvmx_pciercx_cfg003 cvmx_pciercx_cfg003_t;

/**
 * cvmx_pcierc#_cfg004
 *
 * This register contains the fifth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg004 {
	u32 u32;
	struct cvmx_pciercx_cfg004_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pciercx_cfg004_s cn52xx;
	struct cvmx_pciercx_cfg004_s cn52xxp1;
	struct cvmx_pciercx_cfg004_s cn56xx;
	struct cvmx_pciercx_cfg004_s cn56xxp1;
	struct cvmx_pciercx_cfg004_s cn61xx;
	struct cvmx_pciercx_cfg004_s cn63xx;
	struct cvmx_pciercx_cfg004_s cn63xxp1;
	struct cvmx_pciercx_cfg004_s cn66xx;
	struct cvmx_pciercx_cfg004_s cn68xx;
	struct cvmx_pciercx_cfg004_s cn68xxp1;
	struct cvmx_pciercx_cfg004_cn70xx {
		u32 reserved_31_0 : 32;
	} cn70xx;
	struct cvmx_pciercx_cfg004_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg004_cn70xx cn73xx;
	struct cvmx_pciercx_cfg004_cn70xx cn78xx;
	struct cvmx_pciercx_cfg004_cn70xx cn78xxp1;
	struct cvmx_pciercx_cfg004_s cnf71xx;
	struct cvmx_pciercx_cfg004_cn70xx cnf75xx;
};

typedef union cvmx_pciercx_cfg004 cvmx_pciercx_cfg004_t;

/**
 * cvmx_pcierc#_cfg005
 *
 * This register contains the sixth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg005 {
	u32 u32;
	struct cvmx_pciercx_cfg005_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pciercx_cfg005_s cn52xx;
	struct cvmx_pciercx_cfg005_s cn52xxp1;
	struct cvmx_pciercx_cfg005_s cn56xx;
	struct cvmx_pciercx_cfg005_s cn56xxp1;
	struct cvmx_pciercx_cfg005_s cn61xx;
	struct cvmx_pciercx_cfg005_s cn63xx;
	struct cvmx_pciercx_cfg005_s cn63xxp1;
	struct cvmx_pciercx_cfg005_s cn66xx;
	struct cvmx_pciercx_cfg005_s cn68xx;
	struct cvmx_pciercx_cfg005_s cn68xxp1;
	struct cvmx_pciercx_cfg005_cn70xx {
		u32 reserved_31_0 : 32;
	} cn70xx;
	struct cvmx_pciercx_cfg005_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg005_cn70xx cn73xx;
	struct cvmx_pciercx_cfg005_cn70xx cn78xx;
	struct cvmx_pciercx_cfg005_cn70xx cn78xxp1;
	struct cvmx_pciercx_cfg005_s cnf71xx;
	struct cvmx_pciercx_cfg005_cn70xx cnf75xx;
};

typedef union cvmx_pciercx_cfg005 cvmx_pciercx_cfg005_t;

/**
 * cvmx_pcierc#_cfg006
 *
 * This register contains the seventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg006 {
	u32 u32;
	struct cvmx_pciercx_cfg006_s {
		u32 slt : 8;
		u32 subbnum : 8;
		u32 sbnum : 8;
		u32 pbnum : 8;
	} s;
	struct cvmx_pciercx_cfg006_s cn52xx;
	struct cvmx_pciercx_cfg006_s cn52xxp1;
	struct cvmx_pciercx_cfg006_s cn56xx;
	struct cvmx_pciercx_cfg006_s cn56xxp1;
	struct cvmx_pciercx_cfg006_s cn61xx;
	struct cvmx_pciercx_cfg006_s cn63xx;
	struct cvmx_pciercx_cfg006_s cn63xxp1;
	struct cvmx_pciercx_cfg006_s cn66xx;
	struct cvmx_pciercx_cfg006_s cn68xx;
	struct cvmx_pciercx_cfg006_s cn68xxp1;
	struct cvmx_pciercx_cfg006_s cn70xx;
	struct cvmx_pciercx_cfg006_s cn70xxp1;
	struct cvmx_pciercx_cfg006_s cn73xx;
	struct cvmx_pciercx_cfg006_s cn78xx;
	struct cvmx_pciercx_cfg006_s cn78xxp1;
	struct cvmx_pciercx_cfg006_s cnf71xx;
	struct cvmx_pciercx_cfg006_s cnf75xx;
};

typedef union cvmx_pciercx_cfg006 cvmx_pciercx_cfg006_t;

/**
 * cvmx_pcierc#_cfg007
 *
 * This register contains the eighth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg007 {
	u32 u32;
	struct cvmx_pciercx_cfg007_s {
		u32 dpe : 1;
		u32 sse : 1;
		u32 rma : 1;
		u32 rta : 1;
		u32 sta : 1;
		u32 devt : 2;
		u32 mdpe : 1;
		u32 fbb : 1;
		u32 reserved_22_22 : 1;
		u32 m66 : 1;
		u32 reserved_16_20 : 5;
		u32 lio_limi : 4;
		u32 reserved_9_11 : 3;
		u32 io32b : 1;
		u32 lio_base : 4;
		u32 reserved_1_3 : 3;
		u32 io32a : 1;
	} s;
	struct cvmx_pciercx_cfg007_s cn52xx;
	struct cvmx_pciercx_cfg007_s cn52xxp1;
	struct cvmx_pciercx_cfg007_s cn56xx;
	struct cvmx_pciercx_cfg007_s cn56xxp1;
	struct cvmx_pciercx_cfg007_s cn61xx;
	struct cvmx_pciercx_cfg007_s cn63xx;
	struct cvmx_pciercx_cfg007_s cn63xxp1;
	struct cvmx_pciercx_cfg007_s cn66xx;
	struct cvmx_pciercx_cfg007_s cn68xx;
	struct cvmx_pciercx_cfg007_s cn68xxp1;
	struct cvmx_pciercx_cfg007_s cn70xx;
	struct cvmx_pciercx_cfg007_s cn70xxp1;
	struct cvmx_pciercx_cfg007_s cn73xx;
	struct cvmx_pciercx_cfg007_s cn78xx;
	struct cvmx_pciercx_cfg007_s cn78xxp1;
	struct cvmx_pciercx_cfg007_s cnf71xx;
	struct cvmx_pciercx_cfg007_s cnf75xx;
};

typedef union cvmx_pciercx_cfg007 cvmx_pciercx_cfg007_t;

/**
 * cvmx_pcierc#_cfg008
 *
 * This register contains the ninth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg008 {
	u32 u32;
	struct cvmx_pciercx_cfg008_s {
		u32 ml_addr : 12;
		u32 reserved_16_19 : 4;
		u32 mb_addr : 12;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pciercx_cfg008_s cn52xx;
	struct cvmx_pciercx_cfg008_s cn52xxp1;
	struct cvmx_pciercx_cfg008_s cn56xx;
	struct cvmx_pciercx_cfg008_s cn56xxp1;
	struct cvmx_pciercx_cfg008_s cn61xx;
	struct cvmx_pciercx_cfg008_s cn63xx;
	struct cvmx_pciercx_cfg008_s cn63xxp1;
	struct cvmx_pciercx_cfg008_s cn66xx;
	struct cvmx_pciercx_cfg008_s cn68xx;
	struct cvmx_pciercx_cfg008_s cn68xxp1;
	struct cvmx_pciercx_cfg008_cn70xx {
		u32 ml_addr : 12;
		u32 reserved_19_16 : 4;
		u32 mb_addr : 12;
		u32 reserved_3_0 : 4;
	} cn70xx;
	struct cvmx_pciercx_cfg008_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg008_cn70xx cn73xx;
	struct cvmx_pciercx_cfg008_cn70xx cn78xx;
	struct cvmx_pciercx_cfg008_cn70xx cn78xxp1;
	struct cvmx_pciercx_cfg008_s cnf71xx;
	struct cvmx_pciercx_cfg008_cn70xx cnf75xx;
};

typedef union cvmx_pciercx_cfg008 cvmx_pciercx_cfg008_t;

/**
 * cvmx_pcierc#_cfg009
 *
 * This register contains the tenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg009 {
	u32 u32;
	struct cvmx_pciercx_cfg009_s {
		u32 lmem_limit : 12;
		u32 reserved_17_19 : 3;
		u32 mem64b : 1;
		u32 lmem_base : 12;
		u32 reserved_1_3 : 3;
		u32 mem64a : 1;
	} s;
	struct cvmx_pciercx_cfg009_s cn52xx;
	struct cvmx_pciercx_cfg009_s cn52xxp1;
	struct cvmx_pciercx_cfg009_s cn56xx;
	struct cvmx_pciercx_cfg009_s cn56xxp1;
	struct cvmx_pciercx_cfg009_s cn61xx;
	struct cvmx_pciercx_cfg009_s cn63xx;
	struct cvmx_pciercx_cfg009_s cn63xxp1;
	struct cvmx_pciercx_cfg009_s cn66xx;
	struct cvmx_pciercx_cfg009_s cn68xx;
	struct cvmx_pciercx_cfg009_s cn68xxp1;
	struct cvmx_pciercx_cfg009_cn70xx {
		u32 lmem_limit : 12;
		u32 reserved_19_17 : 3;
		u32 mem64b : 1;
		u32 lmem_base : 12;
		u32 reserved_3_1 : 3;
		u32 mem64a : 1;
	} cn70xx;
	struct cvmx_pciercx_cfg009_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg009_cn70xx cn73xx;
	struct cvmx_pciercx_cfg009_cn70xx cn78xx;
	struct cvmx_pciercx_cfg009_cn70xx cn78xxp1;
	struct cvmx_pciercx_cfg009_s cnf71xx;
	struct cvmx_pciercx_cfg009_cn70xx cnf75xx;
};

typedef union cvmx_pciercx_cfg009 cvmx_pciercx_cfg009_t;

/**
 * cvmx_pcierc#_cfg010
 *
 * This register contains the eleventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg010 {
	u32 u32;
	struct cvmx_pciercx_cfg010_s {
		u32 umem_base : 32;
	} s;
	struct cvmx_pciercx_cfg010_s cn52xx;
	struct cvmx_pciercx_cfg010_s cn52xxp1;
	struct cvmx_pciercx_cfg010_s cn56xx;
	struct cvmx_pciercx_cfg010_s cn56xxp1;
	struct cvmx_pciercx_cfg010_s cn61xx;
	struct cvmx_pciercx_cfg010_s cn63xx;
	struct cvmx_pciercx_cfg010_s cn63xxp1;
	struct cvmx_pciercx_cfg010_s cn66xx;
	struct cvmx_pciercx_cfg010_s cn68xx;
	struct cvmx_pciercx_cfg010_s cn68xxp1;
	struct cvmx_pciercx_cfg010_s cn70xx;
	struct cvmx_pciercx_cfg010_s cn70xxp1;
	struct cvmx_pciercx_cfg010_s cn73xx;
	struct cvmx_pciercx_cfg010_s cn78xx;
	struct cvmx_pciercx_cfg010_s cn78xxp1;
	struct cvmx_pciercx_cfg010_s cnf71xx;
	struct cvmx_pciercx_cfg010_s cnf75xx;
};

typedef union cvmx_pciercx_cfg010 cvmx_pciercx_cfg010_t;

/**
 * cvmx_pcierc#_cfg011
 *
 * This register contains the twelfth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg011 {
	u32 u32;
	struct cvmx_pciercx_cfg011_s {
		u32 umem_limit : 32;
	} s;
	struct cvmx_pciercx_cfg011_s cn52xx;
	struct cvmx_pciercx_cfg011_s cn52xxp1;
	struct cvmx_pciercx_cfg011_s cn56xx;
	struct cvmx_pciercx_cfg011_s cn56xxp1;
	struct cvmx_pciercx_cfg011_s cn61xx;
	struct cvmx_pciercx_cfg011_s cn63xx;
	struct cvmx_pciercx_cfg011_s cn63xxp1;
	struct cvmx_pciercx_cfg011_s cn66xx;
	struct cvmx_pciercx_cfg011_s cn68xx;
	struct cvmx_pciercx_cfg011_s cn68xxp1;
	struct cvmx_pciercx_cfg011_s cn70xx;
	struct cvmx_pciercx_cfg011_s cn70xxp1;
	struct cvmx_pciercx_cfg011_s cn73xx;
	struct cvmx_pciercx_cfg011_s cn78xx;
	struct cvmx_pciercx_cfg011_s cn78xxp1;
	struct cvmx_pciercx_cfg011_s cnf71xx;
	struct cvmx_pciercx_cfg011_s cnf75xx;
};

typedef union cvmx_pciercx_cfg011 cvmx_pciercx_cfg011_t;

/**
 * cvmx_pcierc#_cfg012
 *
 * This register contains the thirteenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg012 {
	u32 u32;
	struct cvmx_pciercx_cfg012_s {
		u32 uio_limit : 16;
		u32 uio_base : 16;
	} s;
	struct cvmx_pciercx_cfg012_s cn52xx;
	struct cvmx_pciercx_cfg012_s cn52xxp1;
	struct cvmx_pciercx_cfg012_s cn56xx;
	struct cvmx_pciercx_cfg012_s cn56xxp1;
	struct cvmx_pciercx_cfg012_s cn61xx;
	struct cvmx_pciercx_cfg012_s cn63xx;
	struct cvmx_pciercx_cfg012_s cn63xxp1;
	struct cvmx_pciercx_cfg012_s cn66xx;
	struct cvmx_pciercx_cfg012_s cn68xx;
	struct cvmx_pciercx_cfg012_s cn68xxp1;
	struct cvmx_pciercx_cfg012_s cn70xx;
	struct cvmx_pciercx_cfg012_s cn70xxp1;
	struct cvmx_pciercx_cfg012_s cn73xx;
	struct cvmx_pciercx_cfg012_s cn78xx;
	struct cvmx_pciercx_cfg012_s cn78xxp1;
	struct cvmx_pciercx_cfg012_s cnf71xx;
	struct cvmx_pciercx_cfg012_s cnf75xx;
};

typedef union cvmx_pciercx_cfg012 cvmx_pciercx_cfg012_t;

/**
 * cvmx_pcierc#_cfg013
 *
 * This register contains the fourteenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg013 {
	u32 u32;
	struct cvmx_pciercx_cfg013_s {
		u32 reserved_8_31 : 24;
		u32 cp : 8;
	} s;
	struct cvmx_pciercx_cfg013_s cn52xx;
	struct cvmx_pciercx_cfg013_s cn52xxp1;
	struct cvmx_pciercx_cfg013_s cn56xx;
	struct cvmx_pciercx_cfg013_s cn56xxp1;
	struct cvmx_pciercx_cfg013_s cn61xx;
	struct cvmx_pciercx_cfg013_s cn63xx;
	struct cvmx_pciercx_cfg013_s cn63xxp1;
	struct cvmx_pciercx_cfg013_s cn66xx;
	struct cvmx_pciercx_cfg013_s cn68xx;
	struct cvmx_pciercx_cfg013_s cn68xxp1;
	struct cvmx_pciercx_cfg013_s cn70xx;
	struct cvmx_pciercx_cfg013_s cn70xxp1;
	struct cvmx_pciercx_cfg013_s cn73xx;
	struct cvmx_pciercx_cfg013_s cn78xx;
	struct cvmx_pciercx_cfg013_s cn78xxp1;
	struct cvmx_pciercx_cfg013_s cnf71xx;
	struct cvmx_pciercx_cfg013_s cnf75xx;
};

typedef union cvmx_pciercx_cfg013 cvmx_pciercx_cfg013_t;

/**
 * cvmx_pcierc#_cfg014
 *
 * This register contains the fifteenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg014 {
	u32 u32;
	struct cvmx_pciercx_cfg014_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pciercx_cfg014_s cn52xx;
	struct cvmx_pciercx_cfg014_s cn52xxp1;
	struct cvmx_pciercx_cfg014_s cn56xx;
	struct cvmx_pciercx_cfg014_s cn56xxp1;
	struct cvmx_pciercx_cfg014_s cn61xx;
	struct cvmx_pciercx_cfg014_s cn63xx;
	struct cvmx_pciercx_cfg014_s cn63xxp1;
	struct cvmx_pciercx_cfg014_s cn66xx;
	struct cvmx_pciercx_cfg014_s cn68xx;
	struct cvmx_pciercx_cfg014_s cn68xxp1;
	struct cvmx_pciercx_cfg014_s cn70xx;
	struct cvmx_pciercx_cfg014_s cn70xxp1;
	struct cvmx_pciercx_cfg014_s cn73xx;
	struct cvmx_pciercx_cfg014_s cn78xx;
	struct cvmx_pciercx_cfg014_s cn78xxp1;
	struct cvmx_pciercx_cfg014_s cnf71xx;
	struct cvmx_pciercx_cfg014_s cnf75xx;
};

typedef union cvmx_pciercx_cfg014 cvmx_pciercx_cfg014_t;

/**
 * cvmx_pcierc#_cfg015
 *
 * This register contains the sixteenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg015 {
	u32 u32;
	struct cvmx_pciercx_cfg015_s {
		u32 reserved_28_31 : 4;
		u32 dtsees : 1;
		u32 dts : 1;
		u32 sdt : 1;
		u32 pdt : 1;
		u32 fbbe : 1;
		u32 sbrst : 1;
		u32 mam : 1;
		u32 vga16d : 1;
		u32 vgae : 1;
		u32 isae : 1;
		u32 see : 1;
		u32 pere : 1;
		u32 inta : 8;
		u32 il : 8;
	} s;
	struct cvmx_pciercx_cfg015_s cn52xx;
	struct cvmx_pciercx_cfg015_s cn52xxp1;
	struct cvmx_pciercx_cfg015_s cn56xx;
	struct cvmx_pciercx_cfg015_s cn56xxp1;
	struct cvmx_pciercx_cfg015_s cn61xx;
	struct cvmx_pciercx_cfg015_s cn63xx;
	struct cvmx_pciercx_cfg015_s cn63xxp1;
	struct cvmx_pciercx_cfg015_s cn66xx;
	struct cvmx_pciercx_cfg015_s cn68xx;
	struct cvmx_pciercx_cfg015_s cn68xxp1;
	struct cvmx_pciercx_cfg015_cn70xx {
		u32 reserved_31_28 : 4;
		u32 dtsees : 1;
		u32 dts : 1;
		u32 sdt : 1;
		u32 pdt : 1;
		u32 fbbe : 1;
		u32 sbrst : 1;
		u32 mam : 1;
		u32 vga16d : 1;
		u32 vgae : 1;
		u32 isae : 1;
		u32 see : 1;
		u32 pere : 1;
		u32 inta : 8;
		u32 il : 8;
	} cn70xx;
	struct cvmx_pciercx_cfg015_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg015_cn70xx cn73xx;
	struct cvmx_pciercx_cfg015_cn70xx cn78xx;
	struct cvmx_pciercx_cfg015_cn70xx cn78xxp1;
	struct cvmx_pciercx_cfg015_s cnf71xx;
	struct cvmx_pciercx_cfg015_cn70xx cnf75xx;
};

typedef union cvmx_pciercx_cfg015 cvmx_pciercx_cfg015_t;

/**
 * cvmx_pcierc#_cfg016
 *
 * This register contains the seventeenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg016 {
	u32 u32;
	struct cvmx_pciercx_cfg016_s {
		u32 pmes : 5;
		u32 d2s : 1;
		u32 d1s : 1;
		u32 auxc : 3;
		u32 dsi : 1;
		u32 reserved_20_20 : 1;
		u32 pme_clock : 1;
		u32 pmsv : 3;
		u32 ncp : 8;
		u32 pmcid : 8;
	} s;
	struct cvmx_pciercx_cfg016_s cn52xx;
	struct cvmx_pciercx_cfg016_s cn52xxp1;
	struct cvmx_pciercx_cfg016_s cn56xx;
	struct cvmx_pciercx_cfg016_s cn56xxp1;
	struct cvmx_pciercx_cfg016_s cn61xx;
	struct cvmx_pciercx_cfg016_s cn63xx;
	struct cvmx_pciercx_cfg016_s cn63xxp1;
	struct cvmx_pciercx_cfg016_s cn66xx;
	struct cvmx_pciercx_cfg016_s cn68xx;
	struct cvmx_pciercx_cfg016_s cn68xxp1;
	struct cvmx_pciercx_cfg016_s cn70xx;
	struct cvmx_pciercx_cfg016_s cn70xxp1;
	struct cvmx_pciercx_cfg016_s cn73xx;
	struct cvmx_pciercx_cfg016_s cn78xx;
	struct cvmx_pciercx_cfg016_s cn78xxp1;
	struct cvmx_pciercx_cfg016_s cnf71xx;
	struct cvmx_pciercx_cfg016_s cnf75xx;
};

typedef union cvmx_pciercx_cfg016 cvmx_pciercx_cfg016_t;

/**
 * cvmx_pcierc#_cfg017
 *
 * This register contains the eighteenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg017 {
	u32 u32;
	struct cvmx_pciercx_cfg017_s {
		u32 pmdia : 8;
		u32 bpccee : 1;
		u32 bd3h : 1;
		u32 reserved_16_21 : 6;
		u32 pmess : 1;
		u32 pmedsia : 2;
		u32 pmds : 4;
		u32 pmeens : 1;
		u32 reserved_4_7 : 4;
		u32 nsr : 1;
		u32 reserved_2_2 : 1;
		u32 ps : 2;
	} s;
	struct cvmx_pciercx_cfg017_s cn52xx;
	struct cvmx_pciercx_cfg017_s cn52xxp1;
	struct cvmx_pciercx_cfg017_s cn56xx;
	struct cvmx_pciercx_cfg017_s cn56xxp1;
	struct cvmx_pciercx_cfg017_s cn61xx;
	struct cvmx_pciercx_cfg017_s cn63xx;
	struct cvmx_pciercx_cfg017_s cn63xxp1;
	struct cvmx_pciercx_cfg017_s cn66xx;
	struct cvmx_pciercx_cfg017_s cn68xx;
	struct cvmx_pciercx_cfg017_s cn68xxp1;
	struct cvmx_pciercx_cfg017_s cn70xx;
	struct cvmx_pciercx_cfg017_s cn70xxp1;
	struct cvmx_pciercx_cfg017_s cn73xx;
	struct cvmx_pciercx_cfg017_s cn78xx;
	struct cvmx_pciercx_cfg017_s cn78xxp1;
	struct cvmx_pciercx_cfg017_s cnf71xx;
	struct cvmx_pciercx_cfg017_s cnf75xx;
};

typedef union cvmx_pciercx_cfg017 cvmx_pciercx_cfg017_t;

/**
 * cvmx_pcierc#_cfg020
 *
 * This register contains the twenty-first 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg020 {
	u32 u32;
	struct cvmx_pciercx_cfg020_s {
		u32 reserved_24_31 : 8;
		u32 m64 : 1;
		u32 mme : 3;
		u32 mmc : 3;
		u32 msien : 1;
		u32 ncp : 8;
		u32 msicid : 8;
	} s;
	struct cvmx_pciercx_cfg020_s cn52xx;
	struct cvmx_pciercx_cfg020_s cn52xxp1;
	struct cvmx_pciercx_cfg020_s cn56xx;
	struct cvmx_pciercx_cfg020_s cn56xxp1;
	struct cvmx_pciercx_cfg020_cn61xx {
		u32 reserved_25_31 : 7;
		u32 pvm : 1;
		u32 m64 : 1;
		u32 mme : 3;
		u32 mmc : 3;
		u32 msien : 1;
		u32 ncp : 8;
		u32 msicid : 8;
	} cn61xx;
	struct cvmx_pciercx_cfg020_s cn63xx;
	struct cvmx_pciercx_cfg020_s cn63xxp1;
	struct cvmx_pciercx_cfg020_s cn66xx;
	struct cvmx_pciercx_cfg020_s cn68xx;
	struct cvmx_pciercx_cfg020_s cn68xxp1;
	struct cvmx_pciercx_cfg020_cn61xx cn70xx;
	struct cvmx_pciercx_cfg020_cn61xx cn70xxp1;
	struct cvmx_pciercx_cfg020_cn73xx {
		u32 reserved_25_31 : 7;
		u32 pvms : 1;
		u32 m64 : 1;
		u32 mme : 3;
		u32 mmc : 3;
		u32 msien : 1;
		u32 ncp : 8;
		u32 msicid : 8;
	} cn73xx;
	struct cvmx_pciercx_cfg020_cn73xx cn78xx;
	struct cvmx_pciercx_cfg020_cn73xx cn78xxp1;
	struct cvmx_pciercx_cfg020_cn61xx cnf71xx;
	struct cvmx_pciercx_cfg020_cn73xx cnf75xx;
};

typedef union cvmx_pciercx_cfg020 cvmx_pciercx_cfg020_t;

/**
 * cvmx_pcierc#_cfg021
 *
 * This register contains the twenty-second 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg021 {
	u32 u32;
	struct cvmx_pciercx_cfg021_s {
		u32 lmsi : 30;
		u32 reserved_0_1 : 2;
	} s;
	struct cvmx_pciercx_cfg021_s cn52xx;
	struct cvmx_pciercx_cfg021_s cn52xxp1;
	struct cvmx_pciercx_cfg021_s cn56xx;
	struct cvmx_pciercx_cfg021_s cn56xxp1;
	struct cvmx_pciercx_cfg021_s cn61xx;
	struct cvmx_pciercx_cfg021_s cn63xx;
	struct cvmx_pciercx_cfg021_s cn63xxp1;
	struct cvmx_pciercx_cfg021_s cn66xx;
	struct cvmx_pciercx_cfg021_s cn68xx;
	struct cvmx_pciercx_cfg021_s cn68xxp1;
	struct cvmx_pciercx_cfg021_s cn70xx;
	struct cvmx_pciercx_cfg021_s cn70xxp1;
	struct cvmx_pciercx_cfg021_s cn73xx;
	struct cvmx_pciercx_cfg021_s cn78xx;
	struct cvmx_pciercx_cfg021_s cn78xxp1;
	struct cvmx_pciercx_cfg021_s cnf71xx;
	struct cvmx_pciercx_cfg021_s cnf75xx;
};

typedef union cvmx_pciercx_cfg021 cvmx_pciercx_cfg021_t;

/**
 * cvmx_pcierc#_cfg022
 *
 * This register contains the twenty-third 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg022 {
	u32 u32;
	struct cvmx_pciercx_cfg022_s {
		u32 umsi : 32;
	} s;
	struct cvmx_pciercx_cfg022_s cn52xx;
	struct cvmx_pciercx_cfg022_s cn52xxp1;
	struct cvmx_pciercx_cfg022_s cn56xx;
	struct cvmx_pciercx_cfg022_s cn56xxp1;
	struct cvmx_pciercx_cfg022_s cn61xx;
	struct cvmx_pciercx_cfg022_s cn63xx;
	struct cvmx_pciercx_cfg022_s cn63xxp1;
	struct cvmx_pciercx_cfg022_s cn66xx;
	struct cvmx_pciercx_cfg022_s cn68xx;
	struct cvmx_pciercx_cfg022_s cn68xxp1;
	struct cvmx_pciercx_cfg022_s cn70xx;
	struct cvmx_pciercx_cfg022_s cn70xxp1;
	struct cvmx_pciercx_cfg022_s cn73xx;
	struct cvmx_pciercx_cfg022_s cn78xx;
	struct cvmx_pciercx_cfg022_s cn78xxp1;
	struct cvmx_pciercx_cfg022_s cnf71xx;
	struct cvmx_pciercx_cfg022_s cnf75xx;
};

typedef union cvmx_pciercx_cfg022 cvmx_pciercx_cfg022_t;

/**
 * cvmx_pcierc#_cfg023
 *
 * This register contains the twenty-fourth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg023 {
	u32 u32;
	struct cvmx_pciercx_cfg023_s {
		u32 reserved_16_31 : 16;
		u32 msimd : 16;
	} s;
	struct cvmx_pciercx_cfg023_s cn52xx;
	struct cvmx_pciercx_cfg023_s cn52xxp1;
	struct cvmx_pciercx_cfg023_s cn56xx;
	struct cvmx_pciercx_cfg023_s cn56xxp1;
	struct cvmx_pciercx_cfg023_s cn61xx;
	struct cvmx_pciercx_cfg023_s cn63xx;
	struct cvmx_pciercx_cfg023_s cn63xxp1;
	struct cvmx_pciercx_cfg023_s cn66xx;
	struct cvmx_pciercx_cfg023_s cn68xx;
	struct cvmx_pciercx_cfg023_s cn68xxp1;
	struct cvmx_pciercx_cfg023_s cn70xx;
	struct cvmx_pciercx_cfg023_s cn70xxp1;
	struct cvmx_pciercx_cfg023_s cn73xx;
	struct cvmx_pciercx_cfg023_s cn78xx;
	struct cvmx_pciercx_cfg023_s cn78xxp1;
	struct cvmx_pciercx_cfg023_s cnf71xx;
	struct cvmx_pciercx_cfg023_s cnf75xx;
};

typedef union cvmx_pciercx_cfg023 cvmx_pciercx_cfg023_t;

/**
 * cvmx_pcierc#_cfg028
 *
 * This register contains the twenty-ninth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg028 {
	u32 u32;
	struct cvmx_pciercx_cfg028_s {
		u32 reserved_30_31 : 2;
		u32 imn : 5;
		u32 si : 1;
		u32 dpt : 4;
		u32 pciecv : 4;
		u32 ncp : 8;
		u32 pcieid : 8;
	} s;
	struct cvmx_pciercx_cfg028_s cn52xx;
	struct cvmx_pciercx_cfg028_s cn52xxp1;
	struct cvmx_pciercx_cfg028_s cn56xx;
	struct cvmx_pciercx_cfg028_s cn56xxp1;
	struct cvmx_pciercx_cfg028_s cn61xx;
	struct cvmx_pciercx_cfg028_s cn63xx;
	struct cvmx_pciercx_cfg028_s cn63xxp1;
	struct cvmx_pciercx_cfg028_s cn66xx;
	struct cvmx_pciercx_cfg028_s cn68xx;
	struct cvmx_pciercx_cfg028_s cn68xxp1;
	struct cvmx_pciercx_cfg028_s cn70xx;
	struct cvmx_pciercx_cfg028_s cn70xxp1;
	struct cvmx_pciercx_cfg028_s cn73xx;
	struct cvmx_pciercx_cfg028_s cn78xx;
	struct cvmx_pciercx_cfg028_s cn78xxp1;
	struct cvmx_pciercx_cfg028_s cnf71xx;
	struct cvmx_pciercx_cfg028_s cnf75xx;
};

typedef union cvmx_pciercx_cfg028 cvmx_pciercx_cfg028_t;

/**
 * cvmx_pcierc#_cfg029
 *
 * This register contains the thirtieth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg029 {
	u32 u32;
	struct cvmx_pciercx_cfg029_s {
		u32 reserved_29_31 : 3;
		u32 flr_cap : 1;
		u32 cspls : 2;
		u32 csplv : 8;
		u32 reserved_16_17 : 2;
		u32 rber : 1;
		u32 reserved_12_14 : 3;
		u32 el1al : 3;
		u32 el0al : 3;
		u32 etfs : 1;
		u32 pfs : 2;
		u32 mpss : 3;
	} s;
	struct cvmx_pciercx_cfg029_cn52xx {
		u32 reserved_28_31 : 4;
		u32 cspls : 2;
		u32 csplv : 8;
		u32 reserved_16_17 : 2;
		u32 rber : 1;
		u32 reserved_12_14 : 3;
		u32 el1al : 3;
		u32 el0al : 3;
		u32 etfs : 1;
		u32 pfs : 2;
		u32 mpss : 3;
	} cn52xx;
	struct cvmx_pciercx_cfg029_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg029_cn52xx cn56xx;
	struct cvmx_pciercx_cfg029_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg029_cn52xx cn61xx;
	struct cvmx_pciercx_cfg029_cn52xx cn63xx;
	struct cvmx_pciercx_cfg029_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg029_cn52xx cn66xx;
	struct cvmx_pciercx_cfg029_cn52xx cn68xx;
	struct cvmx_pciercx_cfg029_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg029_cn52xx cn70xx;
	struct cvmx_pciercx_cfg029_cn52xx cn70xxp1;
	struct cvmx_pciercx_cfg029_s cn73xx;
	struct cvmx_pciercx_cfg029_s cn78xx;
	struct cvmx_pciercx_cfg029_s cn78xxp1;
	struct cvmx_pciercx_cfg029_cn52xx cnf71xx;
	struct cvmx_pciercx_cfg029_s cnf75xx;
};

typedef union cvmx_pciercx_cfg029 cvmx_pciercx_cfg029_t;

/**
 * cvmx_pcierc#_cfg030
 *
 * This register contains the thirty-first 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg030 {
	u32 u32;
	struct cvmx_pciercx_cfg030_s {
		u32 reserved_22_31 : 10;
		u32 tp : 1;
		u32 ap_d : 1;
		u32 ur_d : 1;
		u32 fe_d : 1;
		u32 nfe_d : 1;
		u32 ce_d : 1;
		u32 reserved_15_15 : 1;
		u32 mrrs : 3;
		u32 ns_en : 1;
		u32 ap_en : 1;
		u32 pf_en : 1;
		u32 etf_en : 1;
		u32 mps : 3;
		u32 ro_en : 1;
		u32 ur_en : 1;
		u32 fe_en : 1;
		u32 nfe_en : 1;
		u32 ce_en : 1;
	} s;
	struct cvmx_pciercx_cfg030_s cn52xx;
	struct cvmx_pciercx_cfg030_s cn52xxp1;
	struct cvmx_pciercx_cfg030_s cn56xx;
	struct cvmx_pciercx_cfg030_s cn56xxp1;
	struct cvmx_pciercx_cfg030_s cn61xx;
	struct cvmx_pciercx_cfg030_s cn63xx;
	struct cvmx_pciercx_cfg030_s cn63xxp1;
	struct cvmx_pciercx_cfg030_s cn66xx;
	struct cvmx_pciercx_cfg030_s cn68xx;
	struct cvmx_pciercx_cfg030_s cn68xxp1;
	struct cvmx_pciercx_cfg030_s cn70xx;
	struct cvmx_pciercx_cfg030_s cn70xxp1;
	struct cvmx_pciercx_cfg030_s cn73xx;
	struct cvmx_pciercx_cfg030_s cn78xx;
	struct cvmx_pciercx_cfg030_s cn78xxp1;
	struct cvmx_pciercx_cfg030_s cnf71xx;
	struct cvmx_pciercx_cfg030_s cnf75xx;
};

typedef union cvmx_pciercx_cfg030 cvmx_pciercx_cfg030_t;

/**
 * cvmx_pcierc#_cfg031
 *
 * This register contains the thirty-second 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg031 {
	u32 u32;
	struct cvmx_pciercx_cfg031_s {
		u32 pnum : 8;
		u32 reserved_23_23 : 1;
		u32 aspm : 1;
		u32 lbnc : 1;
		u32 dllarc : 1;
		u32 sderc : 1;
		u32 cpm : 1;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 aslpms : 2;
		u32 mlw : 6;
		u32 mls : 4;
	} s;
	struct cvmx_pciercx_cfg031_cn52xx {
		u32 pnum : 8;
		u32 reserved_22_23 : 2;
		u32 lbnc : 1;
		u32 dllarc : 1;
		u32 sderc : 1;
		u32 cpm : 1;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 aslpms : 2;
		u32 mlw : 6;
		u32 mls : 4;
	} cn52xx;
	struct cvmx_pciercx_cfg031_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg031_cn52xx cn56xx;
	struct cvmx_pciercx_cfg031_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg031_s cn61xx;
	struct cvmx_pciercx_cfg031_cn52xx cn63xx;
	struct cvmx_pciercx_cfg031_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg031_s cn66xx;
	struct cvmx_pciercx_cfg031_s cn68xx;
	struct cvmx_pciercx_cfg031_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg031_s cn70xx;
	struct cvmx_pciercx_cfg031_s cn70xxp1;
	struct cvmx_pciercx_cfg031_s cn73xx;
	struct cvmx_pciercx_cfg031_s cn78xx;
	struct cvmx_pciercx_cfg031_s cn78xxp1;
	struct cvmx_pciercx_cfg031_s cnf71xx;
	struct cvmx_pciercx_cfg031_s cnf75xx;
};

typedef union cvmx_pciercx_cfg031 cvmx_pciercx_cfg031_t;

/**
 * cvmx_pcierc#_cfg032
 *
 * This register contains the thirty-third 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg032 {
	u32 u32;
	struct cvmx_pciercx_cfg032_s {
		u32 lab : 1;
		u32 lbm : 1;
		u32 dlla : 1;
		u32 scc : 1;
		u32 lt : 1;
		u32 reserved_26_26 : 1;
		u32 nlw : 6;
		u32 ls : 4;
		u32 reserved_12_15 : 4;
		u32 lab_int_enb : 1;
		u32 lbm_int_enb : 1;
		u32 hawd : 1;
		u32 ecpm : 1;
		u32 es : 1;
		u32 ccc : 1;
		u32 rl : 1;
		u32 ld : 1;
		u32 rcb : 1;
		u32 reserved_2_2 : 1;
		u32 aslpc : 2;
	} s;
	struct cvmx_pciercx_cfg032_s cn52xx;
	struct cvmx_pciercx_cfg032_s cn52xxp1;
	struct cvmx_pciercx_cfg032_s cn56xx;
	struct cvmx_pciercx_cfg032_s cn56xxp1;
	struct cvmx_pciercx_cfg032_s cn61xx;
	struct cvmx_pciercx_cfg032_s cn63xx;
	struct cvmx_pciercx_cfg032_s cn63xxp1;
	struct cvmx_pciercx_cfg032_s cn66xx;
	struct cvmx_pciercx_cfg032_s cn68xx;
	struct cvmx_pciercx_cfg032_s cn68xxp1;
	struct cvmx_pciercx_cfg032_s cn70xx;
	struct cvmx_pciercx_cfg032_s cn70xxp1;
	struct cvmx_pciercx_cfg032_s cn73xx;
	struct cvmx_pciercx_cfg032_s cn78xx;
	struct cvmx_pciercx_cfg032_s cn78xxp1;
	struct cvmx_pciercx_cfg032_s cnf71xx;
	struct cvmx_pciercx_cfg032_s cnf75xx;
};

typedef union cvmx_pciercx_cfg032 cvmx_pciercx_cfg032_t;

/**
 * cvmx_pcierc#_cfg033
 *
 * This register contains the thirty-fourth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg033 {
	u32 u32;
	struct cvmx_pciercx_cfg033_s {
		u32 ps_num : 13;
		u32 nccs : 1;
		u32 emip : 1;
		u32 sp_ls : 2;
		u32 sp_lv : 8;
		u32 hp_c : 1;
		u32 hp_s : 1;
		u32 pip : 1;
		u32 aip : 1;
		u32 mrlsp : 1;
		u32 pcp : 1;
		u32 abp : 1;
	} s;
	struct cvmx_pciercx_cfg033_s cn52xx;
	struct cvmx_pciercx_cfg033_s cn52xxp1;
	struct cvmx_pciercx_cfg033_s cn56xx;
	struct cvmx_pciercx_cfg033_s cn56xxp1;
	struct cvmx_pciercx_cfg033_s cn61xx;
	struct cvmx_pciercx_cfg033_s cn63xx;
	struct cvmx_pciercx_cfg033_s cn63xxp1;
	struct cvmx_pciercx_cfg033_s cn66xx;
	struct cvmx_pciercx_cfg033_s cn68xx;
	struct cvmx_pciercx_cfg033_s cn68xxp1;
	struct cvmx_pciercx_cfg033_s cn70xx;
	struct cvmx_pciercx_cfg033_s cn70xxp1;
	struct cvmx_pciercx_cfg033_s cn73xx;
	struct cvmx_pciercx_cfg033_s cn78xx;
	struct cvmx_pciercx_cfg033_s cn78xxp1;
	struct cvmx_pciercx_cfg033_s cnf71xx;
	struct cvmx_pciercx_cfg033_s cnf75xx;
};

typedef union cvmx_pciercx_cfg033 cvmx_pciercx_cfg033_t;

/**
 * cvmx_pcierc#_cfg034
 *
 * This register contains the thirty-fifth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg034 {
	u32 u32;
	struct cvmx_pciercx_cfg034_s {
		u32 reserved_25_31 : 7;
		u32 dlls_c : 1;
		u32 emis : 1;
		u32 pds : 1;
		u32 mrlss : 1;
		u32 ccint_d : 1;
		u32 pd_c : 1;
		u32 mrls_c : 1;
		u32 pf_d : 1;
		u32 abp_d : 1;
		u32 reserved_13_15 : 3;
		u32 dlls_en : 1;
		u32 emic : 1;
		u32 pcc : 1;
		u32 pic : 2;
		u32 aic : 2;
		u32 hpint_en : 1;
		u32 ccint_en : 1;
		u32 pd_en : 1;
		u32 mrls_en : 1;
		u32 pf_en : 1;
		u32 abp_en : 1;
	} s;
	struct cvmx_pciercx_cfg034_s cn52xx;
	struct cvmx_pciercx_cfg034_s cn52xxp1;
	struct cvmx_pciercx_cfg034_s cn56xx;
	struct cvmx_pciercx_cfg034_s cn56xxp1;
	struct cvmx_pciercx_cfg034_s cn61xx;
	struct cvmx_pciercx_cfg034_s cn63xx;
	struct cvmx_pciercx_cfg034_s cn63xxp1;
	struct cvmx_pciercx_cfg034_s cn66xx;
	struct cvmx_pciercx_cfg034_s cn68xx;
	struct cvmx_pciercx_cfg034_s cn68xxp1;
	struct cvmx_pciercx_cfg034_s cn70xx;
	struct cvmx_pciercx_cfg034_s cn70xxp1;
	struct cvmx_pciercx_cfg034_s cn73xx;
	struct cvmx_pciercx_cfg034_s cn78xx;
	struct cvmx_pciercx_cfg034_s cn78xxp1;
	struct cvmx_pciercx_cfg034_s cnf71xx;
	struct cvmx_pciercx_cfg034_s cnf75xx;
};

typedef union cvmx_pciercx_cfg034 cvmx_pciercx_cfg034_t;

/**
 * cvmx_pcierc#_cfg035
 *
 * This register contains the thirty-sixth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg035 {
	u32 u32;
	struct cvmx_pciercx_cfg035_s {
		u32 reserved_17_31 : 15;
		u32 crssv : 1;
		u32 reserved_5_15 : 11;
		u32 crssve : 1;
		u32 pmeie : 1;
		u32 sefee : 1;
		u32 senfee : 1;
		u32 secee : 1;
	} s;
	struct cvmx_pciercx_cfg035_s cn52xx;
	struct cvmx_pciercx_cfg035_s cn52xxp1;
	struct cvmx_pciercx_cfg035_s cn56xx;
	struct cvmx_pciercx_cfg035_s cn56xxp1;
	struct cvmx_pciercx_cfg035_s cn61xx;
	struct cvmx_pciercx_cfg035_s cn63xx;
	struct cvmx_pciercx_cfg035_s cn63xxp1;
	struct cvmx_pciercx_cfg035_s cn66xx;
	struct cvmx_pciercx_cfg035_s cn68xx;
	struct cvmx_pciercx_cfg035_s cn68xxp1;
	struct cvmx_pciercx_cfg035_s cn70xx;
	struct cvmx_pciercx_cfg035_s cn70xxp1;
	struct cvmx_pciercx_cfg035_s cn73xx;
	struct cvmx_pciercx_cfg035_s cn78xx;
	struct cvmx_pciercx_cfg035_s cn78xxp1;
	struct cvmx_pciercx_cfg035_s cnf71xx;
	struct cvmx_pciercx_cfg035_s cnf75xx;
};

typedef union cvmx_pciercx_cfg035 cvmx_pciercx_cfg035_t;

/**
 * cvmx_pcierc#_cfg036
 *
 * This register contains the thirty-seventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg036 {
	u32 u32;
	struct cvmx_pciercx_cfg036_s {
		u32 reserved_18_31 : 14;
		u32 pme_pend : 1;
		u32 pme_stat : 1;
		u32 pme_rid : 16;
	} s;
	struct cvmx_pciercx_cfg036_s cn52xx;
	struct cvmx_pciercx_cfg036_s cn52xxp1;
	struct cvmx_pciercx_cfg036_s cn56xx;
	struct cvmx_pciercx_cfg036_s cn56xxp1;
	struct cvmx_pciercx_cfg036_s cn61xx;
	struct cvmx_pciercx_cfg036_s cn63xx;
	struct cvmx_pciercx_cfg036_s cn63xxp1;
	struct cvmx_pciercx_cfg036_s cn66xx;
	struct cvmx_pciercx_cfg036_s cn68xx;
	struct cvmx_pciercx_cfg036_s cn68xxp1;
	struct cvmx_pciercx_cfg036_s cn70xx;
	struct cvmx_pciercx_cfg036_s cn70xxp1;
	struct cvmx_pciercx_cfg036_s cn73xx;
	struct cvmx_pciercx_cfg036_s cn78xx;
	struct cvmx_pciercx_cfg036_s cn78xxp1;
	struct cvmx_pciercx_cfg036_s cnf71xx;
	struct cvmx_pciercx_cfg036_s cnf75xx;
};

typedef union cvmx_pciercx_cfg036 cvmx_pciercx_cfg036_t;

/**
 * cvmx_pcierc#_cfg037
 *
 * This register contains the thirty-eighth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg037 {
	u32 u32;
	struct cvmx_pciercx_cfg037_s {
		u32 reserved_24_31 : 8;
		u32 meetp : 2;
		u32 eetps : 1;
		u32 effs : 1;
		u32 obffs : 2;
		u32 reserved_12_17 : 6;
		u32 ltrs : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 reserved_5_5 : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} s;
	struct cvmx_pciercx_cfg037_cn52xx {
		u32 reserved_5_31 : 27;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cn52xx;
	struct cvmx_pciercx_cfg037_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg037_cn52xx cn56xx;
	struct cvmx_pciercx_cfg037_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg037_cn61xx {
		u32 reserved_14_31 : 18;
		u32 tph : 2;
		u32 reserved_11_11 : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari_fw : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cn61xx;
	struct cvmx_pciercx_cfg037_cn52xx cn63xx;
	struct cvmx_pciercx_cfg037_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg037_cn66xx {
		u32 reserved_14_31 : 18;
		u32 tph : 2;
		u32 reserved_11_11 : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cn66xx;
	struct cvmx_pciercx_cfg037_cn66xx cn68xx;
	struct cvmx_pciercx_cfg037_cn66xx cn68xxp1;
	struct cvmx_pciercx_cfg037_cn61xx cn70xx;
	struct cvmx_pciercx_cfg037_cn61xx cn70xxp1;
	struct cvmx_pciercx_cfg037_cn73xx {
		u32 reserved_24_31 : 8;
		u32 meetp : 2;
		u32 eetps : 1;
		u32 effs : 1;
		u32 obffs : 2;
		u32 reserved_14_17 : 4;
		u32 tph : 2;
		u32 ltrs : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari_fw : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cn73xx;
	struct cvmx_pciercx_cfg037_cn73xx cn78xx;
	struct cvmx_pciercx_cfg037_cn73xx cn78xxp1;
	struct cvmx_pciercx_cfg037_cnf71xx {
		u32 reserved_20_31 : 12;
		u32 obffs : 2;
		u32 reserved_14_17 : 4;
		u32 tphs : 2;
		u32 ltrs : 1;
		u32 noroprpr : 1;
		u32 atom128s : 1;
		u32 atom64s : 1;
		u32 atom32s : 1;
		u32 atom_ops : 1;
		u32 ari_fw : 1;
		u32 ctds : 1;
		u32 ctrs : 4;
	} cnf71xx;
	struct cvmx_pciercx_cfg037_cn73xx cnf75xx;
};

typedef union cvmx_pciercx_cfg037 cvmx_pciercx_cfg037_t;

/**
 * cvmx_pcierc#_cfg038
 *
 * This register contains the thirty-ninth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg038 {
	u32 u32;
	struct cvmx_pciercx_cfg038_s {
		u32 reserved_16_31 : 16;
		u32 eetpb : 1;
		u32 obffe : 2;
		u32 reserved_11_12 : 2;
		u32 ltre : 1;
		u32 id0_cp : 1;
		u32 id0_rq : 1;
		u32 atom_op_eb : 1;
		u32 atom_op : 1;
		u32 ari : 1;
		u32 ctd : 1;
		u32 ctv : 4;
	} s;
	struct cvmx_pciercx_cfg038_cn52xx {
		u32 reserved_5_31 : 27;
		u32 ctd : 1;
		u32 ctv : 4;
	} cn52xx;
	struct cvmx_pciercx_cfg038_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg038_cn52xx cn56xx;
	struct cvmx_pciercx_cfg038_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg038_cn61xx {
		u32 reserved_10_31 : 22;
		u32 id0_cp : 1;
		u32 id0_rq : 1;
		u32 atom_op_eb : 1;
		u32 atom_op : 1;
		u32 ari : 1;
		u32 ctd : 1;
		u32 ctv : 4;
	} cn61xx;
	struct cvmx_pciercx_cfg038_cn52xx cn63xx;
	struct cvmx_pciercx_cfg038_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg038_cn61xx cn66xx;
	struct cvmx_pciercx_cfg038_cn61xx cn68xx;
	struct cvmx_pciercx_cfg038_cn61xx cn68xxp1;
	struct cvmx_pciercx_cfg038_cn61xx cn70xx;
	struct cvmx_pciercx_cfg038_cn61xx cn70xxp1;
	struct cvmx_pciercx_cfg038_s cn73xx;
	struct cvmx_pciercx_cfg038_s cn78xx;
	struct cvmx_pciercx_cfg038_s cn78xxp1;
	struct cvmx_pciercx_cfg038_cnf71xx {
		u32 reserved_15_31 : 17;
		u32 obffe : 2;
		u32 reserved_11_12 : 2;
		u32 ltre : 1;
		u32 id0_cp : 1;
		u32 id0_rq : 1;
		u32 atom_op_eb : 1;
		u32 atom_op : 1;
		u32 ari : 1;
		u32 ctd : 1;
		u32 ctv : 4;
	} cnf71xx;
	struct cvmx_pciercx_cfg038_s cnf75xx;
};

typedef union cvmx_pciercx_cfg038 cvmx_pciercx_cfg038_t;

/**
 * cvmx_pcierc#_cfg039
 *
 * This register contains the fortieth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg039 {
	u32 u32;
	struct cvmx_pciercx_cfg039_s {
		u32 reserved_9_31 : 23;
		u32 cls : 1;
		u32 slsv : 7;
		u32 reserved_0_0 : 1;
	} s;
	struct cvmx_pciercx_cfg039_cn52xx {
		u32 reserved_0_31 : 32;
	} cn52xx;
	struct cvmx_pciercx_cfg039_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg039_cn52xx cn56xx;
	struct cvmx_pciercx_cfg039_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg039_s cn61xx;
	struct cvmx_pciercx_cfg039_s cn63xx;
	struct cvmx_pciercx_cfg039_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg039_s cn66xx;
	struct cvmx_pciercx_cfg039_s cn68xx;
	struct cvmx_pciercx_cfg039_s cn68xxp1;
	struct cvmx_pciercx_cfg039_s cn70xx;
	struct cvmx_pciercx_cfg039_s cn70xxp1;
	struct cvmx_pciercx_cfg039_s cn73xx;
	struct cvmx_pciercx_cfg039_s cn78xx;
	struct cvmx_pciercx_cfg039_s cn78xxp1;
	struct cvmx_pciercx_cfg039_s cnf71xx;
	struct cvmx_pciercx_cfg039_s cnf75xx;
};

typedef union cvmx_pciercx_cfg039 cvmx_pciercx_cfg039_t;

/**
 * cvmx_pcierc#_cfg040
 *
 * This register contains the forty-first 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg040 {
	u32 u32;
	struct cvmx_pciercx_cfg040_s {
		u32 reserved_22_31 : 10;
		u32 ler : 1;
		u32 ep3s : 1;
		u32 ep2s : 1;
		u32 ep1s : 1;
		u32 eqc : 1;
		u32 cdl : 1;
		u32 cde : 4;
		u32 csos : 1;
		u32 emc : 1;
		u32 tm : 3;
		u32 sde : 1;
		u32 hasd : 1;
		u32 ec : 1;
		u32 tls : 4;
	} s;
	struct cvmx_pciercx_cfg040_cn52xx {
		u32 reserved_0_31 : 32;
	} cn52xx;
	struct cvmx_pciercx_cfg040_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg040_cn52xx cn56xx;
	struct cvmx_pciercx_cfg040_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg040_cn61xx {
		u32 reserved_17_31 : 15;
		u32 cdl : 1;
		u32 reserved_13_15 : 3;
		u32 cde : 1;
		u32 csos : 1;
		u32 emc : 1;
		u32 tm : 3;
		u32 sde : 1;
		u32 hasd : 1;
		u32 ec : 1;
		u32 tls : 4;
	} cn61xx;
	struct cvmx_pciercx_cfg040_cn61xx cn63xx;
	struct cvmx_pciercx_cfg040_cn61xx cn63xxp1;
	struct cvmx_pciercx_cfg040_cn61xx cn66xx;
	struct cvmx_pciercx_cfg040_cn61xx cn68xx;
	struct cvmx_pciercx_cfg040_cn61xx cn68xxp1;
	struct cvmx_pciercx_cfg040_cn61xx cn70xx;
	struct cvmx_pciercx_cfg040_cn61xx cn70xxp1;
	struct cvmx_pciercx_cfg040_s cn73xx;
	struct cvmx_pciercx_cfg040_s cn78xx;
	struct cvmx_pciercx_cfg040_s cn78xxp1;
	struct cvmx_pciercx_cfg040_cn61xx cnf71xx;
	struct cvmx_pciercx_cfg040_s cnf75xx;
};

typedef union cvmx_pciercx_cfg040 cvmx_pciercx_cfg040_t;

/**
 * cvmx_pcierc#_cfg041
 *
 * This register contains the forty-second 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg041 {
	u32 u32;
	struct cvmx_pciercx_cfg041_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pciercx_cfg041_s cn52xx;
	struct cvmx_pciercx_cfg041_s cn52xxp1;
	struct cvmx_pciercx_cfg041_s cn56xx;
	struct cvmx_pciercx_cfg041_s cn56xxp1;
	struct cvmx_pciercx_cfg041_s cn61xx;
	struct cvmx_pciercx_cfg041_s cn63xx;
	struct cvmx_pciercx_cfg041_s cn63xxp1;
	struct cvmx_pciercx_cfg041_s cn66xx;
	struct cvmx_pciercx_cfg041_s cn68xx;
	struct cvmx_pciercx_cfg041_s cn68xxp1;
	struct cvmx_pciercx_cfg041_s cn70xx;
	struct cvmx_pciercx_cfg041_s cn70xxp1;
	struct cvmx_pciercx_cfg041_s cn73xx;
	struct cvmx_pciercx_cfg041_s cn78xx;
	struct cvmx_pciercx_cfg041_s cn78xxp1;
	struct cvmx_pciercx_cfg041_s cnf71xx;
	struct cvmx_pciercx_cfg041_s cnf75xx;
};

typedef union cvmx_pciercx_cfg041 cvmx_pciercx_cfg041_t;

/**
 * cvmx_pcierc#_cfg042
 *
 * This register contains the forty-third 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg042 {
	u32 u32;
	struct cvmx_pciercx_cfg042_s {
		u32 reserved_0_31 : 32;
	} s;
	struct cvmx_pciercx_cfg042_s cn52xx;
	struct cvmx_pciercx_cfg042_s cn52xxp1;
	struct cvmx_pciercx_cfg042_s cn56xx;
	struct cvmx_pciercx_cfg042_s cn56xxp1;
	struct cvmx_pciercx_cfg042_s cn61xx;
	struct cvmx_pciercx_cfg042_s cn63xx;
	struct cvmx_pciercx_cfg042_s cn63xxp1;
	struct cvmx_pciercx_cfg042_s cn66xx;
	struct cvmx_pciercx_cfg042_s cn68xx;
	struct cvmx_pciercx_cfg042_s cn68xxp1;
	struct cvmx_pciercx_cfg042_s cn70xx;
	struct cvmx_pciercx_cfg042_s cn70xxp1;
	struct cvmx_pciercx_cfg042_s cn73xx;
	struct cvmx_pciercx_cfg042_s cn78xx;
	struct cvmx_pciercx_cfg042_s cn78xxp1;
	struct cvmx_pciercx_cfg042_s cnf71xx;
	struct cvmx_pciercx_cfg042_s cnf75xx;
};

typedef union cvmx_pciercx_cfg042 cvmx_pciercx_cfg042_t;

/**
 * cvmx_pcierc#_cfg044
 *
 * This register contains the forty-fifth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg044 {
	u32 u32;
	struct cvmx_pciercx_cfg044_s {
		u32 msixen : 1;
		u32 funm : 1;
		u32 reserved_27_29 : 3;
		u32 msixts : 11;
		u32 ncp : 8;
		u32 msixcid : 8;
	} s;
	struct cvmx_pciercx_cfg044_s cn73xx;
	struct cvmx_pciercx_cfg044_s cn78xx;
	struct cvmx_pciercx_cfg044_s cn78xxp1;
	struct cvmx_pciercx_cfg044_s cnf75xx;
};

typedef union cvmx_pciercx_cfg044 cvmx_pciercx_cfg044_t;

/**
 * cvmx_pcierc#_cfg045
 *
 * This register contains the forty-sixth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg045 {
	u32 u32;
	struct cvmx_pciercx_cfg045_s {
		u32 msixtoffs : 29;
		u32 msixtbir : 3;
	} s;
	struct cvmx_pciercx_cfg045_s cn73xx;
	struct cvmx_pciercx_cfg045_s cn78xx;
	struct cvmx_pciercx_cfg045_s cn78xxp1;
	struct cvmx_pciercx_cfg045_s cnf75xx;
};

typedef union cvmx_pciercx_cfg045 cvmx_pciercx_cfg045_t;

/**
 * cvmx_pcierc#_cfg046
 *
 * This register contains the forty-seventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg046 {
	u32 u32;
	struct cvmx_pciercx_cfg046_s {
		u32 msixpoffs : 29;
		u32 msixpbir : 3;
	} s;
	struct cvmx_pciercx_cfg046_s cn73xx;
	struct cvmx_pciercx_cfg046_s cn78xx;
	struct cvmx_pciercx_cfg046_s cn78xxp1;
	struct cvmx_pciercx_cfg046_s cnf75xx;
};

typedef union cvmx_pciercx_cfg046 cvmx_pciercx_cfg046_t;

/**
 * cvmx_pcierc#_cfg064
 *
 * This register contains the sixty-fifth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg064 {
	u32 u32;
	struct cvmx_pciercx_cfg064_s {
		u32 nco : 12;
		u32 cv : 4;
		u32 pcieec : 16;
	} s;
	struct cvmx_pciercx_cfg064_s cn52xx;
	struct cvmx_pciercx_cfg064_s cn52xxp1;
	struct cvmx_pciercx_cfg064_s cn56xx;
	struct cvmx_pciercx_cfg064_s cn56xxp1;
	struct cvmx_pciercx_cfg064_s cn61xx;
	struct cvmx_pciercx_cfg064_s cn63xx;
	struct cvmx_pciercx_cfg064_s cn63xxp1;
	struct cvmx_pciercx_cfg064_s cn66xx;
	struct cvmx_pciercx_cfg064_s cn68xx;
	struct cvmx_pciercx_cfg064_s cn68xxp1;
	struct cvmx_pciercx_cfg064_s cn70xx;
	struct cvmx_pciercx_cfg064_s cn70xxp1;
	struct cvmx_pciercx_cfg064_s cn73xx;
	struct cvmx_pciercx_cfg064_s cn78xx;
	struct cvmx_pciercx_cfg064_s cn78xxp1;
	struct cvmx_pciercx_cfg064_s cnf71xx;
	struct cvmx_pciercx_cfg064_s cnf75xx;
};

typedef union cvmx_pciercx_cfg064 cvmx_pciercx_cfg064_t;

/**
 * cvmx_pcierc#_cfg065
 *
 * This register contains the sixty-sixth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg065 {
	u32 u32;
	struct cvmx_pciercx_cfg065_s {
		u32 reserved_26_31 : 6;
		u32 tpbes : 1;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pciercx_cfg065_cn52xx {
		u32 reserved_21_31 : 11;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn52xx;
	struct cvmx_pciercx_cfg065_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg065_cn52xx cn56xx;
	struct cvmx_pciercx_cfg065_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg065_cn61xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_21_23 : 3;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn61xx;
	struct cvmx_pciercx_cfg065_cn52xx cn63xx;
	struct cvmx_pciercx_cfg065_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg065_cn61xx cn66xx;
	struct cvmx_pciercx_cfg065_cn61xx cn68xx;
	struct cvmx_pciercx_cfg065_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg065_cn70xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn70xx;
	struct cvmx_pciercx_cfg065_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg065_s cn73xx;
	struct cvmx_pciercx_cfg065_s cn78xx;
	struct cvmx_pciercx_cfg065_s cn78xxp1;
	struct cvmx_pciercx_cfg065_cn70xx cnf71xx;
	struct cvmx_pciercx_cfg065_s cnf75xx;
};

typedef union cvmx_pciercx_cfg065 cvmx_pciercx_cfg065_t;

/**
 * cvmx_pcierc#_cfg066
 *
 * This register contains the sixty-seventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg066 {
	u32 u32;
	struct cvmx_pciercx_cfg066_s {
		u32 reserved_26_31 : 6;
		u32 tpbem : 1;
		u32 uatombm : 1;
		u32 reserved_23_23 : 1;
		u32 uciem : 1;
		u32 reserved_21_21 : 1;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pciercx_cfg066_cn52xx {
		u32 reserved_21_31 : 11;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cn52xx;
	struct cvmx_pciercx_cfg066_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg066_cn52xx cn56xx;
	struct cvmx_pciercx_cfg066_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg066_cn61xx {
		u32 reserved_25_31 : 7;
		u32 uatombm : 1;
		u32 reserved_21_23 : 3;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cn61xx;
	struct cvmx_pciercx_cfg066_cn52xx cn63xx;
	struct cvmx_pciercx_cfg066_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg066_cn61xx cn66xx;
	struct cvmx_pciercx_cfg066_cn61xx cn68xx;
	struct cvmx_pciercx_cfg066_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg066_cn70xx {
		u32 reserved_25_31 : 7;
		u32 uatombm : 1;
		u32 reserved_23_23 : 1;
		u32 uciem : 1;
		u32 reserved_21_21 : 1;
		u32 urem : 1;
		u32 ecrcem : 1;
		u32 mtlpm : 1;
		u32 rom : 1;
		u32 ucm : 1;
		u32 cam : 1;
		u32 ctm : 1;
		u32 fcpem : 1;
		u32 ptlpm : 1;
		u32 reserved_6_11 : 6;
		u32 sdem : 1;
		u32 dlpem : 1;
		u32 reserved_0_3 : 4;
	} cn70xx;
	struct cvmx_pciercx_cfg066_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg066_s cn73xx;
	struct cvmx_pciercx_cfg066_s cn78xx;
	struct cvmx_pciercx_cfg066_s cn78xxp1;
	struct cvmx_pciercx_cfg066_cn70xx cnf71xx;
	struct cvmx_pciercx_cfg066_s cnf75xx;
};

typedef union cvmx_pciercx_cfg066 cvmx_pciercx_cfg066_t;

/**
 * cvmx_pcierc#_cfg067
 *
 * This register contains the sixty-eighth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg067 {
	u32 u32;
	struct cvmx_pciercx_cfg067_s {
		u32 reserved_26_31 : 6;
		u32 tpbes : 1;
		u32 uatombs : 1;
		u32 reserved_21_23 : 3;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} s;
	struct cvmx_pciercx_cfg067_cn52xx {
		u32 reserved_21_31 : 11;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn52xx;
	struct cvmx_pciercx_cfg067_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg067_cn52xx cn56xx;
	struct cvmx_pciercx_cfg067_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg067_cn61xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_21_23 : 3;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn61xx;
	struct cvmx_pciercx_cfg067_cn52xx cn63xx;
	struct cvmx_pciercx_cfg067_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg067_cn61xx cn66xx;
	struct cvmx_pciercx_cfg067_cn61xx cn68xx;
	struct cvmx_pciercx_cfg067_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg067_cn70xx {
		u32 reserved_25_31 : 7;
		u32 uatombs : 1;
		u32 reserved_23_23 : 1;
		u32 ucies : 1;
		u32 reserved_21_21 : 1;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn70xx;
	struct cvmx_pciercx_cfg067_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg067_cn73xx {
		u32 reserved_26_31 : 6;
		u32 tpbes : 1;
		u32 uatombs : 1;
		u32 unsuperr : 3;
		u32 ures : 1;
		u32 ecrces : 1;
		u32 mtlps : 1;
		u32 ros : 1;
		u32 ucs : 1;
		u32 cas : 1;
		u32 cts : 1;
		u32 fcpes : 1;
		u32 ptlps : 1;
		u32 reserved_6_11 : 6;
		u32 sdes : 1;
		u32 dlpes : 1;
		u32 reserved_0_3 : 4;
	} cn73xx;
	struct cvmx_pciercx_cfg067_cn73xx cn78xx;
	struct cvmx_pciercx_cfg067_cn73xx cn78xxp1;
	struct cvmx_pciercx_cfg067_cn70xx cnf71xx;
	struct cvmx_pciercx_cfg067_cn73xx cnf75xx;
};

typedef union cvmx_pciercx_cfg067 cvmx_pciercx_cfg067_t;

/**
 * cvmx_pcierc#_cfg068
 *
 * This register contains the sixty-ninth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg068 {
	u32 u32;
	struct cvmx_pciercx_cfg068_s {
		u32 reserved_15_31 : 17;
		u32 cies : 1;
		u32 anfes : 1;
		u32 rtts : 1;
		u32 reserved_9_11 : 3;
		u32 rnrs : 1;
		u32 bdllps : 1;
		u32 btlps : 1;
		u32 reserved_1_5 : 5;
		u32 res : 1;
	} s;
	struct cvmx_pciercx_cfg068_cn52xx {
		u32 reserved_14_31 : 18;
		u32 anfes : 1;
		u32 rtts : 1;
		u32 reserved_9_11 : 3;
		u32 rnrs : 1;
		u32 bdllps : 1;
		u32 btlps : 1;
		u32 reserved_1_5 : 5;
		u32 res : 1;
	} cn52xx;
	struct cvmx_pciercx_cfg068_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg068_cn52xx cn56xx;
	struct cvmx_pciercx_cfg068_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg068_cn52xx cn61xx;
	struct cvmx_pciercx_cfg068_cn52xx cn63xx;
	struct cvmx_pciercx_cfg068_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg068_cn52xx cn66xx;
	struct cvmx_pciercx_cfg068_cn52xx cn68xx;
	struct cvmx_pciercx_cfg068_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg068_s cn70xx;
	struct cvmx_pciercx_cfg068_s cn70xxp1;
	struct cvmx_pciercx_cfg068_s cn73xx;
	struct cvmx_pciercx_cfg068_s cn78xx;
	struct cvmx_pciercx_cfg068_s cn78xxp1;
	struct cvmx_pciercx_cfg068_s cnf71xx;
	struct cvmx_pciercx_cfg068_s cnf75xx;
};

typedef union cvmx_pciercx_cfg068 cvmx_pciercx_cfg068_t;

/**
 * cvmx_pcierc#_cfg069
 *
 * This register contains the seventieth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg069 {
	u32 u32;
	struct cvmx_pciercx_cfg069_s {
		u32 reserved_15_31 : 17;
		u32 ciem : 1;
		u32 anfem : 1;
		u32 rttm : 1;
		u32 reserved_9_11 : 3;
		u32 rnrm : 1;
		u32 bdllpm : 1;
		u32 btlpm : 1;
		u32 reserved_1_5 : 5;
		u32 rem : 1;
	} s;
	struct cvmx_pciercx_cfg069_cn52xx {
		u32 reserved_14_31 : 18;
		u32 anfem : 1;
		u32 rttm : 1;
		u32 reserved_9_11 : 3;
		u32 rnrm : 1;
		u32 bdllpm : 1;
		u32 btlpm : 1;
		u32 reserved_1_5 : 5;
		u32 rem : 1;
	} cn52xx;
	struct cvmx_pciercx_cfg069_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg069_cn52xx cn56xx;
	struct cvmx_pciercx_cfg069_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg069_cn52xx cn61xx;
	struct cvmx_pciercx_cfg069_cn52xx cn63xx;
	struct cvmx_pciercx_cfg069_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg069_cn52xx cn66xx;
	struct cvmx_pciercx_cfg069_cn52xx cn68xx;
	struct cvmx_pciercx_cfg069_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg069_s cn70xx;
	struct cvmx_pciercx_cfg069_s cn70xxp1;
	struct cvmx_pciercx_cfg069_s cn73xx;
	struct cvmx_pciercx_cfg069_s cn78xx;
	struct cvmx_pciercx_cfg069_s cn78xxp1;
	struct cvmx_pciercx_cfg069_s cnf71xx;
	struct cvmx_pciercx_cfg069_s cnf75xx;
};

typedef union cvmx_pciercx_cfg069 cvmx_pciercx_cfg069_t;

/**
 * cvmx_pcierc#_cfg070
 *
 * This register contains the seventy-first 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg070 {
	u32 u32;
	struct cvmx_pciercx_cfg070_s {
		u32 reserved_12_31 : 20;
		u32 tplp : 1;
		u32 reserved_9_10 : 2;
		u32 ce : 1;
		u32 cc : 1;
		u32 ge : 1;
		u32 gc : 1;
		u32 fep : 5;
	} s;
	struct cvmx_pciercx_cfg070_cn52xx {
		u32 reserved_9_31 : 23;
		u32 ce : 1;
		u32 cc : 1;
		u32 ge : 1;
		u32 gc : 1;
		u32 fep : 5;
	} cn52xx;
	struct cvmx_pciercx_cfg070_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg070_cn52xx cn56xx;
	struct cvmx_pciercx_cfg070_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg070_cn52xx cn61xx;
	struct cvmx_pciercx_cfg070_cn52xx cn63xx;
	struct cvmx_pciercx_cfg070_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg070_cn52xx cn66xx;
	struct cvmx_pciercx_cfg070_cn52xx cn68xx;
	struct cvmx_pciercx_cfg070_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg070_cn52xx cn70xx;
	struct cvmx_pciercx_cfg070_cn52xx cn70xxp1;
	struct cvmx_pciercx_cfg070_s cn73xx;
	struct cvmx_pciercx_cfg070_s cn78xx;
	struct cvmx_pciercx_cfg070_s cn78xxp1;
	struct cvmx_pciercx_cfg070_cn52xx cnf71xx;
	struct cvmx_pciercx_cfg070_s cnf75xx;
};

typedef union cvmx_pciercx_cfg070 cvmx_pciercx_cfg070_t;

/**
 * cvmx_pcierc#_cfg071
 *
 * This register contains the seventy-second 32-bits of PCIe type 1 configuration space.  The
 * header log registers collect the header for the TLP corresponding to a detected error.
 */
union cvmx_pciercx_cfg071 {
	u32 u32;
	struct cvmx_pciercx_cfg071_s {
		u32 dword1 : 32;
	} s;
	struct cvmx_pciercx_cfg071_s cn52xx;
	struct cvmx_pciercx_cfg071_s cn52xxp1;
	struct cvmx_pciercx_cfg071_s cn56xx;
	struct cvmx_pciercx_cfg071_s cn56xxp1;
	struct cvmx_pciercx_cfg071_s cn61xx;
	struct cvmx_pciercx_cfg071_s cn63xx;
	struct cvmx_pciercx_cfg071_s cn63xxp1;
	struct cvmx_pciercx_cfg071_s cn66xx;
	struct cvmx_pciercx_cfg071_s cn68xx;
	struct cvmx_pciercx_cfg071_s cn68xxp1;
	struct cvmx_pciercx_cfg071_s cn70xx;
	struct cvmx_pciercx_cfg071_s cn70xxp1;
	struct cvmx_pciercx_cfg071_s cn73xx;
	struct cvmx_pciercx_cfg071_s cn78xx;
	struct cvmx_pciercx_cfg071_s cn78xxp1;
	struct cvmx_pciercx_cfg071_s cnf71xx;
	struct cvmx_pciercx_cfg071_s cnf75xx;
};

typedef union cvmx_pciercx_cfg071 cvmx_pciercx_cfg071_t;

/**
 * cvmx_pcierc#_cfg072
 *
 * This register contains the seventy-third 32-bits of PCIe type 1 configuration space.  The
 * header log registers collect the header for the TLP corresponding to a detected error.
 */
union cvmx_pciercx_cfg072 {
	u32 u32;
	struct cvmx_pciercx_cfg072_s {
		u32 dword2 : 32;
	} s;
	struct cvmx_pciercx_cfg072_s cn52xx;
	struct cvmx_pciercx_cfg072_s cn52xxp1;
	struct cvmx_pciercx_cfg072_s cn56xx;
	struct cvmx_pciercx_cfg072_s cn56xxp1;
	struct cvmx_pciercx_cfg072_s cn61xx;
	struct cvmx_pciercx_cfg072_s cn63xx;
	struct cvmx_pciercx_cfg072_s cn63xxp1;
	struct cvmx_pciercx_cfg072_s cn66xx;
	struct cvmx_pciercx_cfg072_s cn68xx;
	struct cvmx_pciercx_cfg072_s cn68xxp1;
	struct cvmx_pciercx_cfg072_s cn70xx;
	struct cvmx_pciercx_cfg072_s cn70xxp1;
	struct cvmx_pciercx_cfg072_s cn73xx;
	struct cvmx_pciercx_cfg072_s cn78xx;
	struct cvmx_pciercx_cfg072_s cn78xxp1;
	struct cvmx_pciercx_cfg072_s cnf71xx;
	struct cvmx_pciercx_cfg072_s cnf75xx;
};

typedef union cvmx_pciercx_cfg072 cvmx_pciercx_cfg072_t;

/**
 * cvmx_pcierc#_cfg073
 *
 * This register contains the seventy-fourth 32-bits of PCIe type 1 configuration space.  The
 * header log registers collect the header for the TLP corresponding to a detected error.
 */
union cvmx_pciercx_cfg073 {
	u32 u32;
	struct cvmx_pciercx_cfg073_s {
		u32 dword3 : 32;
	} s;
	struct cvmx_pciercx_cfg073_s cn52xx;
	struct cvmx_pciercx_cfg073_s cn52xxp1;
	struct cvmx_pciercx_cfg073_s cn56xx;
	struct cvmx_pciercx_cfg073_s cn56xxp1;
	struct cvmx_pciercx_cfg073_s cn61xx;
	struct cvmx_pciercx_cfg073_s cn63xx;
	struct cvmx_pciercx_cfg073_s cn63xxp1;
	struct cvmx_pciercx_cfg073_s cn66xx;
	struct cvmx_pciercx_cfg073_s cn68xx;
	struct cvmx_pciercx_cfg073_s cn68xxp1;
	struct cvmx_pciercx_cfg073_s cn70xx;
	struct cvmx_pciercx_cfg073_s cn70xxp1;
	struct cvmx_pciercx_cfg073_s cn73xx;
	struct cvmx_pciercx_cfg073_s cn78xx;
	struct cvmx_pciercx_cfg073_s cn78xxp1;
	struct cvmx_pciercx_cfg073_s cnf71xx;
	struct cvmx_pciercx_cfg073_s cnf75xx;
};

typedef union cvmx_pciercx_cfg073 cvmx_pciercx_cfg073_t;

/**
 * cvmx_pcierc#_cfg074
 *
 * This register contains the seventy-fifth 32-bits of PCIe type 1 configuration space.  The
 * header log registers collect the header for the TLP corresponding to a detected error.
 */
union cvmx_pciercx_cfg074 {
	u32 u32;
	struct cvmx_pciercx_cfg074_s {
		u32 dword4 : 32;
	} s;
	struct cvmx_pciercx_cfg074_s cn52xx;
	struct cvmx_pciercx_cfg074_s cn52xxp1;
	struct cvmx_pciercx_cfg074_s cn56xx;
	struct cvmx_pciercx_cfg074_s cn56xxp1;
	struct cvmx_pciercx_cfg074_s cn61xx;
	struct cvmx_pciercx_cfg074_s cn63xx;
	struct cvmx_pciercx_cfg074_s cn63xxp1;
	struct cvmx_pciercx_cfg074_s cn66xx;
	struct cvmx_pciercx_cfg074_s cn68xx;
	struct cvmx_pciercx_cfg074_s cn68xxp1;
	struct cvmx_pciercx_cfg074_s cn70xx;
	struct cvmx_pciercx_cfg074_s cn70xxp1;
	struct cvmx_pciercx_cfg074_s cn73xx;
	struct cvmx_pciercx_cfg074_s cn78xx;
	struct cvmx_pciercx_cfg074_s cn78xxp1;
	struct cvmx_pciercx_cfg074_s cnf71xx;
	struct cvmx_pciercx_cfg074_s cnf75xx;
};

typedef union cvmx_pciercx_cfg074 cvmx_pciercx_cfg074_t;

/**
 * cvmx_pcierc#_cfg075
 *
 * This register contains the seventy-sixth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg075 {
	u32 u32;
	struct cvmx_pciercx_cfg075_s {
		u32 reserved_3_31 : 29;
		u32 fere : 1;
		u32 nfere : 1;
		u32 cere : 1;
	} s;
	struct cvmx_pciercx_cfg075_s cn52xx;
	struct cvmx_pciercx_cfg075_s cn52xxp1;
	struct cvmx_pciercx_cfg075_s cn56xx;
	struct cvmx_pciercx_cfg075_s cn56xxp1;
	struct cvmx_pciercx_cfg075_s cn61xx;
	struct cvmx_pciercx_cfg075_s cn63xx;
	struct cvmx_pciercx_cfg075_s cn63xxp1;
	struct cvmx_pciercx_cfg075_s cn66xx;
	struct cvmx_pciercx_cfg075_s cn68xx;
	struct cvmx_pciercx_cfg075_s cn68xxp1;
	struct cvmx_pciercx_cfg075_s cn70xx;
	struct cvmx_pciercx_cfg075_s cn70xxp1;
	struct cvmx_pciercx_cfg075_s cn73xx;
	struct cvmx_pciercx_cfg075_s cn78xx;
	struct cvmx_pciercx_cfg075_s cn78xxp1;
	struct cvmx_pciercx_cfg075_s cnf71xx;
	struct cvmx_pciercx_cfg075_s cnf75xx;
};

typedef union cvmx_pciercx_cfg075 cvmx_pciercx_cfg075_t;

/**
 * cvmx_pcierc#_cfg076
 *
 * This register contains the seventy-seventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg076 {
	u32 u32;
	struct cvmx_pciercx_cfg076_s {
		u32 aeimn : 5;
		u32 reserved_7_26 : 20;
		u32 femr : 1;
		u32 nfemr : 1;
		u32 fuf : 1;
		u32 multi_efnfr : 1;
		u32 efnfr : 1;
		u32 multi_ecr : 1;
		u32 ecr : 1;
	} s;
	struct cvmx_pciercx_cfg076_s cn52xx;
	struct cvmx_pciercx_cfg076_s cn52xxp1;
	struct cvmx_pciercx_cfg076_s cn56xx;
	struct cvmx_pciercx_cfg076_s cn56xxp1;
	struct cvmx_pciercx_cfg076_s cn61xx;
	struct cvmx_pciercx_cfg076_s cn63xx;
	struct cvmx_pciercx_cfg076_s cn63xxp1;
	struct cvmx_pciercx_cfg076_s cn66xx;
	struct cvmx_pciercx_cfg076_s cn68xx;
	struct cvmx_pciercx_cfg076_s cn68xxp1;
	struct cvmx_pciercx_cfg076_s cn70xx;
	struct cvmx_pciercx_cfg076_s cn70xxp1;
	struct cvmx_pciercx_cfg076_s cn73xx;
	struct cvmx_pciercx_cfg076_s cn78xx;
	struct cvmx_pciercx_cfg076_s cn78xxp1;
	struct cvmx_pciercx_cfg076_s cnf71xx;
	struct cvmx_pciercx_cfg076_s cnf75xx;
};

typedef union cvmx_pciercx_cfg076 cvmx_pciercx_cfg076_t;

/**
 * cvmx_pcierc#_cfg077
 *
 * This register contains the seventy-eighth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg077 {
	u32 u32;
	struct cvmx_pciercx_cfg077_s {
		u32 efnfsi : 16;
		u32 ecsi : 16;
	} s;
	struct cvmx_pciercx_cfg077_s cn52xx;
	struct cvmx_pciercx_cfg077_s cn52xxp1;
	struct cvmx_pciercx_cfg077_s cn56xx;
	struct cvmx_pciercx_cfg077_s cn56xxp1;
	struct cvmx_pciercx_cfg077_s cn61xx;
	struct cvmx_pciercx_cfg077_s cn63xx;
	struct cvmx_pciercx_cfg077_s cn63xxp1;
	struct cvmx_pciercx_cfg077_s cn66xx;
	struct cvmx_pciercx_cfg077_s cn68xx;
	struct cvmx_pciercx_cfg077_s cn68xxp1;
	struct cvmx_pciercx_cfg077_s cn70xx;
	struct cvmx_pciercx_cfg077_s cn70xxp1;
	struct cvmx_pciercx_cfg077_s cn73xx;
	struct cvmx_pciercx_cfg077_s cn78xx;
	struct cvmx_pciercx_cfg077_s cn78xxp1;
	struct cvmx_pciercx_cfg077_s cnf71xx;
	struct cvmx_pciercx_cfg077_s cnf75xx;
};

typedef union cvmx_pciercx_cfg077 cvmx_pciercx_cfg077_t;

/**
 * cvmx_pcierc#_cfg086
 *
 * This register contains the eighty-ninth 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg086 {
	u32 u32;
	struct cvmx_pciercx_cfg086_s {
		u32 nco : 12;
		u32 cv : 4;
		u32 pcieec : 16;
	} s;
	struct cvmx_pciercx_cfg086_s cn73xx;
	struct cvmx_pciercx_cfg086_s cn78xx;
	struct cvmx_pciercx_cfg086_s cn78xxp1;
	struct cvmx_pciercx_cfg086_s cnf75xx;
};

typedef union cvmx_pciercx_cfg086 cvmx_pciercx_cfg086_t;

/**
 * cvmx_pcierc#_cfg087
 *
 * This register contains the eighty-eighth 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg087 {
	u32 u32;
	struct cvmx_pciercx_cfg087_s {
		u32 reserved_2_31 : 30;
		u32 ler : 1;
		u32 pe : 1;
	} s;
	struct cvmx_pciercx_cfg087_s cn73xx;
	struct cvmx_pciercx_cfg087_s cn78xx;
	struct cvmx_pciercx_cfg087_s cn78xxp1;
	struct cvmx_pciercx_cfg087_s cnf75xx;
};

typedef union cvmx_pciercx_cfg087 cvmx_pciercx_cfg087_t;

/**
 * cvmx_pcierc#_cfg088
 *
 * This register contains the eighty-ninth 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg088 {
	u32 u32;
	struct cvmx_pciercx_cfg088_s {
		u32 reserved_8_31 : 24;
		u32 les : 8;
	} s;
	struct cvmx_pciercx_cfg088_s cn73xx;
	struct cvmx_pciercx_cfg088_s cn78xx;
	struct cvmx_pciercx_cfg088_s cn78xxp1;
	struct cvmx_pciercx_cfg088_s cnf75xx;
};

typedef union cvmx_pciercx_cfg088 cvmx_pciercx_cfg088_t;

/**
 * cvmx_pcierc#_cfg089
 *
 * This register contains the ninetieth 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg089 {
	u32 u32;
	struct cvmx_pciercx_cfg089_s {
		u32 reserved_31_31 : 1;
		u32 l1urph : 3;
		u32 l1utp : 4;
		u32 reserved_23_23 : 1;
		u32 l1drph : 3;
		u32 l1ddtp : 4;
		u32 reserved_15_15 : 1;
		u32 l0urph : 3;
		u32 l0utp : 4;
		u32 reserved_7_7 : 1;
		u32 l0drph : 3;
		u32 l0dtp : 4;
	} s;
	struct cvmx_pciercx_cfg089_s cn73xx;
	struct cvmx_pciercx_cfg089_s cn78xx;
	struct cvmx_pciercx_cfg089_s cn78xxp1;
	struct cvmx_pciercx_cfg089_s cnf75xx;
};

typedef union cvmx_pciercx_cfg089 cvmx_pciercx_cfg089_t;

/**
 * cvmx_pcierc#_cfg090
 *
 * This register contains the ninety-first 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg090 {
	u32 u32;
	struct cvmx_pciercx_cfg090_s {
		u32 reserved_31_31 : 1;
		u32 l3urph : 3;
		u32 l3utp : 4;
		u32 reserved_23_23 : 1;
		u32 l3drph : 3;
		u32 l3dtp : 4;
		u32 reserved_15_15 : 1;
		u32 l2urph : 3;
		u32 l2utp : 4;
		u32 reserved_7_7 : 1;
		u32 l2drph : 3;
		u32 l2dtp : 4;
	} s;
	struct cvmx_pciercx_cfg090_s cn73xx;
	struct cvmx_pciercx_cfg090_s cn78xx;
	struct cvmx_pciercx_cfg090_s cn78xxp1;
	struct cvmx_pciercx_cfg090_s cnf75xx;
};

typedef union cvmx_pciercx_cfg090 cvmx_pciercx_cfg090_t;

/**
 * cvmx_pcierc#_cfg091
 *
 * This register contains the ninety-second 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg091 {
	u32 u32;
	struct cvmx_pciercx_cfg091_s {
		u32 reserved_31_31 : 1;
		u32 l5urph : 3;
		u32 l5utp : 4;
		u32 reserved_23_23 : 1;
		u32 l5drph : 3;
		u32 l5dtp : 4;
		u32 reserved_15_15 : 1;
		u32 l4urph : 3;
		u32 l4utp : 4;
		u32 reserved_7_7 : 1;
		u32 l4drph : 3;
		u32 l4dtp : 4;
	} s;
	struct cvmx_pciercx_cfg091_s cn73xx;
	struct cvmx_pciercx_cfg091_s cn78xx;
	struct cvmx_pciercx_cfg091_s cn78xxp1;
	struct cvmx_pciercx_cfg091_s cnf75xx;
};

typedef union cvmx_pciercx_cfg091 cvmx_pciercx_cfg091_t;

/**
 * cvmx_pcierc#_cfg092
 *
 * This register contains the ninety-third 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg092 {
	u32 u32;
	struct cvmx_pciercx_cfg092_s {
		u32 reserved_31_31 : 1;
		u32 l7urph : 3;
		u32 l7utp : 4;
		u32 reserved_23_23 : 1;
		u32 l7drph : 3;
		u32 l7dtp : 4;
		u32 reserved_15_15 : 1;
		u32 l6urph : 3;
		u32 l6utp : 4;
		u32 reserved_7_7 : 1;
		u32 l6drph : 3;
		u32 l6dtp : 4;
	} s;
	struct cvmx_pciercx_cfg092_s cn73xx;
	struct cvmx_pciercx_cfg092_s cn78xx;
	struct cvmx_pciercx_cfg092_s cn78xxp1;
	struct cvmx_pciercx_cfg092_s cnf75xx;
};

typedef union cvmx_pciercx_cfg092 cvmx_pciercx_cfg092_t;

/**
 * cvmx_pcierc#_cfg448
 *
 * This register contains the four hundred forty-ninth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg448 {
	u32 u32;
	struct cvmx_pciercx_cfg448_s {
		u32 rtl : 16;
		u32 rtltl : 16;
	} s;
	struct cvmx_pciercx_cfg448_s cn52xx;
	struct cvmx_pciercx_cfg448_s cn52xxp1;
	struct cvmx_pciercx_cfg448_s cn56xx;
	struct cvmx_pciercx_cfg448_s cn56xxp1;
	struct cvmx_pciercx_cfg448_s cn61xx;
	struct cvmx_pciercx_cfg448_s cn63xx;
	struct cvmx_pciercx_cfg448_s cn63xxp1;
	struct cvmx_pciercx_cfg448_s cn66xx;
	struct cvmx_pciercx_cfg448_s cn68xx;
	struct cvmx_pciercx_cfg448_s cn68xxp1;
	struct cvmx_pciercx_cfg448_s cn70xx;
	struct cvmx_pciercx_cfg448_s cn70xxp1;
	struct cvmx_pciercx_cfg448_s cn73xx;
	struct cvmx_pciercx_cfg448_s cn78xx;
	struct cvmx_pciercx_cfg448_s cn78xxp1;
	struct cvmx_pciercx_cfg448_s cnf71xx;
	struct cvmx_pciercx_cfg448_s cnf75xx;
};

typedef union cvmx_pciercx_cfg448 cvmx_pciercx_cfg448_t;

/**
 * cvmx_pcierc#_cfg449
 *
 * This register contains the four hundred fiftieth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg449 {
	u32 u32;
	struct cvmx_pciercx_cfg449_s {
		u32 omr : 32;
	} s;
	struct cvmx_pciercx_cfg449_s cn52xx;
	struct cvmx_pciercx_cfg449_s cn52xxp1;
	struct cvmx_pciercx_cfg449_s cn56xx;
	struct cvmx_pciercx_cfg449_s cn56xxp1;
	struct cvmx_pciercx_cfg449_s cn61xx;
	struct cvmx_pciercx_cfg449_s cn63xx;
	struct cvmx_pciercx_cfg449_s cn63xxp1;
	struct cvmx_pciercx_cfg449_s cn66xx;
	struct cvmx_pciercx_cfg449_s cn68xx;
	struct cvmx_pciercx_cfg449_s cn68xxp1;
	struct cvmx_pciercx_cfg449_s cn70xx;
	struct cvmx_pciercx_cfg449_s cn70xxp1;
	struct cvmx_pciercx_cfg449_s cn73xx;
	struct cvmx_pciercx_cfg449_s cn78xx;
	struct cvmx_pciercx_cfg449_s cn78xxp1;
	struct cvmx_pciercx_cfg449_s cnf71xx;
	struct cvmx_pciercx_cfg449_s cnf75xx;
};

typedef union cvmx_pciercx_cfg449 cvmx_pciercx_cfg449_t;

/**
 * cvmx_pcierc#_cfg450
 *
 * This register contains the four hundred fifty-first 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg450 {
	u32 u32;
	struct cvmx_pciercx_cfg450_s {
		u32 lpec : 8;
		u32 reserved_22_23 : 2;
		u32 link_state : 6;
		u32 force_link : 1;
		u32 reserved_8_14 : 7;
		u32 link_num : 8;
	} s;
	struct cvmx_pciercx_cfg450_s cn52xx;
	struct cvmx_pciercx_cfg450_s cn52xxp1;
	struct cvmx_pciercx_cfg450_s cn56xx;
	struct cvmx_pciercx_cfg450_s cn56xxp1;
	struct cvmx_pciercx_cfg450_s cn61xx;
	struct cvmx_pciercx_cfg450_s cn63xx;
	struct cvmx_pciercx_cfg450_s cn63xxp1;
	struct cvmx_pciercx_cfg450_s cn66xx;
	struct cvmx_pciercx_cfg450_s cn68xx;
	struct cvmx_pciercx_cfg450_s cn68xxp1;
	struct cvmx_pciercx_cfg450_cn70xx {
		u32 lpec : 8;
		u32 reserved_22_23 : 2;
		u32 link_state : 6;
		u32 force_link : 1;
		u32 reserved_12_14 : 3;
		u32 link_cmd : 4;
		u32 link_num : 8;
	} cn70xx;
	struct cvmx_pciercx_cfg450_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg450_cn73xx {
		u32 lpec : 8;
		u32 reserved_22_23 : 2;
		u32 link_state : 6;
		u32 force_link : 1;
		u32 reserved_12_14 : 3;
		u32 forced_ltssm : 4;
		u32 link_num : 8;
	} cn73xx;
	struct cvmx_pciercx_cfg450_cn73xx cn78xx;
	struct cvmx_pciercx_cfg450_cn73xx cn78xxp1;
	struct cvmx_pciercx_cfg450_s cnf71xx;
	struct cvmx_pciercx_cfg450_cn73xx cnf75xx;
};

typedef union cvmx_pciercx_cfg450 cvmx_pciercx_cfg450_t;

/**
 * cvmx_pcierc#_cfg451
 *
 * This register contains the four hundred fifty-second 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg451 {
	u32 u32;
	struct cvmx_pciercx_cfg451_s {
		u32 reserved_31_31 : 1;
		u32 easpml1 : 1;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 n_fts_cc : 8;
		u32 n_fts : 8;
		u32 ack_freq : 8;
	} s;
	struct cvmx_pciercx_cfg451_cn52xx {
		u32 reserved_30_31 : 2;
		u32 l1el : 3;
		u32 l0el : 3;
		u32 n_fts_cc : 8;
		u32 n_fts : 8;
		u32 ack_freq : 8;
	} cn52xx;
	struct cvmx_pciercx_cfg451_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg451_cn52xx cn56xx;
	struct cvmx_pciercx_cfg451_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg451_s cn61xx;
	struct cvmx_pciercx_cfg451_cn52xx cn63xx;
	struct cvmx_pciercx_cfg451_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg451_s cn66xx;
	struct cvmx_pciercx_cfg451_s cn68xx;
	struct cvmx_pciercx_cfg451_s cn68xxp1;
	struct cvmx_pciercx_cfg451_s cn70xx;
	struct cvmx_pciercx_cfg451_s cn70xxp1;
	struct cvmx_pciercx_cfg451_s cn73xx;
	struct cvmx_pciercx_cfg451_s cn78xx;
	struct cvmx_pciercx_cfg451_s cn78xxp1;
	struct cvmx_pciercx_cfg451_s cnf71xx;
	struct cvmx_pciercx_cfg451_s cnf75xx;
};

typedef union cvmx_pciercx_cfg451 cvmx_pciercx_cfg451_t;

/**
 * cvmx_pcierc#_cfg452
 *
 * This register contains the four hundred fifty-third 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg452 {
	u32 u32;
	struct cvmx_pciercx_cfg452_s {
		u32 reserved_26_31 : 6;
		u32 eccrc : 1;
		u32 reserved_22_24 : 3;
		u32 lme : 6;
		u32 reserved_12_15 : 4;
		u32 link_rate : 4;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} s;
	struct cvmx_pciercx_cfg452_cn52xx {
		u32 reserved_26_31 : 6;
		u32 eccrc : 1;
		u32 reserved_22_24 : 3;
		u32 lme : 6;
		u32 reserved_8_15 : 8;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} cn52xx;
	struct cvmx_pciercx_cfg452_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg452_cn52xx cn56xx;
	struct cvmx_pciercx_cfg452_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg452_cn61xx {
		u32 reserved_22_31 : 10;
		u32 lme : 6;
		u32 reserved_8_15 : 8;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} cn61xx;
	struct cvmx_pciercx_cfg452_cn52xx cn63xx;
	struct cvmx_pciercx_cfg452_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg452_cn61xx cn66xx;
	struct cvmx_pciercx_cfg452_cn61xx cn68xx;
	struct cvmx_pciercx_cfg452_cn61xx cn68xxp1;
	struct cvmx_pciercx_cfg452_cn70xx {
		u32 reserved_22_31 : 10;
		u32 lme : 6;
		u32 reserved_12_15 : 4;
		u32 link_rate : 4;
		u32 flm : 1;
		u32 reserved_6_6 : 1;
		u32 dllle : 1;
		u32 reserved_4_4 : 1;
		u32 ra : 1;
		u32 le : 1;
		u32 sd : 1;
		u32 omr : 1;
	} cn70xx;
	struct cvmx_pciercx_cfg452_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg452_cn70xx cn73xx;
	struct cvmx_pciercx_cfg452_cn70xx cn78xx;
	struct cvmx_pciercx_cfg452_cn70xx cn78xxp1;
	struct cvmx_pciercx_cfg452_cn61xx cnf71xx;
	struct cvmx_pciercx_cfg452_cn70xx cnf75xx;
};

typedef union cvmx_pciercx_cfg452 cvmx_pciercx_cfg452_t;

/**
 * cvmx_pcierc#_cfg453
 *
 * This register contains the four hundred fifty-fourth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg453 {
	u32 u32;
	struct cvmx_pciercx_cfg453_s {
		u32 dlld : 1;
		u32 reserved_26_30 : 5;
		u32 ack_nak : 1;
		u32 fcd : 1;
		u32 ilst : 24;
	} s;
	struct cvmx_pciercx_cfg453_s cn52xx;
	struct cvmx_pciercx_cfg453_s cn52xxp1;
	struct cvmx_pciercx_cfg453_s cn56xx;
	struct cvmx_pciercx_cfg453_s cn56xxp1;
	struct cvmx_pciercx_cfg453_s cn61xx;
	struct cvmx_pciercx_cfg453_s cn63xx;
	struct cvmx_pciercx_cfg453_s cn63xxp1;
	struct cvmx_pciercx_cfg453_s cn66xx;
	struct cvmx_pciercx_cfg453_s cn68xx;
	struct cvmx_pciercx_cfg453_s cn68xxp1;
	struct cvmx_pciercx_cfg453_s cn70xx;
	struct cvmx_pciercx_cfg453_s cn70xxp1;
	struct cvmx_pciercx_cfg453_s cn73xx;
	struct cvmx_pciercx_cfg453_s cn78xx;
	struct cvmx_pciercx_cfg453_s cn78xxp1;
	struct cvmx_pciercx_cfg453_s cnf71xx;
	struct cvmx_pciercx_cfg453_s cnf75xx;
};

typedef union cvmx_pciercx_cfg453 cvmx_pciercx_cfg453_t;

/**
 * cvmx_pcierc#_cfg454
 *
 * This register contains the four hundred fifty-fifth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg454 {
	u32 u32;
	struct cvmx_pciercx_cfg454_s {
		u32 cx_nfunc : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_11_13 : 3;
		u32 nskps : 3;
		u32 reserved_0_7 : 8;
	} s;
	struct cvmx_pciercx_cfg454_cn52xx {
		u32 reserved_29_31 : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_11_13 : 3;
		u32 nskps : 3;
		u32 reserved_4_7 : 4;
		u32 ntss : 4;
	} cn52xx;
	struct cvmx_pciercx_cfg454_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg454_cn52xx cn56xx;
	struct cvmx_pciercx_cfg454_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg454_cn61xx {
		u32 cx_nfunc : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_8_13 : 6;
		u32 mfuncn : 8;
	} cn61xx;
	struct cvmx_pciercx_cfg454_cn52xx cn63xx;
	struct cvmx_pciercx_cfg454_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg454_cn61xx cn66xx;
	struct cvmx_pciercx_cfg454_cn61xx cn68xx;
	struct cvmx_pciercx_cfg454_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg454_cn70xx {
		u32 reserved_24_31 : 8;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_8_13 : 6;
		u32 mfuncn : 8;
	} cn70xx;
	struct cvmx_pciercx_cfg454_cn70xx cn70xxp1;
	struct cvmx_pciercx_cfg454_cn73xx {
		u32 reserved_29_31 : 3;
		u32 tmfcwt : 5;
		u32 tmanlt : 5;
		u32 tmrt : 5;
		u32 reserved_8_13 : 6;
		u32 mfuncn : 8;
	} cn73xx;
	struct cvmx_pciercx_cfg454_cn73xx cn78xx;
	struct cvmx_pciercx_cfg454_cn73xx cn78xxp1;
	struct cvmx_pciercx_cfg454_cn61xx cnf71xx;
	struct cvmx_pciercx_cfg454_cn73xx cnf75xx;
};

typedef union cvmx_pciercx_cfg454 cvmx_pciercx_cfg454_t;

/**
 * cvmx_pcierc#_cfg455
 *
 * This register contains the four hundred fifty-sixth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg455 {
	u32 u32;
	struct cvmx_pciercx_cfg455_s {
		u32 m_cfg0_filt : 1;
		u32 m_io_filt : 1;
		u32 msg_ctrl : 1;
		u32 m_cpl_ecrc_filt : 1;
		u32 m_ecrc_filt : 1;
		u32 m_cpl_len_err : 1;
		u32 m_cpl_attr_err : 1;
		u32 m_cpl_tc_err : 1;
		u32 m_cpl_fun_err : 1;
		u32 m_cpl_rid_err : 1;
		u32 m_cpl_tag_err : 1;
		u32 m_lk_filt : 1;
		u32 m_cfg1_filt : 1;
		u32 m_bar_match : 1;
		u32 m_pois_filt : 1;
		u32 m_fun : 1;
		u32 dfcwt : 1;
		u32 reserved_11_14 : 4;
		u32 skpiv : 11;
	} s;
	struct cvmx_pciercx_cfg455_s cn52xx;
	struct cvmx_pciercx_cfg455_s cn52xxp1;
	struct cvmx_pciercx_cfg455_s cn56xx;
	struct cvmx_pciercx_cfg455_s cn56xxp1;
	struct cvmx_pciercx_cfg455_s cn61xx;
	struct cvmx_pciercx_cfg455_s cn63xx;
	struct cvmx_pciercx_cfg455_s cn63xxp1;
	struct cvmx_pciercx_cfg455_s cn66xx;
	struct cvmx_pciercx_cfg455_s cn68xx;
	struct cvmx_pciercx_cfg455_s cn68xxp1;
	struct cvmx_pciercx_cfg455_s cn70xx;
	struct cvmx_pciercx_cfg455_s cn70xxp1;
	struct cvmx_pciercx_cfg455_s cn73xx;
	struct cvmx_pciercx_cfg455_s cn78xx;
	struct cvmx_pciercx_cfg455_s cn78xxp1;
	struct cvmx_pciercx_cfg455_s cnf71xx;
	struct cvmx_pciercx_cfg455_s cnf75xx;
};

typedef union cvmx_pciercx_cfg455 cvmx_pciercx_cfg455_t;

/**
 * cvmx_pcierc#_cfg456
 *
 * This register contains the four hundred fifty-seventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg456 {
	u32 u32;
	struct cvmx_pciercx_cfg456_s {
		u32 reserved_4_31 : 28;
		u32 m_handle_flush : 1;
		u32 m_dabort_4ucpl : 1;
		u32 m_vend1_drp : 1;
		u32 m_vend0_drp : 1;
	} s;
	struct cvmx_pciercx_cfg456_cn52xx {
		u32 reserved_2_31 : 30;
		u32 m_vend1_drp : 1;
		u32 m_vend0_drp : 1;
	} cn52xx;
	struct cvmx_pciercx_cfg456_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg456_cn52xx cn56xx;
	struct cvmx_pciercx_cfg456_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg456_s cn61xx;
	struct cvmx_pciercx_cfg456_cn52xx cn63xx;
	struct cvmx_pciercx_cfg456_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg456_s cn66xx;
	struct cvmx_pciercx_cfg456_s cn68xx;
	struct cvmx_pciercx_cfg456_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg456_s cn70xx;
	struct cvmx_pciercx_cfg456_s cn70xxp1;
	struct cvmx_pciercx_cfg456_s cn73xx;
	struct cvmx_pciercx_cfg456_s cn78xx;
	struct cvmx_pciercx_cfg456_s cn78xxp1;
	struct cvmx_pciercx_cfg456_s cnf71xx;
	struct cvmx_pciercx_cfg456_s cnf75xx;
};

typedef union cvmx_pciercx_cfg456 cvmx_pciercx_cfg456_t;

/**
 * cvmx_pcierc#_cfg458
 *
 * This register contains the four hundred fifty-ninth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg458 {
	u32 u32;
	struct cvmx_pciercx_cfg458_s {
		u32 dbg_info_l32 : 32;
	} s;
	struct cvmx_pciercx_cfg458_s cn52xx;
	struct cvmx_pciercx_cfg458_s cn52xxp1;
	struct cvmx_pciercx_cfg458_s cn56xx;
	struct cvmx_pciercx_cfg458_s cn56xxp1;
	struct cvmx_pciercx_cfg458_s cn61xx;
	struct cvmx_pciercx_cfg458_s cn63xx;
	struct cvmx_pciercx_cfg458_s cn63xxp1;
	struct cvmx_pciercx_cfg458_s cn66xx;
	struct cvmx_pciercx_cfg458_s cn68xx;
	struct cvmx_pciercx_cfg458_s cn68xxp1;
	struct cvmx_pciercx_cfg458_s cn70xx;
	struct cvmx_pciercx_cfg458_s cn70xxp1;
	struct cvmx_pciercx_cfg458_s cn73xx;
	struct cvmx_pciercx_cfg458_s cn78xx;
	struct cvmx_pciercx_cfg458_s cn78xxp1;
	struct cvmx_pciercx_cfg458_s cnf71xx;
	struct cvmx_pciercx_cfg458_s cnf75xx;
};

typedef union cvmx_pciercx_cfg458 cvmx_pciercx_cfg458_t;

/**
 * cvmx_pcierc#_cfg459
 *
 * This register contains the four hundred sixtieth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg459 {
	u32 u32;
	struct cvmx_pciercx_cfg459_s {
		u32 dbg_info_u32 : 32;
	} s;
	struct cvmx_pciercx_cfg459_s cn52xx;
	struct cvmx_pciercx_cfg459_s cn52xxp1;
	struct cvmx_pciercx_cfg459_s cn56xx;
	struct cvmx_pciercx_cfg459_s cn56xxp1;
	struct cvmx_pciercx_cfg459_s cn61xx;
	struct cvmx_pciercx_cfg459_s cn63xx;
	struct cvmx_pciercx_cfg459_s cn63xxp1;
	struct cvmx_pciercx_cfg459_s cn66xx;
	struct cvmx_pciercx_cfg459_s cn68xx;
	struct cvmx_pciercx_cfg459_s cn68xxp1;
	struct cvmx_pciercx_cfg459_s cn70xx;
	struct cvmx_pciercx_cfg459_s cn70xxp1;
	struct cvmx_pciercx_cfg459_s cn73xx;
	struct cvmx_pciercx_cfg459_s cn78xx;
	struct cvmx_pciercx_cfg459_s cn78xxp1;
	struct cvmx_pciercx_cfg459_s cnf71xx;
	struct cvmx_pciercx_cfg459_s cnf75xx;
};

typedef union cvmx_pciercx_cfg459 cvmx_pciercx_cfg459_t;

/**
 * cvmx_pcierc#_cfg460
 *
 * This register contains the four hundred sixty-first 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg460 {
	u32 u32;
	struct cvmx_pciercx_cfg460_s {
		u32 reserved_20_31 : 12;
		u32 tphfcc : 8;
		u32 tpdfcc : 12;
	} s;
	struct cvmx_pciercx_cfg460_s cn52xx;
	struct cvmx_pciercx_cfg460_s cn52xxp1;
	struct cvmx_pciercx_cfg460_s cn56xx;
	struct cvmx_pciercx_cfg460_s cn56xxp1;
	struct cvmx_pciercx_cfg460_s cn61xx;
	struct cvmx_pciercx_cfg460_s cn63xx;
	struct cvmx_pciercx_cfg460_s cn63xxp1;
	struct cvmx_pciercx_cfg460_s cn66xx;
	struct cvmx_pciercx_cfg460_s cn68xx;
	struct cvmx_pciercx_cfg460_s cn68xxp1;
	struct cvmx_pciercx_cfg460_s cn70xx;
	struct cvmx_pciercx_cfg460_s cn70xxp1;
	struct cvmx_pciercx_cfg460_s cn73xx;
	struct cvmx_pciercx_cfg460_s cn78xx;
	struct cvmx_pciercx_cfg460_s cn78xxp1;
	struct cvmx_pciercx_cfg460_s cnf71xx;
	struct cvmx_pciercx_cfg460_s cnf75xx;
};

typedef union cvmx_pciercx_cfg460 cvmx_pciercx_cfg460_t;

/**
 * cvmx_pcierc#_cfg461
 *
 * This register contains the four hundred sixty-second 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg461 {
	u32 u32;
	struct cvmx_pciercx_cfg461_s {
		u32 reserved_20_31 : 12;
		u32 tchfcc : 8;
		u32 tcdfcc : 12;
	} s;
	struct cvmx_pciercx_cfg461_s cn52xx;
	struct cvmx_pciercx_cfg461_s cn52xxp1;
	struct cvmx_pciercx_cfg461_s cn56xx;
	struct cvmx_pciercx_cfg461_s cn56xxp1;
	struct cvmx_pciercx_cfg461_s cn61xx;
	struct cvmx_pciercx_cfg461_s cn63xx;
	struct cvmx_pciercx_cfg461_s cn63xxp1;
	struct cvmx_pciercx_cfg461_s cn66xx;
	struct cvmx_pciercx_cfg461_s cn68xx;
	struct cvmx_pciercx_cfg461_s cn68xxp1;
	struct cvmx_pciercx_cfg461_s cn70xx;
	struct cvmx_pciercx_cfg461_s cn70xxp1;
	struct cvmx_pciercx_cfg461_s cn73xx;
	struct cvmx_pciercx_cfg461_s cn78xx;
	struct cvmx_pciercx_cfg461_s cn78xxp1;
	struct cvmx_pciercx_cfg461_s cnf71xx;
	struct cvmx_pciercx_cfg461_s cnf75xx;
};

typedef union cvmx_pciercx_cfg461 cvmx_pciercx_cfg461_t;

/**
 * cvmx_pcierc#_cfg462
 *
 * This register contains the four hundred sixty-third 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg462 {
	u32 u32;
	struct cvmx_pciercx_cfg462_s {
		u32 reserved_20_31 : 12;
		u32 tchfcc : 8;
		u32 tcdfcc : 12;
	} s;
	struct cvmx_pciercx_cfg462_s cn52xx;
	struct cvmx_pciercx_cfg462_s cn52xxp1;
	struct cvmx_pciercx_cfg462_s cn56xx;
	struct cvmx_pciercx_cfg462_s cn56xxp1;
	struct cvmx_pciercx_cfg462_s cn61xx;
	struct cvmx_pciercx_cfg462_s cn63xx;
	struct cvmx_pciercx_cfg462_s cn63xxp1;
	struct cvmx_pciercx_cfg462_s cn66xx;
	struct cvmx_pciercx_cfg462_s cn68xx;
	struct cvmx_pciercx_cfg462_s cn68xxp1;
	struct cvmx_pciercx_cfg462_s cn70xx;
	struct cvmx_pciercx_cfg462_s cn70xxp1;
	struct cvmx_pciercx_cfg462_s cn73xx;
	struct cvmx_pciercx_cfg462_s cn78xx;
	struct cvmx_pciercx_cfg462_s cn78xxp1;
	struct cvmx_pciercx_cfg462_s cnf71xx;
	struct cvmx_pciercx_cfg462_s cnf75xx;
};

typedef union cvmx_pciercx_cfg462 cvmx_pciercx_cfg462_t;

/**
 * cvmx_pcierc#_cfg463
 *
 * This register contains the four hundred sixty-fourth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg463 {
	u32 u32;
	struct cvmx_pciercx_cfg463_s {
		u32 fcltoe : 1;
		u32 reserved_29_30 : 2;
		u32 fcltov : 13;
		u32 reserved_3_15 : 13;
		u32 rqne : 1;
		u32 trbne : 1;
		u32 rtlpfccnr : 1;
	} s;
	struct cvmx_pciercx_cfg463_cn52xx {
		u32 reserved_3_31 : 29;
		u32 rqne : 1;
		u32 trbne : 1;
		u32 rtlpfccnr : 1;
	} cn52xx;
	struct cvmx_pciercx_cfg463_cn52xx cn52xxp1;
	struct cvmx_pciercx_cfg463_cn52xx cn56xx;
	struct cvmx_pciercx_cfg463_cn52xx cn56xxp1;
	struct cvmx_pciercx_cfg463_cn52xx cn61xx;
	struct cvmx_pciercx_cfg463_cn52xx cn63xx;
	struct cvmx_pciercx_cfg463_cn52xx cn63xxp1;
	struct cvmx_pciercx_cfg463_cn52xx cn66xx;
	struct cvmx_pciercx_cfg463_cn52xx cn68xx;
	struct cvmx_pciercx_cfg463_cn52xx cn68xxp1;
	struct cvmx_pciercx_cfg463_cn52xx cn70xx;
	struct cvmx_pciercx_cfg463_cn52xx cn70xxp1;
	struct cvmx_pciercx_cfg463_s cn73xx;
	struct cvmx_pciercx_cfg463_s cn78xx;
	struct cvmx_pciercx_cfg463_s cn78xxp1;
	struct cvmx_pciercx_cfg463_cn52xx cnf71xx;
	struct cvmx_pciercx_cfg463_s cnf75xx;
};

typedef union cvmx_pciercx_cfg463 cvmx_pciercx_cfg463_t;

/**
 * cvmx_pcierc#_cfg464
 *
 * This register contains the four hundred sixty-fifth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg464 {
	u32 u32;
	struct cvmx_pciercx_cfg464_s {
		u32 wrr_vc3 : 8;
		u32 wrr_vc2 : 8;
		u32 wrr_vc1 : 8;
		u32 wrr_vc0 : 8;
	} s;
	struct cvmx_pciercx_cfg464_s cn52xx;
	struct cvmx_pciercx_cfg464_s cn52xxp1;
	struct cvmx_pciercx_cfg464_s cn56xx;
	struct cvmx_pciercx_cfg464_s cn56xxp1;
	struct cvmx_pciercx_cfg464_s cn61xx;
	struct cvmx_pciercx_cfg464_s cn63xx;
	struct cvmx_pciercx_cfg464_s cn63xxp1;
	struct cvmx_pciercx_cfg464_s cn66xx;
	struct cvmx_pciercx_cfg464_s cn68xx;
	struct cvmx_pciercx_cfg464_s cn68xxp1;
	struct cvmx_pciercx_cfg464_s cn70xx;
	struct cvmx_pciercx_cfg464_s cn70xxp1;
	struct cvmx_pciercx_cfg464_s cn73xx;
	struct cvmx_pciercx_cfg464_s cn78xx;
	struct cvmx_pciercx_cfg464_s cn78xxp1;
	struct cvmx_pciercx_cfg464_s cnf71xx;
	struct cvmx_pciercx_cfg464_s cnf75xx;
};

typedef union cvmx_pciercx_cfg464 cvmx_pciercx_cfg464_t;

/**
 * cvmx_pcierc#_cfg465
 *
 * This register contains the four hundred sixty-sixth 32-bits of configuration space.
 *
 */
union cvmx_pciercx_cfg465 {
	u32 u32;
	struct cvmx_pciercx_cfg465_s {
		u32 wrr_vc7 : 8;
		u32 wrr_vc6 : 8;
		u32 wrr_vc5 : 8;
		u32 wrr_vc4 : 8;
	} s;
	struct cvmx_pciercx_cfg465_s cn52xx;
	struct cvmx_pciercx_cfg465_s cn52xxp1;
	struct cvmx_pciercx_cfg465_s cn56xx;
	struct cvmx_pciercx_cfg465_s cn56xxp1;
	struct cvmx_pciercx_cfg465_s cn61xx;
	struct cvmx_pciercx_cfg465_s cn63xx;
	struct cvmx_pciercx_cfg465_s cn63xxp1;
	struct cvmx_pciercx_cfg465_s cn66xx;
	struct cvmx_pciercx_cfg465_s cn68xx;
	struct cvmx_pciercx_cfg465_s cn68xxp1;
	struct cvmx_pciercx_cfg465_s cn70xx;
	struct cvmx_pciercx_cfg465_s cn70xxp1;
	struct cvmx_pciercx_cfg465_s cn73xx;
	struct cvmx_pciercx_cfg465_s cn78xx;
	struct cvmx_pciercx_cfg465_s cn78xxp1;
	struct cvmx_pciercx_cfg465_s cnf71xx;
	struct cvmx_pciercx_cfg465_s cnf75xx;
};

typedef union cvmx_pciercx_cfg465 cvmx_pciercx_cfg465_t;

/**
 * cvmx_pcierc#_cfg466
 *
 * This register contains the four hundred sixty-seventh 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg466 {
	u32 u32;
	struct cvmx_pciercx_cfg466_s {
		u32 rx_queue_order : 1;
		u32 type_ordering : 1;
		u32 reserved_24_29 : 6;
		u32 queue_mode : 3;
		u32 reserved_20_20 : 1;
		u32 header_credits : 8;
		u32 data_credits : 12;
	} s;
	struct cvmx_pciercx_cfg466_s cn52xx;
	struct cvmx_pciercx_cfg466_s cn52xxp1;
	struct cvmx_pciercx_cfg466_s cn56xx;
	struct cvmx_pciercx_cfg466_s cn56xxp1;
	struct cvmx_pciercx_cfg466_s cn61xx;
	struct cvmx_pciercx_cfg466_s cn63xx;
	struct cvmx_pciercx_cfg466_s cn63xxp1;
	struct cvmx_pciercx_cfg466_s cn66xx;
	struct cvmx_pciercx_cfg466_s cn68xx;
	struct cvmx_pciercx_cfg466_s cn68xxp1;
	struct cvmx_pciercx_cfg466_s cn70xx;
	struct cvmx_pciercx_cfg466_s cn70xxp1;
	struct cvmx_pciercx_cfg466_s cn73xx;
	struct cvmx_pciercx_cfg466_s cn78xx;
	struct cvmx_pciercx_cfg466_s cn78xxp1;
	struct cvmx_pciercx_cfg466_s cnf71xx;
	struct cvmx_pciercx_cfg466_s cnf75xx;
};

typedef union cvmx_pciercx_cfg466 cvmx_pciercx_cfg466_t;

/**
 * cvmx_pcierc#_cfg467
 *
 * This register contains the four hundred sixty-eighth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg467 {
	u32 u32;
	struct cvmx_pciercx_cfg467_s {
		u32 reserved_24_31 : 8;
		u32 queue_mode : 3;
		u32 reserved_20_20 : 1;
		u32 header_credits : 8;
		u32 data_credits : 12;
	} s;
	struct cvmx_pciercx_cfg467_s cn52xx;
	struct cvmx_pciercx_cfg467_s cn52xxp1;
	struct cvmx_pciercx_cfg467_s cn56xx;
	struct cvmx_pciercx_cfg467_s cn56xxp1;
	struct cvmx_pciercx_cfg467_s cn61xx;
	struct cvmx_pciercx_cfg467_s cn63xx;
	struct cvmx_pciercx_cfg467_s cn63xxp1;
	struct cvmx_pciercx_cfg467_s cn66xx;
	struct cvmx_pciercx_cfg467_s cn68xx;
	struct cvmx_pciercx_cfg467_s cn68xxp1;
	struct cvmx_pciercx_cfg467_s cn70xx;
	struct cvmx_pciercx_cfg467_s cn70xxp1;
	struct cvmx_pciercx_cfg467_s cn73xx;
	struct cvmx_pciercx_cfg467_s cn78xx;
	struct cvmx_pciercx_cfg467_s cn78xxp1;
	struct cvmx_pciercx_cfg467_s cnf71xx;
	struct cvmx_pciercx_cfg467_s cnf75xx;
};

typedef union cvmx_pciercx_cfg467 cvmx_pciercx_cfg467_t;

/**
 * cvmx_pcierc#_cfg468
 *
 * This register contains the four hundred sixty-ninth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg468 {
	u32 u32;
	struct cvmx_pciercx_cfg468_s {
		u32 reserved_24_31 : 8;
		u32 queue_mode : 3;
		u32 reserved_20_20 : 1;
		u32 header_credits : 8;
		u32 data_credits : 12;
	} s;
	struct cvmx_pciercx_cfg468_s cn52xx;
	struct cvmx_pciercx_cfg468_s cn52xxp1;
	struct cvmx_pciercx_cfg468_s cn56xx;
	struct cvmx_pciercx_cfg468_s cn56xxp1;
	struct cvmx_pciercx_cfg468_s cn61xx;
	struct cvmx_pciercx_cfg468_s cn63xx;
	struct cvmx_pciercx_cfg468_s cn63xxp1;
	struct cvmx_pciercx_cfg468_s cn66xx;
	struct cvmx_pciercx_cfg468_s cn68xx;
	struct cvmx_pciercx_cfg468_s cn68xxp1;
	struct cvmx_pciercx_cfg468_s cn70xx;
	struct cvmx_pciercx_cfg468_s cn70xxp1;
	struct cvmx_pciercx_cfg468_s cn73xx;
	struct cvmx_pciercx_cfg468_s cn78xx;
	struct cvmx_pciercx_cfg468_s cn78xxp1;
	struct cvmx_pciercx_cfg468_s cnf71xx;
	struct cvmx_pciercx_cfg468_s cnf75xx;
};

typedef union cvmx_pciercx_cfg468 cvmx_pciercx_cfg468_t;

/**
 * cvmx_pcierc#_cfg490
 *
 * PCIE_CFG490 = Four hundred ninety-first 32-bits of PCIE type 1 config space
 * (VC0 Posted Buffer Depth)
 */
union cvmx_pciercx_cfg490 {
	u32 u32;
	struct cvmx_pciercx_cfg490_s {
		u32 reserved_26_31 : 6;
		u32 header_depth : 10;
		u32 reserved_14_15 : 2;
		u32 data_depth : 14;
	} s;
	struct cvmx_pciercx_cfg490_s cn52xx;
	struct cvmx_pciercx_cfg490_s cn52xxp1;
	struct cvmx_pciercx_cfg490_s cn56xx;
	struct cvmx_pciercx_cfg490_s cn56xxp1;
	struct cvmx_pciercx_cfg490_s cn61xx;
	struct cvmx_pciercx_cfg490_s cn63xx;
	struct cvmx_pciercx_cfg490_s cn63xxp1;
	struct cvmx_pciercx_cfg490_s cn66xx;
	struct cvmx_pciercx_cfg490_s cn68xx;
	struct cvmx_pciercx_cfg490_s cn68xxp1;
	struct cvmx_pciercx_cfg490_s cn70xx;
	struct cvmx_pciercx_cfg490_s cn70xxp1;
	struct cvmx_pciercx_cfg490_s cnf71xx;
};

typedef union cvmx_pciercx_cfg490 cvmx_pciercx_cfg490_t;

/**
 * cvmx_pcierc#_cfg491
 *
 * PCIE_CFG491 = Four hundred ninety-second 32-bits of PCIE type 1 config space
 * (VC0 Non-Posted Buffer Depth)
 */
union cvmx_pciercx_cfg491 {
	u32 u32;
	struct cvmx_pciercx_cfg491_s {
		u32 reserved_26_31 : 6;
		u32 header_depth : 10;
		u32 reserved_14_15 : 2;
		u32 data_depth : 14;
	} s;
	struct cvmx_pciercx_cfg491_s cn52xx;
	struct cvmx_pciercx_cfg491_s cn52xxp1;
	struct cvmx_pciercx_cfg491_s cn56xx;
	struct cvmx_pciercx_cfg491_s cn56xxp1;
	struct cvmx_pciercx_cfg491_s cn61xx;
	struct cvmx_pciercx_cfg491_s cn63xx;
	struct cvmx_pciercx_cfg491_s cn63xxp1;
	struct cvmx_pciercx_cfg491_s cn66xx;
	struct cvmx_pciercx_cfg491_s cn68xx;
	struct cvmx_pciercx_cfg491_s cn68xxp1;
	struct cvmx_pciercx_cfg491_s cn70xx;
	struct cvmx_pciercx_cfg491_s cn70xxp1;
	struct cvmx_pciercx_cfg491_s cnf71xx;
};

typedef union cvmx_pciercx_cfg491 cvmx_pciercx_cfg491_t;

/**
 * cvmx_pcierc#_cfg492
 *
 * PCIE_CFG492 = Four hundred ninety-third 32-bits of PCIE type 1 config space
 * (VC0 Completion Buffer Depth)
 */
union cvmx_pciercx_cfg492 {
	u32 u32;
	struct cvmx_pciercx_cfg492_s {
		u32 reserved_26_31 : 6;
		u32 header_depth : 10;
		u32 reserved_14_15 : 2;
		u32 data_depth : 14;
	} s;
	struct cvmx_pciercx_cfg492_s cn52xx;
	struct cvmx_pciercx_cfg492_s cn52xxp1;
	struct cvmx_pciercx_cfg492_s cn56xx;
	struct cvmx_pciercx_cfg492_s cn56xxp1;
	struct cvmx_pciercx_cfg492_s cn61xx;
	struct cvmx_pciercx_cfg492_s cn63xx;
	struct cvmx_pciercx_cfg492_s cn63xxp1;
	struct cvmx_pciercx_cfg492_s cn66xx;
	struct cvmx_pciercx_cfg492_s cn68xx;
	struct cvmx_pciercx_cfg492_s cn68xxp1;
	struct cvmx_pciercx_cfg492_s cn70xx;
	struct cvmx_pciercx_cfg492_s cn70xxp1;
	struct cvmx_pciercx_cfg492_s cnf71xx;
};

typedef union cvmx_pciercx_cfg492 cvmx_pciercx_cfg492_t;

/**
 * cvmx_pcierc#_cfg515
 *
 * This register contains the five hundred sixteenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg515 {
	u32 u32;
	struct cvmx_pciercx_cfg515_s {
		u32 reserved_21_31 : 11;
		u32 s_d_e : 1;
		u32 ctcrb : 1;
		u32 cpyts : 1;
		u32 dsc : 1;
		u32 reserved_8_16 : 9;
		u32 n_fts : 8;
	} s;
	struct cvmx_pciercx_cfg515_cn61xx {
		u32 reserved_21_31 : 11;
		u32 s_d_e : 1;
		u32 ctcrb : 1;
		u32 cpyts : 1;
		u32 dsc : 1;
		u32 le : 9;
		u32 n_fts : 8;
	} cn61xx;
	struct cvmx_pciercx_cfg515_cn61xx cn63xx;
	struct cvmx_pciercx_cfg515_cn61xx cn63xxp1;
	struct cvmx_pciercx_cfg515_cn61xx cn66xx;
	struct cvmx_pciercx_cfg515_cn61xx cn68xx;
	struct cvmx_pciercx_cfg515_cn61xx cn68xxp1;
	struct cvmx_pciercx_cfg515_cn61xx cn70xx;
	struct cvmx_pciercx_cfg515_cn61xx cn70xxp1;
	struct cvmx_pciercx_cfg515_cn61xx cn73xx;
	struct cvmx_pciercx_cfg515_cn78xx {
		u32 reserved_21_31 : 11;
		u32 s_d_e : 1;
		u32 ctcrb : 1;
		u32 cpyts : 1;
		u32 dsc : 1;
		u32 alaneflip : 1;
		u32 pdetlane : 3;
		u32 nlanes : 5;
		u32 n_fts : 8;
	} cn78xx;
	struct cvmx_pciercx_cfg515_cn61xx cn78xxp1;
	struct cvmx_pciercx_cfg515_cn61xx cnf71xx;
	struct cvmx_pciercx_cfg515_cn78xx cnf75xx;
};

typedef union cvmx_pciercx_cfg515 cvmx_pciercx_cfg515_t;

/**
 * cvmx_pcierc#_cfg516
 *
 * This register contains the five hundred seventeenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg516 {
	u32 u32;
	struct cvmx_pciercx_cfg516_s {
		u32 phy_stat : 32;
	} s;
	struct cvmx_pciercx_cfg516_s cn52xx;
	struct cvmx_pciercx_cfg516_s cn52xxp1;
	struct cvmx_pciercx_cfg516_s cn56xx;
	struct cvmx_pciercx_cfg516_s cn56xxp1;
	struct cvmx_pciercx_cfg516_s cn61xx;
	struct cvmx_pciercx_cfg516_s cn63xx;
	struct cvmx_pciercx_cfg516_s cn63xxp1;
	struct cvmx_pciercx_cfg516_s cn66xx;
	struct cvmx_pciercx_cfg516_s cn68xx;
	struct cvmx_pciercx_cfg516_s cn68xxp1;
	struct cvmx_pciercx_cfg516_s cn70xx;
	struct cvmx_pciercx_cfg516_s cn70xxp1;
	struct cvmx_pciercx_cfg516_s cn73xx;
	struct cvmx_pciercx_cfg516_s cn78xx;
	struct cvmx_pciercx_cfg516_s cn78xxp1;
	struct cvmx_pciercx_cfg516_s cnf71xx;
	struct cvmx_pciercx_cfg516_s cnf75xx;
};

typedef union cvmx_pciercx_cfg516 cvmx_pciercx_cfg516_t;

/**
 * cvmx_pcierc#_cfg517
 *
 * This register contains the five hundred eighteenth 32-bits of PCIe type 1 configuration space.
 *
 */
union cvmx_pciercx_cfg517 {
	u32 u32;
	struct cvmx_pciercx_cfg517_s {
		u32 phy_ctrl : 32;
	} s;
	struct cvmx_pciercx_cfg517_s cn52xx;
	struct cvmx_pciercx_cfg517_s cn52xxp1;
	struct cvmx_pciercx_cfg517_s cn56xx;
	struct cvmx_pciercx_cfg517_s cn56xxp1;
	struct cvmx_pciercx_cfg517_s cn61xx;
	struct cvmx_pciercx_cfg517_s cn63xx;
	struct cvmx_pciercx_cfg517_s cn63xxp1;
	struct cvmx_pciercx_cfg517_s cn66xx;
	struct cvmx_pciercx_cfg517_s cn68xx;
	struct cvmx_pciercx_cfg517_s cn68xxp1;
	struct cvmx_pciercx_cfg517_s cn70xx;
	struct cvmx_pciercx_cfg517_s cn70xxp1;
	struct cvmx_pciercx_cfg517_s cn73xx;
	struct cvmx_pciercx_cfg517_s cn78xx;
	struct cvmx_pciercx_cfg517_s cn78xxp1;
	struct cvmx_pciercx_cfg517_s cnf71xx;
	struct cvmx_pciercx_cfg517_s cnf75xx;
};

typedef union cvmx_pciercx_cfg517 cvmx_pciercx_cfg517_t;

/**
 * cvmx_pcierc#_cfg548
 *
 * This register contains the five hundred forty-ninth 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg548 {
	u32 u32;
	struct cvmx_pciercx_cfg548_s {
		u32 reserved_26_31 : 6;
		u32 rss : 2;
		u32 eiedd : 1;
		u32 reserved_19_22 : 4;
		u32 dcbd : 1;
		u32 dtdd : 1;
		u32 ed : 1;
		u32 reserved_13_15 : 3;
		u32 rxeq_ph01_en : 1;
		u32 erd : 1;
		u32 ecrd : 1;
		u32 ep2p3d : 1;
		u32 dsg3 : 1;
		u32 reserved_1_7 : 7;
		u32 grizdnc : 1;
	} s;
	struct cvmx_pciercx_cfg548_s cn73xx;
	struct cvmx_pciercx_cfg548_s cn78xx;
	struct cvmx_pciercx_cfg548_s cn78xxp1;
	struct cvmx_pciercx_cfg548_s cnf75xx;
};

typedef union cvmx_pciercx_cfg548 cvmx_pciercx_cfg548_t;

/**
 * cvmx_pcierc#_cfg554
 *
 * This register contains the five hundred fifty-fifth 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg554 {
	u32 u32;
	struct cvmx_pciercx_cfg554_s {
		u32 reserved_27_31 : 5;
		u32 scefpm : 1;
		u32 reserved_25_25 : 1;
		u32 iif : 1;
		u32 prv : 16;
		u32 reserved_6_7 : 2;
		u32 p23td : 1;
		u32 bt : 1;
		u32 fm : 4;
	} s;
	struct cvmx_pciercx_cfg554_cn73xx {
		u32 reserved_25_31 : 7;
		u32 iif : 1;
		u32 prv : 16;
		u32 reserved_6_7 : 2;
		u32 p23td : 1;
		u32 bt : 1;
		u32 fm : 4;
	} cn73xx;
	struct cvmx_pciercx_cfg554_s cn78xx;
	struct cvmx_pciercx_cfg554_s cn78xxp1;
	struct cvmx_pciercx_cfg554_s cnf75xx;
};

typedef union cvmx_pciercx_cfg554 cvmx_pciercx_cfg554_t;

/**
 * cvmx_pcierc#_cfg558
 *
 * This register contains the five hundred fifty-ninth 32-bits of type 0 PCIe configuration space.
 *
 */
union cvmx_pciercx_cfg558 {
	u32 u32;
	struct cvmx_pciercx_cfg558_s {
		u32 ple : 1;
		u32 rxstatus : 31;
	} s;
	struct cvmx_pciercx_cfg558_s cn73xx;
	struct cvmx_pciercx_cfg558_s cn78xx;
	struct cvmx_pciercx_cfg558_s cn78xxp1;
	struct cvmx_pciercx_cfg558_s cnf75xx;
};

typedef union cvmx_pciercx_cfg558 cvmx_pciercx_cfg558_t;

/**
 * cvmx_pcierc#_cfg559
 *
 * This register contains the five hundred sixtieth 32-bits of PCIe type 0 configuration space.
 *
 */
union cvmx_pciercx_cfg559 {
	u32 u32;
	struct cvmx_pciercx_cfg559_s {
		u32 reserved_1_31 : 31;
		u32 dbi_ro_wr_en : 1;
	} s;
	struct cvmx_pciercx_cfg559_s cn73xx;
	struct cvmx_pciercx_cfg559_s cn78xx;
	struct cvmx_pciercx_cfg559_s cn78xxp1;
	struct cvmx_pciercx_cfg559_s cnf75xx;
};

typedef union cvmx_pciercx_cfg559 cvmx_pciercx_cfg559_t;

#endif
