/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.guava.collect;

import io.bazel.kotlin.builder.guava.annotations.GwtCompatible;
import io.bazel.kotlin.builder.guava.base.Preconditions;
import io.bazel.kotlin.builder.guava.collect.ElementTypesAreNonnullByDefault;
import io.bazel.kotlin.builder.guava.collect.ForwardingCollection;
import io.bazel.kotlin.builder.guava.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSet<E>
extends ForwardingCollection<E>
implements Set<E> {
    protected ForwardingSet() {
    }

    @Override
    protected abstract Set<E> delegate();

    @Override
    public boolean equals(@CheckForNull Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Sets.removeAllImpl(this, Preconditions.checkNotNull(collection));
    }

    protected boolean standardEquals(@CheckForNull Object object) {
        return Sets.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this);
    }
}

