/*
** Copyright (c) 2018-2021 Valve Corporation
** Copyright (c) 2018-2024 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

#include "decode/common_object_info_table.h"

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(decode)

CommonObjectInfoTable* CommonObjectInfoTable::singleton_          = nullptr;
uint32_t               CommonObjectInfoTable::singleton_refcount_ = 0;

CommonObjectInfoTable* CommonObjectInfoTable::GetSingleton()
{
    if (!singleton_)
    {
        singleton_          = new CommonObjectInfoTable();
        singleton_refcount_ = 1;
    }
    else
    {
        assert(singleton_refcount_ > 0);
        singleton_refcount_++;
    }
    return singleton_;
}

void CommonObjectInfoTable::ReleaseSingleton()
{
    if (singleton_)
    {
        singleton_refcount_--;
        if (singleton_refcount_ == 0)
        {
            delete singleton_;
            singleton_ = nullptr;
        }
    }
    else
    {
        assert(singleton_refcount_ == 0);
    }
}

GFXRECON_END_NAMESPACE(decode)
GFXRECON_END_NAMESPACE(gfxrecon)
