/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.DefinitionUtils;
import org.eclipse.californium.elements.config.ValueException;

public class StringSetDefinition
extends BasicDefinition<String> {
    private final String defaultValue;
    private final List<String> values;
    private final String valuesDocumentation;

    public StringSetDefinition(String key, String documentation, String ... values) {
        super(key, documentation, String.class, null);
        if (values == null) {
            throw new NullPointerException("Value set must not be null!");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Value set must not be empty!");
        }
        for (String in : values) {
            if (in != null) continue;
            throw new IllegalArgumentException("Value set must not contain null!");
        }
        boolean found = false;
        String defaultValue = values[0];
        for (int index = 1; index < values.length; ++index) {
            if (!values[index].equals(defaultValue)) continue;
            found = true;
            break;
        }
        if (found) {
            this.defaultValue = defaultValue;
            this.values = Arrays.asList(Arrays.copyOfRange(values, 1, values.length));
        } else {
            this.defaultValue = null;
            this.values = Arrays.asList(Arrays.copyOf(values, values.length));
        }
        this.valuesDocumentation = DefinitionUtils.toString(this.values, true);
    }

    public StringSetDefinition(String key, String documentation, String defaultValue, String[] values) {
        super(key, documentation, String.class, null);
        if (values == null) {
            throw new NullPointerException("Value set must not be null!");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Value set must not be empty!");
        }
        for (String in : values) {
            if (in != null) continue;
            throw new IllegalArgumentException("Value set must not contain null!");
        }
        this.values = Arrays.asList(Arrays.copyOf(values, values.length));
        this.valuesDocumentation = DefinitionUtils.toString(this.values, true);
        try {
            this.defaultValue = this.checkValue(defaultValue);
        }
        catch (ValueException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    @Override
    public String getTypeName() {
        return "StringSet";
    }

    @Override
    public String writeValue(String value) {
        return value;
    }

    @Override
    public String getDocumentation() {
        return super.getDocumentation() + "\n" + this.valuesDocumentation + ".";
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String checkValue(String value) throws ValueException {
        if (value == null || this.values.contains(value)) {
            return value;
        }
        throw new IllegalArgumentException(value + " is not in " + this.valuesDocumentation);
    }

    @Override
    protected boolean isAssignableFrom(Object value) {
        if (this.values.contains(value)) {
            return true;
        }
        if (super.isAssignableFrom(value)) {
            throw new IllegalArgumentException(value + " is not in " + this.valuesDocumentation);
        }
        return false;
    }

    @Override
    protected String parseValue(String value) throws ValueException {
        if (this.values.contains(value)) {
            return value;
        }
        throw new ValueException(value + " is not in " + this.valuesDocumentation);
    }
}

