/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.common;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.SafeCaller;
import org.openhab.core.common.SafeCallerBuilder;
import org.openhab.core.internal.common.AbstractInvocationHandler;
import org.openhab.core.internal.common.CombinedClassLoader;
import org.openhab.core.internal.common.InvocationHandlerAsync;
import org.openhab.core.internal.common.InvocationHandlerSync;
import org.openhab.core.internal.common.SafeCallManager;

@NonNullByDefault
public class SafeCallerBuilderImpl<@NonNull T>
implements SafeCallerBuilder<T> {
    private final T target;
    private final Class<?>[] interfaceTypes;
    private long timeout;
    private Object identifier;
    private @Nullable Consumer<Throwable> exceptionHandler;
    private @Nullable Runnable timeoutHandler;
    private boolean async;
    private final SafeCallManager manager;

    public SafeCallerBuilderImpl(T target, Class<?>[] classes, SafeCallManager manager) {
        this.target = target;
        this.interfaceTypes = classes;
        this.manager = manager;
        this.timeout = SafeCaller.DEFAULT_TIMEOUT;
        this.identifier = target;
        this.async = false;
    }

    @Override
    public T build() {
        AbstractInvocationHandler handler = this.async ? new InvocationHandlerAsync<T>(this.manager, this.target, this.identifier, this.timeout, this.exceptionHandler, this.timeoutHandler) : new InvocationHandlerSync<T>(this.manager, this.target, this.identifier, this.timeout, this.exceptionHandler, this.timeoutHandler);
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("Cannot create proxy because '" + this.getClass().getName() + "' class loader is null");
        }
        return (T)Proxy.newProxyInstance(CombinedClassLoader.fromClasses(classLoader, Stream.concat(Stream.of(this.target.getClass()), Arrays.stream(this.interfaceTypes))), this.interfaceTypes, handler);
    }

    @Override
    public SafeCallerBuilder<T> withTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> withIdentifier(Object identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> onException(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> onTimeout(Runnable timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        return this;
    }

    @Override
    public SafeCallerBuilder<T> withAsync() {
        this.async = true;
        return this;
    }
}

