/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal;

import java.io.IOException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.JSONResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@JaxrsExtension
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@NonNullByDefault
public class JSONResponseExceptionMapper
implements ExceptionMapper<Exception> {
    private final Logger logger = LoggerFactory.getLogger(JSONResponseExceptionMapper.class);
    private final ExceptionMapper<Exception> delegate = new JSONResponse.ExceptionMapper();

    public @Nullable Response toResponse(Exception e) {
        if (e instanceof IOException) {
            this.logger.debug("Failed writing HTTP response, since other side closed the connection", (Throwable)e);
            return null;
        }
        if (e instanceof ClientErrorException) {
            ClientErrorException cee = (ClientErrorException)e;
            this.logger.debug("Requested resource not (yet) found", (Throwable)cee);
            return cee.getResponse();
        }
        this.logger.error("Unexpected exception occurred while processing REST request.", (Throwable)e);
        return this.delegate.toResponse((Throwable)e);
    }
}

